use crate::builder::ToBClientBuilder;
use crate::types::{SyncStats, WalletBalance};
use crate::Result;
use async_trait::async_trait;

//Use this to enable lots of different types of clients.
//e.g. Handshake can be both rpc and http so we would say which types we support and then
//when we create the client you can pick.
#[derive(Debug)]
pub enum ClientType {
    RPC,
    HTTP,
    GRPC,
    Websocket,
}

pub enum ProtocolClient {}

//@todo need a builder here.
// #[derive(Clone)]
// pub struct ToBClient {
//     client: Arc<RpcClient>,
//     protocol: Protocol,
// }

//@todo we should probs have a function of "supported_daemons" since some of them differ in RPC and
//HTTP calls. That should probs be a parameter as well to creating a client.
//@todo will need a generic Result type here.
#[async_trait]
pub trait CryptoClient {
    fn client_type(&self) -> ClientType;
    async fn sync_stats(&self) -> SyncStats;
    async fn wallet_balance(&self, identifier: &str) -> Result<WalletBalance>;
}

pub type Client = dyn CryptoClient + Send + Sync;

pub struct ToBClient {
    //@todo just review what is the most efficient here.
    pub(crate) inner_client: Box<Client>,
}

impl ToBClient {
    pub fn new(client: Box<Client>) -> Self {
        ToBClient {
            inner_client: client,
        }
    }

    pub fn builder(url: &str) -> ToBClientBuilder {
        ToBClientBuilder::new(url)
    }

    //@todo need Result.
    pub async fn sync_stats(&self) -> SyncStats {
        self.inner_client.sync_stats().await
    }

    pub async fn wallet_balance(&self, identifier: &str) -> Result<WalletBalance> {
        self.inner_client.wallet_balance(identifier).await
    }
}
