mod config;

use anyhow::Error;
use config::Config;
use std::env;

fn main() -> Result<(), Error> {
    let args: Vec<_> = env::args().into_iter().collect();
    let mut config = Config::restore().unwrap_or_default();
    match &args[1..] {
        [] => {
            for (alias, path) in config.0 {
                println!("{} -> {}", alias, path);
            }
        }
        [alias] => {
            let value = config.0.get(alias).map(String::as_ref).unwrap_or(".");
            println!("{}", value);
        }
        [command, alias] => {
            match command.as_ref() {
                "add" => {
                    let cur_dir = std::env::current_dir()?;
                    let path = cur_dir
                        .to_str()
                        .ok_or_else(|| Error::msg("can't get current dir"))?;
                    config.0.insert(alias.to_string(), path.to_string());
                }
                "remove" => {
                    config.0.remove(alias);
                }
                unknown => {
                    println!("unknown command: {}", unknown);
                }
            }
            config.store()?;
        }
        args => {
            println!("too many arguments: {}", args.join(" "));
        }
    }
    Ok(())
}
