use anyhow::{anyhow, Error};
use serde::{Deserialize, Serialize};
use std::collections::BTreeMap;
use std::fs;
use std::path::PathBuf;

fn path() -> Result<PathBuf, Error> {
    let mut path = dirs::home_dir().ok_or_else(|| anyhow!("can't get home folder"))?;
    path.push(".to");
    Ok(path)
}

#[derive(Deserialize, Serialize, Default)]
pub struct Config(pub BTreeMap<String, String>);

impl Config {
    pub fn restore() -> Result<Self, Error> {
        let content = fs::read(path()?)?;
        let map = toml::from_slice(&content)?;
        Ok(Self(map))
    }

    pub fn store(&self) -> Result<(), Error> {
        let data = toml::to_vec(self)?;
        fs::write(path()?, data)?;
        Ok(())
    }
}
