pub mod config;
pub mod devices;
pub mod stats;
pub mod client;

use lazy_static::lazy_static;
use rust_utils::{utils, logging::Log};
use std::{env, sync::RwLock};

use client::TrashcanClient;

lazy_static! {
    pub static ref LOG: Log = Log::get(&utils::get_execname(), "tmo-tools");
    pub static ref DEBUG: bool = should_debug();
    pub static ref PRINT_STDOUT: bool = utils::get_execname().as_str() != "tmotop";
    pub static ref CLIENT: RwLock<TrashcanClient> = RwLock::new(TrashcanClient::new());
}

// are we in debug mode?
fn should_debug() -> bool {
    // get the runtime arguments
    let args: Vec<String> = env::args().collect();

    // should debug messages be shown?
    if args.is_empty() { false }
    else if let Some(string) = args.get(1) { string == "-d" && utils::get_execname().as_str() != "tmocli" }
    else { false }
}