use std::fs;
use chrono::{Datelike, Timelike, Local};

fn main() {
    println!("cargo:rerun-if-changed=build.rs");

    // get the current date and time (formatted)
    let months = ["January","February","March","April","May","June","July","August","September","October","November","December"];
    let date = Local::now().date();
    let month = months[date.month() as usize - 1];
    let day = date.day();
    let year = date.year();
    let date_str = format!("{} {} {}",day, month, year);
    let time = Local::now().time();
    let hour = time.hour();
    let minute = time.minute();
    let second = time.second(); 
    let time_str = format!("{:02}:{:02}:{:02}", hour, minute, second);

    // manpage templates
    let gatewaymon_manpage = format!(".\\\" Manpage for gatewaymon (part of T-Mobile Home Internet Tools).\n\
    .\\\" Created on {} {}, {} at {}\n\
    .TH gatewaymon 1 \"{}\" \"{}\" \"gatewaymon man page\"\n\
    .SH NAME\n\
    gatewaymon \\- T-Mobile gateway monitor.\n\
    .SH DESCRIPTION\n\
    This process monitors T-Mobile Home Internet gateways, keeps a history of the signal strength and reboots the gateway if it causes amy connection trouble.\n\n\
    .SH EXAMPLES\n\
    If connections are user specific:\n\
    .br\n    start from systemd: systemctl start --user gatewaymon\n\
    .br\n\
    If the network connection is systemwide:\n\
    .br
    sudo systemctl start gatewaymon\n\
    .br\n\
    start upon first login using systemd: systemctl enable [--user] gatewaymon\n\
    .br\n\
    start manually (as background process): gatewaymon &\n\
    .br\n\
    Show debug log info: gatewaymon -d &\n\n\
    .SH SEE ALSO\n\
    tmotop(1)\n\
    .br\n\
    tmocli(1)\n\n\
    .SH AUTHOR\n\
    Noah Jelen (noahtjelen@gmail.com)", month, day, year, time_str, date_str, env!("CARGO_PKG_VERSION"));
    
    let tmocli_manpage = format!(".\\\" Manpage for tmocli (part of T-Mobile Home Internet Tools).\n\
    .\\\" Created on {} {}, {} at {}\n\
    .TH tmocli 1 \"{}\" \"{}\" \"tmocli man page\"\n\
    .SH NAME\n\
    tmocli \\- Command line interface for controlling T-Mobile Home Internet gateways\n\n\
    .SH SYNOPSIS\n\
    tmocli -h\n\
    .br\n\
    tmocli -v\n\
    .br\n\
    tmocli info\n\
    .br\n\
    tmocli reboot\n\
    .br\n\
    tmocli stats\n\
    .br\n\
    tmocli connection\n\
    .br\n\
    tmocli data\n\
    .br\n\
    tmocli networks\n\
    .br\n\
    tmocli devices\n\
    .br\n\
    tmocli device\n\
    .br\n\n\
    .SH DESCRIPTION\n\
    Allows controlling of T-Mobile gateways from the command line. Please make sure that gatewaymon is not running when using this to reboot the gateway!\n\n\
    .SH OPTIONS\n\
    -h : Show help\n\
    .br\n\
    -v : Show current version\n\
    .br\n\
    info: Show info about the gateway\n\
    .br\n\
    reboot: Reboot the gateway. Pass -y to skip the confirmation prompt.   \n\
    .br\n\
    stats: Show all the stats of the gateway\n\
    .br\n\
    connection: Show connection stats\n\
    .br\n\
    networks: Show network stats\n\
    .br\n\
    data: Show data usage stats\n\
    .br\n\
    devices: List devices connected to gateway\n\
    .br\n\
    device: Get info about a connected device by its name IP address, or MAC address\n\n\
    .SH EXAMPLES\n\
    .br\n\
    Reboot gateway: tmocli reboot\n\
    Show all stats: tmocli stats\n\n\
    .SH SEE ALSO\n\
    gatewaymon(1)\n\
    .br\n\
    tmotop(1)\n\n\
    .SH AUTHOR\n\
    Noah Jelen (noahtjelen@gmail.com)", month, day, year, time_str, date_str, env!("CARGO_PKG_VERSION"));

    let tmotop_manpage = format!(".\\\" Manpage for tmotop (part of T-Mobile Home Internet Tools).\n\
    .\\\" Created on {} {}, {} at {}\n\
    .TH tmotop 1 \"{}\" \"{}\" \"tmotop man page\"\n\
    .SH NAME\n\
    tmotop \\- Text user interface that shows information about a connected T-Mobile gateway.\n\
    .SH DESCRIPTION\n\
    The interface shows the signal strength, active networks, data usage, and connected devices.\n\n\
    .SH SEE ALSO\n\
    tmotop(1)\n\
    .br\n\
    gatewaymon(1)\n\n\
    .SH AUTHOR\n\
    Noah Jelen (noahtjelen@gmail.com)", month, day, year, time_str, date_str, env!("CARGO_PKG_VERSION"));
    
    // Arch PKGBUILD template
    let aur_pkgbuild = format!("# Maintainer: Noah Jelen <noahtjelen@gmail.com>\n\
    # Generated by cargo on {} {}, {} at {}\n\
    pkgname=tmobile-internet-tools\n\
    pkgver={}\n\
    pkgrel=1\n\
    pkgdesc=\"Set of tools for working with T-Mobile Home Internet gateways\"\n\
    arch=('i686' 'x86_64')\n\
    url=\"https://gitlab.com/NoahJelen/tmobile-internet-tools\"\n\
    license=('GPL')\n\
    depends=('ncurses' 'gcc-libs' 'glibc' 'networkmanager' 'openssl')\n\
    makedepends=('cargo' 'gzip')\n\
    source=(\"https://gitlab.com/NoahJelen/tmobile-internet-tools/-/archive/$pkgver/tmobile-internet-tools-$pkgver.zip\")\n\
    md5sums=('SKIP')\n\n\
    build() {{\n    \
        cd \"tmobile-internet-tools-$pkgver\"\n    \
        cargo build --release\n    \
        cd target/release\n    \
        ln -sf gatewaymon tmotop\n    \
        ln -sf gatewaymon tmocli\n\
    }}\n\
    \npackage() {{\n    \
        cd \"tmobile-internet-tools-$pkgver\"\n    \
        mkdir -p \"$pkgdir/usr/share/tmobile-internet-tools/\"\n    \
        cp -r webui/ \"$pkgdir/usr/share/tmobile-internet-tools/\"\n    \
        chmod -R 755 \"$pkgdir/usr/share/tmobile-internet-tools/webui/\"\n    \
        mkdir -p \"$pkgdir/usr/share/man/man1/\"\n    \
        mkdir -p \"$pkgdir/usr/lib/systemd/system\"\n    \
        install -Dt \"$pkgdir/usr/bin\" -m755 target/release/gatewaymon\n    \
        install -Dt \"$pkgdir/usr/bin\" -m755 target/release/tmocli\n    \
        install -Dt \"$pkgdir/usr/bin\" -m755 target/release/tmotop\n    \
        install -Dt \"$pkgdir/usr/bin\" -m755 target/release/tmo-webui\n    \
        install -Dt \"$pkgdir/usr/share/man/man1\" man/gatewaymon.1\n    \
        install -Dt \"$pkgdir/usr/share/man/man1\" man/tmocli.1\n    \
        install -Dt \"$pkgdir/usr/share/man/man1\" man/tmotop.1\n    \
        install -Dt \"$pkgdir/usr/lib/systemd/user\" gatewaymon.service\n    \
        install -Dt \"$pkgdir/usr/lib/systemd/system\" gatewaymon.service\n    \
        install -Dt \"$pkgdir/usr/lib/systemd/user\" gatewaymon-debug.service\n    \
        install -Dt \"$pkgdir/usr/lib/systemd/system\" gatewaymon-debug.service\n    \
        install -Dt \"$pkgdir/usr/lib/systemd/user\" tmo-webui.service\n    \
        install -Dt \"$pkgdir/usr/lib/systemd/system\" tmo-webui.service\n    \
        gzip \"$pkgdir/usr/share/man/man1/gatewaymon.1\"\n    \
        gzip \"$pkgdir/usr/share/man/man1/tmotop.1\"\n    \
        gzip \"$pkgdir/usr/share/man/man1/tmocli.1\"\n\
    }}", month, day, year, time_str, env!("CARGO_PKG_VERSION"));

    // save the PKGBUILD and manpages
    fs::remove_dir_all("man/").unwrap_or(());
    fs::create_dir_all("man/").unwrap_or(());
    fs::write("man/gatewaymon.1", gatewaymon_manpage).expect("Unable to save manpages!");
    fs::write("man/tmocli.1", tmocli_manpage).expect("Unable to save manpages!");
    fs::write("man/tmotop.1", tmotop_manpage).expect("Unable to save manpages!");
    fs::write("aur/PKGBUILD", aur_pkgbuild).unwrap_or(());
}