use std::env;
use rust_utils::{utils, logging::Log};
use lazy_static::lazy_static;

mod config;
mod gatewaymon;
mod hosts;
mod stats;
mod client;
mod tmotop;
mod cli;

lazy_static! {
    pub static ref LOG: Log = Log::get(&utils::get_execname(), "tmo-tools");
    pub static ref DEBUG: bool = should_debug();
    pub static ref PRINT_STDOUT: bool = utils::get_execname().as_str() != "tmotop";
}

fn main() {
    match utils::get_execname().as_str() {
        "gatewaymon" => gatewaymon::init(),
        "tmotop" => tmotop::init(),
        "tmocli" => cli::parse_args(),
        _ => unreachable!()
    }
}

// are we in debug mode?
fn should_debug() -> bool {
    // get the runtime arguments
    let args: Vec<String> = env::args().collect();

    // should debug messages be shown?
    if args.is_empty() { false }
    else if let Some(string) = args.get(1) { string == "-d" && utils::get_execname().as_str() != "tmocli" }
    else { false }
}