use rust_utils::{utils, logging::Log};
use lazy_static::lazy_static;

mod config;
mod gatewaymon;
mod hosts;
mod stats;
mod client;
mod tmotop;
mod cli;

lazy_static! {
    pub static ref LOG: Log = Log::get(&utils::get_execname(), "tmo-tools");
}

fn main() {
    match utils::get_execname().as_str() {
        "gatewaymon" => gatewaymon::init(),
        "tmotop" => tmotop::init(),
        "tmocli" => cli::parse_args(),
        _ => unreachable!()
    }
}