// FIXME: doctest not running
/// `fileify` takes a string, strips leading and trailing whitespace both for
/// the whole string and for each line, and makes sure that a final newline is
/// present. This serves mostly aesthetic purposes (file contents can be
/// indented):
///
/// ```rs
/// assert_eq!(
/// 	fileify!(
/// 		"
/// 		line 1
/// 		line 2
/// 		"
/// 	),
/// 	"line 1\nline 2\n"
/// );
/// ```
///
/// Overloads allow prefixing and suffixing each line:
///
/// ```rs
/// let file = fileify!("
///     line 1
///     line 2
/// ", "\t");
/// assert_eq!(file, "\tline 1\n\tline 2\n");
///
/// let file = fileify!("
///     line 1
///     line 2
/// ", "\t", ",");
/// assert_eq!(file, "\tline 1,\n\tline 2,\n");
///
/// let file = fileify!("
///     line 1
///     line 2
/// ", "", ",");
/// assert_eq!(file, "line 1,\nline 2,\n");
///
/// ```
#[macro_export]
macro_rules! fileify {
    ($string:expr) => {
        fileify!($string, "", "")
    };

    ($string:expr, $prefix:expr) => {
        fileify!($string, $prefix, "")
    };

    ($string:expr, $prefix:expr, $suffix:expr) => {
        $string
            .trim()
            .lines()
            .fold("".to_string(), |mut file, line| {
                file.push_str($prefix);
                file.push_str(line.trim());
                file.push_str($suffix);
                file.push('\n');
                file
            })
    };
}

#[cfg(test)]
mod tests {
    #[test]
    fn works_plain() {
        let file = fileify!(
            "
			line 1
			line 2
			"
        );
        assert_eq!(file, "line 1\nline 2\n");
    }

    #[test]
    fn works_with_prefix() {
        let file = fileify!(
            "
			line 1
			line 2
			",
            "\t"
        );
        assert_eq!(file, "\tline 1\n\tline 2\n");
    }

    #[test]
    fn works_with_suffix() {
        let file = fileify!(
            "
			line 1
			line 2
			",
            "",
            ";"
        );
        assert_eq!(file, "line 1;\nline 2;\n");
    }

    #[test]
    fn works_with_prefix_and_suffix() {
        let file = fileify!(
            "
			line 1
			line 2
			",
            "\t",
            ";"
        );
        assert_eq!(file, "\tline 1;\n\tline 2;\n");
    }
}
