# tld_msg
This is a simple crate for the [TLDMP protocol](https://files.almaember.com/tld-messages.txt).
There isn't much else to say about it.

It's extremely simplistic. The source code is about 40 lines.

Here's an example, though:

```rust
mod lib;

fn main() {
    let mut output: Vec<u8> = Vec::new();

    lib::send(&mut output, 1, &mut "Hey!".as_bytes()).unwrap();
    let mut input = &output[..];
    let msg = lib::receive(&mut input).unwrap();

    println!("{:#?}", output);
    println!("{:#?}\n{}", msg, String::from_utf8(msg.content.clone()).unwrap());
}
```