#![deny(missing_docs)]
//! For servers: [`crate::server`]
//!
//! For clients: [`crate::client`]
mod errors;
mod frame;

pub mod client;
pub mod server;
pub use errors::{TinyRouteError as Error, Result};
pub use frame::Frame;
pub use server::TcpServer;
pub use bytes::Bytes;

/// A message that has a header byte and a content length
/// prefixed to it.
#[derive(Debug)]
pub struct FramedMessage(pub(crate) Bytes);
