use std::io::Error as IoErr;

use thiserror::Error;

/// Result
pub type Result<T> = std::result::Result<T, TinyRouteError>;

/// Error
#[derive(Debug, Error)]
pub enum TinyRouteError {
    /// Io error
    #[error("Io Error")]
    Io(#[from] IoErr),

    /// Malformed data
    #[error("Malformed header")]
    MalformedHeader,
}
