/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures power, DC voltage and DC current up to 720W/36V/20A.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/VoltageCurrentV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum VoltageCurrentV2BrickletFunction {
    GetCurrent,
    SetCurrentCallbackConfiguration,
    GetCurrentCallbackConfiguration,
    GetVoltage,
    SetVoltageCallbackConfiguration,
    GetVoltageCallbackConfiguration,
    GetPower,
    SetPowerCallbackConfiguration,
    GetPowerCallbackConfiguration,
    SetConfiguration,
    GetConfiguration,
    SetCalibration,
    GetCalibration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackCurrent,
    CallbackVoltage,
    CallbackPower,
}
impl From<VoltageCurrentV2BrickletFunction> for u8 {
    fn from(fun: VoltageCurrentV2BrickletFunction) -> Self {
        match fun {
            VoltageCurrentV2BrickletFunction::GetCurrent => 1,
            VoltageCurrentV2BrickletFunction::SetCurrentCallbackConfiguration => 2,
            VoltageCurrentV2BrickletFunction::GetCurrentCallbackConfiguration => 3,
            VoltageCurrentV2BrickletFunction::GetVoltage => 5,
            VoltageCurrentV2BrickletFunction::SetVoltageCallbackConfiguration => 6,
            VoltageCurrentV2BrickletFunction::GetVoltageCallbackConfiguration => 7,
            VoltageCurrentV2BrickletFunction::GetPower => 9,
            VoltageCurrentV2BrickletFunction::SetPowerCallbackConfiguration => 10,
            VoltageCurrentV2BrickletFunction::GetPowerCallbackConfiguration => 11,
            VoltageCurrentV2BrickletFunction::SetConfiguration => 13,
            VoltageCurrentV2BrickletFunction::GetConfiguration => 14,
            VoltageCurrentV2BrickletFunction::SetCalibration => 15,
            VoltageCurrentV2BrickletFunction::GetCalibration => 16,
            VoltageCurrentV2BrickletFunction::GetSpitfpErrorCount => 234,
            VoltageCurrentV2BrickletFunction::SetBootloaderMode => 235,
            VoltageCurrentV2BrickletFunction::GetBootloaderMode => 236,
            VoltageCurrentV2BrickletFunction::SetWriteFirmwarePointer => 237,
            VoltageCurrentV2BrickletFunction::WriteFirmware => 238,
            VoltageCurrentV2BrickletFunction::SetStatusLedConfig => 239,
            VoltageCurrentV2BrickletFunction::GetStatusLedConfig => 240,
            VoltageCurrentV2BrickletFunction::GetChipTemperature => 242,
            VoltageCurrentV2BrickletFunction::Reset => 243,
            VoltageCurrentV2BrickletFunction::WriteUid => 248,
            VoltageCurrentV2BrickletFunction::ReadUid => 249,
            VoltageCurrentV2BrickletFunction::GetIdentity => 255,
            VoltageCurrentV2BrickletFunction::CallbackCurrent => 4,
            VoltageCurrentV2BrickletFunction::CallbackVoltage => 8,
            VoltageCurrentV2BrickletFunction::CallbackPower => 12,
        }
    }
}
pub const VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_1: u8 = 0;
pub const VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_4: u8 = 1;
pub const VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_16: u8 = 2;
pub const VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_64: u8 = 3;
pub const VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_128: u8 = 4;
pub const VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_256: u8 = 5;
pub const VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_512: u8 = 6;
pub const VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_1024: u8 = 7;
pub const VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_140US: u8 = 0;
pub const VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_204US: u8 = 1;
pub const VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_332US: u8 = 2;
pub const VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_588US: u8 = 3;
pub const VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_1_1MS: u8 = 4;
pub const VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_2_116MS: u8 = 5;
pub const VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_4_156MS: u8 = 6;
pub const VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_8_244MS: u8 = 7;
pub const VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const VOLTAGE_CURRENT_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const VOLTAGE_CURRENT_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const VOLTAGE_CURRENT_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const VOLTAGE_CURRENT_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CurrentCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for CurrentCallbackConfiguration {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> CurrentCallbackConfiguration {
        CurrentCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <i32>::from_le_byte_slice(&bytes[6..10]),
            max: <i32>::from_le_byte_slice(&bytes[10..14]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct VoltageCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for VoltageCallbackConfiguration {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> VoltageCallbackConfiguration {
        VoltageCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <i32>::from_le_byte_slice(&bytes[6..10]),
            max: <i32>::from_le_byte_slice(&bytes[10..14]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct PowerCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for PowerCallbackConfiguration {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> PowerCallbackConfiguration {
        PowerCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <i32>::from_le_byte_slice(&bytes[6..10]),
            max: <i32>::from_le_byte_slice(&bytes[10..14]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub averaging: u8,
    pub voltage_conversion_time: u8,
    pub current_conversion_time: u8,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration {
            averaging: <u8>::from_le_byte_slice(&bytes[0..1]),
            voltage_conversion_time: <u8>::from_le_byte_slice(&bytes[1..2]),
            current_conversion_time: <u8>::from_le_byte_slice(&bytes[2..3]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Calibration {
    pub voltage_multiplier: u16,
    pub voltage_divisor: u16,
    pub current_multiplier: u16,
    pub current_divisor: u16,
}
impl FromByteSlice for Calibration {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> Calibration {
        Calibration {
            voltage_multiplier: <u16>::from_le_byte_slice(&bytes[0..2]),
            voltage_divisor: <u16>::from_le_byte_slice(&bytes[2..4]),
            current_multiplier: <u16>::from_le_byte_slice(&bytes[4..6]),
            current_divisor: <u16>::from_le_byte_slice(&bytes[6..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures power, DC voltage and DC current up to 720W/36V/20A
#[derive(Clone)]
pub struct VoltageCurrentV2Bricklet {
    device: Device,
}
impl VoltageCurrentV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2105;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Voltage/Current Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> VoltageCurrentV2Bricklet {
        let mut result = VoltageCurrentV2Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::GetCurrent) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::SetCurrentCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::GetCurrentCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::GetVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::SetVoltageCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::GetVoltageCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::GetPower) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::SetPowerCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::GetPowerCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::SetConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::GetConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::SetCalibration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::GetCalibration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentV2BrickletFunction::GetIdentity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::voltage_current_v2_bricklet::VoltageCurrentV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::voltage_current_v2_bricklet::VoltageCurrentV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: VoltageCurrentV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: VoltageCurrentV2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_current_callback_configuration`].
    ///
    /// The parameter is the same as [`get_current`].
    ///
    /// [`get_current`]: #method.get_current
    /// [`set_current_callback_configuration`]: #method.set_current_callback_configuration
    pub fn get_current_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(VoltageCurrentV2BrickletFunction::CallbackCurrent))
    }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_voltage_callback_configuration`].
    ///
    /// The parameter is the same as [`get_voltage`].
    pub fn get_voltage_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(VoltageCurrentV2BrickletFunction::CallbackVoltage))
    }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_power_callback_configuration`].
    ///
    /// The parameter is the same as [`get_power`].
    pub fn get_power_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(VoltageCurrentV2BrickletFunction::CallbackPower))
    }

    /// Returns the current.
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_current_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_current_callback_configuration`].
    pub fn get_current(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentV2BrickletFunction::GetCurrent), payload)
    }

    /// The period is the period with which the [`get_current_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_current_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_current_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: i32,
        max: i32,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 14];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..10].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[10..14].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(VoltageCurrentV2BrickletFunction::SetCurrentCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_current_callback_configuration`].
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_current_callback_configuration(&self) -> ConvertingReceiver<CurrentCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentV2BrickletFunction::GetCurrentCallbackConfiguration), payload)
    }

    /// Returns the voltage.
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_voltage_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_voltage_callback_configuration`].
    pub fn get_voltage(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentV2BrickletFunction::GetVoltage), payload)
    }

    /// The period is the period with which the [`get_voltage_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_voltage_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_voltage_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: i32,
        max: i32,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 14];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..10].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[10..14].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(VoltageCurrentV2BrickletFunction::SetVoltageCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_voltage_callback_configuration`].
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_voltage_callback_configuration(&self) -> ConvertingReceiver<VoltageCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentV2BrickletFunction::GetVoltageCallbackConfiguration), payload)
    }

    /// Returns the power.
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_power_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_power_callback_configuration`].
    pub fn get_power(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentV2BrickletFunction::GetPower), payload)
    }

    /// The period is the period with which the [`get_power_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_power_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_power_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: i32,
        max: i32,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 14];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..10].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[10..14].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(VoltageCurrentV2BrickletFunction::SetPowerCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_power_callback_configuration`].
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_power_callback_configuration(&self) -> ConvertingReceiver<PowerCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentV2BrickletFunction::GetPowerCallbackConfiguration), payload)
    }

    /// Sets the configuration of the Voltage/Current Bricklet 2.0. It is
    /// possible to configure number of averages as well as
    /// voltage and current conversion time.
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_1
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_4
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_16
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_64
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_128
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_256
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_512
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_1024
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_140US
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_204US
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_332US
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_588US
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_1_1MS
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_2_116MS
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_4_156MS
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_8_244MS
    pub fn set_configuration(&self, averaging: u8, voltage_conversion_time: u8, current_conversion_time: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(averaging));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(voltage_conversion_time));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(current_conversion_time));

        self.device.set(u8::from(VoltageCurrentV2BrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_1
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_4
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_16
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_64
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_128
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_256
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_512
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_AVERAGING_1024
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_140US
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_204US
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_332US
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_588US
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_1_1MS
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_2_116MS
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_4_156MS
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_CONVERSION_TIME_8_244MS
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentV2BrickletFunction::GetConfiguration), payload)
    }

    /// Since the ADC and the shunt resistor used for the measurements
    /// are not perfect they need to be calibrated by a multiplier and
    /// a divisor if a very precise reading is needed.
    ///
    /// For example, if you are expecting a current of 1000mA and you
    /// are measuring 1023mA, you can calibrate the Voltage/Current Bricklet
    /// by setting the current multiplier to 1000 and the divisor to 1023.
    /// The same applies for the voltage.
    ///
    /// The calibration will be saved on the EEPROM of the Voltage/Current
    /// Bricklet and only needs to be done once.
    pub fn set_calibration(
        &self,
        voltage_multiplier: u16,
        voltage_divisor: u16,
        current_multiplier: u16,
        current_divisor: u16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 8];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(voltage_multiplier));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(voltage_divisor));
        payload[4..6].copy_from_slice(&<u16>::to_le_byte_vec(current_multiplier));
        payload[6..8].copy_from_slice(&<u16>::to_le_byte_vec(current_divisor));

        self.device.set(u8::from(VoltageCurrentV2BrickletFunction::SetCalibration), payload)
    }

    /// Returns the calibration as set by [`set_calibration`].
    pub fn get_calibration(&self) -> ConvertingReceiver<Calibration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentV2BrickletFunction::GetCalibration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(VoltageCurrentV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(VoltageCurrentV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(VoltageCurrentV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(VoltageCurrentV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* VOLTAGE_CURRENT_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(VoltageCurrentV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(VoltageCurrentV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentV2BrickletFunction::GetIdentity), payload)
    }
}
