/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures power, DC voltage and DC current up to 720W/36V/20A.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/VoltageCurrent_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum VoltageCurrentBrickletFunction {
    GetCurrent,
    GetVoltage,
    GetPower,
    SetConfiguration,
    GetConfiguration,
    SetCalibration,
    GetCalibration,
    SetCurrentCallbackPeriod,
    GetCurrentCallbackPeriod,
    SetVoltageCallbackPeriod,
    GetVoltageCallbackPeriod,
    SetPowerCallbackPeriod,
    GetPowerCallbackPeriod,
    SetCurrentCallbackThreshold,
    GetCurrentCallbackThreshold,
    SetVoltageCallbackThreshold,
    GetVoltageCallbackThreshold,
    SetPowerCallbackThreshold,
    GetPowerCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    GetIdentity,
    CallbackCurrent,
    CallbackVoltage,
    CallbackPower,
    CallbackCurrentReached,
    CallbackVoltageReached,
    CallbackPowerReached,
}
impl From<VoltageCurrentBrickletFunction> for u8 {
    fn from(fun: VoltageCurrentBrickletFunction) -> Self {
        match fun {
            VoltageCurrentBrickletFunction::GetCurrent => 1,
            VoltageCurrentBrickletFunction::GetVoltage => 2,
            VoltageCurrentBrickletFunction::GetPower => 3,
            VoltageCurrentBrickletFunction::SetConfiguration => 4,
            VoltageCurrentBrickletFunction::GetConfiguration => 5,
            VoltageCurrentBrickletFunction::SetCalibration => 6,
            VoltageCurrentBrickletFunction::GetCalibration => 7,
            VoltageCurrentBrickletFunction::SetCurrentCallbackPeriod => 8,
            VoltageCurrentBrickletFunction::GetCurrentCallbackPeriod => 9,
            VoltageCurrentBrickletFunction::SetVoltageCallbackPeriod => 10,
            VoltageCurrentBrickletFunction::GetVoltageCallbackPeriod => 11,
            VoltageCurrentBrickletFunction::SetPowerCallbackPeriod => 12,
            VoltageCurrentBrickletFunction::GetPowerCallbackPeriod => 13,
            VoltageCurrentBrickletFunction::SetCurrentCallbackThreshold => 14,
            VoltageCurrentBrickletFunction::GetCurrentCallbackThreshold => 15,
            VoltageCurrentBrickletFunction::SetVoltageCallbackThreshold => 16,
            VoltageCurrentBrickletFunction::GetVoltageCallbackThreshold => 17,
            VoltageCurrentBrickletFunction::SetPowerCallbackThreshold => 18,
            VoltageCurrentBrickletFunction::GetPowerCallbackThreshold => 19,
            VoltageCurrentBrickletFunction::SetDebouncePeriod => 20,
            VoltageCurrentBrickletFunction::GetDebouncePeriod => 21,
            VoltageCurrentBrickletFunction::GetIdentity => 255,
            VoltageCurrentBrickletFunction::CallbackCurrent => 22,
            VoltageCurrentBrickletFunction::CallbackVoltage => 23,
            VoltageCurrentBrickletFunction::CallbackPower => 24,
            VoltageCurrentBrickletFunction::CallbackCurrentReached => 25,
            VoltageCurrentBrickletFunction::CallbackVoltageReached => 26,
            VoltageCurrentBrickletFunction::CallbackPowerReached => 27,
        }
    }
}
pub const VOLTAGE_CURRENT_BRICKLET_AVERAGING_1: u8 = 0;
pub const VOLTAGE_CURRENT_BRICKLET_AVERAGING_4: u8 = 1;
pub const VOLTAGE_CURRENT_BRICKLET_AVERAGING_16: u8 = 2;
pub const VOLTAGE_CURRENT_BRICKLET_AVERAGING_64: u8 = 3;
pub const VOLTAGE_CURRENT_BRICKLET_AVERAGING_128: u8 = 4;
pub const VOLTAGE_CURRENT_BRICKLET_AVERAGING_256: u8 = 5;
pub const VOLTAGE_CURRENT_BRICKLET_AVERAGING_512: u8 = 6;
pub const VOLTAGE_CURRENT_BRICKLET_AVERAGING_1024: u8 = 7;
pub const VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_140US: u8 = 0;
pub const VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_204US: u8 = 1;
pub const VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_332US: u8 = 2;
pub const VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_588US: u8 = 3;
pub const VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_1_1MS: u8 = 4;
pub const VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_2_116MS: u8 = 5;
pub const VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_4_156MS: u8 = 6;
pub const VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_8_244MS: u8 = 7;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub averaging: u8,
    pub voltage_conversion_time: u8,
    pub current_conversion_time: u8,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration {
            averaging: <u8>::from_le_byte_slice(&bytes[0..1]),
            voltage_conversion_time: <u8>::from_le_byte_slice(&bytes[1..2]),
            current_conversion_time: <u8>::from_le_byte_slice(&bytes[2..3]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Calibration {
    pub gain_multiplier: u16,
    pub gain_divisor: u16,
}
impl FromByteSlice for Calibration {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> Calibration {
        Calibration { gain_multiplier: <u16>::from_le_byte_slice(&bytes[0..2]), gain_divisor: <u16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CurrentCallbackThreshold {
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for CurrentCallbackThreshold {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> CurrentCallbackThreshold {
        CurrentCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <i32>::from_le_byte_slice(&bytes[1..5]),
            max: <i32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct VoltageCallbackThreshold {
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for VoltageCallbackThreshold {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> VoltageCallbackThreshold {
        VoltageCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <i32>::from_le_byte_slice(&bytes[1..5]),
            max: <i32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct PowerCallbackThreshold {
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for PowerCallbackThreshold {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> PowerCallbackThreshold {
        PowerCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <i32>::from_le_byte_slice(&bytes[1..5]),
            max: <i32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures power, DC voltage and DC current up to 720W/36V/20A
#[derive(Clone)]
pub struct VoltageCurrentBricklet {
    device: Device,
}
impl VoltageCurrentBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 227;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Voltage/Current Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> VoltageCurrentBricklet {
        let mut result = VoltageCurrentBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::GetCurrent) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::GetVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::GetPower) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::SetConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::GetConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::SetCalibration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::GetCalibration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::SetCurrentCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::GetCurrentCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::SetVoltageCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::GetVoltageCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::SetPowerCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::GetPowerCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::SetCurrentCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::GetCurrentCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::SetVoltageCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::GetVoltageCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::SetPowerCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::GetPowerCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::GetDebouncePeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(VoltageCurrentBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::voltage_current_bricklet::VoltageCurrentBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::voltage_current_bricklet::VoltageCurrentBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: VoltageCurrentBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: VoltageCurrentBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_current_callback_period`]. The parameter is the current of the
    /// sensor.
    ///
    /// The [`get_current_callback_receiver`] receiver is only triggered if the current has changed since
    /// the last triggering.
    ///
    /// [`set_current_callback_period`]: #method.set_current_callback_period
    /// [`get_current_callback_receiver`]: #method.get_current_callback_receiver
    pub fn get_current_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(VoltageCurrentBrickletFunction::CallbackCurrent))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_voltage_callback_period`]. The parameter is the voltage of
    /// the sensor.
    ///
    /// The [`get_voltage_callback_receiver`] receiver is only triggered if the voltage has changed since
    /// the last triggering.
    pub fn get_voltage_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(VoltageCurrentBrickletFunction::CallbackVoltage))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_power_callback_period`]. The parameter is the power of the
    /// sensor.
    ///
    /// The [`get_power_callback_receiver`] receiver is only triggered if the power has changed since the
    /// last triggering.
    pub fn get_power_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(VoltageCurrentBrickletFunction::CallbackPower))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_current_callback_threshold`] is reached.
    /// The parameter is the current of the sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_current_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(VoltageCurrentBrickletFunction::CallbackCurrentReached))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_voltage_callback_threshold`] is reached.
    /// The parameter is the voltage of the sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_voltage_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(VoltageCurrentBrickletFunction::CallbackVoltageReached))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_power_callback_threshold`] is reached.
    /// The parameter is the power of the sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_power_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(VoltageCurrentBrickletFunction::CallbackPowerReached))
    }

    /// Returns the current.
    ///
    /// If you want to get the current periodically, it is recommended to use the
    /// [`get_current_callback_receiver`] receiver and set the period with
    /// [`set_current_callback_period`].
    pub fn get_current(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentBrickletFunction::GetCurrent), payload)
    }

    /// Returns the voltage.
    ///
    /// If you want to get the voltage periodically, it is recommended to use the
    /// [`get_voltage_callback_receiver`] receiver and set the period with
    /// [`set_voltage_callback_period`].
    pub fn get_voltage(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentBrickletFunction::GetVoltage), payload)
    }

    /// Returns the power.
    ///
    /// If you want to get the power periodically, it is recommended to use the
    /// [`get_power_callback_receiver`] receiver and set the period with
    /// [`set_power_callback_period`].
    pub fn get_power(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentBrickletFunction::GetPower), payload)
    }

    /// Sets the configuration of the Voltage/Current Bricklet. It is
    /// possible to configure number of averages as well as
    /// voltage and current conversion time.
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_BRICKLET_AVERAGING_1
    ///	* VOLTAGE_CURRENT_BRICKLET_AVERAGING_4
    ///	* VOLTAGE_CURRENT_BRICKLET_AVERAGING_16
    ///	* VOLTAGE_CURRENT_BRICKLET_AVERAGING_64
    ///	* VOLTAGE_CURRENT_BRICKLET_AVERAGING_128
    ///	* VOLTAGE_CURRENT_BRICKLET_AVERAGING_256
    ///	* VOLTAGE_CURRENT_BRICKLET_AVERAGING_512
    ///	* VOLTAGE_CURRENT_BRICKLET_AVERAGING_1024
    ///	* VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_140US
    ///	* VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_204US
    ///	* VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_332US
    ///	* VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_588US
    ///	* VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_1_1MS
    ///	* VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_2_116MS
    ///	* VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_4_156MS
    ///	* VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_8_244MS
    pub fn set_configuration(&self, averaging: u8, voltage_conversion_time: u8, current_conversion_time: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(averaging));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(voltage_conversion_time));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(current_conversion_time));

        self.device.set(u8::from(VoltageCurrentBrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_BRICKLET_AVERAGING_1
    ///	* VOLTAGE_CURRENT_BRICKLET_AVERAGING_4
    ///	* VOLTAGE_CURRENT_BRICKLET_AVERAGING_16
    ///	* VOLTAGE_CURRENT_BRICKLET_AVERAGING_64
    ///	* VOLTAGE_CURRENT_BRICKLET_AVERAGING_128
    ///	* VOLTAGE_CURRENT_BRICKLET_AVERAGING_256
    ///	* VOLTAGE_CURRENT_BRICKLET_AVERAGING_512
    ///	* VOLTAGE_CURRENT_BRICKLET_AVERAGING_1024
    ///	* VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_140US
    ///	* VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_204US
    ///	* VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_332US
    ///	* VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_588US
    ///	* VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_1_1MS
    ///	* VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_2_116MS
    ///	* VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_4_156MS
    ///	* VOLTAGE_CURRENT_BRICKLET_CONVERSION_TIME_8_244MS
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentBrickletFunction::GetConfiguration), payload)
    }

    /// Since the shunt resistor that is used to measure the current is not
    /// perfectly precise, it needs to be calibrated by a multiplier and
    /// divisor if a very precise reading is needed.
    ///
    /// For example, if you are expecting a measurement of 1000mA and you
    /// are measuring 1023mA, you can calibrate the Voltage/Current Bricklet
    /// by setting the multiplier to 1000 and the divisor to 1023.
    pub fn set_calibration(&self, gain_multiplier: u16, gain_divisor: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(gain_multiplier));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(gain_divisor));

        self.device.set(u8::from(VoltageCurrentBrickletFunction::SetCalibration), payload)
    }

    /// Returns the calibration as set by [`set_calibration`].
    pub fn get_calibration(&self) -> ConvertingReceiver<Calibration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentBrickletFunction::GetCalibration), payload)
    }

    /// Sets the period with which the [`get_current_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_current_callback_receiver`] receiver is only triggered if the current has changed since
    /// the last triggering.
    pub fn set_current_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(VoltageCurrentBrickletFunction::SetCurrentCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_current_callback_period`].
    pub fn get_current_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentBrickletFunction::GetCurrentCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_voltage_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_voltage_callback_receiver`] receiver is only triggered if the voltage has changed since
    /// the last triggering.
    pub fn set_voltage_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(VoltageCurrentBrickletFunction::SetVoltageCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_voltage_callback_period`].
    pub fn get_voltage_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentBrickletFunction::GetVoltageCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_power_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_power_callback_receiver`] receiver is only triggered if the power has changed since the
    /// last triggering.
    pub fn set_power_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(VoltageCurrentBrickletFunction::SetPowerCallbackPeriod), payload)
    }

    /// Returns the period as set by [`get_power_callback_period`].
    pub fn get_power_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentBrickletFunction::GetPowerCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_current_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the current is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the current is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the current is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the current is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_current_callback_threshold(&self, option: char, min: i32, max: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..5].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[5..9].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(VoltageCurrentBrickletFunction::SetCurrentCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_current_callback_threshold`].
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_current_callback_threshold(&self) -> ConvertingReceiver<CurrentCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentBrickletFunction::GetCurrentCallbackThreshold), payload)
    }

    /// Sets the thresholds for the [`get_voltage_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the voltage is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the voltage is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the voltage is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the voltage is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_voltage_callback_threshold(&self, option: char, min: i32, max: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..5].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[5..9].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(VoltageCurrentBrickletFunction::SetVoltageCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_voltage_callback_threshold`].
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_voltage_callback_threshold(&self) -> ConvertingReceiver<VoltageCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentBrickletFunction::GetVoltageCallbackThreshold), payload)
    }

    /// Sets the thresholds for the [`get_power_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the power is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the power is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the power is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the power is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_power_callback_threshold(&self, option: char, min: i32, max: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..5].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[5..9].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(VoltageCurrentBrickletFunction::SetPowerCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_power_callback_threshold`].
    ///
    /// Associated constants:
    /// * VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* VOLTAGE_CURRENT_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_power_callback_threshold(&self) -> ConvertingReceiver<PowerCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentBrickletFunction::GetPowerCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receivers
    ///
    /// * [`get_current_reached_callback_receiver`],
    /// * [`get_voltage_reached_callback_receiver`],
    /// * [`get_power_reached_callback_receiver`]
    ///
    /// are triggered, if the thresholds
    ///
    /// * [`set_current_callback_threshold`],
    /// * [`set_voltage_callback_threshold`],
    /// * [`set_power_callback_threshold`]
    ///
    /// keep being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(VoltageCurrentBrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentBrickletFunction::GetDebouncePeriod), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(VoltageCurrentBrickletFunction::GetIdentity), payload)
    }
}
