/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures UV light.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/UVLight_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum UvLightBrickletFunction {
    GetUvLight,
    SetUvLightCallbackPeriod,
    GetUvLightCallbackPeriod,
    SetUvLightCallbackThreshold,
    GetUvLightCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    GetIdentity,
    CallbackUvLight,
    CallbackUvLightReached,
}
impl From<UvLightBrickletFunction> for u8 {
    fn from(fun: UvLightBrickletFunction) -> Self {
        match fun {
            UvLightBrickletFunction::GetUvLight => 1,
            UvLightBrickletFunction::SetUvLightCallbackPeriod => 2,
            UvLightBrickletFunction::GetUvLightCallbackPeriod => 3,
            UvLightBrickletFunction::SetUvLightCallbackThreshold => 4,
            UvLightBrickletFunction::GetUvLightCallbackThreshold => 5,
            UvLightBrickletFunction::SetDebouncePeriod => 6,
            UvLightBrickletFunction::GetDebouncePeriod => 7,
            UvLightBrickletFunction::GetIdentity => 255,
            UvLightBrickletFunction::CallbackUvLight => 8,
            UvLightBrickletFunction::CallbackUvLightReached => 9,
        }
    }
}
pub const UV_LIGHT_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const UV_LIGHT_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const UV_LIGHT_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const UV_LIGHT_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const UV_LIGHT_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct UvLightCallbackThreshold {
    pub option: char,
    pub min: u32,
    pub max: u32,
}
impl FromByteSlice for UvLightCallbackThreshold {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> UvLightCallbackThreshold {
        UvLightCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <u32>::from_le_byte_slice(&bytes[1..5]),
            max: <u32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures UV light
#[derive(Clone)]
pub struct UvLightBricklet {
    device: Device,
}
impl UvLightBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 265;
    pub const DEVICE_DISPLAY_NAME: &'static str = "UV Light Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> UvLightBricklet {
        let mut result = UvLightBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(UvLightBrickletFunction::GetUvLight) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(UvLightBrickletFunction::SetUvLightCallbackPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(UvLightBrickletFunction::GetUvLightCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(UvLightBrickletFunction::SetUvLightCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(UvLightBrickletFunction::GetUvLightCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(UvLightBrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(UvLightBrickletFunction::GetDebouncePeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(UvLightBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::uv_light_bricklet::UvLightBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::uv_light_bricklet::UvLightBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: UvLightBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: UvLightBrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_uv_light_callback_period`]. The parameter is the UV Light
    /// intensity of the sensor.
    ///
    /// The [`get_uv_light_callback_receiver`] receiver is only triggered if the intensity has changed
    /// since the last triggering.
    ///
    /// [`set_uv_light_callback_period`]: #method.set_uv_light_callback_period
    /// [`get_uv_light_callback_receiver`]: #method.get_uv_light_callback_receiver
    pub fn get_uv_light_callback_receiver(&self) -> ConvertingCallbackReceiver<u32> {
        self.device.get_callback_receiver(u8::from(UvLightBrickletFunction::CallbackUvLight))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_uv_light_callback_threshold`] is reached.
    /// The parameter is the UV Light intensity of the sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_uv_light_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<u32> {
        self.device.get_callback_receiver(u8::from(UvLightBrickletFunction::CallbackUvLightReached))
    }

    /// Returns the UV light intensity of the sensor.
    /// The sensor has already weighted the intensity with the erythemal
    /// action spectrum to get the skin-affecting irradiation.
    ///
    /// To get UV index you just have to divide the value by 250. For example, a UV
    /// light intensity of 500 is equivalent to an UV index of 2.
    ///
    /// If you want to get the intensity periodically, it is recommended to use the
    /// [`get_uv_light_callback_receiver`] receiver and set the period with
    /// [`set_uv_light_callback_period`].
    pub fn get_uv_light(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(UvLightBrickletFunction::GetUvLight), payload)
    }

    /// Sets the period with which the [`get_uv_light_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_uv_light_callback_receiver`] receiver is only triggered if the intensity has changed since
    /// the last triggering.
    pub fn set_uv_light_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(UvLightBrickletFunction::SetUvLightCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_uv_light_callback_period`].
    pub fn get_uv_light_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(UvLightBrickletFunction::GetUvLightCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_uv_light_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the intensity is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the intensity is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the intensity is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the intensity is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * UV_LIGHT_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* UV_LIGHT_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* UV_LIGHT_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* UV_LIGHT_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* UV_LIGHT_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_uv_light_callback_threshold(&self, option: char, min: u32, max: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(min));
        payload[5..9].copy_from_slice(&<u32>::to_le_byte_vec(max));

        self.device.set(u8::from(UvLightBrickletFunction::SetUvLightCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_uv_light_callback_threshold`].
    ///
    /// Associated constants:
    /// * UV_LIGHT_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* UV_LIGHT_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* UV_LIGHT_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* UV_LIGHT_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* UV_LIGHT_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_uv_light_callback_threshold(&self) -> ConvertingReceiver<UvLightCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(UvLightBrickletFunction::GetUvLightCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receivers
    ///
    /// * [`get_uv_light_reached_callback_receiver`],
    ///
    /// are triggered, if the thresholds
    ///
    /// * [`set_uv_light_callback_threshold`],
    ///
    /// keep being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(UvLightBrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(UvLightBrickletFunction::GetDebouncePeriod), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(UvLightBrickletFunction::GetIdentity), payload)
    }
}
