/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures temperature with thermocouples.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/ThermocoupleV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum ThermocoupleV2BrickletFunction {
    GetTemperature,
    SetTemperatureCallbackConfiguration,
    GetTemperatureCallbackConfiguration,
    SetConfiguration,
    GetConfiguration,
    GetErrorState,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackTemperature,
    CallbackErrorState,
}
impl From<ThermocoupleV2BrickletFunction> for u8 {
    fn from(fun: ThermocoupleV2BrickletFunction) -> Self {
        match fun {
            ThermocoupleV2BrickletFunction::GetTemperature => 1,
            ThermocoupleV2BrickletFunction::SetTemperatureCallbackConfiguration => 2,
            ThermocoupleV2BrickletFunction::GetTemperatureCallbackConfiguration => 3,
            ThermocoupleV2BrickletFunction::SetConfiguration => 5,
            ThermocoupleV2BrickletFunction::GetConfiguration => 6,
            ThermocoupleV2BrickletFunction::GetErrorState => 7,
            ThermocoupleV2BrickletFunction::GetSpitfpErrorCount => 234,
            ThermocoupleV2BrickletFunction::SetBootloaderMode => 235,
            ThermocoupleV2BrickletFunction::GetBootloaderMode => 236,
            ThermocoupleV2BrickletFunction::SetWriteFirmwarePointer => 237,
            ThermocoupleV2BrickletFunction::WriteFirmware => 238,
            ThermocoupleV2BrickletFunction::SetStatusLedConfig => 239,
            ThermocoupleV2BrickletFunction::GetStatusLedConfig => 240,
            ThermocoupleV2BrickletFunction::GetChipTemperature => 242,
            ThermocoupleV2BrickletFunction::Reset => 243,
            ThermocoupleV2BrickletFunction::WriteUid => 248,
            ThermocoupleV2BrickletFunction::ReadUid => 249,
            ThermocoupleV2BrickletFunction::GetIdentity => 255,
            ThermocoupleV2BrickletFunction::CallbackTemperature => 4,
            ThermocoupleV2BrickletFunction::CallbackErrorState => 8,
        }
    }
}
pub const THERMOCOUPLE_V2_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const THERMOCOUPLE_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const THERMOCOUPLE_V2_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const THERMOCOUPLE_V2_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const THERMOCOUPLE_V2_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const THERMOCOUPLE_V2_BRICKLET_AVERAGING_1: u8 = 1;
pub const THERMOCOUPLE_V2_BRICKLET_AVERAGING_2: u8 = 2;
pub const THERMOCOUPLE_V2_BRICKLET_AVERAGING_4: u8 = 4;
pub const THERMOCOUPLE_V2_BRICKLET_AVERAGING_8: u8 = 8;
pub const THERMOCOUPLE_V2_BRICKLET_AVERAGING_16: u8 = 16;
pub const THERMOCOUPLE_V2_BRICKLET_TYPE_B: u8 = 0;
pub const THERMOCOUPLE_V2_BRICKLET_TYPE_E: u8 = 1;
pub const THERMOCOUPLE_V2_BRICKLET_TYPE_J: u8 = 2;
pub const THERMOCOUPLE_V2_BRICKLET_TYPE_K: u8 = 3;
pub const THERMOCOUPLE_V2_BRICKLET_TYPE_N: u8 = 4;
pub const THERMOCOUPLE_V2_BRICKLET_TYPE_R: u8 = 5;
pub const THERMOCOUPLE_V2_BRICKLET_TYPE_S: u8 = 6;
pub const THERMOCOUPLE_V2_BRICKLET_TYPE_T: u8 = 7;
pub const THERMOCOUPLE_V2_BRICKLET_TYPE_G8: u8 = 8;
pub const THERMOCOUPLE_V2_BRICKLET_TYPE_G32: u8 = 9;
pub const THERMOCOUPLE_V2_BRICKLET_FILTER_OPTION_50HZ: u8 = 0;
pub const THERMOCOUPLE_V2_BRICKLET_FILTER_OPTION_60HZ: u8 = 1;
pub const THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const THERMOCOUPLE_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const THERMOCOUPLE_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const THERMOCOUPLE_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const THERMOCOUPLE_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct TemperatureCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for TemperatureCallbackConfiguration {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> TemperatureCallbackConfiguration {
        TemperatureCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <i32>::from_le_byte_slice(&bytes[6..10]),
            max: <i32>::from_le_byte_slice(&bytes[10..14]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub averaging: u8,
    pub thermocouple_type: u8,
    pub filter: u8,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration {
            averaging: <u8>::from_le_byte_slice(&bytes[0..1]),
            thermocouple_type: <u8>::from_le_byte_slice(&bytes[1..2]),
            filter: <u8>::from_le_byte_slice(&bytes[2..3]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ErrorState {
    pub over_under: bool,
    pub open_circuit: bool,
}
impl FromByteSlice for ErrorState {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> ErrorState {
        ErrorState { over_under: <bool>::from_le_byte_slice(&bytes[0..1]), open_circuit: <bool>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ErrorStateEvent {
    pub over_under: bool,
    pub open_circuit: bool,
}
impl FromByteSlice for ErrorStateEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> ErrorStateEvent {
        ErrorStateEvent { over_under: <bool>::from_le_byte_slice(&bytes[0..1]), open_circuit: <bool>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures temperature with thermocouples
#[derive(Clone)]
pub struct ThermocoupleV2Bricklet {
    device: Device,
}
impl ThermocoupleV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2109;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Thermocouple Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> ThermocoupleV2Bricklet {
        let mut result = ThermocoupleV2Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(ThermocoupleV2BrickletFunction::GetTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermocoupleV2BrickletFunction::SetTemperatureCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ThermocoupleV2BrickletFunction::GetTemperatureCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermocoupleV2BrickletFunction::SetConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ThermocoupleV2BrickletFunction::GetConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermocoupleV2BrickletFunction::GetErrorState) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermocoupleV2BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermocoupleV2BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermocoupleV2BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermocoupleV2BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ThermocoupleV2BrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermocoupleV2BrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ThermocoupleV2BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermocoupleV2BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermocoupleV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ThermocoupleV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ThermocoupleV2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermocoupleV2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::thermocouple_v2_bricklet::ThermocoupleV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::thermocouple_v2_bricklet::ThermocoupleV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: ThermocoupleV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: ThermocoupleV2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_temperature_callback_configuration`].
    ///
    /// The parameter is the same as [`get_temperature`].
    ///
    /// [`get_temperature`]: #method.get_temperature
    /// [`set_temperature_callback_configuration`]: #method.set_temperature_callback_configuration
    pub fn get_temperature_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(ThermocoupleV2BrickletFunction::CallbackTemperature))
    }

    /// This Receiver is triggered every time the error state changes
    /// (see [`get_error_state`]).
    pub fn get_error_state_callback_receiver(&self) -> ConvertingCallbackReceiver<ErrorStateEvent> {
        self.device.get_callback_receiver(u8::from(ThermocoupleV2BrickletFunction::CallbackErrorState))
    }

    /// Returns the temperature of the thermocouple. The value is given in °C/100,
    /// e.g. a value of 4223 means that a temperature of 42.23 °C is measured.
    ///
    /// If you want to get the temperature periodically, it is recommended
    /// to use the [`get_temperature_callback_receiver`] receiver and set the period with
    /// [`set_temperature_callback_configuration`].
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_temperature_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_temperature_callback_configuration`].
    pub fn get_temperature(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermocoupleV2BrickletFunction::GetTemperature), payload)
    }

    /// The period is the period with which the [`get_temperature_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_temperature_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * THERMOCOUPLE_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* THERMOCOUPLE_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* THERMOCOUPLE_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* THERMOCOUPLE_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* THERMOCOUPLE_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_temperature_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: i32,
        max: i32,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 14];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..10].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[10..14].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(ThermocoupleV2BrickletFunction::SetTemperatureCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_temperature_callback_configuration`].
    ///
    /// Associated constants:
    /// * THERMOCOUPLE_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* THERMOCOUPLE_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* THERMOCOUPLE_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* THERMOCOUPLE_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* THERMOCOUPLE_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_temperature_callback_configuration(&self) -> ConvertingReceiver<TemperatureCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermocoupleV2BrickletFunction::GetTemperatureCallbackConfiguration), payload)
    }

    /// You can configure averaging size, thermocouple type and frequency
    /// filtering.
    ///
    /// Available averaging sizes are 1, 2, 4, 8 and 16 samples.
    ///
    /// As thermocouple type you can use B, E, J, K, N, R, S and T. If you have a
    /// different thermocouple or a custom thermocouple you can also use
    /// G8 and G32. With these types the returned value will not be in °C/100,
    /// it will be calculated by the following formulas:
    ///
    /// * G8: ``value = 8 * 1.6 * 2^17 * Vin``
    /// * G32: ``value = 32 * 1.6 * 2^17 * Vin``
    ///
    /// where Vin is the thermocouple input voltage.
    ///
    /// The frequency filter can be either configured to 50Hz or to 60Hz. You should
    /// configure it according to your utility frequency.
    ///
    /// The conversion time depends on the averaging and filter configuration, it can
    /// be calculated as follows:
    ///
    /// * 60Hz: ``time = 82 + (samples - 1) * 16.67``
    /// * 50Hz: ``time = 98 + (samples - 1) * 20``
    ///
    /// Associated constants:
    /// * THERMOCOUPLE_V2_BRICKLET_AVERAGING_1
    ///	* THERMOCOUPLE_V2_BRICKLET_AVERAGING_2
    ///	* THERMOCOUPLE_V2_BRICKLET_AVERAGING_4
    ///	* THERMOCOUPLE_V2_BRICKLET_AVERAGING_8
    ///	* THERMOCOUPLE_V2_BRICKLET_AVERAGING_16
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_B
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_E
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_J
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_K
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_N
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_R
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_S
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_T
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_G8
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_G32
    ///	* THERMOCOUPLE_V2_BRICKLET_FILTER_OPTION_50HZ
    ///	* THERMOCOUPLE_V2_BRICKLET_FILTER_OPTION_60HZ
    pub fn set_configuration(&self, averaging: u8, thermocouple_type: u8, filter: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(averaging));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(thermocouple_type));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(filter));

        self.device.set(u8::from(ThermocoupleV2BrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    ///
    /// Associated constants:
    /// * THERMOCOUPLE_V2_BRICKLET_AVERAGING_1
    ///	* THERMOCOUPLE_V2_BRICKLET_AVERAGING_2
    ///	* THERMOCOUPLE_V2_BRICKLET_AVERAGING_4
    ///	* THERMOCOUPLE_V2_BRICKLET_AVERAGING_8
    ///	* THERMOCOUPLE_V2_BRICKLET_AVERAGING_16
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_B
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_E
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_J
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_K
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_N
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_R
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_S
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_T
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_G8
    ///	* THERMOCOUPLE_V2_BRICKLET_TYPE_G32
    ///	* THERMOCOUPLE_V2_BRICKLET_FILTER_OPTION_50HZ
    ///	* THERMOCOUPLE_V2_BRICKLET_FILTER_OPTION_60HZ
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermocoupleV2BrickletFunction::GetConfiguration), payload)
    }

    /// Returns the current error state. There are two possible errors:
    ///
    /// * Over/Under Voltage and
    /// * Open Circuit.
    ///
    /// Over/Under Voltage happens for voltages below 0V or above 3.3V. In this case
    /// it is very likely that your thermocouple is defective. An Open Circuit error
    /// indicates that there is no thermocouple connected.
    ///
    /// You can use the [`get_error_state_callback_receiver`] receiver to automatically get triggered
    /// when the error state changes.
    pub fn get_error_state(&self) -> ConvertingReceiver<ErrorState> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermocoupleV2BrickletFunction::GetErrorState), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermocoupleV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(ThermocoupleV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* THERMOCOUPLE_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermocoupleV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(ThermocoupleV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(ThermocoupleV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * THERMOCOUPLE_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* THERMOCOUPLE_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* THERMOCOUPLE_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* THERMOCOUPLE_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(ThermocoupleV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * THERMOCOUPLE_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* THERMOCOUPLE_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* THERMOCOUPLE_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* THERMOCOUPLE_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermocoupleV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermocoupleV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ThermocoupleV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(ThermocoupleV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermocoupleV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermocoupleV2BrickletFunction::GetIdentity), payload)
    }
}
