/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures temperature with thermocouples.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/Thermocouple_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum ThermocoupleBrickletFunction {
    GetTemperature,
    SetTemperatureCallbackPeriod,
    GetTemperatureCallbackPeriod,
    SetTemperatureCallbackThreshold,
    GetTemperatureCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    SetConfiguration,
    GetConfiguration,
    GetErrorState,
    GetIdentity,
    CallbackTemperature,
    CallbackTemperatureReached,
    CallbackErrorState,
}
impl From<ThermocoupleBrickletFunction> for u8 {
    fn from(fun: ThermocoupleBrickletFunction) -> Self {
        match fun {
            ThermocoupleBrickletFunction::GetTemperature => 1,
            ThermocoupleBrickletFunction::SetTemperatureCallbackPeriod => 2,
            ThermocoupleBrickletFunction::GetTemperatureCallbackPeriod => 3,
            ThermocoupleBrickletFunction::SetTemperatureCallbackThreshold => 4,
            ThermocoupleBrickletFunction::GetTemperatureCallbackThreshold => 5,
            ThermocoupleBrickletFunction::SetDebouncePeriod => 6,
            ThermocoupleBrickletFunction::GetDebouncePeriod => 7,
            ThermocoupleBrickletFunction::SetConfiguration => 10,
            ThermocoupleBrickletFunction::GetConfiguration => 11,
            ThermocoupleBrickletFunction::GetErrorState => 12,
            ThermocoupleBrickletFunction::GetIdentity => 255,
            ThermocoupleBrickletFunction::CallbackTemperature => 8,
            ThermocoupleBrickletFunction::CallbackTemperatureReached => 9,
            ThermocoupleBrickletFunction::CallbackErrorState => 13,
        }
    }
}
pub const THERMOCOUPLE_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const THERMOCOUPLE_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const THERMOCOUPLE_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const THERMOCOUPLE_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const THERMOCOUPLE_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const THERMOCOUPLE_BRICKLET_AVERAGING_1: u8 = 1;
pub const THERMOCOUPLE_BRICKLET_AVERAGING_2: u8 = 2;
pub const THERMOCOUPLE_BRICKLET_AVERAGING_4: u8 = 4;
pub const THERMOCOUPLE_BRICKLET_AVERAGING_8: u8 = 8;
pub const THERMOCOUPLE_BRICKLET_AVERAGING_16: u8 = 16;
pub const THERMOCOUPLE_BRICKLET_TYPE_B: u8 = 0;
pub const THERMOCOUPLE_BRICKLET_TYPE_E: u8 = 1;
pub const THERMOCOUPLE_BRICKLET_TYPE_J: u8 = 2;
pub const THERMOCOUPLE_BRICKLET_TYPE_K: u8 = 3;
pub const THERMOCOUPLE_BRICKLET_TYPE_N: u8 = 4;
pub const THERMOCOUPLE_BRICKLET_TYPE_R: u8 = 5;
pub const THERMOCOUPLE_BRICKLET_TYPE_S: u8 = 6;
pub const THERMOCOUPLE_BRICKLET_TYPE_T: u8 = 7;
pub const THERMOCOUPLE_BRICKLET_TYPE_G8: u8 = 8;
pub const THERMOCOUPLE_BRICKLET_TYPE_G32: u8 = 9;
pub const THERMOCOUPLE_BRICKLET_FILTER_OPTION_50HZ: u8 = 0;
pub const THERMOCOUPLE_BRICKLET_FILTER_OPTION_60HZ: u8 = 1;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct TemperatureCallbackThreshold {
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for TemperatureCallbackThreshold {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> TemperatureCallbackThreshold {
        TemperatureCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <i32>::from_le_byte_slice(&bytes[1..5]),
            max: <i32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub averaging: u8,
    pub thermocouple_type: u8,
    pub filter: u8,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration {
            averaging: <u8>::from_le_byte_slice(&bytes[0..1]),
            thermocouple_type: <u8>::from_le_byte_slice(&bytes[1..2]),
            filter: <u8>::from_le_byte_slice(&bytes[2..3]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ErrorState {
    pub over_under: bool,
    pub open_circuit: bool,
}
impl FromByteSlice for ErrorState {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> ErrorState {
        ErrorState { over_under: <bool>::from_le_byte_slice(&bytes[0..1]), open_circuit: <bool>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ErrorStateEvent {
    pub over_under: bool,
    pub open_circuit: bool,
}
impl FromByteSlice for ErrorStateEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> ErrorStateEvent {
        ErrorStateEvent { over_under: <bool>::from_le_byte_slice(&bytes[0..1]), open_circuit: <bool>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures temperature with thermocouples
#[derive(Clone)]
pub struct ThermocoupleBricklet {
    device: Device,
}
impl ThermocoupleBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 266;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Thermocouple Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> ThermocoupleBricklet {
        let mut result = ThermocoupleBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(ThermocoupleBrickletFunction::GetTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermocoupleBrickletFunction::SetTemperatureCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ThermocoupleBrickletFunction::GetTemperatureCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermocoupleBrickletFunction::SetTemperatureCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ThermocoupleBrickletFunction::GetTemperatureCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermocoupleBrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ThermocoupleBrickletFunction::GetDebouncePeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermocoupleBrickletFunction::SetConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ThermocoupleBrickletFunction::GetConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermocoupleBrickletFunction::GetErrorState) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermocoupleBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::thermocouple_bricklet::ThermocoupleBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::thermocouple_bricklet::ThermocoupleBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: ThermocoupleBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: ThermocoupleBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_temperature_callback_period`]. The parameter is the
    /// temperature of the thermocouple.
    ///
    /// The [`get_temperature_callback_receiver`] receiver is only triggered if the temperature has
    /// changed since the last triggering.
    ///
    /// [`set_temperature_callback_period`]: #method.set_temperature_callback_period
    /// [`get_temperature_callback_receiver`]: #method.get_temperature_callback_receiver
    pub fn get_temperature_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(ThermocoupleBrickletFunction::CallbackTemperature))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_temperature_callback_threshold`] is reached.
    /// The parameter is the temperature of the thermocouple.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_temperature_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(ThermocoupleBrickletFunction::CallbackTemperatureReached))
    }

    /// This Receiver is triggered every time the error state changes
    /// (see [`get_error_state`]).
    pub fn get_error_state_callback_receiver(&self) -> ConvertingCallbackReceiver<ErrorStateEvent> {
        self.device.get_callback_receiver(u8::from(ThermocoupleBrickletFunction::CallbackErrorState))
    }

    /// Returns the temperature of the thermocouple.
    ///
    /// If you want to get the temperature periodically, it is recommended
    /// to use the [`get_temperature_callback_receiver`] receiver and set the period with
    /// [`set_temperature_callback_period`].
    pub fn get_temperature(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermocoupleBrickletFunction::GetTemperature), payload)
    }

    /// Sets the period with which the [`get_temperature_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_temperature_callback_receiver`] receiver is only triggered if the temperature has changed
    /// since the last triggering.
    pub fn set_temperature_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ThermocoupleBrickletFunction::SetTemperatureCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_temperature_callback_period`].
    pub fn get_temperature_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermocoupleBrickletFunction::GetTemperatureCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_temperature_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the temperature is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the temperature is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the temperature is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the temperature is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * THERMOCOUPLE_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* THERMOCOUPLE_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* THERMOCOUPLE_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* THERMOCOUPLE_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* THERMOCOUPLE_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_temperature_callback_threshold(&self, option: char, min: i32, max: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..5].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[5..9].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(ThermocoupleBrickletFunction::SetTemperatureCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_temperature_callback_threshold`].
    ///
    /// Associated constants:
    /// * THERMOCOUPLE_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* THERMOCOUPLE_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* THERMOCOUPLE_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* THERMOCOUPLE_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* THERMOCOUPLE_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_temperature_callback_threshold(&self) -> ConvertingReceiver<TemperatureCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermocoupleBrickletFunction::GetTemperatureCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receiver
    ///
    /// * [`get_temperature_reached_callback_receiver`]
    ///
    /// is triggered, if the threshold
    ///
    /// * [`set_temperature_callback_threshold`]
    ///
    /// keeps being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(ThermocoupleBrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermocoupleBrickletFunction::GetDebouncePeriod), payload)
    }

    /// You can configure averaging size, thermocouple type and frequency
    /// filtering.
    ///
    /// Available averaging sizes are 1, 2, 4, 8 and 16 samples.
    ///
    /// As thermocouple type you can use B, E, J, K, N, R, S and T. If you have a
    /// different thermocouple or a custom thermocouple you can also use
    /// G8 and G32. With these types the returned value will not be in °C/100,
    /// it will be calculated by the following formulas:
    ///
    /// * G8: ``value = 8 * 1.6 * 2^17 * Vin``
    /// * G32: ``value = 32 * 1.6 * 2^17 * Vin``
    ///
    /// where Vin is the thermocouple input voltage.
    ///
    /// The frequency filter can be either configured to 50Hz or to 60Hz. You should
    /// configure it according to your utility frequency.
    ///
    /// The conversion time depends on the averaging and filter configuration, it can
    /// be calculated as follows:
    ///
    /// * 60Hz: ``time = 82 + (samples - 1) * 16.67``
    /// * 50Hz: ``time = 98 + (samples - 1) * 20``
    ///
    /// Associated constants:
    /// * THERMOCOUPLE_BRICKLET_AVERAGING_1
    ///	* THERMOCOUPLE_BRICKLET_AVERAGING_2
    ///	* THERMOCOUPLE_BRICKLET_AVERAGING_4
    ///	* THERMOCOUPLE_BRICKLET_AVERAGING_8
    ///	* THERMOCOUPLE_BRICKLET_AVERAGING_16
    ///	* THERMOCOUPLE_BRICKLET_TYPE_B
    ///	* THERMOCOUPLE_BRICKLET_TYPE_E
    ///	* THERMOCOUPLE_BRICKLET_TYPE_J
    ///	* THERMOCOUPLE_BRICKLET_TYPE_K
    ///	* THERMOCOUPLE_BRICKLET_TYPE_N
    ///	* THERMOCOUPLE_BRICKLET_TYPE_R
    ///	* THERMOCOUPLE_BRICKLET_TYPE_S
    ///	* THERMOCOUPLE_BRICKLET_TYPE_T
    ///	* THERMOCOUPLE_BRICKLET_TYPE_G8
    ///	* THERMOCOUPLE_BRICKLET_TYPE_G32
    ///	* THERMOCOUPLE_BRICKLET_FILTER_OPTION_50HZ
    ///	* THERMOCOUPLE_BRICKLET_FILTER_OPTION_60HZ
    pub fn set_configuration(&self, averaging: u8, thermocouple_type: u8, filter: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(averaging));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(thermocouple_type));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(filter));

        self.device.set(u8::from(ThermocoupleBrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    ///
    /// Associated constants:
    /// * THERMOCOUPLE_BRICKLET_AVERAGING_1
    ///	* THERMOCOUPLE_BRICKLET_AVERAGING_2
    ///	* THERMOCOUPLE_BRICKLET_AVERAGING_4
    ///	* THERMOCOUPLE_BRICKLET_AVERAGING_8
    ///	* THERMOCOUPLE_BRICKLET_AVERAGING_16
    ///	* THERMOCOUPLE_BRICKLET_TYPE_B
    ///	* THERMOCOUPLE_BRICKLET_TYPE_E
    ///	* THERMOCOUPLE_BRICKLET_TYPE_J
    ///	* THERMOCOUPLE_BRICKLET_TYPE_K
    ///	* THERMOCOUPLE_BRICKLET_TYPE_N
    ///	* THERMOCOUPLE_BRICKLET_TYPE_R
    ///	* THERMOCOUPLE_BRICKLET_TYPE_S
    ///	* THERMOCOUPLE_BRICKLET_TYPE_T
    ///	* THERMOCOUPLE_BRICKLET_TYPE_G8
    ///	* THERMOCOUPLE_BRICKLET_TYPE_G32
    ///	* THERMOCOUPLE_BRICKLET_FILTER_OPTION_50HZ
    ///	* THERMOCOUPLE_BRICKLET_FILTER_OPTION_60HZ
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermocoupleBrickletFunction::GetConfiguration), payload)
    }

    /// Returns the current error state. There are two possible errors:
    ///
    /// * Over/Under Voltage and
    /// * Open Circuit.
    ///
    /// Over/Under Voltage happens for voltages below 0V or above 3.3V. In this case
    /// it is very likely that your thermocouple is defective. An Open Circuit error
    /// indicates that there is no thermocouple connected.
    ///
    /// You can use the [`get_error_state_callback_receiver`] receiver to automatically get triggered
    /// when the error state changes.
    pub fn get_error_state(&self) -> ConvertingReceiver<ErrorState> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermocoupleBrickletFunction::GetErrorState), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermocoupleBrickletFunction::GetIdentity), payload)
    }
}
