/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! 80x60 pixel thermal imaging camera.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/ThermalImaging_Bricklet_Rust.html).
use crate::{
    byte_converter::*,
    converting_callback_receiver::ConvertingCallbackReceiver,
    converting_high_level_callback_receiver::ConvertingHighLevelCallbackReceiver,
    converting_receiver::{BrickletRecvTimeoutError, ConvertingReceiver},
    device::*,
    ip_connection::GetRequestSender,
    low_level_traits::*,
};
pub enum ThermalImagingBrickletFunction {
    GetHighContrastImageLowLevel,
    GetTemperatureImageLowLevel,
    GetStatistics,
    SetResolution,
    GetResolution,
    SetSpotmeterConfig,
    GetSpotmeterConfig,
    SetHighContrastConfig,
    GetHighContrastConfig,
    SetImageTransferConfig,
    GetImageTransferConfig,
    SetFluxLinearParameters,
    GetFluxLinearParameters,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackHighContrastImageLowLevel,
    CallbackTemperatureImageLowLevel,
}
impl From<ThermalImagingBrickletFunction> for u8 {
    fn from(fun: ThermalImagingBrickletFunction) -> Self {
        match fun {
            ThermalImagingBrickletFunction::GetHighContrastImageLowLevel => 1,
            ThermalImagingBrickletFunction::GetTemperatureImageLowLevel => 2,
            ThermalImagingBrickletFunction::GetStatistics => 3,
            ThermalImagingBrickletFunction::SetResolution => 4,
            ThermalImagingBrickletFunction::GetResolution => 5,
            ThermalImagingBrickletFunction::SetSpotmeterConfig => 6,
            ThermalImagingBrickletFunction::GetSpotmeterConfig => 7,
            ThermalImagingBrickletFunction::SetHighContrastConfig => 8,
            ThermalImagingBrickletFunction::GetHighContrastConfig => 9,
            ThermalImagingBrickletFunction::SetImageTransferConfig => 10,
            ThermalImagingBrickletFunction::GetImageTransferConfig => 11,
            ThermalImagingBrickletFunction::SetFluxLinearParameters => 14,
            ThermalImagingBrickletFunction::GetFluxLinearParameters => 15,
            ThermalImagingBrickletFunction::GetSpitfpErrorCount => 234,
            ThermalImagingBrickletFunction::SetBootloaderMode => 235,
            ThermalImagingBrickletFunction::GetBootloaderMode => 236,
            ThermalImagingBrickletFunction::SetWriteFirmwarePointer => 237,
            ThermalImagingBrickletFunction::WriteFirmware => 238,
            ThermalImagingBrickletFunction::SetStatusLedConfig => 239,
            ThermalImagingBrickletFunction::GetStatusLedConfig => 240,
            ThermalImagingBrickletFunction::GetChipTemperature => 242,
            ThermalImagingBrickletFunction::Reset => 243,
            ThermalImagingBrickletFunction::WriteUid => 248,
            ThermalImagingBrickletFunction::ReadUid => 249,
            ThermalImagingBrickletFunction::GetIdentity => 255,
            ThermalImagingBrickletFunction::CallbackHighContrastImageLowLevel => 12,
            ThermalImagingBrickletFunction::CallbackTemperatureImageLowLevel => 13,
        }
    }
}
pub const THERMAL_IMAGING_BRICKLET_RESOLUTION_0_TO_6553_KELVIN: u8 = 0;
pub const THERMAL_IMAGING_BRICKLET_RESOLUTION_0_TO_655_KELVIN: u8 = 1;
pub const THERMAL_IMAGING_BRICKLET_FFC_STATUS_NEVER_COMMANDED: u8 = 0;
pub const THERMAL_IMAGING_BRICKLET_FFC_STATUS_IMMINENT: u8 = 1;
pub const THERMAL_IMAGING_BRICKLET_FFC_STATUS_IN_PROGRESS: u8 = 2;
pub const THERMAL_IMAGING_BRICKLET_FFC_STATUS_COMPLETE: u8 = 3;
pub const THERMAL_IMAGING_BRICKLET_IMAGE_TRANSFER_MANUAL_HIGH_CONTRAST_IMAGE: u8 = 0;
pub const THERMAL_IMAGING_BRICKLET_IMAGE_TRANSFER_MANUAL_TEMPERATURE_IMAGE: u8 = 1;
pub const THERMAL_IMAGING_BRICKLET_IMAGE_TRANSFER_CALLBACK_HIGH_CONTRAST_IMAGE: u8 = 2;
pub const THERMAL_IMAGING_BRICKLET_IMAGE_TRANSFER_CALLBACK_TEMPERATURE_IMAGE: u8 = 3;
pub const THERMAL_IMAGING_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const THERMAL_IMAGING_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const THERMAL_IMAGING_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const THERMAL_IMAGING_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const THERMAL_IMAGING_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const THERMAL_IMAGING_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const THERMAL_IMAGING_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const THERMAL_IMAGING_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const THERMAL_IMAGING_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const THERMAL_IMAGING_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const THERMAL_IMAGING_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const THERMAL_IMAGING_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const THERMAL_IMAGING_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const THERMAL_IMAGING_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const THERMAL_IMAGING_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy)]
pub struct HighContrastImageLowLevel {
    pub image_chunk_offset: u16,
    pub image_chunk_data: [u8; 62],
}
impl FromByteSlice for HighContrastImageLowLevel {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> HighContrastImageLowLevel {
        HighContrastImageLowLevel {
            image_chunk_offset: <u16>::from_le_byte_slice(&bytes[0..2]),
            image_chunk_data: <[u8; 62]>::from_le_byte_slice(&bytes[2..64]),
        }
    }
}
impl LowLevelRead<u8, HighContrastImageResult> for HighContrastImageLowLevel {
    fn ll_message_length(&self) -> usize { 4800 }

    fn ll_message_chunk_offset(&self) -> usize { self.image_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[u8] { &self.image_chunk_data }

    fn get_result(&self) -> HighContrastImageResult { HighContrastImageResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct TemperatureImageLowLevel {
    pub image_chunk_offset: u16,
    pub image_chunk_data: [u16; 31],
}
impl FromByteSlice for TemperatureImageLowLevel {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> TemperatureImageLowLevel {
        TemperatureImageLowLevel {
            image_chunk_offset: <u16>::from_le_byte_slice(&bytes[0..2]),
            image_chunk_data: <[u16; 31]>::from_le_byte_slice(&bytes[2..64]),
        }
    }
}
impl LowLevelRead<u16, TemperatureImageResult> for TemperatureImageLowLevel {
    fn ll_message_length(&self) -> usize { 4800 }

    fn ll_message_chunk_offset(&self) -> usize { self.image_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[u16] { &self.image_chunk_data }

    fn get_result(&self) -> TemperatureImageResult { TemperatureImageResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Statistics {
    pub spotmeter_statistics: [u16; 4],
    pub temperatures: [u16; 4],
    pub resolution: u8,
    pub ffc_status: u8,
    pub temperature_warning: [bool; 2],
}
impl FromByteSlice for Statistics {
    fn bytes_expected() -> usize { 19 }
    fn from_le_byte_slice(bytes: &[u8]) -> Statistics {
        Statistics {
            spotmeter_statistics: <[u16; 4]>::from_le_byte_slice(&bytes[0..8]),
            temperatures: <[u16; 4]>::from_le_byte_slice(&bytes[8..16]),
            resolution: <u8>::from_le_byte_slice(&bytes[16..17]),
            ffc_status: <u8>::from_le_byte_slice(&bytes[17..18]),
            temperature_warning: <[bool; 2]>::from_le_byte_slice(&bytes[18..19]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct HighContrastConfig {
    pub region_of_interest: [u8; 4],
    pub dampening_factor: u16,
    pub clip_limit: [u16; 2],
    pub empty_counts: u16,
}
impl FromByteSlice for HighContrastConfig {
    fn bytes_expected() -> usize { 12 }
    fn from_le_byte_slice(bytes: &[u8]) -> HighContrastConfig {
        HighContrastConfig {
            region_of_interest: <[u8; 4]>::from_le_byte_slice(&bytes[0..4]),
            dampening_factor: <u16>::from_le_byte_slice(&bytes[4..6]),
            clip_limit: <[u16; 2]>::from_le_byte_slice(&bytes[6..10]),
            empty_counts: <u16>::from_le_byte_slice(&bytes[10..12]),
        }
    }
}

#[derive(Clone, Copy)]
pub struct HighContrastImageLowLevelEvent {
    pub image_chunk_offset: u16,
    pub image_chunk_data: [u8; 62],
}
impl FromByteSlice for HighContrastImageLowLevelEvent {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> HighContrastImageLowLevelEvent {
        HighContrastImageLowLevelEvent {
            image_chunk_offset: <u16>::from_le_byte_slice(&bytes[0..2]),
            image_chunk_data: <[u8; 62]>::from_le_byte_slice(&bytes[2..64]),
        }
    }
}
impl LowLevelRead<u8, HighContrastImageResult> for HighContrastImageLowLevelEvent {
    fn ll_message_length(&self) -> usize { 4800 }

    fn ll_message_chunk_offset(&self) -> usize { self.image_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[u8] { &self.image_chunk_data }

    fn get_result(&self) -> HighContrastImageResult { HighContrastImageResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct TemperatureImageLowLevelEvent {
    pub image_chunk_offset: u16,
    pub image_chunk_data: [u16; 31],
}
impl FromByteSlice for TemperatureImageLowLevelEvent {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> TemperatureImageLowLevelEvent {
        TemperatureImageLowLevelEvent {
            image_chunk_offset: <u16>::from_le_byte_slice(&bytes[0..2]),
            image_chunk_data: <[u16; 31]>::from_le_byte_slice(&bytes[2..64]),
        }
    }
}
impl LowLevelRead<u16, TemperatureImageResult> for TemperatureImageLowLevelEvent {
    fn ll_message_length(&self) -> usize { 4800 }

    fn ll_message_chunk_offset(&self) -> usize { self.image_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[u16] { &self.image_chunk_data }

    fn get_result(&self) -> TemperatureImageResult { TemperatureImageResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct FluxLinearParameters {
    pub scene_emissivity: u16,
    pub temperature_background: u16,
    pub tau_window: u16,
    pub temperatur_window: u16,
    pub tau_atmosphere: u16,
    pub temperature_atmosphere: u16,
    pub reflection_window: u16,
    pub temperature_reflection: u16,
}
impl FromByteSlice for FluxLinearParameters {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> FluxLinearParameters {
        FluxLinearParameters {
            scene_emissivity: <u16>::from_le_byte_slice(&bytes[0..2]),
            temperature_background: <u16>::from_le_byte_slice(&bytes[2..4]),
            tau_window: <u16>::from_le_byte_slice(&bytes[4..6]),
            temperatur_window: <u16>::from_le_byte_slice(&bytes[6..8]),
            tau_atmosphere: <u16>::from_le_byte_slice(&bytes[8..10]),
            temperature_atmosphere: <u16>::from_le_byte_slice(&bytes[10..12]),
            reflection_window: <u16>::from_le_byte_slice(&bytes[12..14]),
            temperature_reflection: <u16>::from_le_byte_slice(&bytes[14..16]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct HighContrastImageResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct TemperatureImageResult {}

/// 80x60 pixel thermal imaging camera
#[derive(Clone)]
pub struct ThermalImagingBricklet {
    device: Device,
}
impl ThermalImagingBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 278;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Thermal Imaging Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> ThermalImagingBricklet {
        let mut result = ThermalImagingBricklet { device: Device::new([2, 0, 1], uid, req_sender, 4) };
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::GetHighContrastImageLowLevel) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::GetTemperatureImageLowLevel) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::GetStatistics) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::SetResolution) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::GetResolution) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::SetSpotmeterConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::GetSpotmeterConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::SetHighContrastConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::GetHighContrastConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::SetImageTransferConfig) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::GetImageTransferConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::SetFluxLinearParameters) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::GetFluxLinearParameters) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ThermalImagingBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::thermal_imaging_bricklet::ThermalImagingBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::thermal_imaging_bricklet::ThermalImagingBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: ThermalImagingBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: ThermalImagingBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// See [`get_high_contrast_image_callback_receiver`](crate::thermal_imaging::ThermalImaging::get_high_contrast_image_callback_receiver)
    pub fn get_high_contrast_image_low_level_callback_receiver(&self) -> ConvertingCallbackReceiver<HighContrastImageLowLevelEvent> {
        self.device.get_callback_receiver(u8::from(ThermalImagingBrickletFunction::CallbackHighContrastImageLowLevel))
    }

    /// This receiver is triggered with every new high contrast image if the transfer image
    /// config is configured for high contrast receiver (see [`set_image_transfer_config`]).
    ///
    /// The data is organized as a 8-bit value 80x60 pixel matrix linearized in
    /// a one-dimensional array. The data is arranged line by line from top left to
    /// bottom right.
    ///
    /// Each 8-bit value represents one gray-scale image pixel that can directly be
    /// shown to a user on a display.
    ///
    /// [`set_image_transfer_config`]: #method.set_image_transfer_config
    pub fn get_high_contrast_image_callback_receiver(
        &self,
    ) -> ConvertingHighLevelCallbackReceiver<u8, HighContrastImageResult, HighContrastImageLowLevelEvent> {
        ConvertingHighLevelCallbackReceiver::new(
            self.device.get_callback_receiver(u8::from(ThermalImagingBrickletFunction::CallbackHighContrastImageLowLevel)),
        )
    }

    /// See [`get_temperature_image_callback_receiver`](crate::thermal_imaging::ThermalImaging::get_temperature_image_callback_receiver)
    pub fn get_temperature_image_low_level_callback_receiver(&self) -> ConvertingCallbackReceiver<TemperatureImageLowLevelEvent> {
        self.device.get_callback_receiver(u8::from(ThermalImagingBrickletFunction::CallbackTemperatureImageLowLevel))
    }

    /// This receiver is triggered with every new temperature image if the transfer image
    /// config is configured for temperature receiver (see [`set_image_transfer_config`]).
    ///
    /// The data is organized as a 16-bit value 80x60 pixel matrix linearized in
    /// a one-dimensional array. The data is arranged line by line from top left to
    /// bottom right.
    ///
    /// Each 16-bit value represents one temperature measurement in either
    /// Kelvin/10 or Kelvin/100 (depending on the resolution set with [`set_resolution`]).
    pub fn get_temperature_image_callback_receiver(
        &self,
    ) -> ConvertingHighLevelCallbackReceiver<u16, TemperatureImageResult, TemperatureImageLowLevelEvent> {
        ConvertingHighLevelCallbackReceiver::new(
            self.device.get_callback_receiver(u8::from(ThermalImagingBrickletFunction::CallbackTemperatureImageLowLevel)),
        )
    }

    /// Returns the current high contrast image. See [here](https://www.tinkerforge.com/en/doc/Hardware/Bricklets/Thermal_Imaging.html#high-contrast-image-vs-temperature-image)__
    /// for the difference between
    /// High Contrast and Temperature Image. If you don't know what to use
    /// the High Contrast Image is probably right for you.
    ///
    /// The data is organized as a 8-bit value 80x60 pixel matrix linearized in
    /// a one-dimensional array. The data is arranged line by line from top left to
    /// bottom right.
    ///
    /// Each 8-bit value represents one gray-scale image pixel that can directly be
    /// shown to a user on a display.
    ///
    /// Before you can use this function you have to enable it with
    /// [`set_image_transfer_config`].
    pub fn get_high_contrast_image_low_level(&self) -> ConvertingReceiver<HighContrastImageLowLevel> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermalImagingBrickletFunction::GetHighContrastImageLowLevel), payload)
    }

    /// Returns the current high contrast image. See [here](https://www.tinkerforge.com/en/doc/Hardware/Bricklets/Thermal_Imaging.html#high-contrast-image-vs-temperature-image)__
    /// for the difference between
    /// High Contrast and Temperature Image. If you don't know what to use
    /// the High Contrast Image is probably right for you.
    ///
    /// The data is organized as a 8-bit value 80x60 pixel matrix linearized in
    /// a one-dimensional array. The data is arranged line by line from top left to
    /// bottom right.
    ///
    /// Each 8-bit value represents one gray-scale image pixel that can directly be
    /// shown to a user on a display.
    ///
    /// Before you can use this function you have to enable it with
    /// [`set_image_transfer_config`].
    pub fn get_high_contrast_image(&self) -> Result<Vec<u8>, BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(0, &mut || self.get_high_contrast_image_low_level().recv())?;
        Ok(ll_result.0)
    }

    /// Returns the current temperature image. See [here](https://www.tinkerforge.com/en/doc/Hardware/Bricklets/Thermal_Imaging.html#high-contrast-image-vs-temperature-image)__
    /// for the difference between High Contrast and Temperature Image.
    /// If you don't know what to use the High Contrast Image is probably right for you.
    ///
    /// The data is organized as a 16-bit value 80x60 pixel matrix linearized in
    /// a one-dimensional array. The data is arranged line by line from top left to
    /// bottom right.
    ///
    /// Each 16-bit value represents one temperature measurement in either
    /// Kelvin/10 or Kelvin/100 (depending on the resolution set with [`set_resolution`]).
    ///
    /// Before you can use this function you have to enable it with
    /// [`set_image_transfer_config`].
    pub fn get_temperature_image_low_level(&self) -> ConvertingReceiver<TemperatureImageLowLevel> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermalImagingBrickletFunction::GetTemperatureImageLowLevel), payload)
    }

    /// Returns the current temperature image. See [here](https://www.tinkerforge.com/en/doc/Hardware/Bricklets/Thermal_Imaging.html#high-contrast-image-vs-temperature-image)__
    /// for the difference between High Contrast and Temperature Image.
    /// If you don't know what to use the High Contrast Image is probably right for you.
    ///
    /// The data is organized as a 16-bit value 80x60 pixel matrix linearized in
    /// a one-dimensional array. The data is arranged line by line from top left to
    /// bottom right.
    ///
    /// Each 16-bit value represents one temperature measurement in either
    /// Kelvin/10 or Kelvin/100 (depending on the resolution set with [`set_resolution`]).
    ///
    /// Before you can use this function you have to enable it with
    /// [`set_image_transfer_config`].
    pub fn get_temperature_image(&self) -> Result<Vec<u16>, BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(1, &mut || self.get_temperature_image_low_level().recv())?;
        Ok(ll_result.0)
    }

    /// Returns the spotmeter statistics, various temperatures, current resolution and status bits.
    ///
    /// The spotmeter statistics are:
    ///
    /// * Index 0: Mean Temperature.
    /// * Index 1: Maximum Temperature.
    /// * Index 2: Minimum Temperature.
    /// * Index 3: Pixel Count of spotmeter region of interest.
    ///
    /// The temperatures are:
    ///
    /// * Index 0: Focal Plain Array temperature.
    /// * Index 1: Focal Plain Array temperature at last FFC (Flat Field Correction).
    /// * Index 2: Housing temperature.
    /// * Index 3: Housing temperature at last FFC.
    ///
    /// The resolution is either `0 to 6553 Kelvin` or `0 to 655 Kelvin`. If the resolution is the former,
    /// the temperatures are in Kelvin/10, if it is the latter the temperatures are in Kelvin/100.
    ///
    /// FFC (Flat Field Correction) Status:
    ///
    /// * FFC Never Commanded: Only seen on startup before first FFC.
    /// * FFC Imminent: This state is entered 2 seconds prior to initiating FFC.
    /// * FFC In Progress: Flat field correction is started (shutter moves in front of lens and back). Takes about 1 second.
    /// * FFC Complete: Shutter is in waiting position again, FFC done.
    ///
    /// Temperature warning bits:
    ///
    /// * Index 0: Shutter lockout (if true shutter is locked out because temperature is outside -10°C to +65°C)
    /// * Index 1: Overtemperature shut down imminent (goes true 10 seconds before shutdown)
    ///
    /// Associated constants:
    /// * THERMAL_IMAGING_BRICKLET_RESOLUTION_0_TO_6553_KELVIN
    ///	* THERMAL_IMAGING_BRICKLET_RESOLUTION_0_TO_655_KELVIN
    ///	* THERMAL_IMAGING_BRICKLET_FFC_STATUS_NEVER_COMMANDED
    ///	* THERMAL_IMAGING_BRICKLET_FFC_STATUS_IMMINENT
    ///	* THERMAL_IMAGING_BRICKLET_FFC_STATUS_IN_PROGRESS
    ///	* THERMAL_IMAGING_BRICKLET_FFC_STATUS_COMPLETE
    pub fn get_statistics(&self) -> ConvertingReceiver<Statistics> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermalImagingBrickletFunction::GetStatistics), payload)
    }

    /// Sets the resolution. The Thermal Imaging Bricklet can either measure
    ///
    /// * from 0 to 6553 Kelvin (-273.15°C to +6279.85°C) with 0.1°C resolution or
    /// * from 0 to 655 Kelvin (-273.15°C to +381.85°C) with 0.01°C resolution.
    ///
    /// The accuracy is specified for -10°C to 450°C in the
    /// first range and -10°C and 140°C in the second range.
    ///
    /// Associated constants:
    /// * THERMAL_IMAGING_BRICKLET_RESOLUTION_0_TO_6553_KELVIN
    ///	* THERMAL_IMAGING_BRICKLET_RESOLUTION_0_TO_655_KELVIN
    pub fn set_resolution(&self, resolution: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(resolution));

        self.device.set(u8::from(ThermalImagingBrickletFunction::SetResolution), payload)
    }

    /// Returns the resolution as set by [`set_resolution`].
    ///
    /// Associated constants:
    /// * THERMAL_IMAGING_BRICKLET_RESOLUTION_0_TO_6553_KELVIN
    ///	* THERMAL_IMAGING_BRICKLET_RESOLUTION_0_TO_655_KELVIN
    pub fn get_resolution(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermalImagingBrickletFunction::GetResolution), payload)
    }

    /// Sets the spotmeter region of interest. The 4 values are
    ///
    /// * Index 0: Column start (has to be smaller then Column end).
    /// * Index 1: Row start (has to be smaller then Row end).
    /// * Index 2: Column end (has to be smaller then 80).
    /// * Index 3: Row end (has to be smaller then 60).
    ///
    /// The spotmeter statistics can be read out with [`get_statistics`].
    pub fn set_spotmeter_config(&self, region_of_interest: [u8; 4]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<[u8; 4]>::to_le_byte_vec(region_of_interest));

        self.device.set(u8::from(ThermalImagingBrickletFunction::SetSpotmeterConfig), payload)
    }

    /// Returns the spotmeter config as set by [`set_spotmeter_config`].
    pub fn get_spotmeter_config(&self) -> ConvertingReceiver<[u8; 4]> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermalImagingBrickletFunction::GetSpotmeterConfig), payload)
    }

    /// Sets the high contrast region of interest, dampening factor, clip limit and empty counts.
    /// This config is only used in high contrast mode (see [`set_image_transfer_config`]).
    ///
    /// The high contrast region of interest consists of four values:
    ///
    /// * Index 0: Column start (has to be smaller or equal then Column end).
    /// * Index 1: Row start (has to be smaller then Row end).
    /// * Index 2: Column end (has to be smaller then 80).
    /// * Index 3: Row end (has to be smaller then 60).
    ///
    /// The algorithm to generate the high contrast image is applied to this region.
    ///
    /// Dampening Factor: This parameter is the amount of temporal dampening applied to the HEQ
    /// (history equalization) transformation function. An IIR filter of the form::
    ///
    ///  (N / 256) * previous + ((256 - N) / 256) * current
    ///
    /// is applied, and the HEQ dampening factor
    /// represents the value N in the equation, i.e., a value that applies to the amount of
    /// influence the previous HEQ transformation function has on the current function. The
    /// lower the value of N the higher the influence of the current video frame whereas
    /// the higher the value of N the more influence the previous damped transfer function has.
    ///
    /// Clip Limit Index 0 (AGC HEQ Clip Limit High): This parameter defines the maximum number of pixels allowed
    /// to accumulate in any given histogram bin. Any additional pixels in a given bin are clipped.
    /// The effect of this parameter is to limit the influence of highly-populated bins on the
    /// resulting HEQ transformation function.
    ///
    /// Clip Limit Index 1 (AGC HEQ Clip Limit Low): This parameter defines an artificial population that is added to
    /// every non-empty histogram bin. In other words, if the Clip Limit Low is set to L, a bin
    /// with an actual population of X will have an effective population of L + X. Any empty bin
    /// that is nearby a populated bin will be given an artificial population of L. The effect of
    /// higher values is to provide a more linear transfer function; lower values provide a more
    /// non-linear (equalized) transfer function.
    ///
    /// Empty Counts: This parameter specifies the maximum number of pixels in a bin that will be
    /// interpreted as an empty bin. Histogram bins with this number of pixels or less will be
    /// processed as an empty bin.
    pub fn set_high_contrast_config(
        &self,
        region_of_interest: [u8; 4],
        dampening_factor: u16,
        clip_limit: [u16; 2],
        empty_counts: u16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 12];
        payload[0..4].copy_from_slice(&<[u8; 4]>::to_le_byte_vec(region_of_interest));
        payload[4..6].copy_from_slice(&<u16>::to_le_byte_vec(dampening_factor));
        payload[6..10].copy_from_slice(&<[u16; 2]>::to_le_byte_vec(clip_limit));
        payload[10..12].copy_from_slice(&<u16>::to_le_byte_vec(empty_counts));

        self.device.set(u8::from(ThermalImagingBrickletFunction::SetHighContrastConfig), payload)
    }

    /// Returns the high contrast config as set by [`set_high_contrast_config`].
    pub fn get_high_contrast_config(&self) -> ConvertingReceiver<HighContrastConfig> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermalImagingBrickletFunction::GetHighContrastConfig), payload)
    }

    /// The necessary bandwidth of this Bricklet is too high to use getter/receiver or
    /// high contrast/temperature image at the same time. You have to configure the one
    /// you want to use, the Bricklet will optimize the internal configuration accordingly.
    ///
    /// Corresponding functions:
    ///
    /// * Manual High Contrast Image: [`get_high_contrast_image`].
    /// * Manual Temperature Image: [`get_temperature_image`].
    /// * Receiver High Contrast Image: [`get_high_contrast_image_callback_receiver`] receiver.
    /// * Receiver Temperature Image: [`get_temperature_image_callback_receiver`] receiver.
    ///
    /// Associated constants:
    /// * THERMAL_IMAGING_BRICKLET_IMAGE_TRANSFER_MANUAL_HIGH_CONTRAST_IMAGE
    ///	* THERMAL_IMAGING_BRICKLET_IMAGE_TRANSFER_MANUAL_TEMPERATURE_IMAGE
    ///	* THERMAL_IMAGING_BRICKLET_IMAGE_TRANSFER_CALLBACK_HIGH_CONTRAST_IMAGE
    ///	* THERMAL_IMAGING_BRICKLET_IMAGE_TRANSFER_CALLBACK_TEMPERATURE_IMAGE
    pub fn set_image_transfer_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(ThermalImagingBrickletFunction::SetImageTransferConfig), payload)
    }

    /// Returns the image transfer config, as set by [`set_image_transfer_config`].
    ///
    /// Associated constants:
    /// * THERMAL_IMAGING_BRICKLET_IMAGE_TRANSFER_MANUAL_HIGH_CONTRAST_IMAGE
    ///	* THERMAL_IMAGING_BRICKLET_IMAGE_TRANSFER_MANUAL_TEMPERATURE_IMAGE
    ///	* THERMAL_IMAGING_BRICKLET_IMAGE_TRANSFER_CALLBACK_HIGH_CONTRAST_IMAGE
    ///	* THERMAL_IMAGING_BRICKLET_IMAGE_TRANSFER_CALLBACK_TEMPERATURE_IMAGE
    pub fn get_image_transfer_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermalImagingBrickletFunction::GetImageTransferConfig), payload)
    }

    /// Sets the flux linear parameters that can be used for radiometry calibration.
    ///
    /// See FLIR document 102-PS245-100-01 for more details.
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Plugin)
    pub fn set_flux_linear_parameters(
        &self,
        scene_emissivity: u16,
        temperature_background: u16,
        tau_window: u16,
        temperatur_window: u16,
        tau_atmosphere: u16,
        temperature_atmosphere: u16,
        reflection_window: u16,
        temperature_reflection: u16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 16];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(scene_emissivity));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(temperature_background));
        payload[4..6].copy_from_slice(&<u16>::to_le_byte_vec(tau_window));
        payload[6..8].copy_from_slice(&<u16>::to_le_byte_vec(temperatur_window));
        payload[8..10].copy_from_slice(&<u16>::to_le_byte_vec(tau_atmosphere));
        payload[10..12].copy_from_slice(&<u16>::to_le_byte_vec(temperature_atmosphere));
        payload[12..14].copy_from_slice(&<u16>::to_le_byte_vec(reflection_window));
        payload[14..16].copy_from_slice(&<u16>::to_le_byte_vec(temperature_reflection));

        self.device.set(u8::from(ThermalImagingBrickletFunction::SetFluxLinearParameters), payload)
    }

    /// Returns the flux linear parameters, as set by [`set_flux_linear_parameters`].
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Plugin)
    pub fn get_flux_linear_parameters(&self) -> ConvertingReceiver<FluxLinearParameters> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermalImagingBrickletFunction::GetFluxLinearParameters), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermalImagingBrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * THERMAL_IMAGING_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* THERMAL_IMAGING_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* THERMAL_IMAGING_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* THERMAL_IMAGING_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* THERMAL_IMAGING_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* THERMAL_IMAGING_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* THERMAL_IMAGING_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* THERMAL_IMAGING_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* THERMAL_IMAGING_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* THERMAL_IMAGING_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* THERMAL_IMAGING_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(ThermalImagingBrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * THERMAL_IMAGING_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* THERMAL_IMAGING_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* THERMAL_IMAGING_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* THERMAL_IMAGING_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* THERMAL_IMAGING_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermalImagingBrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(ThermalImagingBrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(ThermalImagingBrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * THERMAL_IMAGING_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* THERMAL_IMAGING_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* THERMAL_IMAGING_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* THERMAL_IMAGING_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(ThermalImagingBrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * THERMAL_IMAGING_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* THERMAL_IMAGING_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* THERMAL_IMAGING_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* THERMAL_IMAGING_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermalImagingBrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermalImagingBrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ThermalImagingBrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(ThermalImagingBrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermalImagingBrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ThermalImagingBrickletFunction::GetIdentity), payload)
    }
}
