/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures contactless object temperature between -70°C and +380°C.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/TemperatureIR_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum TemperatureIrBrickletFunction {
    GetAmbientTemperature,
    GetObjectTemperature,
    SetEmissivity,
    GetEmissivity,
    SetAmbientTemperatureCallbackPeriod,
    GetAmbientTemperatureCallbackPeriod,
    SetObjectTemperatureCallbackPeriod,
    GetObjectTemperatureCallbackPeriod,
    SetAmbientTemperatureCallbackThreshold,
    GetAmbientTemperatureCallbackThreshold,
    SetObjectTemperatureCallbackThreshold,
    GetObjectTemperatureCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    GetIdentity,
    CallbackAmbientTemperature,
    CallbackObjectTemperature,
    CallbackAmbientTemperatureReached,
    CallbackObjectTemperatureReached,
}
impl From<TemperatureIrBrickletFunction> for u8 {
    fn from(fun: TemperatureIrBrickletFunction) -> Self {
        match fun {
            TemperatureIrBrickletFunction::GetAmbientTemperature => 1,
            TemperatureIrBrickletFunction::GetObjectTemperature => 2,
            TemperatureIrBrickletFunction::SetEmissivity => 3,
            TemperatureIrBrickletFunction::GetEmissivity => 4,
            TemperatureIrBrickletFunction::SetAmbientTemperatureCallbackPeriod => 5,
            TemperatureIrBrickletFunction::GetAmbientTemperatureCallbackPeriod => 6,
            TemperatureIrBrickletFunction::SetObjectTemperatureCallbackPeriod => 7,
            TemperatureIrBrickletFunction::GetObjectTemperatureCallbackPeriod => 8,
            TemperatureIrBrickletFunction::SetAmbientTemperatureCallbackThreshold => 9,
            TemperatureIrBrickletFunction::GetAmbientTemperatureCallbackThreshold => 10,
            TemperatureIrBrickletFunction::SetObjectTemperatureCallbackThreshold => 11,
            TemperatureIrBrickletFunction::GetObjectTemperatureCallbackThreshold => 12,
            TemperatureIrBrickletFunction::SetDebouncePeriod => 13,
            TemperatureIrBrickletFunction::GetDebouncePeriod => 14,
            TemperatureIrBrickletFunction::GetIdentity => 255,
            TemperatureIrBrickletFunction::CallbackAmbientTemperature => 15,
            TemperatureIrBrickletFunction::CallbackObjectTemperature => 16,
            TemperatureIrBrickletFunction::CallbackAmbientTemperatureReached => 17,
            TemperatureIrBrickletFunction::CallbackObjectTemperatureReached => 18,
        }
    }
}
pub const TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AmbientTemperatureCallbackThreshold {
    pub option: char,
    pub min: i16,
    pub max: i16,
}
impl FromByteSlice for AmbientTemperatureCallbackThreshold {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> AmbientTemperatureCallbackThreshold {
        AmbientTemperatureCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <i16>::from_le_byte_slice(&bytes[1..3]),
            max: <i16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ObjectTemperatureCallbackThreshold {
    pub option: char,
    pub min: i16,
    pub max: i16,
}
impl FromByteSlice for ObjectTemperatureCallbackThreshold {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> ObjectTemperatureCallbackThreshold {
        ObjectTemperatureCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <i16>::from_le_byte_slice(&bytes[1..3]),
            max: <i16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures contactless object temperature between -70°C and +380°C
#[derive(Clone)]
pub struct TemperatureIrBricklet {
    device: Device,
}
impl TemperatureIrBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 217;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Temperature IR Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> TemperatureIrBricklet {
        let mut result = TemperatureIrBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(TemperatureIrBrickletFunction::GetAmbientTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(TemperatureIrBrickletFunction::GetObjectTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(TemperatureIrBrickletFunction::SetEmissivity) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(TemperatureIrBrickletFunction::GetEmissivity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(TemperatureIrBrickletFunction::SetAmbientTemperatureCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(TemperatureIrBrickletFunction::GetAmbientTemperatureCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(TemperatureIrBrickletFunction::SetObjectTemperatureCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(TemperatureIrBrickletFunction::GetObjectTemperatureCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(TemperatureIrBrickletFunction::SetAmbientTemperatureCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(TemperatureIrBrickletFunction::GetAmbientTemperatureCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(TemperatureIrBrickletFunction::SetObjectTemperatureCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(TemperatureIrBrickletFunction::GetObjectTemperatureCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(TemperatureIrBrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(TemperatureIrBrickletFunction::GetDebouncePeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(TemperatureIrBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::temperature_ir_bricklet::TemperatureIrBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::temperature_ir_bricklet::TemperatureIrBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: TemperatureIrBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: TemperatureIrBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_ambient_temperature_callback_period`]. The parameter is the
    /// ambient temperature of the sensor.
    ///
    /// The [`get_ambient_temperature_callback_receiver`] receiver is only triggered if the ambient
    /// temperature has changed since the last triggering.
    ///
    /// [`set_ambient_temperature_callback_period`]: #method.set_ambient_temperature_callback_period
    /// [`get_ambient_temperature_callback_receiver`]: #method.get_ambient_temperature_callback_receiver
    pub fn get_ambient_temperature_callback_receiver(&self) -> ConvertingCallbackReceiver<i16> {
        self.device.get_callback_receiver(u8::from(TemperatureIrBrickletFunction::CallbackAmbientTemperature))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_object_temperature_callback_period`]. The parameter is the
    /// object temperature of the sensor.
    ///
    /// The [`get_object_temperature_callback_receiver`] receiver is only triggered if the object
    /// temperature has changed since the last triggering.
    pub fn get_object_temperature_callback_receiver(&self) -> ConvertingCallbackReceiver<i16> {
        self.device.get_callback_receiver(u8::from(TemperatureIrBrickletFunction::CallbackObjectTemperature))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_ambient_temperature_callback_threshold`] is reached.
    /// The parameter is the ambient temperature of the sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_ambient_temperature_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i16> {
        self.device.get_callback_receiver(u8::from(TemperatureIrBrickletFunction::CallbackAmbientTemperatureReached))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_object_temperature_callback_threshold`] is reached.
    /// The parameter is the object temperature of the sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_object_temperature_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i16> {
        self.device.get_callback_receiver(u8::from(TemperatureIrBrickletFunction::CallbackObjectTemperatureReached))
    }

    /// Returns the ambient temperature of the sensor.
    ///
    /// If you want to get the ambient temperature periodically, it is recommended
    /// to use the [`get_ambient_temperature_callback_receiver`] receiver and set the period with
    /// [`set_ambient_temperature_callback_period`].
    pub fn get_ambient_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(TemperatureIrBrickletFunction::GetAmbientTemperature), payload)
    }

    /// Returns the object temperature of the sensor, i.e. the temperature
    /// of the surface of the object the sensor is aimed at.
    ///
    /// The temperature of different materials is dependent on their `emissivity
    /// <https://en.wikipedia.org/wiki/Emissivity>`__. The emissivity of the material
    /// can be set with [`set_emissivity`].
    ///
    /// If you want to get the object temperature periodically, it is recommended
    /// to use the [`get_object_temperature_callback_receiver`] receiver and set the period with
    /// [`set_object_temperature_callback_period`].
    pub fn get_object_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(TemperatureIrBrickletFunction::GetObjectTemperature), payload)
    }

    /// Sets the [emissivity](https://en.wikipedia.org/wiki/Emissivity)__ that is
    /// used to calculate the surface temperature as returned by
    /// :func:[Get Object Temperature`.
    ///
    /// The emissivity is usually given as a value between 0.0 and 1.0. A list of
    /// emissivities of different materials can be found
    /// `here](https://www.infrared-thermography.com/material.htm)__.
    ///
    /// The parameter of [`set_emissivity`] has to be given with a factor of
    /// 65535 (16-bit). For example: An emissivity of 0.1 can be set with the
    /// value 6553, an emissivity of 0.5 with the value 32767 and so on.
    ///
    /// # Note
    ///  If you need a precise measurement for the object temperature, it is
    ///  absolutely crucial that you also provide a precise emissivity.
    ///
    /// The emissivity is stored in non-volatile memory and will still be used after a restart or power cycle of the Bricklet.
    pub fn set_emissivity(&self, emissivity: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(emissivity));

        self.device.set(u8::from(TemperatureIrBrickletFunction::SetEmissivity), payload)
    }

    /// Returns the emissivity as set by [`set_emissivity`].
    pub fn get_emissivity(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(TemperatureIrBrickletFunction::GetEmissivity), payload)
    }

    /// Sets the period with which the [`get_ambient_temperature_callback_receiver`] receiver is
    /// triggered periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_ambient_temperature_callback_receiver`] receiver is only triggered if the temperature has
    /// changed since the last triggering.
    pub fn set_ambient_temperature_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(TemperatureIrBrickletFunction::SetAmbientTemperatureCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_ambient_temperature_callback_period`].
    pub fn get_ambient_temperature_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(TemperatureIrBrickletFunction::GetAmbientTemperatureCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_object_temperature_callback_receiver`] receiver is
    /// triggered periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_object_temperature_callback_receiver`] receiver is only triggered if the temperature
    /// has changed since the last triggering.
    pub fn set_object_temperature_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(TemperatureIrBrickletFunction::SetObjectTemperatureCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_object_temperature_callback_period`].
    pub fn get_object_temperature_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(TemperatureIrBrickletFunction::GetObjectTemperatureCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_ambient_temperature_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the ambient temperature is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the ambient temperature is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the ambient temperature is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the ambient temperature is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_ambient_temperature_callback_threshold(&self, option: char, min: i16, max: i16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<i16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<i16>::to_le_byte_vec(max));

        self.device.set(u8::from(TemperatureIrBrickletFunction::SetAmbientTemperatureCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_ambient_temperature_callback_threshold`].
    ///
    /// Associated constants:
    /// * TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_ambient_temperature_callback_threshold(&self) -> ConvertingReceiver<AmbientTemperatureCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(TemperatureIrBrickletFunction::GetAmbientTemperatureCallbackThreshold), payload)
    }

    /// Sets the thresholds for the [`get_object_temperature_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the object temperature is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the object temperature is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the object temperature is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the object temperature is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_object_temperature_callback_threshold(&self, option: char, min: i16, max: i16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<i16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<i16>::to_le_byte_vec(max));

        self.device.set(u8::from(TemperatureIrBrickletFunction::SetObjectTemperatureCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_object_temperature_callback_threshold`].
    ///
    /// Associated constants:
    /// * TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* TEMPERATURE_IR_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_object_temperature_callback_threshold(&self) -> ConvertingReceiver<ObjectTemperatureCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(TemperatureIrBrickletFunction::GetObjectTemperatureCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receivers
    ///
    /// * [`get_ambient_temperature_reached_callback_receiver`],
    /// * [`get_object_temperature_reached_callback_receiver`]
    ///
    /// are triggered, if the thresholds
    ///
    /// * [`set_ambient_temperature_callback_threshold`],
    /// * [`set_object_temperature_callback_threshold`]
    ///
    /// keep being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(TemperatureIrBrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(TemperatureIrBrickletFunction::GetDebouncePeriod), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(TemperatureIrBrickletFunction::GetIdentity), payload)
    }
}
