/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures ambient temperature with 0.5°C accuracy.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/Temperature_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum TemperatureBrickletFunction {
    GetTemperature,
    SetTemperatureCallbackPeriod,
    GetTemperatureCallbackPeriod,
    SetTemperatureCallbackThreshold,
    GetTemperatureCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    SetI2cMode,
    GetI2cMode,
    GetIdentity,
    CallbackTemperature,
    CallbackTemperatureReached,
}
impl From<TemperatureBrickletFunction> for u8 {
    fn from(fun: TemperatureBrickletFunction) -> Self {
        match fun {
            TemperatureBrickletFunction::GetTemperature => 1,
            TemperatureBrickletFunction::SetTemperatureCallbackPeriod => 2,
            TemperatureBrickletFunction::GetTemperatureCallbackPeriod => 3,
            TemperatureBrickletFunction::SetTemperatureCallbackThreshold => 4,
            TemperatureBrickletFunction::GetTemperatureCallbackThreshold => 5,
            TemperatureBrickletFunction::SetDebouncePeriod => 6,
            TemperatureBrickletFunction::GetDebouncePeriod => 7,
            TemperatureBrickletFunction::SetI2cMode => 10,
            TemperatureBrickletFunction::GetI2cMode => 11,
            TemperatureBrickletFunction::GetIdentity => 255,
            TemperatureBrickletFunction::CallbackTemperature => 8,
            TemperatureBrickletFunction::CallbackTemperatureReached => 9,
        }
    }
}
pub const TEMPERATURE_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const TEMPERATURE_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const TEMPERATURE_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const TEMPERATURE_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const TEMPERATURE_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const TEMPERATURE_BRICKLET_I2C_MODE_FAST: u8 = 0;
pub const TEMPERATURE_BRICKLET_I2C_MODE_SLOW: u8 = 1;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct TemperatureCallbackThreshold {
    pub option: char,
    pub min: i16,
    pub max: i16,
}
impl FromByteSlice for TemperatureCallbackThreshold {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> TemperatureCallbackThreshold {
        TemperatureCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <i16>::from_le_byte_slice(&bytes[1..3]),
            max: <i16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures ambient temperature with 0.5°C accuracy
#[derive(Clone)]
pub struct TemperatureBricklet {
    device: Device,
}
impl TemperatureBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 216;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Temperature Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> TemperatureBricklet {
        let mut result = TemperatureBricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(TemperatureBrickletFunction::GetTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(TemperatureBrickletFunction::SetTemperatureCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(TemperatureBrickletFunction::GetTemperatureCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(TemperatureBrickletFunction::SetTemperatureCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(TemperatureBrickletFunction::GetTemperatureCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(TemperatureBrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(TemperatureBrickletFunction::GetDebouncePeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(TemperatureBrickletFunction::SetI2cMode) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(TemperatureBrickletFunction::GetI2cMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(TemperatureBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::temperature_bricklet::TemperatureBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::temperature_bricklet::TemperatureBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: TemperatureBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: TemperatureBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_temperature_callback_period`]. The parameter is the
    /// temperature of the sensor.
    ///
    /// The [`get_temperature_callback_receiver`] receiver is only triggered if the temperature has changed
    /// since the last triggering.
    ///
    /// [`set_temperature_callback_period`]: #method.set_temperature_callback_period
    /// [`get_temperature_callback_receiver`]: #method.get_temperature_callback_receiver
    pub fn get_temperature_callback_receiver(&self) -> ConvertingCallbackReceiver<i16> {
        self.device.get_callback_receiver(u8::from(TemperatureBrickletFunction::CallbackTemperature))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_temperature_callback_threshold`] is reached.
    /// The parameter is the temperature of the sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_temperature_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i16> {
        self.device.get_callback_receiver(u8::from(TemperatureBrickletFunction::CallbackTemperatureReached))
    }

    /// Returns the temperature of the sensor.
    ///
    /// If you want to get the temperature periodically, it is recommended
    /// to use the [`get_temperature_callback_receiver`] receiver and set the period with
    /// [`set_temperature_callback_period`].
    pub fn get_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(TemperatureBrickletFunction::GetTemperature), payload)
    }

    /// Sets the period with which the [`get_temperature_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_temperature_callback_receiver`] receiver is only triggered if the temperature has changed
    /// since the last triggering.
    pub fn set_temperature_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(TemperatureBrickletFunction::SetTemperatureCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_temperature_callback_period`].
    pub fn get_temperature_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(TemperatureBrickletFunction::GetTemperatureCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_temperature_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the temperature is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the temperature is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the temperature is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the temperature is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * TEMPERATURE_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* TEMPERATURE_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* TEMPERATURE_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* TEMPERATURE_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* TEMPERATURE_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_temperature_callback_threshold(&self, option: char, min: i16, max: i16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<i16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<i16>::to_le_byte_vec(max));

        self.device.set(u8::from(TemperatureBrickletFunction::SetTemperatureCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_temperature_callback_threshold`].
    ///
    /// Associated constants:
    /// * TEMPERATURE_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* TEMPERATURE_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* TEMPERATURE_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* TEMPERATURE_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* TEMPERATURE_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_temperature_callback_threshold(&self) -> ConvertingReceiver<TemperatureCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(TemperatureBrickletFunction::GetTemperatureCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receiver
    ///
    /// * [`get_temperature_reached_callback_receiver`]
    ///
    /// is triggered, if the threshold
    ///
    /// * [`set_temperature_callback_threshold`]
    ///
    /// keeps being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(TemperatureBrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(TemperatureBrickletFunction::GetDebouncePeriod), payload)
    }

    /// Sets the I2C mode. Possible modes are:
    ///
    /// * 0: Fast (400kHz)
    /// * 1: Slow (100kHz)
    ///
    /// If you have problems with obvious outliers in the
    /// Temperature Bricklet measurements, they may be caused by EMI issues.
    /// In this case it may be helpful to lower the I2C speed.
    ///
    /// It is however not recommended to lower the I2C speed in applications where
    /// a high throughput needs to be achieved.
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * TEMPERATURE_BRICKLET_I2C_MODE_FAST
    ///	* TEMPERATURE_BRICKLET_I2C_MODE_SLOW
    pub fn set_i2c_mode(&self, mode: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.set(u8::from(TemperatureBrickletFunction::SetI2cMode), payload)
    }

    /// Returns the I2C mode as set by [`set_i2c_mode`].
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * TEMPERATURE_BRICKLET_I2C_MODE_FAST
    ///	* TEMPERATURE_BRICKLET_I2C_MODE_SLOW
    pub fn get_i2c_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(TemperatureBrickletFunction::GetI2cMode), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(TemperatureBrickletFunction::GetIdentity), payload)
    }
}
