/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Silently drives one bipolar stepper motor with up to 46V and 1.6A per phase.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/SilentStepperV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum SilentStepperV2BrickletFunction {
    SetMaxVelocity,
    GetMaxVelocity,
    GetCurrentVelocity,
    SetSpeedRamping,
    GetSpeedRamping,
    FullBrake,
    SetCurrentPosition,
    GetCurrentPosition,
    SetTargetPosition,
    GetTargetPosition,
    SetSteps,
    GetSteps,
    GetRemainingSteps,
    SetStepConfiguration,
    GetStepConfiguration,
    DriveForward,
    DriveBackward,
    Stop,
    GetInputVoltage,
    SetMotorCurrent,
    GetMotorCurrent,
    SetEnabled,
    GetEnabled,
    SetBasicConfiguration,
    GetBasicConfiguration,
    SetSpreadcycleConfiguration,
    GetSpreadcycleConfiguration,
    SetStealthConfiguration,
    GetStealthConfiguration,
    SetCoolstepConfiguration,
    GetCoolstepConfiguration,
    SetMiscConfiguration,
    GetMiscConfiguration,
    SetErrorLedConfig,
    GetErrorLedConfig,
    GetDriverStatus,
    SetMinimumVoltage,
    GetMinimumVoltage,
    SetTimeBase,
    GetTimeBase,
    GetAllData,
    SetAllCallbackConfiguration,
    GetAllDataCallbackConfiguraton,
    SetGpioConfiguration,
    GetGpioConfiguration,
    SetGpioAction,
    GetGpioAction,
    GetGpioState,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackUnderVoltage,
    CallbackPositionReached,
    CallbackAllData,
    CallbackNewState,
    CallbackGpioState,
}
impl From<SilentStepperV2BrickletFunction> for u8 {
    fn from(fun: SilentStepperV2BrickletFunction) -> Self {
        match fun {
            SilentStepperV2BrickletFunction::SetMaxVelocity => 1,
            SilentStepperV2BrickletFunction::GetMaxVelocity => 2,
            SilentStepperV2BrickletFunction::GetCurrentVelocity => 3,
            SilentStepperV2BrickletFunction::SetSpeedRamping => 4,
            SilentStepperV2BrickletFunction::GetSpeedRamping => 5,
            SilentStepperV2BrickletFunction::FullBrake => 6,
            SilentStepperV2BrickletFunction::SetCurrentPosition => 7,
            SilentStepperV2BrickletFunction::GetCurrentPosition => 8,
            SilentStepperV2BrickletFunction::SetTargetPosition => 9,
            SilentStepperV2BrickletFunction::GetTargetPosition => 10,
            SilentStepperV2BrickletFunction::SetSteps => 11,
            SilentStepperV2BrickletFunction::GetSteps => 12,
            SilentStepperV2BrickletFunction::GetRemainingSteps => 13,
            SilentStepperV2BrickletFunction::SetStepConfiguration => 14,
            SilentStepperV2BrickletFunction::GetStepConfiguration => 15,
            SilentStepperV2BrickletFunction::DriveForward => 16,
            SilentStepperV2BrickletFunction::DriveBackward => 17,
            SilentStepperV2BrickletFunction::Stop => 18,
            SilentStepperV2BrickletFunction::GetInputVoltage => 19,
            SilentStepperV2BrickletFunction::SetMotorCurrent => 22,
            SilentStepperV2BrickletFunction::GetMotorCurrent => 23,
            SilentStepperV2BrickletFunction::SetEnabled => 24,
            SilentStepperV2BrickletFunction::GetEnabled => 25,
            SilentStepperV2BrickletFunction::SetBasicConfiguration => 26,
            SilentStepperV2BrickletFunction::GetBasicConfiguration => 27,
            SilentStepperV2BrickletFunction::SetSpreadcycleConfiguration => 28,
            SilentStepperV2BrickletFunction::GetSpreadcycleConfiguration => 29,
            SilentStepperV2BrickletFunction::SetStealthConfiguration => 30,
            SilentStepperV2BrickletFunction::GetStealthConfiguration => 31,
            SilentStepperV2BrickletFunction::SetCoolstepConfiguration => 32,
            SilentStepperV2BrickletFunction::GetCoolstepConfiguration => 33,
            SilentStepperV2BrickletFunction::SetMiscConfiguration => 34,
            SilentStepperV2BrickletFunction::GetMiscConfiguration => 35,
            SilentStepperV2BrickletFunction::SetErrorLedConfig => 36,
            SilentStepperV2BrickletFunction::GetErrorLedConfig => 37,
            SilentStepperV2BrickletFunction::GetDriverStatus => 38,
            SilentStepperV2BrickletFunction::SetMinimumVoltage => 39,
            SilentStepperV2BrickletFunction::GetMinimumVoltage => 40,
            SilentStepperV2BrickletFunction::SetTimeBase => 43,
            SilentStepperV2BrickletFunction::GetTimeBase => 44,
            SilentStepperV2BrickletFunction::GetAllData => 45,
            SilentStepperV2BrickletFunction::SetAllCallbackConfiguration => 46,
            SilentStepperV2BrickletFunction::GetAllDataCallbackConfiguraton => 47,
            SilentStepperV2BrickletFunction::SetGpioConfiguration => 48,
            SilentStepperV2BrickletFunction::GetGpioConfiguration => 49,
            SilentStepperV2BrickletFunction::SetGpioAction => 50,
            SilentStepperV2BrickletFunction::GetGpioAction => 51,
            SilentStepperV2BrickletFunction::GetGpioState => 52,
            SilentStepperV2BrickletFunction::GetSpitfpErrorCount => 234,
            SilentStepperV2BrickletFunction::SetBootloaderMode => 235,
            SilentStepperV2BrickletFunction::GetBootloaderMode => 236,
            SilentStepperV2BrickletFunction::SetWriteFirmwarePointer => 237,
            SilentStepperV2BrickletFunction::WriteFirmware => 238,
            SilentStepperV2BrickletFunction::SetStatusLedConfig => 239,
            SilentStepperV2BrickletFunction::GetStatusLedConfig => 240,
            SilentStepperV2BrickletFunction::GetChipTemperature => 242,
            SilentStepperV2BrickletFunction::Reset => 243,
            SilentStepperV2BrickletFunction::WriteUid => 248,
            SilentStepperV2BrickletFunction::ReadUid => 249,
            SilentStepperV2BrickletFunction::GetIdentity => 255,
            SilentStepperV2BrickletFunction::CallbackUnderVoltage => 41,
            SilentStepperV2BrickletFunction::CallbackPositionReached => 42,
            SilentStepperV2BrickletFunction::CallbackAllData => 53,
            SilentStepperV2BrickletFunction::CallbackNewState => 54,
            SilentStepperV2BrickletFunction::CallbackGpioState => 55,
        }
    }
}
pub const SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_1: u8 = 8;
pub const SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_2: u8 = 7;
pub const SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_4: u8 = 6;
pub const SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_8: u8 = 5;
pub const SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_16: u8 = 4;
pub const SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_32: u8 = 3;
pub const SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_64: u8 = 2;
pub const SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_128: u8 = 1;
pub const SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_256: u8 = 0;
pub const SILENT_STEPPER_V2_BRICKLET_CHOPPER_MODE_SPREAD_CYCLE: u8 = 0;
pub const SILENT_STEPPER_V2_BRICKLET_CHOPPER_MODE_FAST_DECAY: u8 = 1;
pub const SILENT_STEPPER_V2_BRICKLET_FREEWHEEL_MODE_NORMAL: u8 = 0;
pub const SILENT_STEPPER_V2_BRICKLET_FREEWHEEL_MODE_FREEWHEELING: u8 = 1;
pub const SILENT_STEPPER_V2_BRICKLET_FREEWHEEL_MODE_COIL_SHORT_LS: u8 = 2;
pub const SILENT_STEPPER_V2_BRICKLET_FREEWHEEL_MODE_COIL_SHORT_HS: u8 = 3;
pub const SILENT_STEPPER_V2_BRICKLET_CURRENT_UP_STEP_INCREMENT_1: u8 = 0;
pub const SILENT_STEPPER_V2_BRICKLET_CURRENT_UP_STEP_INCREMENT_2: u8 = 1;
pub const SILENT_STEPPER_V2_BRICKLET_CURRENT_UP_STEP_INCREMENT_4: u8 = 2;
pub const SILENT_STEPPER_V2_BRICKLET_CURRENT_UP_STEP_INCREMENT_8: u8 = 3;
pub const SILENT_STEPPER_V2_BRICKLET_CURRENT_DOWN_STEP_DECREMENT_1: u8 = 0;
pub const SILENT_STEPPER_V2_BRICKLET_CURRENT_DOWN_STEP_DECREMENT_2: u8 = 1;
pub const SILENT_STEPPER_V2_BRICKLET_CURRENT_DOWN_STEP_DECREMENT_8: u8 = 2;
pub const SILENT_STEPPER_V2_BRICKLET_CURRENT_DOWN_STEP_DECREMENT_32: u8 = 3;
pub const SILENT_STEPPER_V2_BRICKLET_MINIMUM_CURRENT_HALF: u8 = 0;
pub const SILENT_STEPPER_V2_BRICKLET_MINIMUM_CURRENT_QUARTER: u8 = 1;
pub const SILENT_STEPPER_V2_BRICKLET_STALLGUARD_MODE_STANDARD: u8 = 0;
pub const SILENT_STEPPER_V2_BRICKLET_STALLGUARD_MODE_FILTERED: u8 = 1;
pub const SILENT_STEPPER_V2_BRICKLET_OPEN_LOAD_NONE: u8 = 0;
pub const SILENT_STEPPER_V2_BRICKLET_OPEN_LOAD_PHASE_A: u8 = 1;
pub const SILENT_STEPPER_V2_BRICKLET_OPEN_LOAD_PHASE_B: u8 = 2;
pub const SILENT_STEPPER_V2_BRICKLET_OPEN_LOAD_PHASE_AB: u8 = 3;
pub const SILENT_STEPPER_V2_BRICKLET_SHORT_TO_GROUND_NONE: u8 = 0;
pub const SILENT_STEPPER_V2_BRICKLET_SHORT_TO_GROUND_PHASE_A: u8 = 1;
pub const SILENT_STEPPER_V2_BRICKLET_SHORT_TO_GROUND_PHASE_B: u8 = 2;
pub const SILENT_STEPPER_V2_BRICKLET_SHORT_TO_GROUND_PHASE_AB: u8 = 3;
pub const SILENT_STEPPER_V2_BRICKLET_OVER_TEMPERATURE_NONE: u8 = 0;
pub const SILENT_STEPPER_V2_BRICKLET_OVER_TEMPERATURE_WARNING: u8 = 1;
pub const SILENT_STEPPER_V2_BRICKLET_OVER_TEMPERATURE_LIMIT: u8 = 2;
pub const SILENT_STEPPER_V2_BRICKLET_STATE_STOP: u8 = 1;
pub const SILENT_STEPPER_V2_BRICKLET_STATE_ACCELERATION: u8 = 2;
pub const SILENT_STEPPER_V2_BRICKLET_STATE_RUN: u8 = 3;
pub const SILENT_STEPPER_V2_BRICKLET_STATE_DEACCELERATION: u8 = 4;
pub const SILENT_STEPPER_V2_BRICKLET_STATE_DIRECTION_CHANGE_TO_FORWARD: u8 = 5;
pub const SILENT_STEPPER_V2_BRICKLET_STATE_DIRECTION_CHANGE_TO_BACKWARD: u8 = 6;
pub const SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_NONE: u32 = 0;
pub const SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_NORMAL_STOP_RISING_EDGE: u32 = 1;
pub const SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_NORMAL_STOP_FALLING_EDGE: u32 = 2;
pub const SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_FULL_BRAKE_RISING_EDGE: u32 = 4;
pub const SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_FULL_BRAKE_FALLING_EDGE: u32 = 8;
pub const SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_CALLBACK_RISING_EDGE: u32 = 16;
pub const SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_CALLBACK_FALLING_EDGE: u32 = 32;
pub const SILENT_STEPPER_V2_BRICKLET_ERROR_LED_CONFIG_OFF: u8 = 0;
pub const SILENT_STEPPER_V2_BRICKLET_ERROR_LED_CONFIG_ON: u8 = 1;
pub const SILENT_STEPPER_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const SILENT_STEPPER_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_ERROR: u8 = 3;
pub const SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const SILENT_STEPPER_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const SILENT_STEPPER_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const SILENT_STEPPER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const SILENT_STEPPER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpeedRamping {
    pub acceleration: u16,
    pub deacceleration: u16,
}
impl FromByteSlice for SpeedRamping {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpeedRamping {
        SpeedRamping { acceleration: <u16>::from_le_byte_slice(&bytes[0..2]), deacceleration: <u16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct StepConfiguration {
    pub step_resolution: u8,
    pub interpolation: bool,
}
impl FromByteSlice for StepConfiguration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> StepConfiguration {
        StepConfiguration {
            step_resolution: <u8>::from_le_byte_slice(&bytes[0..1]),
            interpolation: <bool>::from_le_byte_slice(&bytes[1..2]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct BasicConfiguration {
    pub standstill_current: u16,
    pub motor_run_current: u16,
    pub standstill_delay_time: u16,
    pub power_down_time: u16,
    pub stealth_threshold: u16,
    pub coolstep_threshold: u16,
    pub classic_threshold: u16,
    pub high_velocity_chopper_mode: bool,
}
impl FromByteSlice for BasicConfiguration {
    fn bytes_expected() -> usize { 15 }
    fn from_le_byte_slice(bytes: &[u8]) -> BasicConfiguration {
        BasicConfiguration {
            standstill_current: <u16>::from_le_byte_slice(&bytes[0..2]),
            motor_run_current: <u16>::from_le_byte_slice(&bytes[2..4]),
            standstill_delay_time: <u16>::from_le_byte_slice(&bytes[4..6]),
            power_down_time: <u16>::from_le_byte_slice(&bytes[6..8]),
            stealth_threshold: <u16>::from_le_byte_slice(&bytes[8..10]),
            coolstep_threshold: <u16>::from_le_byte_slice(&bytes[10..12]),
            classic_threshold: <u16>::from_le_byte_slice(&bytes[12..14]),
            high_velocity_chopper_mode: <bool>::from_le_byte_slice(&bytes[14..15]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpreadcycleConfiguration {
    pub slow_decay_duration: u8,
    pub enable_random_slow_decay: bool,
    pub fast_decay_duration: u8,
    pub hysteresis_start_value: u8,
    pub hysteresis_end_value: i8,
    pub sine_wave_offset: i8,
    pub chopper_mode: u8,
    pub comparator_blank_time: u8,
    pub fast_decay_without_comparator: bool,
}
impl FromByteSlice for SpreadcycleConfiguration {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpreadcycleConfiguration {
        SpreadcycleConfiguration {
            slow_decay_duration: <u8>::from_le_byte_slice(&bytes[0..1]),
            enable_random_slow_decay: <bool>::from_le_byte_slice(&bytes[1..2]),
            fast_decay_duration: <u8>::from_le_byte_slice(&bytes[2..3]),
            hysteresis_start_value: <u8>::from_le_byte_slice(&bytes[3..4]),
            hysteresis_end_value: <i8>::from_le_byte_slice(&bytes[4..5]),
            sine_wave_offset: <i8>::from_le_byte_slice(&bytes[5..6]),
            chopper_mode: <u8>::from_le_byte_slice(&bytes[6..7]),
            comparator_blank_time: <u8>::from_le_byte_slice(&bytes[7..8]),
            fast_decay_without_comparator: <bool>::from_le_byte_slice(&bytes[8..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct StealthConfiguration {
    pub enable_stealth: bool,
    pub amplitude: u8,
    pub gradient: u8,
    pub enable_autoscale: bool,
    pub force_symmetric: bool,
    pub freewheel_mode: u8,
}
impl FromByteSlice for StealthConfiguration {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> StealthConfiguration {
        StealthConfiguration {
            enable_stealth: <bool>::from_le_byte_slice(&bytes[0..1]),
            amplitude: <u8>::from_le_byte_slice(&bytes[1..2]),
            gradient: <u8>::from_le_byte_slice(&bytes[2..3]),
            enable_autoscale: <bool>::from_le_byte_slice(&bytes[3..4]),
            force_symmetric: <bool>::from_le_byte_slice(&bytes[4..5]),
            freewheel_mode: <u8>::from_le_byte_slice(&bytes[5..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CoolstepConfiguration {
    pub minimum_stallguard_value: u8,
    pub maximum_stallguard_value: u8,
    pub current_up_step_width: u8,
    pub current_down_step_width: u8,
    pub minimum_current: u8,
    pub stallguard_threshold_value: i8,
    pub stallguard_mode: u8,
}
impl FromByteSlice for CoolstepConfiguration {
    fn bytes_expected() -> usize { 7 }
    fn from_le_byte_slice(bytes: &[u8]) -> CoolstepConfiguration {
        CoolstepConfiguration {
            minimum_stallguard_value: <u8>::from_le_byte_slice(&bytes[0..1]),
            maximum_stallguard_value: <u8>::from_le_byte_slice(&bytes[1..2]),
            current_up_step_width: <u8>::from_le_byte_slice(&bytes[2..3]),
            current_down_step_width: <u8>::from_le_byte_slice(&bytes[3..4]),
            minimum_current: <u8>::from_le_byte_slice(&bytes[4..5]),
            stallguard_threshold_value: <i8>::from_le_byte_slice(&bytes[5..6]),
            stallguard_mode: <u8>::from_le_byte_slice(&bytes[6..7]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MiscConfiguration {
    pub disable_short_to_ground_protection: bool,
    pub synchronize_phase_frequency: u8,
}
impl FromByteSlice for MiscConfiguration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> MiscConfiguration {
        MiscConfiguration {
            disable_short_to_ground_protection: <bool>::from_le_byte_slice(&bytes[0..1]),
            synchronize_phase_frequency: <u8>::from_le_byte_slice(&bytes[1..2]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct DriverStatus {
    pub open_load: u8,
    pub short_to_ground: u8,
    pub over_temperature: u8,
    pub motor_stalled: bool,
    pub actual_motor_current: u8,
    pub full_step_active: bool,
    pub stallguard_result: u8,
    pub stealth_voltage_amplitude: u8,
}
impl FromByteSlice for DriverStatus {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> DriverStatus {
        DriverStatus {
            open_load: <u8>::from_le_byte_slice(&bytes[0..1]),
            short_to_ground: <u8>::from_le_byte_slice(&bytes[1..2]),
            over_temperature: <u8>::from_le_byte_slice(&bytes[2..3]),
            motor_stalled: <bool>::from_le_byte_slice(&bytes[3..4]),
            actual_motor_current: <u8>::from_le_byte_slice(&bytes[4..5]),
            full_step_active: <bool>::from_le_byte_slice(&bytes[5..6]),
            stallguard_result: <u8>::from_le_byte_slice(&bytes[6..7]),
            stealth_voltage_amplitude: <u8>::from_le_byte_slice(&bytes[7..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllData {
    pub current_velocity: u16,
    pub current_position: i32,
    pub remaining_steps: i32,
    pub input_voltage: u16,
    pub current_consumption: u16,
}
impl FromByteSlice for AllData {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllData {
        AllData {
            current_velocity: <u16>::from_le_byte_slice(&bytes[0..2]),
            current_position: <i32>::from_le_byte_slice(&bytes[2..6]),
            remaining_steps: <i32>::from_le_byte_slice(&bytes[6..10]),
            input_voltage: <u16>::from_le_byte_slice(&bytes[10..12]),
            current_consumption: <u16>::from_le_byte_slice(&bytes[12..14]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct GpioConfiguration {
    pub debounce: u16,
    pub stop_deceleration: u16,
}
impl FromByteSlice for GpioConfiguration {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> GpioConfiguration {
        GpioConfiguration { debounce: <u16>::from_le_byte_slice(&bytes[0..2]), stop_deceleration: <u16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllDataEvent {
    pub current_velocity: u16,
    pub current_position: i32,
    pub remaining_steps: i32,
    pub input_voltage: u16,
    pub current_consumption: u16,
}
impl FromByteSlice for AllDataEvent {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllDataEvent {
        AllDataEvent {
            current_velocity: <u16>::from_le_byte_slice(&bytes[0..2]),
            current_position: <i32>::from_le_byte_slice(&bytes[2..6]),
            remaining_steps: <i32>::from_le_byte_slice(&bytes[6..10]),
            input_voltage: <u16>::from_le_byte_slice(&bytes[10..12]),
            current_consumption: <u16>::from_le_byte_slice(&bytes[12..14]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct NewStateEvent {
    pub state_new: u8,
    pub state_previous: u8,
}
impl FromByteSlice for NewStateEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> NewStateEvent {
        NewStateEvent { state_new: <u8>::from_le_byte_slice(&bytes[0..1]), state_previous: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Silently drives one bipolar stepper motor with up to 46V and 1.6A per phase
#[derive(Clone)]
pub struct SilentStepperV2Bricklet {
    device: Device,
}
impl SilentStepperV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2166;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Silent Stepper Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> SilentStepperV2Bricklet {
        let mut result = SilentStepperV2Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetMaxVelocity) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetMaxVelocity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetCurrentVelocity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetSpeedRamping) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetSpeedRamping) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::FullBrake) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetCurrentPosition) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetCurrentPosition) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetTargetPosition) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetTargetPosition) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetSteps) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetSteps) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetRemainingSteps) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetStepConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetStepConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::DriveForward) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::DriveBackward) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::Stop) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetInputVoltage) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetMotorCurrent) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetMotorCurrent) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetEnabled) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetEnabled) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetBasicConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetBasicConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetSpreadcycleConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetSpreadcycleConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetStealthConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetStealthConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetCoolstepConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetCoolstepConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetMiscConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetMiscConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetErrorLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetErrorLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetDriverStatus) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetMinimumVoltage) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetMinimumVoltage) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetTimeBase) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetTimeBase) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetAllData) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetAllCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetAllDataCallbackConfiguraton) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetGpioConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetGpioConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetGpioAction) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetGpioAction) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetGpioState) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperV2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::silent_stepper_v2_bricklet::SilentStepperV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::silent_stepper_v2_bricklet::SilentStepperV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: SilentStepperV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: SilentStepperV2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered when the input voltage drops below the value set by
    /// [`set_minimum_voltage`]. The parameter is the current voltage.
    ///
    /// [`set_minimum_voltage`]: #method.set_minimum_voltage
    pub fn get_under_voltage_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(SilentStepperV2BrickletFunction::CallbackUnderVoltage))
    }

    /// This receiver is triggered when a position set by [`set_steps`] or
    /// [`set_target_position`] is reached.
    ///
    /// # Note
    ///  Since we can't get any feedback from the stepper motor, this only works if the
    ///  acceleration (see [`set_speed_ramping`]) is set smaller or equal to the
    ///  maximum acceleration of the motor. Otherwise the motor will lag behind the
    ///  control value and the receiver will be triggered too early.
    pub fn get_position_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(SilentStepperV2BrickletFunction::CallbackPositionReached))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_all_callback_configuration`]. The parameters are: the current velocity,
    /// the current position, the remaining steps, the stack voltage, the external
    /// voltage and the current consumption of the stepper motor.
    pub fn get_all_data_callback_receiver(&self) -> ConvertingCallbackReceiver<AllDataEvent> {
        self.device.get_callback_receiver(u8::from(SilentStepperV2BrickletFunction::CallbackAllData))
    }

    /// This receiver is triggered whenever the Silent Stepper Bricklet 2.0 enters a new state.
    /// It returns the new state as well as the previous state.
    pub fn get_new_state_callback_receiver(&self) -> ConvertingCallbackReceiver<NewStateEvent> {
        self.device.get_callback_receiver(u8::from(SilentStepperV2BrickletFunction::CallbackNewState))
    }

    /// This receiver is triggered by GPIO changes if it is activated through [`set_gpio_action`].
    pub fn get_gpio_state_callback_receiver(&self) -> ConvertingCallbackReceiver<[bool; 2]> {
        self.device.get_callback_receiver(u8::from(SilentStepperV2BrickletFunction::CallbackGpioState))
    }

    /// Sets the maximum velocity of the stepper motor.
    /// This function does *not* start the motor, it merely sets the maximum
    /// velocity the stepper motor is accelerated to. To get the motor running use
    /// either [`set_target_position`], [`set_steps`], [`drive_forward`] or
    /// [`drive_backward`].
    pub fn set_max_velocity(&self, velocity: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(velocity));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetMaxVelocity), payload)
    }

    /// Returns the velocity as set by [`set_max_velocity`].
    pub fn get_max_velocity(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetMaxVelocity), payload)
    }

    /// Returns the *current* velocity of the stepper motor.
    pub fn get_current_velocity(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetCurrentVelocity), payload)
    }

    /// Sets the acceleration and deacceleration of the stepper motor.
    /// An acceleration of 1000 means, that
    /// every second the velocity is increased by 1000 *steps/s*.
    ///
    /// For example: If the current velocity is 0 and you want to accelerate to a
    /// velocity of 8000 *steps/s* in 10 seconds, you should set an acceleration
    /// of 800 *steps/s²*.
    ///
    /// An acceleration/deacceleration of 0 means instantaneous
    /// acceleration/deacceleration (not recommended)
    pub fn set_speed_ramping(&self, acceleration: u16, deacceleration: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(acceleration));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(deacceleration));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetSpeedRamping), payload)
    }

    /// Returns the acceleration and deacceleration as set by
    /// [`set_speed_ramping`].
    pub fn get_speed_ramping(&self) -> ConvertingReceiver<SpeedRamping> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetSpeedRamping), payload)
    }

    /// Executes an active full brake.
    ///
    /// # Warning
    ///  This function is for emergency purposes,
    ///  where an immediate brake is necessary. Depending on the current velocity and
    ///  the strength of the motor, a full brake can be quite violent.
    ///
    /// Call [`stop`] if you just want to stop the motor.
    pub fn full_brake(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(SilentStepperV2BrickletFunction::FullBrake), payload)
    }

    /// Sets the current steps of the internal step counter. This can be used to
    /// set the current position to 0 when some kind of starting position
    /// is reached (e.g. when a CNC machine reaches a corner).
    pub fn set_current_position(&self, position: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<i32>::to_le_byte_vec(position));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetCurrentPosition), payload)
    }

    /// Returns the current position of the stepper motor in steps. On startup
    /// the position is 0. The steps are counted with all possible driving
    /// functions ([`set_target_position`], [`set_steps`], [`drive_forward`] or
    /// [`drive_backward`]). It also is possible to reset the steps to 0 or
    /// set them to any other desired value with [`set_current_position`].
    pub fn get_current_position(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetCurrentPosition), payload)
    }

    /// Sets the target position of the stepper motor in steps. For example,
    /// if the current position of the motor is 500 and [`set_target_position`] is
    /// called with 1000, the stepper motor will drive 500 steps forward. It will
    /// use the velocity, acceleration and deacceleration as set by
    /// [`set_max_velocity`] and [`set_speed_ramping`].
    ///
    /// A call of [`set_target_position`] with the parameter *x* is equivalent to
    /// a call of [`set_steps`] with the parameter
    /// (*x* - [`get_current_position`]).
    pub fn set_target_position(&self, position: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<i32>::to_le_byte_vec(position));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetTargetPosition), payload)
    }

    /// Returns the last target position as set by [`set_target_position`].
    pub fn get_target_position(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetTargetPosition), payload)
    }

    /// Sets the number of steps the stepper motor should run. Positive values
    /// will drive the motor forward and negative values backward.
    /// The velocity, acceleration and deacceleration as set by
    /// [`set_max_velocity`] and [`set_speed_ramping`] will be used.
    pub fn set_steps(&self, steps: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<i32>::to_le_byte_vec(steps));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetSteps), payload)
    }

    /// Returns the last steps as set by [`set_steps`].
    pub fn get_steps(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetSteps), payload)
    }

    /// Returns the remaining steps of the last call of [`set_steps`].
    /// For example, if [`set_steps`] is called with 2000 and
    /// [`get_remaining_steps`] is called after the motor has run for 500 steps,
    /// it will return 1500.
    pub fn get_remaining_steps(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetRemainingSteps), payload)
    }

    /// Sets the step resolution from full-step up to 1/256-step.
    ///
    /// If interpolation is turned on, the Silent Stepper Bricklet 2.0 will always interpolate
    /// your step inputs as 1/256-step. If you use full-step mode with interpolation, each
    /// step will generate 256 1/256 steps.
    ///
    /// For maximum torque use full-step without interpolation. For maximum resolution use
    /// 1/256-step. Turn interpolation on to make the Stepper driving less noisy.
    ///
    /// If you often change the speed with high acceleration you should turn the
    /// interpolation off.
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_1
    ///	* SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_2
    ///	* SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_4
    ///	* SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_8
    ///	* SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_16
    ///	* SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_32
    ///	* SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_64
    ///	* SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_128
    ///	* SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_256
    pub fn set_step_configuration(&self, step_resolution: u8, interpolation: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(step_resolution));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(interpolation));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetStepConfiguration), payload)
    }

    /// Returns the step mode as set by [`set_step_configuration`].
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_1
    ///	* SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_2
    ///	* SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_4
    ///	* SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_8
    ///	* SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_16
    ///	* SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_32
    ///	* SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_64
    ///	* SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_128
    ///	* SILENT_STEPPER_V2_BRICKLET_STEP_RESOLUTION_256
    pub fn get_step_configuration(&self) -> ConvertingReceiver<StepConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetStepConfiguration), payload)
    }

    /// Drives the stepper motor forward until [`drive_backward`] or
    /// [`stop`] is called. The velocity, acceleration and deacceleration as
    /// set by [`set_max_velocity`] and [`set_speed_ramping`] will be used.
    pub fn drive_forward(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(SilentStepperV2BrickletFunction::DriveForward), payload)
    }

    /// Drives the stepper motor backward until [`drive_forward`] or
    /// [`stop`] is triggered. The velocity, acceleration and deacceleration as
    /// set by [`set_max_velocity`] and [`set_speed_ramping`] will be used.
    pub fn drive_backward(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(SilentStepperV2BrickletFunction::DriveBackward), payload)
    }

    /// Stops the stepper motor with the deacceleration as set by
    /// [`set_speed_ramping`].
    pub fn stop(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(SilentStepperV2BrickletFunction::Stop), payload)
    }

    /// Returns the external input voltage. The external input voltage is
    /// given via the black power input connector on the Silent Stepper Bricklet 2.0.
    ///
    /// If there is an external input voltage and a stack input voltage, the motor
    /// will be driven by the external input voltage. If there is only a stack
    /// voltage present, the motor will be driven by this voltage.
    ///
    /// # Warning
    ///  This means, if you have a high stack voltage and a low external voltage,
    ///  the motor will be driven with the low external voltage. If you then remove
    ///  the external connection, it will immediately be driven by the high
    ///  stack voltage
    pub fn get_input_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetInputVoltage), payload)
    }

    /// Sets the current with which the motor will be driven.
    ///
    /// # Warning
    ///  Do not set this value above the specifications of your stepper motor.
    ///  Otherwise it may damage your motor.
    pub fn set_motor_current(&self, current: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(current));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetMotorCurrent), payload)
    }

    /// Returns the current as set by [`set_motor_current`].
    pub fn get_motor_current(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetMotorCurrent), payload)
    }

    /// Enables/Disables the driver chip. The driver parameters can be configured (maximum velocity,
    /// acceleration, etc) before it is enabled.
    ///
    /// # Warning
    ///  Disabling the driver chip while the motor is still turning can damage the
    ///  driver chip. The motor should be stopped calling [`stop`] function
    ///  before disabling the motor power. The [`stop`] function will **not**
    ///  wait until the motor is actually stopped. You have to explicitly wait for the
    ///  appropriate time after calling the [`stop`] function before calling
    ///  the [`set_enabled`] with false function.
    pub fn set_enabled(&self, enabled: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enabled));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetEnabled), payload)
    }

    /// Returns *true* if the stepper driver is enabled, *false* otherwise.
    pub fn get_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetEnabled), payload)
    }

    /// Sets the basic configuration parameters for the different modes (Stealth, Coolstep, Classic).
    ///
    /// * Standstill Current: This value can be used to lower the current during stand still. This might
    ///   be reasonable to reduce the heating of the motor and the Bricklet 2.0. When the motor is in standstill
    ///   the configured motor phase current will be driven until the configured
    ///   Power Down Time is elapsed. After that the phase current will be reduced to the standstill
    ///   current. The elapsed time for this reduction can be configured with the Standstill Delay Time.
    ///   The maximum allowed value is the configured maximum motor current
    ///   (see [`set_motor_current`]).
    ///
    /// * Motor Run Current: The value sets the motor current when the motor is running.
    ///   Use a value of at least one half of the global maximum motor current for a good
    ///   microstep performance. The maximum allowed value is the current
    ///   motor current. The API maps the entered value to 1/32 ... 32/32 of the maximum
    ///   motor current. This value should be used to change the motor current during motor movement,
    ///   whereas the global maximum motor current should not be changed while the motor is moving
    ///   (see [`set_motor_current`]).
    ///
    /// * Standstill Delay Time: Controls the duration for motor power down after a motion
    ///   as soon as standstill is detected and the Power Down Time is expired. A high Standstill Delay
    ///   Time results in a smooth transition that avoids motor jerk during power down.
    ///
    /// * Power Down Time: Sets the delay time after a stand still.
    ///
    /// * Stealth Threshold: Sets the upper threshold for Stealth mode.
    ///   If the velocity of the motor goes above this value, Stealth mode is turned
    ///   off. Otherwise it is turned on. In Stealth mode the torque declines with high speed.
    ///
    /// * Coolstep Threshold: Sets the lower threshold for Coolstep mode.
    ///   The Coolstep Threshold needs to be above the Stealth Threshold.
    ///
    /// * Classic Threshold: Sets the lower threshold for classic mode.
    ///   In classic mode the stepper becomes more noisy, but the torque is maximized.
    ///
    /// * High Velocity Chopper Mode: If High Velocity Chopper Mode is enabled, the stepper control
    ///   is optimized to run the stepper motors at high velocities.
    ///
    /// If you want to use all three thresholds make sure that
    /// Stealth Threshold < Coolstep Threshold < Classic Threshold.
    pub fn set_basic_configuration(
        &self,
        standstill_current: u16,
        motor_run_current: u16,
        standstill_delay_time: u16,
        power_down_time: u16,
        stealth_threshold: u16,
        coolstep_threshold: u16,
        classic_threshold: u16,
        high_velocity_chopper_mode: bool,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 15];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(standstill_current));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(motor_run_current));
        payload[4..6].copy_from_slice(&<u16>::to_le_byte_vec(standstill_delay_time));
        payload[6..8].copy_from_slice(&<u16>::to_le_byte_vec(power_down_time));
        payload[8..10].copy_from_slice(&<u16>::to_le_byte_vec(stealth_threshold));
        payload[10..12].copy_from_slice(&<u16>::to_le_byte_vec(coolstep_threshold));
        payload[12..14].copy_from_slice(&<u16>::to_le_byte_vec(classic_threshold));
        payload[14..15].copy_from_slice(&<bool>::to_le_byte_vec(high_velocity_chopper_mode));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetBasicConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_basic_configuration`].
    pub fn get_basic_configuration(&self) -> ConvertingReceiver<BasicConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetBasicConfiguration), payload)
    }

    /// Note: If you don't know what any of this means you can very likely keep all of
    /// the values as default!
    ///
    /// Sets the Spreadcycle configuration parameters. Spreadcycle is a chopper algorithm which actively
    /// controls the motor current flow. More information can be found in the TMC2130 datasheet on page
    /// 47 (7 spreadCycle and Classic Chopper).
    ///
    /// * Slow Decay Duration: Controls duration of off time setting of slow decay phase.
    ///   0 = driver disabled, all bridges off. Use 1 only with Comparator Blank time >= 2.
    ///
    /// * Enable Random Slow Decay: Set to false to fix chopper off time as set by Slow Decay Duration.
    ///   If you set it to true, Decay Duration is randomly modulated.
    ///
    /// * Fast Decay Duration: Sets the fast decay duration. This parameters is
    ///   only used if the Chopper Mode is set to Fast Decay.
    ///
    /// * Hysteresis Start Value: Sets the hysteresis start value. This parameter is
    ///   only used if the Chopper Mode is set to Spread Cycle.
    ///
    /// * Hysteresis End Value: Sets the hysteresis end value. This parameter is
    ///   only used if the Chopper Mode is set to Spread Cycle.
    ///
    /// * Sine Wave Offset: Sets the sine wave offset. This parameters is
    ///   only used if the Chopper Mode is set to Fast Decay. 1/512 of the value becomes added to the absolute
    ///   value of the sine wave.
    ///
    /// * Chopper Mode: 0 = Spread Cycle, 1 = Fast Decay.
    ///
    /// * Comparator Blank Time: Sets the blank time of the comparator. Available values are
    ///
    ///   * 0 = 16 clocks,
    ///   * 1 = 24 clocks,
    ///   * 2 = 36 clocks and
    ///   * 3 = 54 clocks.
    ///
    ///   A value of 1 or 2 is recommended for most applications.
    ///
    /// * Fast Decay Without Comparator: If set to true the current comparator usage for termination of the
    ///   fast decay cycle is disabled.
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_V2_BRICKLET_CHOPPER_MODE_SPREAD_CYCLE
    ///	* SILENT_STEPPER_V2_BRICKLET_CHOPPER_MODE_FAST_DECAY
    pub fn set_spreadcycle_configuration(
        &self,
        slow_decay_duration: u8,
        enable_random_slow_decay: bool,
        fast_decay_duration: u8,
        hysteresis_start_value: u8,
        hysteresis_end_value: i8,
        sine_wave_offset: i8,
        chopper_mode: u8,
        comparator_blank_time: u8,
        fast_decay_without_comparator: bool,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(slow_decay_duration));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(enable_random_slow_decay));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(fast_decay_duration));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(hysteresis_start_value));
        payload[4..5].copy_from_slice(&<i8>::to_le_byte_vec(hysteresis_end_value));
        payload[5..6].copy_from_slice(&<i8>::to_le_byte_vec(sine_wave_offset));
        payload[6..7].copy_from_slice(&<u8>::to_le_byte_vec(chopper_mode));
        payload[7..8].copy_from_slice(&<u8>::to_le_byte_vec(comparator_blank_time));
        payload[8..9].copy_from_slice(&<bool>::to_le_byte_vec(fast_decay_without_comparator));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetSpreadcycleConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_basic_configuration`].
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_V2_BRICKLET_CHOPPER_MODE_SPREAD_CYCLE
    ///	* SILENT_STEPPER_V2_BRICKLET_CHOPPER_MODE_FAST_DECAY
    pub fn get_spreadcycle_configuration(&self) -> ConvertingReceiver<SpreadcycleConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetSpreadcycleConfiguration), payload)
    }

    /// Note: If you don't know what any of this means you can very likely keep all of
    /// the values as default!
    ///
    /// Sets the configuration relevant for Stealth mode.
    ///
    /// * Enable Stealth: If set to true the stealth mode is enabled, if set to false the
    ///   stealth mode is disabled, even if the speed is below the threshold set in [`set_basic_configuration`].
    ///
    /// * Amplitude: If autoscale is disabled, the PWM amplitude is scaled by this value. If autoscale is enabled,
    ///   this value defines the maximum PWM amplitude change per half wave.
    ///
    /// * Gradient: If autoscale is disabled, the PWM gradient is scaled by this value. If autoscale is enabled,
    ///   this value defines the maximum PWM gradient. With autoscale a value above 64 is recommended,
    ///   otherwise the regulation might not be able to measure the current.
    ///
    /// * Enable Autoscale: If set to true, automatic current control is used. Otherwise the user defined
    ///   amplitude and gradient are used.
    ///
    /// * Force Symmetric: If true, A symmetric PWM cycle is enforced. Otherwise the PWM value may change within each
    ///   PWM cycle.
    ///
    /// * Freewheel Mode: The freewheel mode defines the behavior in stand still if the Standstill Current
    ///   (see [`set_basic_configuration`]) is set to 0.
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_V2_BRICKLET_FREEWHEEL_MODE_NORMAL
    ///	* SILENT_STEPPER_V2_BRICKLET_FREEWHEEL_MODE_FREEWHEELING
    ///	* SILENT_STEPPER_V2_BRICKLET_FREEWHEEL_MODE_COIL_SHORT_LS
    ///	* SILENT_STEPPER_V2_BRICKLET_FREEWHEEL_MODE_COIL_SHORT_HS
    pub fn set_stealth_configuration(
        &self,
        enable_stealth: bool,
        amplitude: u8,
        gradient: u8,
        enable_autoscale: bool,
        force_symmetric: bool,
        freewheel_mode: u8,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enable_stealth));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(amplitude));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(gradient));
        payload[3..4].copy_from_slice(&<bool>::to_le_byte_vec(enable_autoscale));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(force_symmetric));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(freewheel_mode));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetStealthConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_stealth_configuration`].
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_V2_BRICKLET_FREEWHEEL_MODE_NORMAL
    ///	* SILENT_STEPPER_V2_BRICKLET_FREEWHEEL_MODE_FREEWHEELING
    ///	* SILENT_STEPPER_V2_BRICKLET_FREEWHEEL_MODE_COIL_SHORT_LS
    ///	* SILENT_STEPPER_V2_BRICKLET_FREEWHEEL_MODE_COIL_SHORT_HS
    pub fn get_stealth_configuration(&self) -> ConvertingReceiver<StealthConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetStealthConfiguration), payload)
    }

    /// Note: If you don't know what any of this means you can very likely keep all of
    /// the values as default!
    ///
    /// Sets the configuration relevant for Coolstep.
    ///
    /// * Minimum Stallguard Value: If the Stallguard result falls below this value*32, the motor current
    ///   is increased to reduce motor load angle. A value of 0 turns Coolstep off.
    ///
    /// * Maximum Stallguard Value: If the Stallguard result goes above
    ///   (Min Stallguard Value + Max Stallguard Value + 1) * 32, the motor current is decreased to save
    ///   energy.
    ///
    /// * Current Up Step Width: Sets the up step increment per Stallguard value. The value range is 0-3,
    ///   corresponding to the increments 1, 2, 4 and 8.
    ///
    /// * Current Down Step Width: Sets the down step decrement per Stallguard value. The value range is 0-3,
    ///   corresponding to the decrements 1, 2, 8 and 16.
    ///
    /// * Minimum Current: Sets the minimum current for Coolstep current control. You can choose between
    ///   half and quarter of the run current.
    ///
    /// * Stallguard Threshold Value: Sets the level for stall output (see [`get_driver_status`]).
    ///   A lower value gives a higher sensitivity. You have to find a suitable value for your
    ///   motor by trial and error, 0 works for most motors.
    ///
    /// * Stallguard Mode: Set to 0 for standard resolution or 1 for filtered mode. In filtered mode the Stallguard
    ///   signal will be updated every four full-steps.
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_V2_BRICKLET_CURRENT_UP_STEP_INCREMENT_1
    ///	* SILENT_STEPPER_V2_BRICKLET_CURRENT_UP_STEP_INCREMENT_2
    ///	* SILENT_STEPPER_V2_BRICKLET_CURRENT_UP_STEP_INCREMENT_4
    ///	* SILENT_STEPPER_V2_BRICKLET_CURRENT_UP_STEP_INCREMENT_8
    ///	* SILENT_STEPPER_V2_BRICKLET_CURRENT_DOWN_STEP_DECREMENT_1
    ///	* SILENT_STEPPER_V2_BRICKLET_CURRENT_DOWN_STEP_DECREMENT_2
    ///	* SILENT_STEPPER_V2_BRICKLET_CURRENT_DOWN_STEP_DECREMENT_8
    ///	* SILENT_STEPPER_V2_BRICKLET_CURRENT_DOWN_STEP_DECREMENT_32
    ///	* SILENT_STEPPER_V2_BRICKLET_MINIMUM_CURRENT_HALF
    ///	* SILENT_STEPPER_V2_BRICKLET_MINIMUM_CURRENT_QUARTER
    ///	* SILENT_STEPPER_V2_BRICKLET_STALLGUARD_MODE_STANDARD
    ///	* SILENT_STEPPER_V2_BRICKLET_STALLGUARD_MODE_FILTERED
    pub fn set_coolstep_configuration(
        &self,
        minimum_stallguard_value: u8,
        maximum_stallguard_value: u8,
        current_up_step_width: u8,
        current_down_step_width: u8,
        minimum_current: u8,
        stallguard_threshold_value: i8,
        stallguard_mode: u8,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 7];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(minimum_stallguard_value));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(maximum_stallguard_value));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(current_up_step_width));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(current_down_step_width));
        payload[4..5].copy_from_slice(&<u8>::to_le_byte_vec(minimum_current));
        payload[5..6].copy_from_slice(&<i8>::to_le_byte_vec(stallguard_threshold_value));
        payload[6..7].copy_from_slice(&<u8>::to_le_byte_vec(stallguard_mode));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetCoolstepConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_coolstep_configuration`].
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_V2_BRICKLET_CURRENT_UP_STEP_INCREMENT_1
    ///	* SILENT_STEPPER_V2_BRICKLET_CURRENT_UP_STEP_INCREMENT_2
    ///	* SILENT_STEPPER_V2_BRICKLET_CURRENT_UP_STEP_INCREMENT_4
    ///	* SILENT_STEPPER_V2_BRICKLET_CURRENT_UP_STEP_INCREMENT_8
    ///	* SILENT_STEPPER_V2_BRICKLET_CURRENT_DOWN_STEP_DECREMENT_1
    ///	* SILENT_STEPPER_V2_BRICKLET_CURRENT_DOWN_STEP_DECREMENT_2
    ///	* SILENT_STEPPER_V2_BRICKLET_CURRENT_DOWN_STEP_DECREMENT_8
    ///	* SILENT_STEPPER_V2_BRICKLET_CURRENT_DOWN_STEP_DECREMENT_32
    ///	* SILENT_STEPPER_V2_BRICKLET_MINIMUM_CURRENT_HALF
    ///	* SILENT_STEPPER_V2_BRICKLET_MINIMUM_CURRENT_QUARTER
    ///	* SILENT_STEPPER_V2_BRICKLET_STALLGUARD_MODE_STANDARD
    ///	* SILENT_STEPPER_V2_BRICKLET_STALLGUARD_MODE_FILTERED
    pub fn get_coolstep_configuration(&self) -> ConvertingReceiver<CoolstepConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetCoolstepConfiguration), payload)
    }

    /// Note: If you don't know what any of this means you can very likely keep all of
    /// the values as default!
    ///
    /// Sets miscellaneous configuration parameters.
    ///
    /// * Disable Short To Ground Protection: Set to false to enable short to ground protection, otherwise
    ///   it is disabled.
    ///
    /// * Synchronize Phase Frequency: With this parameter you can synchronize the chopper for both phases
    ///   of a two phase motor to avoid the occurrence of a beat. The value range is 0-15. If set to 0,
    ///   the synchronization is turned off. Otherwise the synchronization is done through the formula
    ///   f_sync = f_clk/(value*64). In Classic Mode the synchronization is automatically switched off.
    ///   f_clk is 12.8MHz.
    pub fn set_misc_configuration(
        &self,
        disable_short_to_ground_protection: bool,
        synchronize_phase_frequency: u8,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(disable_short_to_ground_protection));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(synchronize_phase_frequency));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetMiscConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_misc_configuration`].
    pub fn get_misc_configuration(&self) -> ConvertingReceiver<MiscConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetMiscConfiguration), payload)
    }

    /// Configures the error LED to be either turned off, turned on, blink in
    /// heartbeat mode or show an error.
    ///
    /// If the LED is configured to show errors it has three different states:
    ///
    /// * Off: No error present.
    /// * 250ms interval blink: Overtemperature warning.
    /// * 1s interval blink: Input voltage too small.
    /// * full red: motor disabled because of short to ground in phase a or b or because of overtemperature.
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_V2_BRICKLET_ERROR_LED_CONFIG_OFF
    ///	* SILENT_STEPPER_V2_BRICKLET_ERROR_LED_CONFIG_ON
    ///	* SILENT_STEPPER_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_HEARTBEAT
    ///	* SILENT_STEPPER_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_ERROR
    pub fn set_error_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetErrorLedConfig), payload)
    }

    /// Returns the LED configuration as set by [`set_error_led_config`]
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_V2_BRICKLET_ERROR_LED_CONFIG_OFF
    ///	* SILENT_STEPPER_V2_BRICKLET_ERROR_LED_CONFIG_ON
    ///	* SILENT_STEPPER_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_HEARTBEAT
    ///	* SILENT_STEPPER_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_ERROR
    pub fn get_error_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetErrorLedConfig), payload)
    }

    /// Returns the current driver status.
    ///
    /// * Open Load: Indicates if an open load is present on phase A, B or both. This could mean that there is a problem
    ///   with the wiring of the motor. False detection can occur in fast motion as well as during stand still.
    ///
    /// * Short To Ground: Indicates if a short to ground is present on phase A, B or both. If this is detected the driver
    ///   automatically becomes disabled and stays disabled until it is enabled again manually.
    ///
    /// * Over Temperature: The over temperature indicator switches to Warning if the driver IC warms up. The warning flag
    ///   is expected during long duration stepper uses. If the temperature limit is reached the indicator switches
    ///   to Limit. In this case the driver becomes disabled until it cools down again.
    ///
    /// * Motor Stalled: Is true if a motor stall was detected.
    ///
    /// * Actual Motor Current: Indicates the actual current control scaling as used in Coolstep mode.
    ///   It represents a multiplier of 1/32 to 32/32 of the
    ///   ``Motor Run Current`` as set by [`set_basic_configuration`]. Example: If a ``Motor Run Current``
    ///   of 1000mA was set and the returned value is 15, the ``Actual Motor Current`` is 16/32*1000mA = 500mA.
    ///
    /// * Stallguard Result: Indicates the load of the motor. A lower value signals a higher load. Per trial and error
    ///   you can find out which value corresponds to a suitable torque for the velocity used in your application.
    ///   After that you can use this threshold value to find out if a motor stall becomes probable and react on it (e.g.
    ///   decrease velocity).
    ///   During stand still this value can not be used for stall detection, it shows the chopper on-time for motor coil A.
    ///
    /// * Stealth Voltage Amplitude: Shows the actual PWM scaling. In Stealth mode it can be used to detect motor load and
    ///   stall if autoscale is enabled (see [`set_stealth_configuration`]).
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_V2_BRICKLET_OPEN_LOAD_NONE
    ///	* SILENT_STEPPER_V2_BRICKLET_OPEN_LOAD_PHASE_A
    ///	* SILENT_STEPPER_V2_BRICKLET_OPEN_LOAD_PHASE_B
    ///	* SILENT_STEPPER_V2_BRICKLET_OPEN_LOAD_PHASE_AB
    ///	* SILENT_STEPPER_V2_BRICKLET_SHORT_TO_GROUND_NONE
    ///	* SILENT_STEPPER_V2_BRICKLET_SHORT_TO_GROUND_PHASE_A
    ///	* SILENT_STEPPER_V2_BRICKLET_SHORT_TO_GROUND_PHASE_B
    ///	* SILENT_STEPPER_V2_BRICKLET_SHORT_TO_GROUND_PHASE_AB
    ///	* SILENT_STEPPER_V2_BRICKLET_OVER_TEMPERATURE_NONE
    ///	* SILENT_STEPPER_V2_BRICKLET_OVER_TEMPERATURE_WARNING
    ///	* SILENT_STEPPER_V2_BRICKLET_OVER_TEMPERATURE_LIMIT
    pub fn get_driver_status(&self) -> ConvertingReceiver<DriverStatus> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetDriverStatus), payload)
    }

    /// Sets the minimum voltage, below which the [`get_under_voltage_callback_receiver`] receiver
    /// is triggered. The minimum possible value that works with the Silent Stepper
    /// Bricklet 2.0 is 8V.
    /// You can use this function to detect the discharge of a battery that is used
    /// to drive the stepper motor. If you have a fixed power supply, you likely do
    /// not need this functionality.
    pub fn set_minimum_voltage(&self, voltage: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(voltage));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetMinimumVoltage), payload)
    }

    /// Returns the minimum voltage as set by [`set_minimum_voltage`].
    pub fn get_minimum_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetMinimumVoltage), payload)
    }

    /// Sets the time base of the velocity and the acceleration of the Silent Stepper
    /// Bricklet 2.0.
    ///
    /// For example, if you want to make one step every 1.5 seconds, you can set
    /// the time base to 15 and the velocity to 10. Now the velocity is
    /// 10steps/15s = 1steps/1.5s.
    pub fn set_time_base(&self, time_base: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(time_base));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetTimeBase), payload)
    }

    /// Returns the time base as set by [`set_time_base`].
    pub fn get_time_base(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetTimeBase), payload)
    }

    /// Returns the following parameters: The current velocity,
    /// the current position, the remaining steps, the stack voltage, the external
    /// voltage and the current consumption of the stepper motor.
    ///
    /// The current consumption is calculated by multiplying the ``Actual Motor Current``
    /// value (see [`set_basic_configuration`]) with the ``Motor Run Current``
    /// (see [`get_driver_status`]). This is an internal calculation of the
    /// driver, not an independent external measurement.
    ///
    /// The current consumption calculation was broken up to firmware 2.0.1, it is fixed
    /// since firmware 2.0.2.
    ///
    /// There is also a receiver for this function, see [`get_all_data_callback_receiver`] receiver.
    pub fn get_all_data(&self) -> ConvertingReceiver<AllData> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetAllData), payload)
    }

    /// Sets the period with which the [`get_all_data_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    pub fn set_all_callback_configuration(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetAllCallbackConfiguration), payload)
    }

    /// Returns the period as set by [`set_all_callback_configuration`].
    pub fn get_all_data_callback_configuraton(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetAllDataCallbackConfiguraton), payload)
    }

    /// Sets the GPIO configuration for the given channel.
    /// You can configure a debounce and the deceleration that is used if the action is
    /// configured as ``normal stop``. See [`set_gpio_action`].
    pub fn set_gpio_configuration(&self, channel: u8, debounce: u16, stop_deceleration: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(debounce));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(stop_deceleration));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetGpioConfiguration), payload)
    }

    /// Returns the GPIO configuration for a channel as set by [`set_gpio_configuration`].
    pub fn get_gpio_configuration(&self, channel: u8) -> ConvertingReceiver<GpioConfiguration> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetGpioConfiguration), payload)
    }

    /// Sets the GPIO action for the given channel.
    ///
    /// The action can be a normal stop, a full brake or a receiver. Each for a rising
    /// edge or falling edge. The actions are a bitmask they can be used at the same time.
    /// You can for example trigger a full brake and a receiver at the same time or for
    /// rising and falling edge.
    ///
    /// The deceleration speed for the normal stop can be configured with
    /// [`set_gpio_configuration`].
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_NONE
    ///	* SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_NORMAL_STOP_RISING_EDGE
    ///	* SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_NORMAL_STOP_FALLING_EDGE
    ///	* SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_FULL_BRAKE_RISING_EDGE
    ///	* SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_FULL_BRAKE_FALLING_EDGE
    ///	* SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_CALLBACK_RISING_EDGE
    ///	* SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_CALLBACK_FALLING_EDGE
    pub fn set_gpio_action(&self, channel: u8, action: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(action));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetGpioAction), payload)
    }

    /// Returns the GPIO action for a channel as set by [`set_gpio_action`].
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_NONE
    ///	* SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_NORMAL_STOP_RISING_EDGE
    ///	* SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_NORMAL_STOP_FALLING_EDGE
    ///	* SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_FULL_BRAKE_RISING_EDGE
    ///	* SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_FULL_BRAKE_FALLING_EDGE
    ///	* SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_CALLBACK_RISING_EDGE
    ///	* SILENT_STEPPER_V2_BRICKLET_GPIO_ACTION_CALLBACK_FALLING_EDGE
    pub fn get_gpio_action(&self, channel: u8) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetGpioAction), payload)
    }

    /// Returns the GPIO state for both channels. True if the state is ``high`` and
    /// false if the state is ``low``.
    pub fn get_gpio_state(&self) -> ConvertingReceiver<[bool; 2]> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetGpioState), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(SilentStepperV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* SILENT_STEPPER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(SilentStepperV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* SILENT_STEPPER_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* SILENT_STEPPER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* SILENT_STEPPER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* SILENT_STEPPER_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* SILENT_STEPPER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* SILENT_STEPPER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(SilentStepperV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(SilentStepperV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperV2BrickletFunction::GetIdentity), payload)
    }
}
