/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Drives up to 10 RC Servos.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/ServoV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum ServoV2BrickletFunction {
    GetStatus,
    SetEnable,
    GetEnabled,
    SetPosition,
    GetPosition,
    GetCurrentPosition,
    GetCurrentVelocity,
    SetMotionConfiguration,
    GetMotionConfiguration,
    SetPulseWidth,
    GetPulseWidth,
    SetDegree,
    GetDegree,
    SetPeriod,
    GetPeriod,
    GetServoCurrent,
    SetServoCurrentConfiguration,
    GetServoCurrentConfiguration,
    SetInputVoltageConfiguration,
    GetInputVoltageConfiguration,
    GetOverallCurrent,
    GetInputVoltage,
    SetCurrentCalibration,
    GetCurrentCalibration,
    SetPositionReachedCallbackConfiguration,
    GetPositionReachedCallbackConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackPositionReached,
}
impl From<ServoV2BrickletFunction> for u8 {
    fn from(fun: ServoV2BrickletFunction) -> Self {
        match fun {
            ServoV2BrickletFunction::GetStatus => 1,
            ServoV2BrickletFunction::SetEnable => 2,
            ServoV2BrickletFunction::GetEnabled => 3,
            ServoV2BrickletFunction::SetPosition => 4,
            ServoV2BrickletFunction::GetPosition => 5,
            ServoV2BrickletFunction::GetCurrentPosition => 6,
            ServoV2BrickletFunction::GetCurrentVelocity => 7,
            ServoV2BrickletFunction::SetMotionConfiguration => 8,
            ServoV2BrickletFunction::GetMotionConfiguration => 9,
            ServoV2BrickletFunction::SetPulseWidth => 10,
            ServoV2BrickletFunction::GetPulseWidth => 11,
            ServoV2BrickletFunction::SetDegree => 12,
            ServoV2BrickletFunction::GetDegree => 13,
            ServoV2BrickletFunction::SetPeriod => 14,
            ServoV2BrickletFunction::GetPeriod => 15,
            ServoV2BrickletFunction::GetServoCurrent => 16,
            ServoV2BrickletFunction::SetServoCurrentConfiguration => 17,
            ServoV2BrickletFunction::GetServoCurrentConfiguration => 18,
            ServoV2BrickletFunction::SetInputVoltageConfiguration => 19,
            ServoV2BrickletFunction::GetInputVoltageConfiguration => 20,
            ServoV2BrickletFunction::GetOverallCurrent => 21,
            ServoV2BrickletFunction::GetInputVoltage => 22,
            ServoV2BrickletFunction::SetCurrentCalibration => 23,
            ServoV2BrickletFunction::GetCurrentCalibration => 24,
            ServoV2BrickletFunction::SetPositionReachedCallbackConfiguration => 25,
            ServoV2BrickletFunction::GetPositionReachedCallbackConfiguration => 26,
            ServoV2BrickletFunction::GetSpitfpErrorCount => 234,
            ServoV2BrickletFunction::SetBootloaderMode => 235,
            ServoV2BrickletFunction::GetBootloaderMode => 236,
            ServoV2BrickletFunction::SetWriteFirmwarePointer => 237,
            ServoV2BrickletFunction::WriteFirmware => 238,
            ServoV2BrickletFunction::SetStatusLedConfig => 239,
            ServoV2BrickletFunction::GetStatusLedConfig => 240,
            ServoV2BrickletFunction::GetChipTemperature => 242,
            ServoV2BrickletFunction::Reset => 243,
            ServoV2BrickletFunction::WriteUid => 248,
            ServoV2BrickletFunction::ReadUid => 249,
            ServoV2BrickletFunction::GetIdentity => 255,
            ServoV2BrickletFunction::CallbackPositionReached => 27,
        }
    }
}
pub const SERVO_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const SERVO_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const SERVO_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const SERVO_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const SERVO_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const SERVO_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const SERVO_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const SERVO_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const SERVO_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const SERVO_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const SERVO_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const SERVO_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const SERVO_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const SERVO_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const SERVO_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Status {
    pub enabled: [bool; 10],
    pub current_position: [i16; 10],
    pub current_velocity: [i16; 10],
    pub current: [u16; 10],
    pub input_voltage: u16,
}
impl FromByteSlice for Status {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> Status {
        Status {
            enabled: <[bool; 10]>::from_le_byte_slice(&bytes[0..2]),
            current_position: <[i16; 10]>::from_le_byte_slice(&bytes[2..22]),
            current_velocity: <[i16; 10]>::from_le_byte_slice(&bytes[22..42]),
            current: <[u16; 10]>::from_le_byte_slice(&bytes[42..62]),
            input_voltage: <u16>::from_le_byte_slice(&bytes[62..64]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MotionConfiguration {
    pub velocity: u32,
    pub acceleration: u32,
    pub deceleration: u32,
}
impl FromByteSlice for MotionConfiguration {
    fn bytes_expected() -> usize { 12 }
    fn from_le_byte_slice(bytes: &[u8]) -> MotionConfiguration {
        MotionConfiguration {
            velocity: <u32>::from_le_byte_slice(&bytes[0..4]),
            acceleration: <u32>::from_le_byte_slice(&bytes[4..8]),
            deceleration: <u32>::from_le_byte_slice(&bytes[8..12]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct PulseWidth {
    pub min: u32,
    pub max: u32,
}
impl FromByteSlice for PulseWidth {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> PulseWidth {
        PulseWidth { min: <u32>::from_le_byte_slice(&bytes[0..4]), max: <u32>::from_le_byte_slice(&bytes[4..8]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Degree {
    pub min: i16,
    pub max: i16,
}
impl FromByteSlice for Degree {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> Degree {
        Degree { min: <i16>::from_le_byte_slice(&bytes[0..2]), max: <i16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct PositionReachedEvent {
    pub servo_channel: u16,
    pub position: i16,
}
impl FromByteSlice for PositionReachedEvent {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> PositionReachedEvent {
        PositionReachedEvent { servo_channel: <u16>::from_le_byte_slice(&bytes[0..2]), position: <i16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Drives up to 10 RC Servos
#[derive(Clone)]
pub struct ServoV2Bricklet {
    device: Device,
}
impl ServoV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2157;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Servo Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> ServoV2Bricklet {
        let mut result = ServoV2Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetStatus) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::SetEnable) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetEnabled) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::SetPosition) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetPosition) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetCurrentPosition) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetCurrentVelocity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::SetMotionConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetMotionConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::SetPulseWidth) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetPulseWidth) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::SetDegree) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetDegree) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::SetPeriod) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetServoCurrent) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::SetServoCurrentConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetServoCurrentConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::SetInputVoltageConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetInputVoltageConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetOverallCurrent) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetInputVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::SetCurrentCalibration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetCurrentCalibration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::SetPositionReachedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetPositionReachedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::SetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::SetWriteFirmwarePointer) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetStatusLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoV2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::servo_v2_bricklet::ServoV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::servo_v2_bricklet::ServoV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: ServoV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: ServoV2BrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered when a position set by [`set_position`]
    /// is reached. If the new position matches the current position then the
    /// receiver is not triggered, because the servo didn't move.
    /// The parameters are the servo and the position that is reached.
    ///
    /// You can enable this receiver with [`set_position_reached_callback_configuration`].
    ///
    /// # Note
    ///  Since we can't get any feedback from the servo, this only works if the
    ///  velocity (see [`set_motion_configuration`]) is set smaller or equal to the
    ///  maximum velocity of the servo. Otherwise the servo will lag behind the
    ///  control value and the receiver will be triggered too early.
    ///
    /// [`set_position`]: #method.set_position
    /// [`set_motion_configuration`]: #method.set_motion_configuration
    /// [`set_position_reached_callback_configuration`]: #method.set_position_reached_callback_configuration
    pub fn get_position_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<PositionReachedEvent> {
        self.device.get_callback_receiver(u8::from(ServoV2BrickletFunction::CallbackPositionReached))
    }

    /// Returns the status information of the Servo Bricklet 2.0.
    ///
    /// The status includes
    ///
    /// * for each channel if it is enabled or disabled,
    /// * for each channel the current position,
    /// * for each channel the current velocity,
    /// * for each channel the current usage and
    /// * the input voltage.
    ///
    /// Please note that the position and the velocity is a snapshot of the
    /// current position and velocity of the servo in motion.
    pub fn get_status(&self) -> ConvertingReceiver<Status> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoV2BrickletFunction::GetStatus), payload)
    }

    /// Enables a servo channel (0 to 9). If a servo is enabled, the configured position,
    /// velocity, acceleration, etc. are applied immediately.
    pub fn set_enable(&self, servo_channel: u16, enable: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(servo_channel));
        payload[2..3].copy_from_slice(&<bool>::to_le_byte_vec(enable));

        self.device.set(u8::from(ServoV2BrickletFunction::SetEnable), payload)
    }

    /// Returns *true* if the specified servo channel is enabled, *false* otherwise.
    pub fn get_enabled(&self, servo_channel: u16) -> ConvertingReceiver<bool> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(servo_channel));

        self.device.get(u8::from(ServoV2BrickletFunction::GetEnabled), payload)
    }

    /// Sets the position in °/100 for the specified servo channel.
    ///
    /// The default range of the position is -9000 to 9000, but it can be specified
    /// according to your servo with [`set_degree`].
    ///
    /// If you want to control a linear servo or RC brushless motor controller or
    /// similar with the Servo Brick, you can also define lengths or speeds with
    /// [`set_degree`].
    pub fn set_position(&self, servo_channel: u16, position: i16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(servo_channel));
        payload[2..4].copy_from_slice(&<i16>::to_le_byte_vec(position));

        self.device.set(u8::from(ServoV2BrickletFunction::SetPosition), payload)
    }

    /// Returns the position of the specified servo channel as set by [`set_position`].
    pub fn get_position(&self, servo_channel: u16) -> ConvertingReceiver<i16> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(servo_channel));

        self.device.get(u8::from(ServoV2BrickletFunction::GetPosition), payload)
    }

    /// Returns the *current* position of the specified servo channel. This may not be the
    /// value of [`set_position`] if the servo is currently approaching a
    /// position goal.
    pub fn get_current_position(&self, servo_channel: u16) -> ConvertingReceiver<i16> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(servo_channel));

        self.device.get(u8::from(ServoV2BrickletFunction::GetCurrentPosition), payload)
    }

    /// Returns the *current* velocity of the specified servo channel. This may not be the
    /// velocity specified by [`set_motion_configuration`]. if the servo is
    /// currently approaching a velocity goal.
    pub fn get_current_velocity(&self, servo_channel: u16) -> ConvertingReceiver<u16> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(servo_channel));

        self.device.get(u8::from(ServoV2BrickletFunction::GetCurrentVelocity), payload)
    }

    /// Sets the maximum velocity of the specified servo channel in °/100s as well as
    /// the acceleration and deceleration in °/100s²
    ///
    /// With a velocity of 0 °/100s the position will be set immediately (no velocity).
    ///
    /// With an acc-/deceleration of 0 °/100s² the velocity will be set immediately
    /// (no acc-/deceleration).
    pub fn set_motion_configuration(
        &self,
        servo_channel: u16,
        velocity: u32,
        acceleration: u32,
        deceleration: u32,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 14];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(servo_channel));
        payload[2..6].copy_from_slice(&<u32>::to_le_byte_vec(velocity));
        payload[6..10].copy_from_slice(&<u32>::to_le_byte_vec(acceleration));
        payload[10..14].copy_from_slice(&<u32>::to_le_byte_vec(deceleration));

        self.device.set(u8::from(ServoV2BrickletFunction::SetMotionConfiguration), payload)
    }

    /// Returns the motion configuration as set by [`set_motion_configuration`].
    pub fn get_motion_configuration(&self, servo_channel: u16) -> ConvertingReceiver<MotionConfiguration> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(servo_channel));

        self.device.get(u8::from(ServoV2BrickletFunction::GetMotionConfiguration), payload)
    }

    /// Sets the minimum and maximum pulse width of the specified servo channel in µs.
    ///
    /// Usually, servos are controlled with a
    /// [PWM](https://en.wikipedia.org/wiki/Pulse-width_modulation)__, whereby the
    /// length of the pulse controls the position of the servo. Every servo has
    /// different minimum and maximum pulse widths, these can be specified with
    /// this function.
    ///
    /// If you have a datasheet for your servo that specifies the minimum and
    /// maximum pulse width, you should set the values accordingly. If your servo
    /// comes without any datasheet you have to find the values via trial and error.
    ///
    /// Both values have a range from 1 to 65535 (unsigned 16-bit integer). The
    /// minimum must be smaller than the maximum.
    ///
    /// The default values are 1000µs (1ms) and 2000µs (2ms) for minimum and
    /// maximum pulse width.
    pub fn set_pulse_width(&self, servo_channel: u16, min: u32, max: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 10];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(servo_channel));
        payload[2..6].copy_from_slice(&<u32>::to_le_byte_vec(min));
        payload[6..10].copy_from_slice(&<u32>::to_le_byte_vec(max));

        self.device.set(u8::from(ServoV2BrickletFunction::SetPulseWidth), payload)
    }

    /// Returns the minimum and maximum pulse width for the specified servo channel as set by
    /// [`set_pulse_width`].
    pub fn get_pulse_width(&self, servo_channel: u16) -> ConvertingReceiver<PulseWidth> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(servo_channel));

        self.device.get(u8::from(ServoV2BrickletFunction::GetPulseWidth), payload)
    }

    /// Sets the minimum and maximum degree for the specified servo channel (by default
    /// given as °/100).
    ///
    /// This only specifies the abstract values between which the minimum and maximum
    /// pulse width is scaled. For example: If you specify a pulse width of 1000µs
    /// to 2000µs and a degree range of -90° to 90°, a call of [`set_position`]
    /// with 0 will result in a pulse width of 1500µs
    /// (-90° = 1000µs, 90° = 2000µs, etc.).
    ///
    /// Possible usage:
    ///
    /// * The datasheet of your servo specifies a range of 200° with the middle position
    ///   at 110°. In this case you can set the minimum to -9000 and the maximum to 11000.
    /// * You measure a range of 220° on your servo and you don't have or need a middle
    ///   position. In this case you can set the minimum to 0 and the maximum to 22000.
    /// * You have a linear servo with a drive length of 20cm, In this case you could
    ///   set the minimum to 0 and the maximum to 20000. Now you can set the Position
    ///   with [`set_position`] with a resolution of cm/100. Also the velocity will
    ///   have a resolution of cm/100s and the acceleration will have a resolution of
    ///   cm/100s².
    /// * You don't care about units and just want the highest possible resolution. In
    ///   this case you should set the minimum to -32767 and the maximum to 32767.
    /// * You have a brushless motor with a maximum speed of 10000 rpm and want to
    ///   control it with a RC brushless motor controller. In this case you can set the
    ///   minimum to 0 and the maximum to 10000. [`set_position`] now controls the rpm.
    ///
    /// Both values have a possible range from -32767 to 32767
    /// (signed 16-bit integer). The minimum must be smaller than the maximum.
    ///
    /// The default values are -9000 and 9000 for the minimum and maximum degree.
    pub fn set_degree(&self, servo_channel: u16, min: i16, max: i16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(servo_channel));
        payload[2..4].copy_from_slice(&<i16>::to_le_byte_vec(min));
        payload[4..6].copy_from_slice(&<i16>::to_le_byte_vec(max));

        self.device.set(u8::from(ServoV2BrickletFunction::SetDegree), payload)
    }

    /// Returns the minimum and maximum degree for the specified servo channel as set by
    /// [`set_degree`].
    pub fn get_degree(&self, servo_channel: u16) -> ConvertingReceiver<Degree> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(servo_channel));

        self.device.get(u8::from(ServoV2BrickletFunction::GetDegree), payload)
    }

    /// Sets the period of the specified servo channel in µs.
    ///
    /// Usually, servos are controlled with a
    /// [PWM](https://en.wikipedia.org/wiki/Pulse-width_modulation)__. Different
    /// servos expect PWMs with different periods. Most servos run well with a
    /// period of about 20ms.
    ///
    /// If your servo comes with a datasheet that specifies a period, you should
    /// set it accordingly. If you don't have a datasheet and you have no idea
    /// what the correct period is, the default value (19.5ms) will most likely
    /// work fine.
    ///
    /// The minimum possible period is 1µs and the maximum is 1000000µs.
    ///
    /// The default value is 19.5ms (19500µs).
    pub fn set_period(&self, servo_channel: u16, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(servo_channel));
        payload[2..6].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ServoV2BrickletFunction::SetPeriod), payload)
    }

    /// Returns the period for the specified servo channel as set by [`set_period`].
    pub fn get_period(&self, servo_channel: u16) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(servo_channel));

        self.device.get(u8::from(ServoV2BrickletFunction::GetPeriod), payload)
    }

    /// Returns the current consumption of the specified servo channel in mA.
    pub fn get_servo_current(&self, servo_channel: u16) -> ConvertingReceiver<u16> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(servo_channel));

        self.device.get(u8::from(ServoV2BrickletFunction::GetServoCurrent), payload)
    }

    /// Sets the averaging duration of the current measurement for the specified servo channel in ms.
    pub fn set_servo_current_configuration(&self, servo_channel: u16, averaging_duration: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(servo_channel));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(averaging_duration));

        self.device.set(u8::from(ServoV2BrickletFunction::SetServoCurrentConfiguration), payload)
    }

    /// Returns the servo current configuration for the specified servo channel as set
    /// by [`set_servo_current_configuration`].
    pub fn get_servo_current_configuration(&self, servo_channel: u16) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(servo_channel));

        self.device.get(u8::from(ServoV2BrickletFunction::GetServoCurrentConfiguration), payload)
    }

    /// Sets the averaging duration of the input voltage measurement for the specified servo channel in ms.
    pub fn set_input_voltage_configuration(&self, averaging_duration: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(averaging_duration));

        self.device.set(u8::from(ServoV2BrickletFunction::SetInputVoltageConfiguration), payload)
    }

    /// Returns the input voltage configuration as set by [`set_input_voltage_configuration`].
    pub fn get_input_voltage_configuration(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoV2BrickletFunction::GetInputVoltageConfiguration), payload)
    }

    /// Returns the current consumption of all servos together in mA.
    pub fn get_overall_current(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoV2BrickletFunction::GetOverallCurrent), payload)
    }

    /// Returns the input voltage in mV. The input voltage is
    /// given via the black power input connector on the Servo Brick.
    pub fn get_input_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoV2BrickletFunction::GetInputVoltage), payload)
    }

    /// Sets an offset value (in mA) for each channel.
    ///
    /// Note: On delivery the Servo Bricklet 2.0 is already calibrated.
    pub fn set_current_calibration(&self, offset: [i16; 10]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 20];
        payload[0..20].copy_from_slice(&<[i16; 10]>::to_le_byte_vec(offset));

        self.device.set(u8::from(ServoV2BrickletFunction::SetCurrentCalibration), payload)
    }

    /// Returns the current calibration as set by [`set_current_calibration`].
    pub fn get_current_calibration(&self) -> ConvertingReceiver<[i16; 10]> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoV2BrickletFunction::GetCurrentCalibration), payload)
    }

    /// Enable/Disable [`get_position_reached_callback_receiver`] receiver.
    pub fn set_position_reached_callback_configuration(&self, servo_channel: u16, enabled: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(servo_channel));
        payload[2..3].copy_from_slice(&<bool>::to_le_byte_vec(enabled));

        self.device.set(u8::from(ServoV2BrickletFunction::SetPositionReachedCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_position_reached_callback_configuration`].
    pub fn get_position_reached_callback_configuration(&self, servo_channel: u16) -> ConvertingReceiver<bool> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(servo_channel));

        self.device.get(u8::from(ServoV2BrickletFunction::GetPositionReachedCallbackConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * SERVO_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* SERVO_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* SERVO_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* SERVO_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* SERVO_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* SERVO_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* SERVO_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* SERVO_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* SERVO_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* SERVO_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* SERVO_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(ServoV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * SERVO_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* SERVO_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* SERVO_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* SERVO_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* SERVO_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(ServoV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(ServoV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * SERVO_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* SERVO_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* SERVO_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* SERVO_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(ServoV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * SERVO_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* SERVO_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* SERVO_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* SERVO_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ServoV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(ServoV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoV2BrickletFunction::GetIdentity), payload)
    }
}
