/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Drives up to 7 RC Servos with up to 3A.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricks/Servo_Brick_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum ServoBrickFunction {
    Enable,
    Disable,
    IsEnabled,
    SetPosition,
    GetPosition,
    GetCurrentPosition,
    SetVelocity,
    GetVelocity,
    GetCurrentVelocity,
    SetAcceleration,
    GetAcceleration,
    SetOutputVoltage,
    GetOutputVoltage,
    SetPulseWidth,
    GetPulseWidth,
    SetDegree,
    GetDegree,
    SetPeriod,
    GetPeriod,
    GetServoCurrent,
    GetOverallCurrent,
    GetStackInputVoltage,
    GetExternalInputVoltage,
    SetMinimumVoltage,
    GetMinimumVoltage,
    EnablePositionReachedCallback,
    DisablePositionReachedCallback,
    IsPositionReachedCallbackEnabled,
    EnableVelocityReachedCallback,
    DisableVelocityReachedCallback,
    IsVelocityReachedCallbackEnabled,
    SetSpitfpBaudrateConfig,
    GetSpitfpBaudrateConfig,
    GetSendTimeoutCount,
    SetSpitfpBaudrate,
    GetSpitfpBaudrate,
    GetSpitfpErrorCount,
    EnableStatusLed,
    DisableStatusLed,
    IsStatusLedEnabled,
    GetProtocol1BrickletName,
    GetChipTemperature,
    Reset,
    WriteBrickletPlugin,
    ReadBrickletPlugin,
    GetIdentity,
    CallbackUnderVoltage,
    CallbackPositionReached,
    CallbackVelocityReached,
}
impl From<ServoBrickFunction> for u8 {
    fn from(fun: ServoBrickFunction) -> Self {
        match fun {
            ServoBrickFunction::Enable => 1,
            ServoBrickFunction::Disable => 2,
            ServoBrickFunction::IsEnabled => 3,
            ServoBrickFunction::SetPosition => 4,
            ServoBrickFunction::GetPosition => 5,
            ServoBrickFunction::GetCurrentPosition => 6,
            ServoBrickFunction::SetVelocity => 7,
            ServoBrickFunction::GetVelocity => 8,
            ServoBrickFunction::GetCurrentVelocity => 9,
            ServoBrickFunction::SetAcceleration => 10,
            ServoBrickFunction::GetAcceleration => 11,
            ServoBrickFunction::SetOutputVoltage => 12,
            ServoBrickFunction::GetOutputVoltage => 13,
            ServoBrickFunction::SetPulseWidth => 14,
            ServoBrickFunction::GetPulseWidth => 15,
            ServoBrickFunction::SetDegree => 16,
            ServoBrickFunction::GetDegree => 17,
            ServoBrickFunction::SetPeriod => 18,
            ServoBrickFunction::GetPeriod => 19,
            ServoBrickFunction::GetServoCurrent => 20,
            ServoBrickFunction::GetOverallCurrent => 21,
            ServoBrickFunction::GetStackInputVoltage => 22,
            ServoBrickFunction::GetExternalInputVoltage => 23,
            ServoBrickFunction::SetMinimumVoltage => 24,
            ServoBrickFunction::GetMinimumVoltage => 25,
            ServoBrickFunction::EnablePositionReachedCallback => 29,
            ServoBrickFunction::DisablePositionReachedCallback => 30,
            ServoBrickFunction::IsPositionReachedCallbackEnabled => 31,
            ServoBrickFunction::EnableVelocityReachedCallback => 32,
            ServoBrickFunction::DisableVelocityReachedCallback => 33,
            ServoBrickFunction::IsVelocityReachedCallbackEnabled => 34,
            ServoBrickFunction::SetSpitfpBaudrateConfig => 231,
            ServoBrickFunction::GetSpitfpBaudrateConfig => 232,
            ServoBrickFunction::GetSendTimeoutCount => 233,
            ServoBrickFunction::SetSpitfpBaudrate => 234,
            ServoBrickFunction::GetSpitfpBaudrate => 235,
            ServoBrickFunction::GetSpitfpErrorCount => 237,
            ServoBrickFunction::EnableStatusLed => 238,
            ServoBrickFunction::DisableStatusLed => 239,
            ServoBrickFunction::IsStatusLedEnabled => 240,
            ServoBrickFunction::GetProtocol1BrickletName => 241,
            ServoBrickFunction::GetChipTemperature => 242,
            ServoBrickFunction::Reset => 243,
            ServoBrickFunction::WriteBrickletPlugin => 246,
            ServoBrickFunction::ReadBrickletPlugin => 247,
            ServoBrickFunction::GetIdentity => 255,
            ServoBrickFunction::CallbackUnderVoltage => 26,
            ServoBrickFunction::CallbackPositionReached => 27,
            ServoBrickFunction::CallbackVelocityReached => 28,
        }
    }
}
pub const SERVO_BRICK_COMMUNICATION_METHOD_NONE: u8 = 0;
pub const SERVO_BRICK_COMMUNICATION_METHOD_USB: u8 = 1;
pub const SERVO_BRICK_COMMUNICATION_METHOD_SPI_STACK: u8 = 2;
pub const SERVO_BRICK_COMMUNICATION_METHOD_CHIBI: u8 = 3;
pub const SERVO_BRICK_COMMUNICATION_METHOD_RS485: u8 = 4;
pub const SERVO_BRICK_COMMUNICATION_METHOD_WIFI: u8 = 5;
pub const SERVO_BRICK_COMMUNICATION_METHOD_ETHERNET: u8 = 6;
pub const SERVO_BRICK_COMMUNICATION_METHOD_WIFI_V2: u8 = 7;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct PulseWidth {
    pub min: u16,
    pub max: u16,
}
impl FromByteSlice for PulseWidth {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> PulseWidth {
        PulseWidth { min: <u16>::from_le_byte_slice(&bytes[0..2]), max: <u16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Degree {
    pub min: i16,
    pub max: i16,
}
impl FromByteSlice for Degree {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> Degree {
        Degree { min: <i16>::from_le_byte_slice(&bytes[0..2]), max: <i16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct PositionReachedEvent {
    pub servo_num: u8,
    pub position: i16,
}
impl FromByteSlice for PositionReachedEvent {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> PositionReachedEvent {
        PositionReachedEvent { servo_num: <u8>::from_le_byte_slice(&bytes[0..1]), position: <i16>::from_le_byte_slice(&bytes[1..3]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct VelocityReachedEvent {
    pub servo_num: u8,
    pub velocity: i16,
}
impl FromByteSlice for VelocityReachedEvent {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> VelocityReachedEvent {
        VelocityReachedEvent { servo_num: <u8>::from_le_byte_slice(&bytes[0..1]), velocity: <i16>::from_le_byte_slice(&bytes[1..3]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpBaudrateConfig {
    pub enable_dynamic_baudrate: bool,
    pub minimum_dynamic_baudrate: u32,
}
impl FromByteSlice for SpitfpBaudrateConfig {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpBaudrateConfig {
        SpitfpBaudrateConfig {
            enable_dynamic_baudrate: <bool>::from_le_byte_slice(&bytes[0..1]),
            minimum_dynamic_baudrate: <u32>::from_le_byte_slice(&bytes[1..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone)]
pub struct Protocol1BrickletName {
    pub protocol_version: u8,
    pub firmware_version: [u8; 3],
    pub name: String,
}
impl FromByteSlice for Protocol1BrickletName {
    fn bytes_expected() -> usize { 44 }
    fn from_le_byte_slice(bytes: &[u8]) -> Protocol1BrickletName {
        Protocol1BrickletName {
            protocol_version: <u8>::from_le_byte_slice(&bytes[0..1]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[1..4]),
            name: <String>::from_le_byte_slice(&bytes[4..44]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Drives up to 7 RC Servos with up to 3A
#[derive(Clone)]
pub struct ServoBrick {
    device: Device,
}
impl ServoBrick {
    pub const DEVICE_IDENTIFIER: u16 = 14;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Servo Brick";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> ServoBrick {
        let mut result = ServoBrick { device: Device::new([2, 0, 4], uid, req_sender, 0) };
        result.device.response_expected[u8::from(ServoBrickFunction::Enable) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoBrickFunction::Disable) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoBrickFunction::IsEnabled) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::SetPosition) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoBrickFunction::GetPosition) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::GetCurrentPosition) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::SetVelocity) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoBrickFunction::GetVelocity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::GetCurrentVelocity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::SetAcceleration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoBrickFunction::GetAcceleration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::SetOutputVoltage) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoBrickFunction::GetOutputVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::SetPulseWidth) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoBrickFunction::GetPulseWidth) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::SetDegree) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoBrickFunction::GetDegree) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::SetPeriod) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoBrickFunction::GetPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::GetServoCurrent) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::GetOverallCurrent) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::GetStackInputVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::GetExternalInputVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::SetMinimumVoltage) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ServoBrickFunction::GetMinimumVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::EnablePositionReachedCallback) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ServoBrickFunction::DisablePositionReachedCallback) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ServoBrickFunction::IsPositionReachedCallbackEnabled) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::EnableVelocityReachedCallback) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ServoBrickFunction::DisableVelocityReachedCallback) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ServoBrickFunction::IsVelocityReachedCallbackEnabled) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::SetSpitfpBaudrateConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoBrickFunction::GetSpitfpBaudrateConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::GetSendTimeoutCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::SetSpitfpBaudrate) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoBrickFunction::GetSpitfpBaudrate) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::EnableStatusLed) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoBrickFunction::DisableStatusLed) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoBrickFunction::IsStatusLedEnabled) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::GetProtocol1BrickletName) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoBrickFunction::WriteBrickletPlugin) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ServoBrickFunction::ReadBrickletPlugin) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ServoBrickFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::servo_brick::ServoBrick::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::servo_brick::ServoBrick::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: ServoBrickFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: ServoBrickFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered when the input voltage drops below the value set by
    /// [`set_minimum_voltage`]. The parameter is the current voltage.
    ///
    /// [`set_minimum_voltage`]: #method.set_minimum_voltage
    pub fn get_under_voltage_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(ServoBrickFunction::CallbackUnderVoltage))
    }

    /// This receiver is triggered when a position set by [`set_position`]
    /// is reached. If the new position matches the current position then the
    /// receiver is not triggered, because the servo didn't move.
    /// The parameters are the servo and the position that is reached.
    ///
    /// You can enable this receiver with [`enable_position_reached_callback`].
    ///
    /// # Note
    ///  Since we can't get any feedback from the servo, this only works if the
    ///  velocity (see [`set_velocity`]) is set smaller or equal to the
    ///  maximum velocity of the servo. Otherwise the servo will lag behind the
    ///  control value and the receiver will be triggered too early.
    pub fn get_position_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<PositionReachedEvent> {
        self.device.get_callback_receiver(u8::from(ServoBrickFunction::CallbackPositionReached))
    }

    /// This receiver is triggered when a velocity set by [`set_velocity`]
    /// is reached. The parameters are the servo and the velocity that is reached.
    ///
    /// You can enable this receiver with [`enable_velocity_reached_callback`].
    ///
    /// # Note
    ///  Since we can't get any feedback from the servo, this only works if the
    ///  acceleration (see [`set_acceleration`]) is set smaller or equal to the
    ///  maximum acceleration of the servo. Otherwise the servo will lag behind the
    ///  control value and the receiver will be triggered too early.
    pub fn get_velocity_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<VelocityReachedEvent> {
        self.device.get_callback_receiver(u8::from(ServoBrickFunction::CallbackVelocityReached))
    }

    /// Enables a servo (0 to 6). If a servo is enabled, the configured position,
    /// velocity, acceleration, etc. are applied immediately.
    pub fn enable(&self, servo_num: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(servo_num));

        self.device.set(u8::from(ServoBrickFunction::Enable), payload)
    }

    /// Disables a servo (0 to 6). Disabled servos are not driven at all, i.e. a
    /// disabled servo will not hold its position if a load is applied.
    pub fn disable(&self, servo_num: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(servo_num));

        self.device.set(u8::from(ServoBrickFunction::Disable), payload)
    }

    /// Returns *true* if the specified servo is enabled, *false* otherwise.
    pub fn is_enabled(&self, servo_num: u8) -> ConvertingReceiver<bool> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(servo_num));

        self.device.get(u8::from(ServoBrickFunction::IsEnabled), payload)
    }

    /// Sets the position for the specified servo.
    ///
    /// The default range of the position is -9000 to 9000, but it can be specified
    /// according to your servo with [`set_degree`].
    ///
    /// If you want to control a linear servo or RC brushless motor controller or
    /// similar with the Servo Brick, you can also define lengths or speeds with
    /// [`set_degree`].
    pub fn set_position(&self, servo_num: u8, position: i16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(servo_num));
        payload[1..3].copy_from_slice(&<i16>::to_le_byte_vec(position));

        self.device.set(u8::from(ServoBrickFunction::SetPosition), payload)
    }

    /// Returns the position of the specified servo as set by [`set_position`].
    pub fn get_position(&self, servo_num: u8) -> ConvertingReceiver<i16> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(servo_num));

        self.device.get(u8::from(ServoBrickFunction::GetPosition), payload)
    }

    /// Returns the *current* position of the specified servo. This may not be the
    /// value of [`set_position`] if the servo is currently approaching a
    /// position goal.
    pub fn get_current_position(&self, servo_num: u8) -> ConvertingReceiver<i16> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(servo_num));

        self.device.get(u8::from(ServoBrickFunction::GetCurrentPosition), payload)
    }

    /// Sets the maximum velocity of the specified servo. The velocity
    /// is accelerated according to the value set by [`set_acceleration`].
    ///
    /// The minimum velocity is 0 (no movement) and the maximum velocity is 65535.
    /// With a value of 65535 the position will be set immediately (no velocity).
    pub fn set_velocity(&self, servo_num: u8, velocity: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(servo_num));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(velocity));

        self.device.set(u8::from(ServoBrickFunction::SetVelocity), payload)
    }

    /// Returns the velocity of the specified servo as set by [`set_velocity`].
    pub fn get_velocity(&self, servo_num: u8) -> ConvertingReceiver<u16> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(servo_num));

        self.device.get(u8::from(ServoBrickFunction::GetVelocity), payload)
    }

    /// Returns the *current* velocity of the specified servo. This may not be the
    /// value of [`set_velocity`] if the servo is currently approaching a
    /// velocity goal.
    pub fn get_current_velocity(&self, servo_num: u8) -> ConvertingReceiver<u16> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(servo_num));

        self.device.get(u8::from(ServoBrickFunction::GetCurrentVelocity), payload)
    }

    /// Sets the acceleration of the specified servo.
    ///
    /// The minimum acceleration is 1 and the maximum acceleration is 65535.
    /// With a value of 65535 the velocity will be set immediately (no acceleration).
    pub fn set_acceleration(&self, servo_num: u8, acceleration: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(servo_num));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(acceleration));

        self.device.set(u8::from(ServoBrickFunction::SetAcceleration), payload)
    }

    /// Returns the acceleration for the specified servo as set by
    /// [`set_acceleration`].
    pub fn get_acceleration(&self, servo_num: u8) -> ConvertingReceiver<u16> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(servo_num));

        self.device.get(u8::from(ServoBrickFunction::GetAcceleration), payload)
    }

    /// Sets the output voltages with which the servos are driven.
    ///
    /// # Note
    ///  We recommend that you set this value to the maximum voltage that is
    ///  specified for your servo, most servos achieve their maximum force only
    ///  with high voltages.
    pub fn set_output_voltage(&self, voltage: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(voltage));

        self.device.set(u8::from(ServoBrickFunction::SetOutputVoltage), payload)
    }

    /// Returns the output voltage as specified by [`set_output_voltage`].
    pub fn get_output_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoBrickFunction::GetOutputVoltage), payload)
    }

    /// Sets the minimum and maximum pulse width of the specified servo.
    ///
    /// Usually, servos are controlled with a
    /// [PWM](https://en.wikipedia.org/wiki/Pulse-width_modulation)__, whereby the
    /// length of the pulse controls the position of the servo. Every servo has
    /// different minimum and maximum pulse widths, these can be specified with
    /// this function.
    ///
    /// If you have a datasheet for your servo that specifies the minimum and
    /// maximum pulse width, you should set the values accordingly. If your servo
    /// comes without any datasheet you have to find the values via trial and error.
    ///
    /// The minimum must be smaller than the maximum.
    pub fn set_pulse_width(&self, servo_num: u8, min: u16, max: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(servo_num));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(max));

        self.device.set(u8::from(ServoBrickFunction::SetPulseWidth), payload)
    }

    /// Returns the minimum and maximum pulse width for the specified servo as set by
    /// [`set_pulse_width`].
    pub fn get_pulse_width(&self, servo_num: u8) -> ConvertingReceiver<PulseWidth> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(servo_num));

        self.device.get(u8::from(ServoBrickFunction::GetPulseWidth), payload)
    }

    /// Sets the minimum and maximum degree for the specified servo (by default
    /// given as °/100).
    ///
    /// This only specifies the abstract values between which the minimum and maximum
    /// pulse width is scaled. For example: If you specify a pulse width of 1000µs
    /// to 2000µs and a degree range of -90° to 90°, a call of [`set_position`]
    /// with 0 will result in a pulse width of 1500µs
    /// (-90° = 1000µs, 90° = 2000µs, etc.).
    ///
    /// Possible usage:
    ///
    /// * The datasheet of your servo specifies a range of 200° with the middle position
    ///   at 110°. In this case you can set the minimum to -9000 and the maximum to 11000.
    /// * You measure a range of 220° on your servo and you don't have or need a middle
    ///   position. In this case you can set the minimum to 0 and the maximum to 22000.
    /// * You have a linear servo with a drive length of 20cm, In this case you could
    ///   set the minimum to 0 and the maximum to 20000. Now you can set the Position
    ///   with [`set_position`] with a resolution of cm/100. Also the velocity will
    ///   have a resolution of cm/100s and the acceleration will have a resolution of
    ///   cm/100s².
    /// * You don't care about units and just want the highest possible resolution. In
    ///   this case you should set the minimum to -32767 and the maximum to 32767.
    /// * You have a brushless motor with a maximum speed of 10000 rpm and want to
    ///   control it with a RC brushless motor controller. In this case you can set the
    ///   minimum to 0 and the maximum to 10000. [`set_position`] now controls the rpm.
    ///
    /// The minimum must be smaller than the maximum.
    pub fn set_degree(&self, servo_num: u8, min: i16, max: i16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(servo_num));
        payload[1..3].copy_from_slice(&<i16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<i16>::to_le_byte_vec(max));

        self.device.set(u8::from(ServoBrickFunction::SetDegree), payload)
    }

    /// Returns the minimum and maximum degree for the specified servo as set by
    /// [`set_degree`].
    pub fn get_degree(&self, servo_num: u8) -> ConvertingReceiver<Degree> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(servo_num));

        self.device.get(u8::from(ServoBrickFunction::GetDegree), payload)
    }

    /// Sets the period of the specified servo.
    ///
    /// Usually, servos are controlled with a
    /// [PWM](https://en.wikipedia.org/wiki/Pulse-width_modulation)__. Different
    /// servos expect PWMs with different periods. Most servos run well with a
    /// period of about 20ms.
    ///
    /// If your servo comes with a datasheet that specifies a period, you should
    /// set it accordingly. If you don't have a datasheet and you have no idea
    /// what the correct period is, the default value will most likely
    /// work fine.
    pub fn set_period(&self, servo_num: u8, period: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(servo_num));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(period));

        self.device.set(u8::from(ServoBrickFunction::SetPeriod), payload)
    }

    /// Returns the period for the specified servo as set by [`set_period`].
    pub fn get_period(&self, servo_num: u8) -> ConvertingReceiver<u16> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(servo_num));

        self.device.get(u8::from(ServoBrickFunction::GetPeriod), payload)
    }

    /// Returns the current consumption of the specified servo.
    pub fn get_servo_current(&self, servo_num: u8) -> ConvertingReceiver<u16> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(servo_num));

        self.device.get(u8::from(ServoBrickFunction::GetServoCurrent), payload)
    }

    /// Returns the current consumption of all servos together.
    pub fn get_overall_current(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoBrickFunction::GetOverallCurrent), payload)
    }

    /// Returns the stack input voltage. The stack input voltage is the
    /// voltage that is supplied via the stack, i.e. it is given by a
    /// Step-Down or Step-Up Power Supply.
    pub fn get_stack_input_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoBrickFunction::GetStackInputVoltage), payload)
    }

    /// Returns the external input voltage. The external input voltage is
    /// given via the black power input connector on the Servo Brick.
    ///
    /// If there is an external input voltage and a stack input voltage, the motors
    /// will be driven by the external input voltage. If there is only a stack
    /// voltage present, the motors will be driven by this voltage.
    ///
    /// # Warning
    ///  This means, if you have a high stack voltage and a low external voltage,
    ///  the motors will be driven with the low external voltage. If you then remove
    ///  the external connection, it will immediately be driven by the high
    ///  stack voltage
    pub fn get_external_input_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoBrickFunction::GetExternalInputVoltage), payload)
    }

    /// Sets the minimum voltage, below which the [`get_under_voltage_callback_receiver`] receiver
    /// is triggered. The minimum possible value that works with the Servo Brick is 5V.
    /// You can use this function to detect the discharge of a battery that is used
    /// to drive the stepper motor. If you have a fixed power supply, you likely do
    /// not need this functionality.
    pub fn set_minimum_voltage(&self, voltage: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(voltage));

        self.device.set(u8::from(ServoBrickFunction::SetMinimumVoltage), payload)
    }

    /// Returns the minimum voltage as set by [`set_minimum_voltage`]
    pub fn get_minimum_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoBrickFunction::GetMinimumVoltage), payload)
    }

    /// Enables the [`get_position_reached_callback_receiver`] receiver.
    ///
    /// Default is disabled.
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Firmware)
    pub fn enable_position_reached_callback(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ServoBrickFunction::EnablePositionReachedCallback), payload)
    }

    /// Disables the [`get_position_reached_callback_receiver`] receiver.
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Firmware)
    pub fn disable_position_reached_callback(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ServoBrickFunction::DisablePositionReachedCallback), payload)
    }

    /// Returns *true* if [`get_position_reached_callback_receiver`] receiver is enabled, *false* otherwise.
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Firmware)
    pub fn is_position_reached_callback_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoBrickFunction::IsPositionReachedCallbackEnabled), payload)
    }

    /// Enables the [`get_velocity_reached_callback_receiver`] receiver.
    ///
    /// Default is disabled.
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Firmware)
    pub fn enable_velocity_reached_callback(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ServoBrickFunction::EnableVelocityReachedCallback), payload)
    }

    /// Disables the [`get_velocity_reached_callback_receiver`] receiver.
    ///
    /// Default is disabled.
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Firmware)
    pub fn disable_velocity_reached_callback(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ServoBrickFunction::DisableVelocityReachedCallback), payload)
    }

    /// Returns *true* if [`get_velocity_reached_callback_receiver`] receiver is enabled, *false* otherwise.
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Firmware)
    pub fn is_velocity_reached_callback_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoBrickFunction::IsVelocityReachedCallbackEnabled), payload)
    }

    /// The SPITF protocol can be used with a dynamic baudrate. If the dynamic baudrate is
    /// enabled, the Brick will try to adapt the baudrate for the communication
    /// between Bricks and Bricklets according to the amount of data that is transferred.
    ///
    /// The baudrate will be increased exponentially if lots of data is sent/received and
    /// decreased linearly if little data is sent/received.
    ///
    /// This lowers the baudrate in applications where little data is transferred (e.g.
    /// a weather station) and increases the robustness. If there is lots of data to transfer
    /// (e.g. Thermal Imaging Bricklet) it automatically increases the baudrate as needed.
    ///
    /// In cases where some data has to transferred as fast as possible every few seconds
    /// (e.g. RS485 Bricklet with a high baudrate but small payload) you may want to turn
    /// the dynamic baudrate off to get the highest possible performance.
    ///
    /// The maximum value of the baudrate can be set per port with the function
    /// [`set_spitfp_baudrate`]. If the dynamic baudrate is disabled, the baudrate
    /// as set by [`set_spitfp_baudrate`] will be used statically.
    ///
    ///
    /// .. versionadded:: 2.3.4$nbsp;(Firmware)
    pub fn set_spitfp_baudrate_config(&self, enable_dynamic_baudrate: bool, minimum_dynamic_baudrate: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enable_dynamic_baudrate));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(minimum_dynamic_baudrate));

        self.device.set(u8::from(ServoBrickFunction::SetSpitfpBaudrateConfig), payload)
    }

    /// Returns the baudrate config, see [`set_spitfp_baudrate_config`].
    ///
    ///
    /// .. versionadded:: 2.3.4$nbsp;(Firmware)
    pub fn get_spitfp_baudrate_config(&self) -> ConvertingReceiver<SpitfpBaudrateConfig> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoBrickFunction::GetSpitfpBaudrateConfig), payload)
    }

    /// Returns the timeout count for the different communication methods.
    ///
    /// The methods 0-2 are available for all Bricks, 3-7 only for Master Bricks.
    ///
    /// This function is mostly used for debugging during development, in normal operation
    /// the counters should nearly always stay at 0.
    ///
    ///
    /// .. versionadded:: 2.3.2$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * SERVO_BRICK_COMMUNICATION_METHOD_NONE
    ///	* SERVO_BRICK_COMMUNICATION_METHOD_USB
    ///	* SERVO_BRICK_COMMUNICATION_METHOD_SPI_STACK
    ///	* SERVO_BRICK_COMMUNICATION_METHOD_CHIBI
    ///	* SERVO_BRICK_COMMUNICATION_METHOD_RS485
    ///	* SERVO_BRICK_COMMUNICATION_METHOD_WIFI
    ///	* SERVO_BRICK_COMMUNICATION_METHOD_ETHERNET
    ///	* SERVO_BRICK_COMMUNICATION_METHOD_WIFI_V2
    pub fn get_send_timeout_count(&self, communication_method: u8) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(communication_method));

        self.device.get(u8::from(ServoBrickFunction::GetSendTimeoutCount), payload)
    }

    /// Sets the baudrate for a specific Bricklet port.
    ///
    /// If you want to increase the throughput of Bricklets you can increase
    /// the baudrate. If you get a high error count because of high
    /// interference (see [`get_spitfp_error_count`]) you can decrease the
    /// baudrate.
    ///
    /// If the dynamic baudrate feature is enabled, the baudrate set by this
    /// function corresponds to the maximum baudrate (see [`set_spitfp_baudrate_config`]).
    ///
    /// Regulatory testing is done with the default baudrate. If CE compatibility
    /// or similar is necessary in your applications we recommend to not change
    /// the baudrate.
    ///
    ///
    /// .. versionadded:: 2.3.2$nbsp;(Firmware)
    pub fn set_spitfp_baudrate(&self, bricklet_port: char, baudrate: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(baudrate));

        self.device.set(u8::from(ServoBrickFunction::SetSpitfpBaudrate), payload)
    }

    /// Returns the baudrate for a given Bricklet port, see [`set_spitfp_baudrate`].
    ///
    ///
    /// .. versionadded:: 2.3.2$nbsp;(Firmware)
    pub fn get_spitfp_baudrate(&self, bricklet_port: char) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));

        self.device.get(u8::from(ServoBrickFunction::GetSpitfpBaudrate), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Brick side. All
    /// Bricklets have a similar function that returns the errors on the Bricklet side.
    ///
    ///
    /// .. versionadded:: 2.3.2$nbsp;(Firmware)
    pub fn get_spitfp_error_count(&self, bricklet_port: char) -> ConvertingReceiver<SpitfpErrorCount> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));

        self.device.get(u8::from(ServoBrickFunction::GetSpitfpErrorCount), payload)
    }

    /// Enables the status LED.
    ///
    /// The status LED is the blue LED next to the USB connector. If enabled is is
    /// on and it flickers if data is transfered. If disabled it is always off.
    ///
    /// The default state is enabled.
    ///
    ///
    /// .. versionadded:: 2.3.1$nbsp;(Firmware)
    pub fn enable_status_led(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ServoBrickFunction::EnableStatusLed), payload)
    }

    /// Disables the status LED.
    ///
    /// The status LED is the blue LED next to the USB connector. If enabled is is
    /// on and it flickers if data is transfered. If disabled it is always off.
    ///
    /// The default state is enabled.
    ///
    ///
    /// .. versionadded:: 2.3.1$nbsp;(Firmware)
    pub fn disable_status_led(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ServoBrickFunction::DisableStatusLed), payload)
    }

    /// Returns *true* if the status LED is enabled, *false* otherwise.
    ///
    ///
    /// .. versionadded:: 2.3.1$nbsp;(Firmware)
    pub fn is_status_led_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoBrickFunction::IsStatusLedEnabled), payload)
    }

    /// Returns the firmware and protocol version and the name of the Bricklet for a
    /// given port.
    ///
    /// This functions sole purpose is to allow automatic flashing of v1.x.y Bricklet
    /// plugins.
    pub fn get_protocol1_bricklet_name(&self, port: char) -> ConvertingReceiver<Protocol1BrickletName> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));

        self.device.get(u8::from(ServoBrickFunction::GetProtocol1BrickletName), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has an
    /// accuracy of ±15%. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoBrickFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Brick. Calling this function
    /// on a Brick inside of a stack will reset the whole stack.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ServoBrickFunction::Reset), payload)
    }

    /// Writes 32 bytes of firmware to the bricklet attached at the given port.
    /// The bytes are written to the position offset * 32.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_bricklet_plugin(&self, port: char, offset: u8, chunk: [u8; 32]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 34];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(offset));
        payload[2..34].copy_from_slice(&<[u8; 32]>::to_le_byte_vec(chunk));

        self.device.set(u8::from(ServoBrickFunction::WriteBrickletPlugin), payload)
    }

    /// Reads 32 bytes of firmware from the bricklet attached at the given port.
    /// The bytes are read starting at the position offset * 32.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn read_bricklet_plugin(&self, port: char, offset: u8) -> ConvertingReceiver<[u8; 32]> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(offset));

        self.device.get(u8::from(ServoBrickFunction::ReadBrickletPlugin), payload)
    }

    /// Returns the UID, the UID where the Brick is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position is the position in the stack from '0' (bottom) to '8' (top).
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ServoBrickFunction::GetIdentity), payload)
    }
}
