/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Four 7-segment displays with switchable colon.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/SegmentDisplay4x7_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum SegmentDisplay4x7BrickletFunction {
    SetSegments,
    GetSegments,
    StartCounter,
    GetCounterValue,
    GetIdentity,
    CallbackCounterFinished,
}
impl From<SegmentDisplay4x7BrickletFunction> for u8 {
    fn from(fun: SegmentDisplay4x7BrickletFunction) -> Self {
        match fun {
            SegmentDisplay4x7BrickletFunction::SetSegments => 1,
            SegmentDisplay4x7BrickletFunction::GetSegments => 2,
            SegmentDisplay4x7BrickletFunction::StartCounter => 3,
            SegmentDisplay4x7BrickletFunction::GetCounterValue => 4,
            SegmentDisplay4x7BrickletFunction::GetIdentity => 255,
            SegmentDisplay4x7BrickletFunction::CallbackCounterFinished => 5,
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Segments {
    pub segments: [u8; 4],
    pub brightness: u8,
    pub colon: bool,
}
impl FromByteSlice for Segments {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> Segments {
        Segments {
            segments: <[u8; 4]>::from_le_byte_slice(&bytes[0..4]),
            brightness: <u8>::from_le_byte_slice(&bytes[4..5]),
            colon: <bool>::from_le_byte_slice(&bytes[5..6]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Four 7-segment displays with switchable colon
#[derive(Clone)]
pub struct SegmentDisplay4x7Bricklet {
    device: Device,
}
impl SegmentDisplay4x7Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 237;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Segment Display 4x7 Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> SegmentDisplay4x7Bricklet {
        let mut result = SegmentDisplay4x7Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(SegmentDisplay4x7BrickletFunction::SetSegments) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SegmentDisplay4x7BrickletFunction::GetSegments) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SegmentDisplay4x7BrickletFunction::StartCounter) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SegmentDisplay4x7BrickletFunction::GetCounterValue) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SegmentDisplay4x7BrickletFunction::GetIdentity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::segment_display_4x7_bricklet::SegmentDisplay4x7Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::segment_display_4x7_bricklet::SegmentDisplay4x7Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: SegmentDisplay4x7BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: SegmentDisplay4x7BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered when the counter (see [`start_counter`]) is
    /// finished.
    ///
    /// [`start_counter`]: #method.start_counter
    pub fn get_counter_finished_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(SegmentDisplay4x7BrickletFunction::CallbackCounterFinished))
    }

    /// The 7-segment display can be set with bitmaps. Every bit controls one
    /// segment:
    ///
    /// .. image:: /Images/Bricklets/bricklet_segment_display_4x7_bit_order.png
    ///    :scale: 100 %
    ///    :alt: Bit order of one segment
    ///    :align: center
    ///
    /// For example to set a 5 you would want to activate segments 0, 2, 3, 5 and 6.
    /// This is represented by the number 0b01101101 = 0x6d = 109.
    ///
    /// The brightness can be set between 0 (dark) and 7 (bright). The colon
    /// parameter turns the colon of the display on or off.
    pub fn set_segments(&self, segments: [u8; 4], brightness: u8, colon: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..4].copy_from_slice(&<[u8; 4]>::to_le_byte_vec(segments));
        payload[4..5].copy_from_slice(&<u8>::to_le_byte_vec(brightness));
        payload[5..6].copy_from_slice(&<bool>::to_le_byte_vec(colon));

        self.device.set(u8::from(SegmentDisplay4x7BrickletFunction::SetSegments), payload)
    }

    /// Returns the segment, brightness and color data as set by
    /// [`set_segments`].
    pub fn get_segments(&self) -> ConvertingReceiver<Segments> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SegmentDisplay4x7BrickletFunction::GetSegments), payload)
    }

    /// Starts a counter with the *from* value that counts to the *to*
    /// value with the each step incremented by *increment*.
    /// *length* is the pause between each increment.
    ///
    /// Example: If you set *from* to 0, *to* to 100, *increment* to 1 and
    /// *length* to 1000, a counter that goes from 0 to 100 with one second
    /// pause between each increment will be started.
    ///
    /// Using a negative increment allows to count backwards.
    ///
    /// You can stop the counter at every time by calling [`set_segments`].
    pub fn start_counter(&self, value_from: i16, value_to: i16, increment: i16, length: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 10];
        payload[0..2].copy_from_slice(&<i16>::to_le_byte_vec(value_from));
        payload[2..4].copy_from_slice(&<i16>::to_le_byte_vec(value_to));
        payload[4..6].copy_from_slice(&<i16>::to_le_byte_vec(increment));
        payload[6..10].copy_from_slice(&<u32>::to_le_byte_vec(length));

        self.device.set(u8::from(SegmentDisplay4x7BrickletFunction::StartCounter), payload)
    }

    /// Returns the counter value that is currently shown on the display.
    ///
    /// If there is no counter running a 0 will be returned.
    pub fn get_counter_value(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SegmentDisplay4x7BrickletFunction::GetCounterValue), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SegmentDisplay4x7BrickletFunction::GetIdentity), payload)
    }
}
