/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Communicates with RS485/Modbus devices with full- or half-duplex.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/RS485_Bricklet_Rust.html).
use crate::{
    byte_converter::*,
    converting_callback_receiver::ConvertingCallbackReceiver,
    converting_high_level_callback_receiver::ConvertingHighLevelCallbackReceiver,
    converting_receiver::{BrickletRecvTimeoutError, ConvertingReceiver},
    device::*,
    ip_connection::GetRequestSender,
    low_level_traits::*,
};
pub enum Rs485BrickletFunction {
    WriteLowLevel,
    ReadLowLevel,
    EnableReadCallback,
    DisableReadCallback,
    IsReadCallbackEnabled,
    SetRs485Configuration,
    GetRs485Configuration,
    SetModbusConfiguration,
    GetModbusConfiguration,
    SetMode,
    GetMode,
    SetCommunicationLedConfig,
    GetCommunicationLedConfig,
    SetErrorLedConfig,
    GetErrorLedConfig,
    SetBufferConfig,
    GetBufferConfig,
    GetBufferStatus,
    EnableErrorCountCallback,
    DisableErrorCountCallback,
    IsErrorCountCallbackEnabled,
    GetErrorCount,
    GetModbusCommonErrorCount,
    ModbusSlaveReportException,
    ModbusSlaveAnswerReadCoilsRequestLowLevel,
    ModbusMasterReadCoils,
    ModbusSlaveAnswerReadHoldingRegistersRequestLowLevel,
    ModbusMasterReadHoldingRegisters,
    ModbusSlaveAnswerWriteSingleCoilRequest,
    ModbusMasterWriteSingleCoil,
    ModbusSlaveAnswerWriteSingleRegisterRequest,
    ModbusMasterWriteSingleRegister,
    ModbusSlaveAnswerWriteMultipleCoilsRequest,
    ModbusMasterWriteMultipleCoilsLowLevel,
    ModbusSlaveAnswerWriteMultipleRegistersRequest,
    ModbusMasterWriteMultipleRegistersLowLevel,
    ModbusSlaveAnswerReadDiscreteInputsRequestLowLevel,
    ModbusMasterReadDiscreteInputs,
    ModbusSlaveAnswerReadInputRegistersRequestLowLevel,
    ModbusMasterReadInputRegisters,
    SetFrameReadableCallbackConfiguration,
    GetFrameReadableCallbackConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackReadLowLevel,
    CallbackErrorCount,
    CallbackModbusSlaveReadCoilsRequest,
    CallbackModbusMasterReadCoilsResponseLowLevel,
    CallbackModbusSlaveReadHoldingRegistersRequest,
    CallbackModbusMasterReadHoldingRegistersResponseLowLevel,
    CallbackModbusSlaveWriteSingleCoilRequest,
    CallbackModbusMasterWriteSingleCoilResponse,
    CallbackModbusSlaveWriteSingleRegisterRequest,
    CallbackModbusMasterWriteSingleRegisterResponse,
    CallbackModbusSlaveWriteMultipleCoilsRequestLowLevel,
    CallbackModbusMasterWriteMultipleCoilsResponse,
    CallbackModbusSlaveWriteMultipleRegistersRequestLowLevel,
    CallbackModbusMasterWriteMultipleRegistersResponse,
    CallbackModbusSlaveReadDiscreteInputsRequest,
    CallbackModbusMasterReadDiscreteInputsResponseLowLevel,
    CallbackModbusSlaveReadInputRegistersRequest,
    CallbackModbusMasterReadInputRegistersResponseLowLevel,
    CallbackFrameReadable,
}
impl From<Rs485BrickletFunction> for u8 {
    fn from(fun: Rs485BrickletFunction) -> Self {
        match fun {
            Rs485BrickletFunction::WriteLowLevel => 1,
            Rs485BrickletFunction::ReadLowLevel => 2,
            Rs485BrickletFunction::EnableReadCallback => 3,
            Rs485BrickletFunction::DisableReadCallback => 4,
            Rs485BrickletFunction::IsReadCallbackEnabled => 5,
            Rs485BrickletFunction::SetRs485Configuration => 6,
            Rs485BrickletFunction::GetRs485Configuration => 7,
            Rs485BrickletFunction::SetModbusConfiguration => 8,
            Rs485BrickletFunction::GetModbusConfiguration => 9,
            Rs485BrickletFunction::SetMode => 10,
            Rs485BrickletFunction::GetMode => 11,
            Rs485BrickletFunction::SetCommunicationLedConfig => 12,
            Rs485BrickletFunction::GetCommunicationLedConfig => 13,
            Rs485BrickletFunction::SetErrorLedConfig => 14,
            Rs485BrickletFunction::GetErrorLedConfig => 15,
            Rs485BrickletFunction::SetBufferConfig => 16,
            Rs485BrickletFunction::GetBufferConfig => 17,
            Rs485BrickletFunction::GetBufferStatus => 18,
            Rs485BrickletFunction::EnableErrorCountCallback => 19,
            Rs485BrickletFunction::DisableErrorCountCallback => 20,
            Rs485BrickletFunction::IsErrorCountCallbackEnabled => 21,
            Rs485BrickletFunction::GetErrorCount => 22,
            Rs485BrickletFunction::GetModbusCommonErrorCount => 23,
            Rs485BrickletFunction::ModbusSlaveReportException => 24,
            Rs485BrickletFunction::ModbusSlaveAnswerReadCoilsRequestLowLevel => 25,
            Rs485BrickletFunction::ModbusMasterReadCoils => 26,
            Rs485BrickletFunction::ModbusSlaveAnswerReadHoldingRegistersRequestLowLevel => 27,
            Rs485BrickletFunction::ModbusMasterReadHoldingRegisters => 28,
            Rs485BrickletFunction::ModbusSlaveAnswerWriteSingleCoilRequest => 29,
            Rs485BrickletFunction::ModbusMasterWriteSingleCoil => 30,
            Rs485BrickletFunction::ModbusSlaveAnswerWriteSingleRegisterRequest => 31,
            Rs485BrickletFunction::ModbusMasterWriteSingleRegister => 32,
            Rs485BrickletFunction::ModbusSlaveAnswerWriteMultipleCoilsRequest => 33,
            Rs485BrickletFunction::ModbusMasterWriteMultipleCoilsLowLevel => 34,
            Rs485BrickletFunction::ModbusSlaveAnswerWriteMultipleRegistersRequest => 35,
            Rs485BrickletFunction::ModbusMasterWriteMultipleRegistersLowLevel => 36,
            Rs485BrickletFunction::ModbusSlaveAnswerReadDiscreteInputsRequestLowLevel => 37,
            Rs485BrickletFunction::ModbusMasterReadDiscreteInputs => 38,
            Rs485BrickletFunction::ModbusSlaveAnswerReadInputRegistersRequestLowLevel => 39,
            Rs485BrickletFunction::ModbusMasterReadInputRegisters => 40,
            Rs485BrickletFunction::SetFrameReadableCallbackConfiguration => 59,
            Rs485BrickletFunction::GetFrameReadableCallbackConfiguration => 60,
            Rs485BrickletFunction::GetSpitfpErrorCount => 234,
            Rs485BrickletFunction::SetBootloaderMode => 235,
            Rs485BrickletFunction::GetBootloaderMode => 236,
            Rs485BrickletFunction::SetWriteFirmwarePointer => 237,
            Rs485BrickletFunction::WriteFirmware => 238,
            Rs485BrickletFunction::SetStatusLedConfig => 239,
            Rs485BrickletFunction::GetStatusLedConfig => 240,
            Rs485BrickletFunction::GetChipTemperature => 242,
            Rs485BrickletFunction::Reset => 243,
            Rs485BrickletFunction::WriteUid => 248,
            Rs485BrickletFunction::ReadUid => 249,
            Rs485BrickletFunction::GetIdentity => 255,
            Rs485BrickletFunction::CallbackReadLowLevel => 41,
            Rs485BrickletFunction::CallbackErrorCount => 42,
            Rs485BrickletFunction::CallbackModbusSlaveReadCoilsRequest => 43,
            Rs485BrickletFunction::CallbackModbusMasterReadCoilsResponseLowLevel => 44,
            Rs485BrickletFunction::CallbackModbusSlaveReadHoldingRegistersRequest => 45,
            Rs485BrickletFunction::CallbackModbusMasterReadHoldingRegistersResponseLowLevel => 46,
            Rs485BrickletFunction::CallbackModbusSlaveWriteSingleCoilRequest => 47,
            Rs485BrickletFunction::CallbackModbusMasterWriteSingleCoilResponse => 48,
            Rs485BrickletFunction::CallbackModbusSlaveWriteSingleRegisterRequest => 49,
            Rs485BrickletFunction::CallbackModbusMasterWriteSingleRegisterResponse => 50,
            Rs485BrickletFunction::CallbackModbusSlaveWriteMultipleCoilsRequestLowLevel => 51,
            Rs485BrickletFunction::CallbackModbusMasterWriteMultipleCoilsResponse => 52,
            Rs485BrickletFunction::CallbackModbusSlaveWriteMultipleRegistersRequestLowLevel => 53,
            Rs485BrickletFunction::CallbackModbusMasterWriteMultipleRegistersResponse => 54,
            Rs485BrickletFunction::CallbackModbusSlaveReadDiscreteInputsRequest => 55,
            Rs485BrickletFunction::CallbackModbusMasterReadDiscreteInputsResponseLowLevel => 56,
            Rs485BrickletFunction::CallbackModbusSlaveReadInputRegistersRequest => 57,
            Rs485BrickletFunction::CallbackModbusMasterReadInputRegistersResponseLowLevel => 58,
            Rs485BrickletFunction::CallbackFrameReadable => 61,
        }
    }
}
pub const RS485_BRICKLET_PARITY_NONE: u8 = 0;
pub const RS485_BRICKLET_PARITY_ODD: u8 = 1;
pub const RS485_BRICKLET_PARITY_EVEN: u8 = 2;
pub const RS485_BRICKLET_STOPBITS_1: u8 = 1;
pub const RS485_BRICKLET_STOPBITS_2: u8 = 2;
pub const RS485_BRICKLET_WORDLENGTH_5: u8 = 5;
pub const RS485_BRICKLET_WORDLENGTH_6: u8 = 6;
pub const RS485_BRICKLET_WORDLENGTH_7: u8 = 7;
pub const RS485_BRICKLET_WORDLENGTH_8: u8 = 8;
pub const RS485_BRICKLET_DUPLEX_HALF: u8 = 0;
pub const RS485_BRICKLET_DUPLEX_FULL: u8 = 1;
pub const RS485_BRICKLET_MODE_RS485: u8 = 0;
pub const RS485_BRICKLET_MODE_MODBUS_MASTER_RTU: u8 = 1;
pub const RS485_BRICKLET_MODE_MODBUS_SLAVE_RTU: u8 = 2;
pub const RS485_BRICKLET_COMMUNICATION_LED_CONFIG_OFF: u8 = 0;
pub const RS485_BRICKLET_COMMUNICATION_LED_CONFIG_ON: u8 = 1;
pub const RS485_BRICKLET_COMMUNICATION_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const RS485_BRICKLET_COMMUNICATION_LED_CONFIG_SHOW_COMMUNICATION: u8 = 3;
pub const RS485_BRICKLET_ERROR_LED_CONFIG_OFF: u8 = 0;
pub const RS485_BRICKLET_ERROR_LED_CONFIG_ON: u8 = 1;
pub const RS485_BRICKLET_ERROR_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const RS485_BRICKLET_ERROR_LED_CONFIG_SHOW_ERROR: u8 = 3;
pub const RS485_BRICKLET_EXCEPTION_CODE_TIMEOUT: i8 = -1;
pub const RS485_BRICKLET_EXCEPTION_CODE_SUCCESS: i8 = 0;
pub const RS485_BRICKLET_EXCEPTION_CODE_ILLEGAL_FUNCTION: i8 = 1;
pub const RS485_BRICKLET_EXCEPTION_CODE_ILLEGAL_DATA_ADDRESS: i8 = 2;
pub const RS485_BRICKLET_EXCEPTION_CODE_ILLEGAL_DATA_VALUE: i8 = 3;
pub const RS485_BRICKLET_EXCEPTION_CODE_SLAVE_DEVICE_FAILURE: i8 = 4;
pub const RS485_BRICKLET_EXCEPTION_CODE_ACKNOWLEDGE: i8 = 5;
pub const RS485_BRICKLET_EXCEPTION_CODE_SLAVE_DEVICE_BUSY: i8 = 6;
pub const RS485_BRICKLET_EXCEPTION_CODE_MEMORY_PARITY_ERROR: i8 = 8;
pub const RS485_BRICKLET_EXCEPTION_CODE_GATEWAY_PATH_UNAVAILABLE: i8 = 10;
pub const RS485_BRICKLET_EXCEPTION_CODE_GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND: i8 = 11;
pub const RS485_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const RS485_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const RS485_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const RS485_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const RS485_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const RS485_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const RS485_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const RS485_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const RS485_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const RS485_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const RS485_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const RS485_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const RS485_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const RS485_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const RS485_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WriteLowLevel {
    pub message_chunk_written: u8,
}
impl FromByteSlice for WriteLowLevel {
    fn bytes_expected() -> usize { 1 }
    fn from_le_byte_slice(bytes: &[u8]) -> WriteLowLevel { WriteLowLevel { message_chunk_written: <u8>::from_le_byte_slice(&bytes[0..1]) } }
}
impl LowLevelWrite<WriteResult> for WriteLowLevel {
    fn ll_message_written(&self) -> usize { self.message_chunk_written as usize }

    fn get_result(&self) -> WriteResult { WriteResult {} }
}

#[derive(Clone, Copy)]
pub struct ReadLowLevel {
    pub message_length: u16,
    pub message_chunk_offset: u16,
    pub message_chunk_data: [char; 60],
}
impl FromByteSlice for ReadLowLevel {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReadLowLevel {
        ReadLowLevel {
            message_length: <u16>::from_le_byte_slice(&bytes[0..2]),
            message_chunk_offset: <u16>::from_le_byte_slice(&bytes[2..4]),
            message_chunk_data: <[char; 60]>::from_le_byte_slice(&bytes[4..64]),
        }
    }
}
impl LowLevelRead<char, ReadResult> for ReadLowLevel {
    fn ll_message_length(&self) -> usize { self.message_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.message_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[char] { &self.message_chunk_data }

    fn get_result(&self) -> ReadResult { ReadResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Rs485Configuration {
    pub baudrate: u32,
    pub parity: u8,
    pub stopbits: u8,
    pub wordlength: u8,
    pub duplex: u8,
}
impl FromByteSlice for Rs485Configuration {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> Rs485Configuration {
        Rs485Configuration {
            baudrate: <u32>::from_le_byte_slice(&bytes[0..4]),
            parity: <u8>::from_le_byte_slice(&bytes[4..5]),
            stopbits: <u8>::from_le_byte_slice(&bytes[5..6]),
            wordlength: <u8>::from_le_byte_slice(&bytes[6..7]),
            duplex: <u8>::from_le_byte_slice(&bytes[7..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusConfiguration {
    pub slave_address: u8,
    pub master_request_timeout: u32,
}
impl FromByteSlice for ModbusConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusConfiguration {
        ModbusConfiguration {
            slave_address: <u8>::from_le_byte_slice(&bytes[0..1]),
            master_request_timeout: <u32>::from_le_byte_slice(&bytes[1..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct BufferConfig {
    pub send_buffer_size: u16,
    pub receive_buffer_size: u16,
}
impl FromByteSlice for BufferConfig {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> BufferConfig {
        BufferConfig {
            send_buffer_size: <u16>::from_le_byte_slice(&bytes[0..2]),
            receive_buffer_size: <u16>::from_le_byte_slice(&bytes[2..4]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct BufferStatus {
    pub send_buffer_used: u16,
    pub receive_buffer_used: u16,
}
impl FromByteSlice for BufferStatus {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> BufferStatus {
        BufferStatus {
            send_buffer_used: <u16>::from_le_byte_slice(&bytes[0..2]),
            receive_buffer_used: <u16>::from_le_byte_slice(&bytes[2..4]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ErrorCount {
    pub overrun_error_count: u32,
    pub parity_error_count: u32,
}
impl FromByteSlice for ErrorCount {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> ErrorCount {
        ErrorCount {
            overrun_error_count: <u32>::from_le_byte_slice(&bytes[0..4]),
            parity_error_count: <u32>::from_le_byte_slice(&bytes[4..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusCommonErrorCount {
    pub timeout_error_count: u32,
    pub checksum_error_count: u32,
    pub frame_too_big_error_count: u32,
    pub illegal_function_error_count: u32,
    pub illegal_data_address_error_count: u32,
    pub illegal_data_value_error_count: u32,
    pub slave_device_failure_error_count: u32,
}
impl FromByteSlice for ModbusCommonErrorCount {
    fn bytes_expected() -> usize { 28 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusCommonErrorCount {
        ModbusCommonErrorCount {
            timeout_error_count: <u32>::from_le_byte_slice(&bytes[0..4]),
            checksum_error_count: <u32>::from_le_byte_slice(&bytes[4..8]),
            frame_too_big_error_count: <u32>::from_le_byte_slice(&bytes[8..12]),
            illegal_function_error_count: <u32>::from_le_byte_slice(&bytes[12..16]),
            illegal_data_address_error_count: <u32>::from_le_byte_slice(&bytes[16..20]),
            illegal_data_value_error_count: <u32>::from_le_byte_slice(&bytes[20..24]),
            slave_device_failure_error_count: <u32>::from_le_byte_slice(&bytes[24..28]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusSlaveAnswerReadCoilsRequestLowLevel {}
impl FromByteSlice for ModbusSlaveAnswerReadCoilsRequestLowLevel {
    fn bytes_expected() -> usize { 0 }
    fn from_le_byte_slice(_bytes: &[u8]) -> ModbusSlaveAnswerReadCoilsRequestLowLevel { ModbusSlaveAnswerReadCoilsRequestLowLevel {} }
}
impl LowLevelWrite<ModbusSlaveAnswerReadCoilsRequestResult> for ModbusSlaveAnswerReadCoilsRequestLowLevel {
    fn ll_message_written(&self) -> usize { 472 }

    fn get_result(&self) -> ModbusSlaveAnswerReadCoilsRequestResult { ModbusSlaveAnswerReadCoilsRequestResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusSlaveAnswerReadHoldingRegistersRequestLowLevel {}
impl FromByteSlice for ModbusSlaveAnswerReadHoldingRegistersRequestLowLevel {
    fn bytes_expected() -> usize { 0 }
    fn from_le_byte_slice(_bytes: &[u8]) -> ModbusSlaveAnswerReadHoldingRegistersRequestLowLevel {
        ModbusSlaveAnswerReadHoldingRegistersRequestLowLevel {}
    }
}
impl LowLevelWrite<ModbusSlaveAnswerReadHoldingRegistersRequestResult> for ModbusSlaveAnswerReadHoldingRegistersRequestLowLevel {
    fn ll_message_written(&self) -> usize { 29 }

    fn get_result(&self) -> ModbusSlaveAnswerReadHoldingRegistersRequestResult { ModbusSlaveAnswerReadHoldingRegistersRequestResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusMasterWriteMultipleCoilsLowLevel {
    pub request_id: u8,
}
impl FromByteSlice for ModbusMasterWriteMultipleCoilsLowLevel {
    fn bytes_expected() -> usize { 1 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusMasterWriteMultipleCoilsLowLevel {
        ModbusMasterWriteMultipleCoilsLowLevel { request_id: <u8>::from_le_byte_slice(&bytes[0..1]) }
    }
}
impl LowLevelWrite<ModbusMasterWriteMultipleCoilsResult> for ModbusMasterWriteMultipleCoilsLowLevel {
    fn ll_message_written(&self) -> usize { 440 }

    fn get_result(&self) -> ModbusMasterWriteMultipleCoilsResult { ModbusMasterWriteMultipleCoilsResult { request_id: self.request_id } }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusMasterWriteMultipleRegistersLowLevel {
    pub request_id: u8,
}
impl FromByteSlice for ModbusMasterWriteMultipleRegistersLowLevel {
    fn bytes_expected() -> usize { 1 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusMasterWriteMultipleRegistersLowLevel {
        ModbusMasterWriteMultipleRegistersLowLevel { request_id: <u8>::from_le_byte_slice(&bytes[0..1]) }
    }
}
impl LowLevelWrite<ModbusMasterWriteMultipleRegistersResult> for ModbusMasterWriteMultipleRegistersLowLevel {
    fn ll_message_written(&self) -> usize { 27 }

    fn get_result(&self) -> ModbusMasterWriteMultipleRegistersResult {
        ModbusMasterWriteMultipleRegistersResult { request_id: self.request_id }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusSlaveAnswerReadDiscreteInputsRequestLowLevel {}
impl FromByteSlice for ModbusSlaveAnswerReadDiscreteInputsRequestLowLevel {
    fn bytes_expected() -> usize { 0 }
    fn from_le_byte_slice(_bytes: &[u8]) -> ModbusSlaveAnswerReadDiscreteInputsRequestLowLevel {
        ModbusSlaveAnswerReadDiscreteInputsRequestLowLevel {}
    }
}
impl LowLevelWrite<ModbusSlaveAnswerReadDiscreteInputsRequestResult> for ModbusSlaveAnswerReadDiscreteInputsRequestLowLevel {
    fn ll_message_written(&self) -> usize { 472 }

    fn get_result(&self) -> ModbusSlaveAnswerReadDiscreteInputsRequestResult { ModbusSlaveAnswerReadDiscreteInputsRequestResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusSlaveAnswerReadInputRegistersRequestLowLevel {}
impl FromByteSlice for ModbusSlaveAnswerReadInputRegistersRequestLowLevel {
    fn bytes_expected() -> usize { 0 }
    fn from_le_byte_slice(_bytes: &[u8]) -> ModbusSlaveAnswerReadInputRegistersRequestLowLevel {
        ModbusSlaveAnswerReadInputRegistersRequestLowLevel {}
    }
}
impl LowLevelWrite<ModbusSlaveAnswerReadInputRegistersRequestResult> for ModbusSlaveAnswerReadInputRegistersRequestLowLevel {
    fn ll_message_written(&self) -> usize { 29 }

    fn get_result(&self) -> ModbusSlaveAnswerReadInputRegistersRequestResult { ModbusSlaveAnswerReadInputRegistersRequestResult {} }
}

#[derive(Clone, Copy)]
pub struct ReadLowLevelEvent {
    pub message_length: u16,
    pub message_chunk_offset: u16,
    pub message_chunk_data: [char; 60],
}
impl FromByteSlice for ReadLowLevelEvent {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReadLowLevelEvent {
        ReadLowLevelEvent {
            message_length: <u16>::from_le_byte_slice(&bytes[0..2]),
            message_chunk_offset: <u16>::from_le_byte_slice(&bytes[2..4]),
            message_chunk_data: <[char; 60]>::from_le_byte_slice(&bytes[4..64]),
        }
    }
}
impl LowLevelRead<char, ReadResult> for ReadLowLevelEvent {
    fn ll_message_length(&self) -> usize { self.message_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.message_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[char] { &self.message_chunk_data }

    fn get_result(&self) -> ReadResult { ReadResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ErrorCountEvent {
    pub overrun_error_count: u32,
    pub parity_error_count: u32,
}
impl FromByteSlice for ErrorCountEvent {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> ErrorCountEvent {
        ErrorCountEvent {
            overrun_error_count: <u32>::from_le_byte_slice(&bytes[0..4]),
            parity_error_count: <u32>::from_le_byte_slice(&bytes[4..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusSlaveReadCoilsRequestEvent {
    pub request_id: u8,
    pub starting_address: u32,
    pub count: u16,
}
impl FromByteSlice for ModbusSlaveReadCoilsRequestEvent {
    fn bytes_expected() -> usize { 7 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusSlaveReadCoilsRequestEvent {
        ModbusSlaveReadCoilsRequestEvent {
            request_id: <u8>::from_le_byte_slice(&bytes[0..1]),
            starting_address: <u32>::from_le_byte_slice(&bytes[1..5]),
            count: <u16>::from_le_byte_slice(&bytes[5..7]),
        }
    }
}

#[derive(Clone, Copy)]
pub struct ModbusMasterReadCoilsResponseLowLevelEvent {
    pub request_id: u8,
    pub exception_code: i8,
    pub coils_length: u16,
    pub coils_chunk_offset: u16,
    pub coils_chunk_data: [bool; 464],
}
impl FromByteSlice for ModbusMasterReadCoilsResponseLowLevelEvent {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusMasterReadCoilsResponseLowLevelEvent {
        ModbusMasterReadCoilsResponseLowLevelEvent {
            request_id: <u8>::from_le_byte_slice(&bytes[0..1]),
            exception_code: <i8>::from_le_byte_slice(&bytes[1..2]),
            coils_length: <u16>::from_le_byte_slice(&bytes[2..4]),
            coils_chunk_offset: <u16>::from_le_byte_slice(&bytes[4..6]),
            coils_chunk_data: <[bool; 464]>::from_le_byte_slice(&bytes[6..64]),
        }
    }
}
impl LowLevelRead<bool, ModbusMasterReadCoilsResponseResult> for ModbusMasterReadCoilsResponseLowLevelEvent {
    fn ll_message_length(&self) -> usize { self.coils_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.coils_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[bool] { &self.coils_chunk_data }

    fn get_result(&self) -> ModbusMasterReadCoilsResponseResult {
        ModbusMasterReadCoilsResponseResult { request_id: self.request_id, exception_code: self.exception_code }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusSlaveReadHoldingRegistersRequestEvent {
    pub request_id: u8,
    pub starting_address: u32,
    pub count: u16,
}
impl FromByteSlice for ModbusSlaveReadHoldingRegistersRequestEvent {
    fn bytes_expected() -> usize { 7 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusSlaveReadHoldingRegistersRequestEvent {
        ModbusSlaveReadHoldingRegistersRequestEvent {
            request_id: <u8>::from_le_byte_slice(&bytes[0..1]),
            starting_address: <u32>::from_le_byte_slice(&bytes[1..5]),
            count: <u16>::from_le_byte_slice(&bytes[5..7]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusMasterReadHoldingRegistersResponseLowLevelEvent {
    pub request_id: u8,
    pub exception_code: i8,
    pub holding_registers_length: u16,
    pub holding_registers_chunk_offset: u16,
    pub holding_registers_chunk_data: [u16; 29],
}
impl FromByteSlice for ModbusMasterReadHoldingRegistersResponseLowLevelEvent {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusMasterReadHoldingRegistersResponseLowLevelEvent {
        ModbusMasterReadHoldingRegistersResponseLowLevelEvent {
            request_id: <u8>::from_le_byte_slice(&bytes[0..1]),
            exception_code: <i8>::from_le_byte_slice(&bytes[1..2]),
            holding_registers_length: <u16>::from_le_byte_slice(&bytes[2..4]),
            holding_registers_chunk_offset: <u16>::from_le_byte_slice(&bytes[4..6]),
            holding_registers_chunk_data: <[u16; 29]>::from_le_byte_slice(&bytes[6..64]),
        }
    }
}
impl LowLevelRead<u16, ModbusMasterReadHoldingRegistersResponseResult> for ModbusMasterReadHoldingRegistersResponseLowLevelEvent {
    fn ll_message_length(&self) -> usize { self.holding_registers_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.holding_registers_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[u16] { &self.holding_registers_chunk_data }

    fn get_result(&self) -> ModbusMasterReadHoldingRegistersResponseResult {
        ModbusMasterReadHoldingRegistersResponseResult { request_id: self.request_id, exception_code: self.exception_code }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusSlaveWriteSingleCoilRequestEvent {
    pub request_id: u8,
    pub coil_address: u32,
    pub coil_value: bool,
}
impl FromByteSlice for ModbusSlaveWriteSingleCoilRequestEvent {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusSlaveWriteSingleCoilRequestEvent {
        ModbusSlaveWriteSingleCoilRequestEvent {
            request_id: <u8>::from_le_byte_slice(&bytes[0..1]),
            coil_address: <u32>::from_le_byte_slice(&bytes[1..5]),
            coil_value: <bool>::from_le_byte_slice(&bytes[5..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusMasterWriteSingleCoilResponseEvent {
    pub request_id: u8,
    pub exception_code: i8,
}
impl FromByteSlice for ModbusMasterWriteSingleCoilResponseEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusMasterWriteSingleCoilResponseEvent {
        ModbusMasterWriteSingleCoilResponseEvent {
            request_id: <u8>::from_le_byte_slice(&bytes[0..1]),
            exception_code: <i8>::from_le_byte_slice(&bytes[1..2]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusSlaveWriteSingleRegisterRequestEvent {
    pub request_id: u8,
    pub register_address: u32,
    pub register_value: u16,
}
impl FromByteSlice for ModbusSlaveWriteSingleRegisterRequestEvent {
    fn bytes_expected() -> usize { 7 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusSlaveWriteSingleRegisterRequestEvent {
        ModbusSlaveWriteSingleRegisterRequestEvent {
            request_id: <u8>::from_le_byte_slice(&bytes[0..1]),
            register_address: <u32>::from_le_byte_slice(&bytes[1..5]),
            register_value: <u16>::from_le_byte_slice(&bytes[5..7]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusMasterWriteSingleRegisterResponseEvent {
    pub request_id: u8,
    pub exception_code: i8,
}
impl FromByteSlice for ModbusMasterWriteSingleRegisterResponseEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusMasterWriteSingleRegisterResponseEvent {
        ModbusMasterWriteSingleRegisterResponseEvent {
            request_id: <u8>::from_le_byte_slice(&bytes[0..1]),
            exception_code: <i8>::from_le_byte_slice(&bytes[1..2]),
        }
    }
}

#[derive(Clone, Copy)]
pub struct ModbusSlaveWriteMultipleCoilsRequestLowLevelEvent {
    pub request_id: u8,
    pub starting_address: u32,
    pub coils_length: u16,
    pub coils_chunk_offset: u16,
    pub coils_chunk_data: [bool; 440],
}
impl FromByteSlice for ModbusSlaveWriteMultipleCoilsRequestLowLevelEvent {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusSlaveWriteMultipleCoilsRequestLowLevelEvent {
        ModbusSlaveWriteMultipleCoilsRequestLowLevelEvent {
            request_id: <u8>::from_le_byte_slice(&bytes[0..1]),
            starting_address: <u32>::from_le_byte_slice(&bytes[1..5]),
            coils_length: <u16>::from_le_byte_slice(&bytes[5..7]),
            coils_chunk_offset: <u16>::from_le_byte_slice(&bytes[7..9]),
            coils_chunk_data: <[bool; 440]>::from_le_byte_slice(&bytes[9..64]),
        }
    }
}
impl LowLevelRead<bool, ModbusSlaveWriteMultipleCoilsRequestResult> for ModbusSlaveWriteMultipleCoilsRequestLowLevelEvent {
    fn ll_message_length(&self) -> usize { self.coils_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.coils_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[bool] { &self.coils_chunk_data }

    fn get_result(&self) -> ModbusSlaveWriteMultipleCoilsRequestResult {
        ModbusSlaveWriteMultipleCoilsRequestResult { request_id: self.request_id, starting_address: self.starting_address }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusMasterWriteMultipleCoilsResponseEvent {
    pub request_id: u8,
    pub exception_code: i8,
}
impl FromByteSlice for ModbusMasterWriteMultipleCoilsResponseEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusMasterWriteMultipleCoilsResponseEvent {
        ModbusMasterWriteMultipleCoilsResponseEvent {
            request_id: <u8>::from_le_byte_slice(&bytes[0..1]),
            exception_code: <i8>::from_le_byte_slice(&bytes[1..2]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusSlaveWriteMultipleRegistersRequestLowLevelEvent {
    pub request_id: u8,
    pub starting_address: u32,
    pub registers_length: u16,
    pub registers_chunk_offset: u16,
    pub registers_chunk_data: [u16; 27],
}
impl FromByteSlice for ModbusSlaveWriteMultipleRegistersRequestLowLevelEvent {
    fn bytes_expected() -> usize { 63 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusSlaveWriteMultipleRegistersRequestLowLevelEvent {
        ModbusSlaveWriteMultipleRegistersRequestLowLevelEvent {
            request_id: <u8>::from_le_byte_slice(&bytes[0..1]),
            starting_address: <u32>::from_le_byte_slice(&bytes[1..5]),
            registers_length: <u16>::from_le_byte_slice(&bytes[5..7]),
            registers_chunk_offset: <u16>::from_le_byte_slice(&bytes[7..9]),
            registers_chunk_data: <[u16; 27]>::from_le_byte_slice(&bytes[9..63]),
        }
    }
}
impl LowLevelRead<u16, ModbusSlaveWriteMultipleRegistersRequestResult> for ModbusSlaveWriteMultipleRegistersRequestLowLevelEvent {
    fn ll_message_length(&self) -> usize { self.registers_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.registers_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[u16] { &self.registers_chunk_data }

    fn get_result(&self) -> ModbusSlaveWriteMultipleRegistersRequestResult {
        ModbusSlaveWriteMultipleRegistersRequestResult { request_id: self.request_id, starting_address: self.starting_address }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusMasterWriteMultipleRegistersResponseEvent {
    pub request_id: u8,
    pub exception_code: i8,
}
impl FromByteSlice for ModbusMasterWriteMultipleRegistersResponseEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusMasterWriteMultipleRegistersResponseEvent {
        ModbusMasterWriteMultipleRegistersResponseEvent {
            request_id: <u8>::from_le_byte_slice(&bytes[0..1]),
            exception_code: <i8>::from_le_byte_slice(&bytes[1..2]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusSlaveReadDiscreteInputsRequestEvent {
    pub request_id: u8,
    pub starting_address: u32,
    pub count: u16,
}
impl FromByteSlice for ModbusSlaveReadDiscreteInputsRequestEvent {
    fn bytes_expected() -> usize { 7 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusSlaveReadDiscreteInputsRequestEvent {
        ModbusSlaveReadDiscreteInputsRequestEvent {
            request_id: <u8>::from_le_byte_slice(&bytes[0..1]),
            starting_address: <u32>::from_le_byte_slice(&bytes[1..5]),
            count: <u16>::from_le_byte_slice(&bytes[5..7]),
        }
    }
}

#[derive(Clone, Copy)]
pub struct ModbusMasterReadDiscreteInputsResponseLowLevelEvent {
    pub request_id: u8,
    pub exception_code: i8,
    pub discrete_inputs_length: u16,
    pub discrete_inputs_chunk_offset: u16,
    pub discrete_inputs_chunk_data: [bool; 464],
}
impl FromByteSlice for ModbusMasterReadDiscreteInputsResponseLowLevelEvent {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusMasterReadDiscreteInputsResponseLowLevelEvent {
        ModbusMasterReadDiscreteInputsResponseLowLevelEvent {
            request_id: <u8>::from_le_byte_slice(&bytes[0..1]),
            exception_code: <i8>::from_le_byte_slice(&bytes[1..2]),
            discrete_inputs_length: <u16>::from_le_byte_slice(&bytes[2..4]),
            discrete_inputs_chunk_offset: <u16>::from_le_byte_slice(&bytes[4..6]),
            discrete_inputs_chunk_data: <[bool; 464]>::from_le_byte_slice(&bytes[6..64]),
        }
    }
}
impl LowLevelRead<bool, ModbusMasterReadDiscreteInputsResponseResult> for ModbusMasterReadDiscreteInputsResponseLowLevelEvent {
    fn ll_message_length(&self) -> usize { self.discrete_inputs_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.discrete_inputs_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[bool] { &self.discrete_inputs_chunk_data }

    fn get_result(&self) -> ModbusMasterReadDiscreteInputsResponseResult {
        ModbusMasterReadDiscreteInputsResponseResult { request_id: self.request_id, exception_code: self.exception_code }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusSlaveReadInputRegistersRequestEvent {
    pub request_id: u8,
    pub starting_address: u32,
    pub count: u16,
}
impl FromByteSlice for ModbusSlaveReadInputRegistersRequestEvent {
    fn bytes_expected() -> usize { 7 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusSlaveReadInputRegistersRequestEvent {
        ModbusSlaveReadInputRegistersRequestEvent {
            request_id: <u8>::from_le_byte_slice(&bytes[0..1]),
            starting_address: <u32>::from_le_byte_slice(&bytes[1..5]),
            count: <u16>::from_le_byte_slice(&bytes[5..7]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusMasterReadInputRegistersResponseLowLevelEvent {
    pub request_id: u8,
    pub exception_code: i8,
    pub input_registers_length: u16,
    pub input_registers_chunk_offset: u16,
    pub input_registers_chunk_data: [u16; 29],
}
impl FromByteSlice for ModbusMasterReadInputRegistersResponseLowLevelEvent {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> ModbusMasterReadInputRegistersResponseLowLevelEvent {
        ModbusMasterReadInputRegistersResponseLowLevelEvent {
            request_id: <u8>::from_le_byte_slice(&bytes[0..1]),
            exception_code: <i8>::from_le_byte_slice(&bytes[1..2]),
            input_registers_length: <u16>::from_le_byte_slice(&bytes[2..4]),
            input_registers_chunk_offset: <u16>::from_le_byte_slice(&bytes[4..6]),
            input_registers_chunk_data: <[u16; 29]>::from_le_byte_slice(&bytes[6..64]),
        }
    }
}
impl LowLevelRead<u16, ModbusMasterReadInputRegistersResponseResult> for ModbusMasterReadInputRegistersResponseLowLevelEvent {
    fn ll_message_length(&self) -> usize { self.input_registers_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.input_registers_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[u16] { &self.input_registers_chunk_data }

    fn get_result(&self) -> ModbusMasterReadInputRegistersResponseResult {
        ModbusMasterReadInputRegistersResponseResult { request_id: self.request_id, exception_code: self.exception_code }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WriteResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReadResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusSlaveAnswerReadCoilsRequestResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusSlaveAnswerReadHoldingRegistersRequestResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusMasterWriteMultipleCoilsResult {
    pub request_id: u8,
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusMasterWriteMultipleRegistersResult {
    pub request_id: u8,
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusSlaveAnswerReadDiscreteInputsRequestResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusSlaveAnswerReadInputRegistersRequestResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusMasterReadCoilsResponseResult {
    pub request_id: u8,
    pub exception_code: i8,
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusMasterReadHoldingRegistersResponseResult {
    pub request_id: u8,
    pub exception_code: i8,
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusSlaveWriteMultipleCoilsRequestResult {
    pub request_id: u8,
    pub starting_address: u32,
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusSlaveWriteMultipleRegistersRequestResult {
    pub request_id: u8,
    pub starting_address: u32,
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusMasterReadDiscreteInputsResponseResult {
    pub request_id: u8,
    pub exception_code: i8,
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ModbusMasterReadInputRegistersResponseResult {
    pub request_id: u8,
    pub exception_code: i8,
}

/// Communicates with RS485/Modbus devices with full- or half-duplex
#[derive(Clone)]
pub struct Rs485Bricklet {
    device: Device,
}
impl Rs485Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 277;
    pub const DEVICE_DISPLAY_NAME: &'static str = "RS485 Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> Rs485Bricklet {
        let mut result = Rs485Bricklet { device: Device::new([2, 0, 1], uid, req_sender, 15) };
        result.device.response_expected[u8::from(Rs485BrickletFunction::WriteLowLevel) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::ReadLowLevel) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::EnableReadCallback) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Rs485BrickletFunction::DisableReadCallback) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Rs485BrickletFunction::IsReadCallbackEnabled) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::SetRs485Configuration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs485BrickletFunction::GetRs485Configuration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::SetModbusConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs485BrickletFunction::GetModbusConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::SetMode) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs485BrickletFunction::GetMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::SetCommunicationLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs485BrickletFunction::GetCommunicationLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::SetErrorLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs485BrickletFunction::GetErrorLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::SetBufferConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs485BrickletFunction::GetBufferConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::GetBufferStatus) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::EnableErrorCountCallback) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Rs485BrickletFunction::DisableErrorCountCallback) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Rs485BrickletFunction::IsErrorCountCallbackEnabled) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::GetErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::GetModbusCommonErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::ModbusSlaveReportException) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs485BrickletFunction::ModbusSlaveAnswerReadCoilsRequestLowLevel) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Rs485BrickletFunction::ModbusMasterReadCoils) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::ModbusSlaveAnswerReadHoldingRegistersRequestLowLevel) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Rs485BrickletFunction::ModbusMasterReadHoldingRegisters) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::ModbusSlaveAnswerWriteSingleCoilRequest) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs485BrickletFunction::ModbusMasterWriteSingleCoil) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::ModbusSlaveAnswerWriteSingleRegisterRequest) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs485BrickletFunction::ModbusMasterWriteSingleRegister) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::ModbusSlaveAnswerWriteMultipleCoilsRequest) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs485BrickletFunction::ModbusMasterWriteMultipleCoilsLowLevel) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::ModbusSlaveAnswerWriteMultipleRegistersRequest) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs485BrickletFunction::ModbusMasterWriteMultipleRegistersLowLevel) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::ModbusSlaveAnswerReadDiscreteInputsRequestLowLevel) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Rs485BrickletFunction::ModbusMasterReadDiscreteInputs) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::ModbusSlaveAnswerReadInputRegistersRequestLowLevel) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Rs485BrickletFunction::ModbusMasterReadInputRegisters) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::SetFrameReadableCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Rs485BrickletFunction::GetFrameReadableCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::SetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::GetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::SetWriteFirmwarePointer) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs485BrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs485BrickletFunction::GetStatusLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs485BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs485BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs485BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::rs485_bricklet::Rs485Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::rs485_bricklet::Rs485Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: Rs485BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: Rs485BrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// See [`get_read_callback_receiver`](crate::rs485::RS485::get_read_callback_receiver)
    pub fn get_read_low_level_callback_receiver(&self) -> ConvertingCallbackReceiver<ReadLowLevelEvent> {
        self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackReadLowLevel))
    }

    /// This receiver is called if new data is available.
    ///
    /// To enable this receiver, use [`enable_read_callback`].
    ///
    /// [`enable_read_callback`]: #method.enable_read_callback
    pub fn get_read_callback_receiver(&self) -> ConvertingHighLevelCallbackReceiver<char, ReadResult, ReadLowLevelEvent> {
        ConvertingHighLevelCallbackReceiver::new(self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackReadLowLevel)))
    }

    /// This receiver is called if a new error occurs. It returns
    /// the current overrun and parity error count.
    pub fn get_error_count_callback_receiver(&self) -> ConvertingCallbackReceiver<ErrorCountEvent> {
        self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackErrorCount))
    }

    /// This receiver is called only in Modbus slave mode when the slave receives a
    /// valid request from a Modbus master to read coils. The parameters are
    /// request ID of the request, the number of the first coil to be read and the number of coils to
    /// be read as received by the request. The number of the first coil is called starting address for backwards compatibility reasons.
    /// It is not an address, but instead a coil number in the range of 1 to 65536.
    ///
    /// To send a response of this request use [`modbus_slave_answer_read_coils_request`].
    pub fn get_modbus_slave_read_coils_request_callback_receiver(&self) -> ConvertingCallbackReceiver<ModbusSlaveReadCoilsRequestEvent> {
        self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusSlaveReadCoilsRequest))
    }

    /// See [`get_modbus_master_read_coils_response_callback_receiver`](crate::rs485::RS485::get_modbus_master_read_coils_response_callback_receiver)
    pub fn get_modbus_master_read_coils_response_low_level_callback_receiver(
        &self,
    ) -> ConvertingCallbackReceiver<ModbusMasterReadCoilsResponseLowLevelEvent> {
        self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusMasterReadCoilsResponseLowLevel))
    }

    /// This receiver is called only in Modbus master mode when the master receives a
    /// valid response of a request to read coils.
    ///
    /// The parameters are request ID
    /// of the request, exception code of the response and the data as received by the
    /// response.
    ///
    /// Any non-zero exception code indicates a problem. If the exception code
    /// is greater than 0 then the number represents a Modbus exception code. If it is
    /// less than 0 then it represents other errors. For example, -1 indicates that
    /// the request timed out or that the master did not receive any valid response of the
    /// request within the master request timeout period as set by
    /// [`set_modbus_configuration`].
    pub fn get_modbus_master_read_coils_response_callback_receiver(
        &self,
    ) -> ConvertingHighLevelCallbackReceiver<bool, ModbusMasterReadCoilsResponseResult, ModbusMasterReadCoilsResponseLowLevelEvent> {
        ConvertingHighLevelCallbackReceiver::new(
            self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusMasterReadCoilsResponseLowLevel)),
        )
    }

    /// This receiver is called only in Modbus slave mode when the slave receives a
    /// valid request from a Modbus master to read holding registers. The parameters
    /// are request ID of the request, the number of the first holding register to be read and the number of holding
    /// registers to be read as received by the request. The number of the first holding register is called starting address for backwards compatibility reasons.
    /// It is not an address, but instead a holding register number in the range of 1 to 65536. The prefix digit 4 (for holding register) is omitted.
    ///
    /// To send a response of this request use [`modbus_slave_answer_read_holding_registers_request`].
    pub fn get_modbus_slave_read_holding_registers_request_callback_receiver(
        &self,
    ) -> ConvertingCallbackReceiver<ModbusSlaveReadHoldingRegistersRequestEvent> {
        self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusSlaveReadHoldingRegistersRequest))
    }

    /// See [`get_modbus_master_read_holding_registers_response_callback_receiver`](crate::rs485::RS485::get_modbus_master_read_holding_registers_response_callback_receiver)
    pub fn get_modbus_master_read_holding_registers_response_low_level_callback_receiver(
        &self,
    ) -> ConvertingCallbackReceiver<ModbusMasterReadHoldingRegistersResponseLowLevelEvent> {
        self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusMasterReadHoldingRegistersResponseLowLevel))
    }

    /// This receiver is called only in Modbus master mode when the master receives a
    /// valid response of a request to read holding registers.
    ///
    /// The parameters are
    /// request ID of the request, exception code of the response and the data as received
    /// by the response.
    ///
    /// Any non-zero exception code indicates a problem. If the exception
    /// code is greater than 0 then the number represents a Modbus exception code. If
    /// it is less than 0 then it represents other errors. For example, -1 indicates that
    /// the request timed out or that the master did not receive any valid response of the
    /// request within the master request timeout period as set by
    /// [`set_modbus_configuration`].
    pub fn get_modbus_master_read_holding_registers_response_callback_receiver(
        &self,
    ) -> ConvertingHighLevelCallbackReceiver<
        u16,
        ModbusMasterReadHoldingRegistersResponseResult,
        ModbusMasterReadHoldingRegistersResponseLowLevelEvent,
    > {
        ConvertingHighLevelCallbackReceiver::new(
            self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusMasterReadHoldingRegistersResponseLowLevel)),
        )
    }

    /// This receiver is called only in Modbus slave mode when the slave receives a
    /// valid request from a Modbus master to write a single coil. The parameters
    /// are request ID of the request, the number of the coil and the value of coil to be
    /// written as received by the request. The number of the coil is called coil address for backwards compatibility reasons.
    /// It is not an address, but instead a coil number in the range of 1 to 65536.
    ///
    /// To send a response of this request use [`modbus_slave_answer_write_single_coil_request`].
    pub fn get_modbus_slave_write_single_coil_request_callback_receiver(
        &self,
    ) -> ConvertingCallbackReceiver<ModbusSlaveWriteSingleCoilRequestEvent> {
        self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusSlaveWriteSingleCoilRequest))
    }

    /// This receiver is called only in Modbus master mode when the master receives a
    /// valid response of a request to write a single coil.
    ///
    /// The parameters are
    /// request ID of the request and exception code of the response.
    ///
    /// Any non-zero exception code indicates a problem.
    /// If the exception code is greater than 0 then the number represents a Modbus
    /// exception code. If it is less than 0 then it represents other errors. For
    /// example, -1 indicates that the request timed out or that the master did not receive
    /// any valid response of the request within the master request timeout period as set
    /// by [`set_modbus_configuration`].
    pub fn get_modbus_master_write_single_coil_response_callback_receiver(
        &self,
    ) -> ConvertingCallbackReceiver<ModbusMasterWriteSingleCoilResponseEvent> {
        self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusMasterWriteSingleCoilResponse))
    }

    /// This receiver is called only in Modbus slave mode when the slave receives a
    /// valid request from a Modbus master to write a single holding register. The parameters
    /// are request ID of the request, the number of the holding register and the register value to
    /// be written as received by the request. The number of the holding register is called starting address for backwards compatibility reasons.
    /// It is not an address, but instead a holding register number in the range of 1 to 65536. The prefix digit 4 (for holding register) is omitted.
    ///
    /// To send a response of this request use [`modbus_slave_answer_write_single_register_request`].
    pub fn get_modbus_slave_write_single_register_request_callback_receiver(
        &self,
    ) -> ConvertingCallbackReceiver<ModbusSlaveWriteSingleRegisterRequestEvent> {
        self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusSlaveWriteSingleRegisterRequest))
    }

    /// This receiver is called only in Modbus master mode when the master receives a
    /// valid response of a request to write a single register.
    ///
    /// The parameters are
    /// request ID of the request and exception code of the response.
    ///
    /// Any non-zero exception code
    /// indicates a problem. If the exception code is greater than 0 then the number
    /// represents a Modbus exception code. If it is less than 0 then it represents
    /// other errors. For example, -1 indicates that the request timed out or that the
    /// master did not receive any valid response of the request within the master request
    /// timeout period as set by [`set_modbus_configuration`].
    pub fn get_modbus_master_write_single_register_response_callback_receiver(
        &self,
    ) -> ConvertingCallbackReceiver<ModbusMasterWriteSingleRegisterResponseEvent> {
        self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusMasterWriteSingleRegisterResponse))
    }

    /// See [`get_modbus_slave_write_multiple_coils_request_callback_receiver`](crate::rs485::RS485::get_modbus_slave_write_multiple_coils_request_callback_receiver)
    pub fn get_modbus_slave_write_multiple_coils_request_low_level_callback_receiver(
        &self,
    ) -> ConvertingCallbackReceiver<ModbusSlaveWriteMultipleCoilsRequestLowLevelEvent> {
        self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusSlaveWriteMultipleCoilsRequestLowLevel))
    }

    /// This receiver is called only in Modbus slave mode when the slave receives a
    /// valid request from a Modbus master to write multiple coils. The parameters
    /// are request ID of the request, the number of the first coil and the data to be written as
    /// received by the request. The number of the first coil is called starting address for backwards compatibility reasons.
    /// It is not an address, but instead a coil number in the range of 1 to 65536.
    ///
    /// To send a response of this request use [`modbus_slave_answer_write_multiple_coils_request`].
    pub fn get_modbus_slave_write_multiple_coils_request_callback_receiver(
        &self,
    ) -> ConvertingHighLevelCallbackReceiver<
        bool,
        ModbusSlaveWriteMultipleCoilsRequestResult,
        ModbusSlaveWriteMultipleCoilsRequestLowLevelEvent,
    > {
        ConvertingHighLevelCallbackReceiver::new(
            self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusSlaveWriteMultipleCoilsRequestLowLevel)),
        )
    }

    /// This receiver is called only in Modbus master mode when the master receives a
    /// valid response of a request to read coils.
    ///
    /// The parameters are
    /// request ID of the request and exception code of the response.
    ///
    /// Any non-zero exception code
    /// indicates a problem. If the exception code is greater than 0 then the number
    /// represents a Modbus exception code. If it is less than 0 then it represents
    /// other errors. For example, -1 indicates that the request timedout or that the
    /// master did not receive any valid response of the request within the master request
    /// timeout period as set by [`set_modbus_configuration`].
    pub fn get_modbus_master_write_multiple_coils_response_callback_receiver(
        &self,
    ) -> ConvertingCallbackReceiver<ModbusMasterWriteMultipleCoilsResponseEvent> {
        self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusMasterWriteMultipleCoilsResponse))
    }

    /// See [`get_modbus_slave_write_multiple_registers_request_callback_receiver`](crate::rs485::RS485::get_modbus_slave_write_multiple_registers_request_callback_receiver)
    pub fn get_modbus_slave_write_multiple_registers_request_low_level_callback_receiver(
        &self,
    ) -> ConvertingCallbackReceiver<ModbusSlaveWriteMultipleRegistersRequestLowLevelEvent> {
        self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusSlaveWriteMultipleRegistersRequestLowLevel))
    }

    /// This receiver is called only in Modbus slave mode when the slave receives a
    /// valid request from a Modbus master to write multiple holding registers. The parameters
    /// are request ID of the request, the number of the first holding register and the data to be written as
    /// received by the request. The number of the first holding register is called starting address for backwards compatibility reasons.
    /// It is not an address, but instead a holding register number in the range of 1 to 65536. The prefix digit 4 (for holding register) is omitted.
    ///
    /// To send a response of this request use [`modbus_slave_answer_write_multiple_registers_request`].
    pub fn get_modbus_slave_write_multiple_registers_request_callback_receiver(
        &self,
    ) -> ConvertingHighLevelCallbackReceiver<
        u16,
        ModbusSlaveWriteMultipleRegistersRequestResult,
        ModbusSlaveWriteMultipleRegistersRequestLowLevelEvent,
    > {
        ConvertingHighLevelCallbackReceiver::new(
            self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusSlaveWriteMultipleRegistersRequestLowLevel)),
        )
    }

    /// This receiver is called only in Modbus master mode when the master receives a
    /// valid response of a request to write multiple registers.
    ///
    /// The parameters
    /// are request ID of the request and exception code of the response.
    ///
    /// Any non-zero
    /// exception code indicates a problem. If the exception code is greater than 0 then
    /// the number represents a Modbus exception code. If it is less than 0 then it
    /// represents other errors. For example, -1 indicates that the request timedout or
    /// that the master did not receive any valid response of the request within the master
    /// request timeout period as set by [`set_modbus_configuration`].
    pub fn get_modbus_master_write_multiple_registers_response_callback_receiver(
        &self,
    ) -> ConvertingCallbackReceiver<ModbusMasterWriteMultipleRegistersResponseEvent> {
        self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusMasterWriteMultipleRegistersResponse))
    }

    /// This receiver is called only in Modbus slave mode when the slave receives a
    /// valid request from a Modbus master to read discrete inputs. The parameters
    /// are request ID of the request, the number of the first discrete input and the number of discrete
    /// inputs to be read as received by the request. The number of the first discrete input is called starting address for backwards compatibility reasons.
    /// It is not an address, but instead a discrete input number in the range of 1 to 65536. The prefix digit 1 (for discrete input) is omitted.
    ///
    /// To send a response of this request use [`modbus_slave_answer_read_discrete_inputs_request`].
    pub fn get_modbus_slave_read_discrete_inputs_request_callback_receiver(
        &self,
    ) -> ConvertingCallbackReceiver<ModbusSlaveReadDiscreteInputsRequestEvent> {
        self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusSlaveReadDiscreteInputsRequest))
    }

    /// See [`get_modbus_master_read_discrete_inputs_response_callback_receiver`](crate::rs485::RS485::get_modbus_master_read_discrete_inputs_response_callback_receiver)
    pub fn get_modbus_master_read_discrete_inputs_response_low_level_callback_receiver(
        &self,
    ) -> ConvertingCallbackReceiver<ModbusMasterReadDiscreteInputsResponseLowLevelEvent> {
        self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusMasterReadDiscreteInputsResponseLowLevel))
    }

    /// This receiver is called only in Modbus master mode when the master receives a
    /// valid response of a request to read discrete inputs.
    ///
    /// The parameters are
    /// request ID of the request, exception code of the response and the data as received
    /// by the response.
    ///
    /// Any non-zero exception code indicates a problem. If the exception
    /// code is greater than 0 then the number represents a Modbus exception code. If
    /// it is less than 0 then it represents other errors. For example, -1 indicates that
    /// the request timedout or that the master did not receive any valid response of the
    /// request within the master request timeout period as set by
    /// [`set_modbus_configuration`].
    pub fn get_modbus_master_read_discrete_inputs_response_callback_receiver(
        &self,
    ) -> ConvertingHighLevelCallbackReceiver<
        bool,
        ModbusMasterReadDiscreteInputsResponseResult,
        ModbusMasterReadDiscreteInputsResponseLowLevelEvent,
    > {
        ConvertingHighLevelCallbackReceiver::new(
            self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusMasterReadDiscreteInputsResponseLowLevel)),
        )
    }

    /// This receiver is called only in Modbus slave mode when the slave receives a
    /// valid request from a Modbus master to read input registers. The parameters
    /// are request ID of the request, the number of the first input register and the number of input
    /// registers to be read as received by the request. The number of the first input register is called starting address for backwards compatibility reasons.
    /// It is not an address, but instead a input register number in the range of 1 to 65536. The prefix digit 3 (for input register) is omitted.
    ///
    /// To send a response of this request use [`modbus_slave_answer_read_input_registers_request`].
    pub fn get_modbus_slave_read_input_registers_request_callback_receiver(
        &self,
    ) -> ConvertingCallbackReceiver<ModbusSlaveReadInputRegistersRequestEvent> {
        self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusSlaveReadInputRegistersRequest))
    }

    /// See [`get_modbus_master_read_input_registers_response_callback_receiver`](crate::rs485::RS485::get_modbus_master_read_input_registers_response_callback_receiver)
    pub fn get_modbus_master_read_input_registers_response_low_level_callback_receiver(
        &self,
    ) -> ConvertingCallbackReceiver<ModbusMasterReadInputRegistersResponseLowLevelEvent> {
        self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusMasterReadInputRegistersResponseLowLevel))
    }

    /// This receiver is called only in Modbus master mode when the master receives a
    /// valid response of a request to read input registers.
    ///
    /// The parameters are
    /// request ID of the request, exception code of the response and the data as received
    /// by the response.
    ///
    /// Any non-zero exception code indicates a problem. If the exception
    /// code is greater than 0 then the number represents a Modbus exception code. If
    /// it is less than 0 then it represents other errors. For example, -1 indicates that
    /// the request timedout or that the master did not receive any valid response of the
    /// request within the master request timeout period as set by
    /// [`set_modbus_configuration`].
    pub fn get_modbus_master_read_input_registers_response_callback_receiver(
        &self,
    ) -> ConvertingHighLevelCallbackReceiver<
        u16,
        ModbusMasterReadInputRegistersResponseResult,
        ModbusMasterReadInputRegistersResponseLowLevelEvent,
    > {
        ConvertingHighLevelCallbackReceiver::new(
            self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackModbusMasterReadInputRegistersResponseLowLevel)),
        )
    }

    /// This receiver is called if at least one frame of data is readable. The frame size is configured with [`set_frame_readable_callback_configuration`].
    /// The frame count parameter is the number of frames that can be read.
    /// This receiver is triggered only once until [`read`] is called. This means, that if you have configured a frame size of X bytes,
    /// you can read exactly X bytes using the [`read`] function, every time the receiver triggers without checking the frame count parameter.
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Plugin)
    pub fn get_frame_readable_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(Rs485BrickletFunction::CallbackFrameReadable))
    }

    /// Writes characters to the RS485 interface. The characters can be binary data,
    /// ASCII or similar is not necessary.
    ///
    /// The return value is the number of characters that were written.
    ///
    /// See [`set_rs485_configuration`] for configuration possibilities
    /// regarding baudrate, parity and so on.
    pub fn write_low_level(
        &self,
        message_length: u16,
        message_chunk_offset: u16,
        message_chunk_data: [char; 60],
    ) -> ConvertingReceiver<WriteLowLevel> {
        let mut payload = vec![0; 64];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(message_length));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(message_chunk_offset));
        payload[4..64].copy_from_slice(&<[char; 60]>::to_le_byte_vec(message_chunk_data));

        self.device.get(u8::from(Rs485BrickletFunction::WriteLowLevel), payload)
    }

    /// Writes characters to the RS485 interface. The characters can be binary data,
    /// ASCII or similar is not necessary.
    ///
    /// The return value is the number of characters that were written.
    ///
    /// See [`set_rs485_configuration`] for configuration possibilities
    /// regarding baudrate, parity and so on.
    pub fn write(&self, message: &[char]) -> Result<usize, BrickletRecvTimeoutError> {
        let ll_result = self.device.set_high_level(0, message, 65535, 60, &mut |length: usize, chunk_offset: usize, chunk: &[char]| {
            let chunk_length = chunk.len() as u16;
            let mut chunk_array = [<char>::default(); 60];
            chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

            self.write_low_level(length as u16, chunk_offset as u16, chunk_array).recv()
        })?;
        Ok(ll_result.0)
    }

    /// Returns up to *length* characters from receive buffer.
    ///
    /// Instead of polling with this function, you can also use
    /// callbacks. But note that this function will return available
    /// data only when the read receiver is disabled.
    /// See [`enable_read_callback`] and [`get_read_callback_receiver`] receiver.
    pub fn read_low_level(&self, length: u16) -> ConvertingReceiver<ReadLowLevel> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(length));

        self.device.get(u8::from(Rs485BrickletFunction::ReadLowLevel), payload)
    }

    /// Returns up to *length* characters from receive buffer.
    ///
    /// Instead of polling with this function, you can also use
    /// callbacks. But note that this function will return available
    /// data only when the read receiver is disabled.
    /// See [`enable_read_callback`] and [`get_read_callback_receiver`] receiver.
    pub fn read(&self, length: u16) -> Result<Vec<char>, BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(1, &mut || self.read_low_level(length).recv())?;
        Ok(ll_result.0)
    }

    /// Enables the [`get_read_callback_receiver`] receiver. This will disable the [`get_frame_readable_callback_receiver`] receiver.
    ///
    /// By default the receiver is disabled.
    pub fn enable_read_callback(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Rs485BrickletFunction::EnableReadCallback), payload)
    }

    /// Disables the [`get_read_callback_receiver`] receiver.
    ///
    /// By default the receiver is disabled.
    pub fn disable_read_callback(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Rs485BrickletFunction::DisableReadCallback), payload)
    }

    /// Returns *true* if the [`get_read_callback_receiver`] receiver is enabled,
    /// *false* otherwise.
    pub fn is_read_callback_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs485BrickletFunction::IsReadCallbackEnabled), payload)
    }

    /// Sets the configuration for the RS485 communication.
    ///
    /// Associated constants:
    /// * RS485_BRICKLET_PARITY_NONE
    ///	* RS485_BRICKLET_PARITY_ODD
    ///	* RS485_BRICKLET_PARITY_EVEN
    ///	* RS485_BRICKLET_STOPBITS_1
    ///	* RS485_BRICKLET_STOPBITS_2
    ///	* RS485_BRICKLET_WORDLENGTH_5
    ///	* RS485_BRICKLET_WORDLENGTH_6
    ///	* RS485_BRICKLET_WORDLENGTH_7
    ///	* RS485_BRICKLET_WORDLENGTH_8
    ///	* RS485_BRICKLET_DUPLEX_HALF
    ///	* RS485_BRICKLET_DUPLEX_FULL
    pub fn set_rs485_configuration(&self, baudrate: u32, parity: u8, stopbits: u8, wordlength: u8, duplex: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 8];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(baudrate));
        payload[4..5].copy_from_slice(&<u8>::to_le_byte_vec(parity));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(stopbits));
        payload[6..7].copy_from_slice(&<u8>::to_le_byte_vec(wordlength));
        payload[7..8].copy_from_slice(&<u8>::to_le_byte_vec(duplex));

        self.device.set(u8::from(Rs485BrickletFunction::SetRs485Configuration), payload)
    }

    /// Returns the configuration as set by [`set_rs485_configuration`].
    ///
    /// Associated constants:
    /// * RS485_BRICKLET_PARITY_NONE
    ///	* RS485_BRICKLET_PARITY_ODD
    ///	* RS485_BRICKLET_PARITY_EVEN
    ///	* RS485_BRICKLET_STOPBITS_1
    ///	* RS485_BRICKLET_STOPBITS_2
    ///	* RS485_BRICKLET_WORDLENGTH_5
    ///	* RS485_BRICKLET_WORDLENGTH_6
    ///	* RS485_BRICKLET_WORDLENGTH_7
    ///	* RS485_BRICKLET_WORDLENGTH_8
    ///	* RS485_BRICKLET_DUPLEX_HALF
    ///	* RS485_BRICKLET_DUPLEX_FULL
    pub fn get_rs485_configuration(&self) -> ConvertingReceiver<Rs485Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs485BrickletFunction::GetRs485Configuration), payload)
    }

    /// Sets the configuration for the RS485 Modbus communication. Available options:
    ///
    /// * Slave Address: Address to be used as the Modbus slave address in Modbus slave mode. Valid Modbus slave address range is 1 to 247.
    /// * Master Request Timeout: Specifies how long the master should wait for a response from a slave when in Modbus master mode.
    pub fn set_modbus_configuration(&self, slave_address: u8, master_request_timeout: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(slave_address));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(master_request_timeout));

        self.device.set(u8::from(Rs485BrickletFunction::SetModbusConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_modbus_configuration`].
    pub fn get_modbus_configuration(&self) -> ConvertingReceiver<ModbusConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs485BrickletFunction::GetModbusConfiguration), payload)
    }

    /// Sets the mode of the Bricklet in which it operates. Available options are
    ///
    /// * RS485,
    /// * Modbus Master RTU and
    /// * Modbus Slave RTU.
    ///
    /// Associated constants:
    /// * RS485_BRICKLET_MODE_RS485
    ///	* RS485_BRICKLET_MODE_MODBUS_MASTER_RTU
    ///	* RS485_BRICKLET_MODE_MODBUS_SLAVE_RTU
    pub fn set_mode(&self, mode: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.set(u8::from(Rs485BrickletFunction::SetMode), payload)
    }

    /// Returns the configuration as set by [`set_mode`].
    ///
    /// Associated constants:
    /// * RS485_BRICKLET_MODE_RS485
    ///	* RS485_BRICKLET_MODE_MODBUS_MASTER_RTU
    ///	* RS485_BRICKLET_MODE_MODBUS_SLAVE_RTU
    pub fn get_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs485BrickletFunction::GetMode), payload)
    }

    /// Sets the communication LED configuration. By default the LED shows RS485
    /// communication traffic by flickering.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is off.
    ///
    /// Associated constants:
    /// * RS485_BRICKLET_COMMUNICATION_LED_CONFIG_OFF
    ///	* RS485_BRICKLET_COMMUNICATION_LED_CONFIG_ON
    ///	* RS485_BRICKLET_COMMUNICATION_LED_CONFIG_SHOW_HEARTBEAT
    ///	* RS485_BRICKLET_COMMUNICATION_LED_CONFIG_SHOW_COMMUNICATION
    pub fn set_communication_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(Rs485BrickletFunction::SetCommunicationLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_communication_led_config`]
    ///
    /// Associated constants:
    /// * RS485_BRICKLET_COMMUNICATION_LED_CONFIG_OFF
    ///	* RS485_BRICKLET_COMMUNICATION_LED_CONFIG_ON
    ///	* RS485_BRICKLET_COMMUNICATION_LED_CONFIG_SHOW_HEARTBEAT
    ///	* RS485_BRICKLET_COMMUNICATION_LED_CONFIG_SHOW_COMMUNICATION
    pub fn get_communication_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs485BrickletFunction::GetCommunicationLedConfig), payload)
    }

    /// Sets the error LED configuration.
    ///
    /// By default the error LED turns on if there is any error (see [`get_error_count_callback_receiver`]
    /// callback). If you call this function with the SHOW ERROR option again, the LED
    /// will turn off until the next error occurs.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is off.
    ///
    /// Associated constants:
    /// * RS485_BRICKLET_ERROR_LED_CONFIG_OFF
    ///	* RS485_BRICKLET_ERROR_LED_CONFIG_ON
    ///	* RS485_BRICKLET_ERROR_LED_CONFIG_SHOW_HEARTBEAT
    ///	* RS485_BRICKLET_ERROR_LED_CONFIG_SHOW_ERROR
    pub fn set_error_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(Rs485BrickletFunction::SetErrorLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_error_led_config`].
    ///
    /// Associated constants:
    /// * RS485_BRICKLET_ERROR_LED_CONFIG_OFF
    ///	* RS485_BRICKLET_ERROR_LED_CONFIG_ON
    ///	* RS485_BRICKLET_ERROR_LED_CONFIG_SHOW_HEARTBEAT
    ///	* RS485_BRICKLET_ERROR_LED_CONFIG_SHOW_ERROR
    pub fn get_error_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs485BrickletFunction::GetErrorLedConfig), payload)
    }

    /// Sets the send and receive buffer size in byte. In sum there is
    /// 10240 byte (10KiB) buffer available and the minimum buffer size
    /// is 1024 byte (1KiB) for both.
    ///
    /// The current buffer content is lost if this function is called.
    ///
    /// The send buffer holds data that was given by [`write`] and
    /// could not be written yet. The receive buffer holds data that is
    /// received through RS485 but could not yet be send to the
    /// user, either by [`read`] or through [`get_read_callback_receiver`] receiver.
    pub fn set_buffer_config(&self, send_buffer_size: u16, receive_buffer_size: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(send_buffer_size));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(receive_buffer_size));

        self.device.set(u8::from(Rs485BrickletFunction::SetBufferConfig), payload)
    }

    /// Returns the buffer configuration as set by [`set_buffer_config`].
    pub fn get_buffer_config(&self) -> ConvertingReceiver<BufferConfig> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs485BrickletFunction::GetBufferConfig), payload)
    }

    /// Returns the currently used bytes for the send and received buffer.
    ///
    /// See [`set_buffer_config`] for buffer size configuration.
    pub fn get_buffer_status(&self) -> ConvertingReceiver<BufferStatus> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs485BrickletFunction::GetBufferStatus), payload)
    }

    /// Enables the [`get_error_count_callback_receiver`] receiver.
    ///
    /// By default the receiver is disabled.
    pub fn enable_error_count_callback(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Rs485BrickletFunction::EnableErrorCountCallback), payload)
    }

    /// Disables the [`get_error_count_callback_receiver`] receiver.
    ///
    /// By default the receiver is disabled.
    pub fn disable_error_count_callback(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Rs485BrickletFunction::DisableErrorCountCallback), payload)
    }

    /// Returns *true* if the [`get_error_count_callback_receiver`] receiver is enabled,
    /// *false* otherwise.
    pub fn is_error_count_callback_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs485BrickletFunction::IsErrorCountCallbackEnabled), payload)
    }

    /// Returns the current number of overrun and parity errors.
    pub fn get_error_count(&self) -> ConvertingReceiver<ErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs485BrickletFunction::GetErrorCount), payload)
    }

    /// Returns the current number of errors occurred in Modbus mode.
    ///
    /// * Timeout Error Count: Number of timeouts occurred.
    /// * Checksum Error Count: Number of failures due to Modbus frame CRC16 checksum mismatch.
    /// * Frame Too Big Error Count: Number of times frames were rejected because they exceeded maximum Modbus frame size which is 256 bytes.
    /// * Illegal Function Error Count: Number of errors when an unimplemented or illegal function is requested. This corresponds to Modbus exception code 1.
    /// * Illegal Data Address Error Count: Number of errors due to invalid data address. This corresponds to Modbus exception code 2.
    /// * Illegal Data Value Error Count: Number of errors due to invalid data value. This corresponds to Modbus exception code 3.
    /// * Slave Device Failure Error Count: Number of errors occurred on the slave device which were unrecoverable. This corresponds to Modbus exception code 4.
    pub fn get_modbus_common_error_count(&self) -> ConvertingReceiver<ModbusCommonErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs485BrickletFunction::GetModbusCommonErrorCount), payload)
    }

    /// In Modbus slave mode this function can be used to report a Modbus exception for
    /// a Modbus master request.
    ///
    /// * Request ID: Request ID of the request received by the slave.
    /// * Exception Code: Modbus exception code to report to the Modbus master.
    ///
    /// Associated constants:
    /// * RS485_BRICKLET_EXCEPTION_CODE_TIMEOUT
    ///	* RS485_BRICKLET_EXCEPTION_CODE_SUCCESS
    ///	* RS485_BRICKLET_EXCEPTION_CODE_ILLEGAL_FUNCTION
    ///	* RS485_BRICKLET_EXCEPTION_CODE_ILLEGAL_DATA_ADDRESS
    ///	* RS485_BRICKLET_EXCEPTION_CODE_ILLEGAL_DATA_VALUE
    ///	* RS485_BRICKLET_EXCEPTION_CODE_SLAVE_DEVICE_FAILURE
    ///	* RS485_BRICKLET_EXCEPTION_CODE_ACKNOWLEDGE
    ///	* RS485_BRICKLET_EXCEPTION_CODE_SLAVE_DEVICE_BUSY
    ///	* RS485_BRICKLET_EXCEPTION_CODE_MEMORY_PARITY_ERROR
    ///	* RS485_BRICKLET_EXCEPTION_CODE_GATEWAY_PATH_UNAVAILABLE
    ///	* RS485_BRICKLET_EXCEPTION_CODE_GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND
    pub fn modbus_slave_report_exception(&self, request_id: u8, exception_code: i8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(request_id));
        payload[1..2].copy_from_slice(&<i8>::to_le_byte_vec(exception_code));

        self.device.set(u8::from(Rs485BrickletFunction::ModbusSlaveReportException), payload)
    }

    /// In Modbus slave mode this function can be used to answer a master request to
    /// read coils.
    ///
    /// * Request ID: Request ID of the corresponding request that is being answered.
    /// * Coils: Data that is to be sent to the Modbus master for the corresponding request.
    ///
    /// This function must be called from the [`get_modbus_slave_read_coils_request_callback_receiver`] receiver
    /// with the Request ID as provided by the argument of the receiver.
    pub fn modbus_slave_answer_read_coils_request_low_level(
        &self,
        request_id: u8,
        coils_length: u16,
        coils_chunk_offset: u16,
        coils_chunk_data: [bool; 472],
    ) -> ConvertingReceiver<ModbusSlaveAnswerReadCoilsRequestLowLevel> {
        let mut payload = vec![0; 64];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(request_id));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(coils_length));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(coils_chunk_offset));
        payload[5..64].copy_from_slice(&<[bool; 472]>::to_le_byte_vec(coils_chunk_data));

        self.device.set(u8::from(Rs485BrickletFunction::ModbusSlaveAnswerReadCoilsRequestLowLevel), payload)
    }

    /// In Modbus slave mode this function can be used to answer a master request to
    /// read coils.
    ///
    /// * Request ID: Request ID of the corresponding request that is being answered.
    /// * Coils: Data that is to be sent to the Modbus master for the corresponding request.
    ///
    /// This function must be called from the [`get_modbus_slave_read_coils_request_callback_receiver`] receiver
    /// with the Request ID as provided by the argument of the receiver.
    pub fn modbus_slave_answer_read_coils_request(&self, request_id: u8, coils: &[bool]) -> Result<(), BrickletRecvTimeoutError> {
        let _ll_result = self.device.set_high_level(2, coils, 65535, 472, &mut |length: usize, chunk_offset: usize, chunk: &[bool]| {
            let chunk_length = chunk.len() as u16;
            let mut chunk_array = [<bool>::default(); 472];
            chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

            let result =
                self.modbus_slave_answer_read_coils_request_low_level(request_id, length as u16, chunk_offset as u16, chunk_array).recv();
            if let Err(BrickletRecvTimeoutError::SuccessButResponseExpectedIsDisabled) = result {
                Ok(Default::default())
            } else {
                result
            }
        })?;
        Ok(())
    }

    /// In Modbus master mode this function can be used to read coils from a slave. This
    /// function creates a Modbus function code 1 request.
    ///
    /// * Slave Address: Address of the target Modbus slave.
    /// * Starting Address: Number of the first coil to read. For backwards compatibility reasons this parameter is called Starting Address. It is not an address, but instead a coil number in the range of 1 to 65536.
    /// * Count: Number of coils to read.
    ///
    /// Upon success the function will return a non-zero request ID which will represent
    /// the current request initiated by the Modbus master. In case of failure the returned
    /// request ID will be 0.
    ///
    /// When successful this function will also invoke the [`get_modbus_master_read_coils_response_callback_receiver`]
    /// callback. In this receiver the Request ID provided by the receiver argument must be
    /// matched with the Request ID returned from this function to verify that the receiver
    /// is indeed for a particular request.
    pub fn modbus_master_read_coils(&self, slave_address: u8, starting_address: u32, count: u16) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 7];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(slave_address));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(starting_address));
        payload[5..7].copy_from_slice(&<u16>::to_le_byte_vec(count));

        self.device.get(u8::from(Rs485BrickletFunction::ModbusMasterReadCoils), payload)
    }

    /// In Modbus slave mode this function can be used to answer a master request to
    /// read holding registers.
    ///
    /// * Request ID: Request ID of the corresponding request that is being answered.
    /// * Holding Registers: Data that is to be sent to the Modbus master for the corresponding request.
    ///
    /// This function must be called from the [`get_modbus_slave_read_holding_registers_request_callback_receiver`]
    /// receiver with the Request ID as provided by the argument of the receiver.
    pub fn modbus_slave_answer_read_holding_registers_request_low_level(
        &self,
        request_id: u8,
        holding_registers_length: u16,
        holding_registers_chunk_offset: u16,
        holding_registers_chunk_data: [u16; 29],
    ) -> ConvertingReceiver<ModbusSlaveAnswerReadHoldingRegistersRequestLowLevel> {
        let mut payload = vec![0; 63];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(request_id));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(holding_registers_length));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(holding_registers_chunk_offset));
        payload[5..63].copy_from_slice(&<[u16; 29]>::to_le_byte_vec(holding_registers_chunk_data));

        self.device.set(u8::from(Rs485BrickletFunction::ModbusSlaveAnswerReadHoldingRegistersRequestLowLevel), payload)
    }

    /// In Modbus slave mode this function can be used to answer a master request to
    /// read holding registers.
    ///
    /// * Request ID: Request ID of the corresponding request that is being answered.
    /// * Holding Registers: Data that is to be sent to the Modbus master for the corresponding request.
    ///
    /// This function must be called from the [`get_modbus_slave_read_holding_registers_request_callback_receiver`]
    /// receiver with the Request ID as provided by the argument of the receiver.
    pub fn modbus_slave_answer_read_holding_registers_request(
        &self,
        request_id: u8,
        holding_registers: &[u16],
    ) -> Result<(), BrickletRecvTimeoutError> {
        let _ll_result =
            self.device.set_high_level(3, holding_registers, 65535, 29, &mut |length: usize, chunk_offset: usize, chunk: &[u16]| {
                let chunk_length = chunk.len() as u16;
                let mut chunk_array = [<u16>::default(); 29];
                chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

                let result = self
                    .modbus_slave_answer_read_holding_registers_request_low_level(
                        request_id,
                        length as u16,
                        chunk_offset as u16,
                        chunk_array,
                    )
                    .recv();
                if let Err(BrickletRecvTimeoutError::SuccessButResponseExpectedIsDisabled) = result {
                    Ok(Default::default())
                } else {
                    result
                }
            })?;
        Ok(())
    }

    /// In Modbus master mode this function can be used to read holding registers from a slave.
    /// This function creates a Modbus function code 3 request.
    ///
    /// * Slave Address: Address of the target Modbus slave.
    /// * Starting Address: Number of the first holding register to read. For backwards compatibility reasons this parameter is called Starting Address. It is not an address, but instead a holding register number in the range of 1 to 65536. The prefix digit 4 (for holding register) is implicit and must be omitted.
    /// * Count: Number of holding registers to read.
    ///
    /// Upon success the function will return a non-zero request ID which will represent
    /// the current request initiated by the Modbus master. In case of failure the returned
    /// request ID will be 0.
    ///
    /// When successful this function will also invoke the [`get_modbus_master_read_holding_registers_response_callback_receiver`]
    /// callback. In this receiver the Request ID provided by the receiver argument must be matched
    /// with the Request ID returned from this function to verify that the receiver is indeed for a
    /// particular request.
    pub fn modbus_master_read_holding_registers(&self, slave_address: u8, starting_address: u32, count: u16) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 7];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(slave_address));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(starting_address));
        payload[5..7].copy_from_slice(&<u16>::to_le_byte_vec(count));

        self.device.get(u8::from(Rs485BrickletFunction::ModbusMasterReadHoldingRegisters), payload)
    }

    /// In Modbus slave mode this function can be used to answer a master request to
    /// write a single coil.
    ///
    /// * Request ID: Request ID of the corresponding request that is being answered.
    ///
    /// This function must be called from the [`get_modbus_slave_write_single_coil_request_callback_receiver`]
    /// receiver with the Request ID as provided by the arguments of the receiver.
    pub fn modbus_slave_answer_write_single_coil_request(&self, request_id: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(request_id));

        self.device.set(u8::from(Rs485BrickletFunction::ModbusSlaveAnswerWriteSingleCoilRequest), payload)
    }

    /// In Modbus master mode this function can be used to write a single coil of a slave.
    /// This function creates a Modbus function code 5 request.
    ///
    /// * Slave Address: Address of the target Modbus slave.
    /// * Coil Address: Number of the coil to be written. For backwards compatibility reasons, this parameter is called Starting Address. It is not an address, but instead a coil number in the range of 1 to 65536.
    /// * Coil Value: Value to be written.
    ///
    /// Upon success the function will return a non-zero request ID which will represent
    /// the current request initiated by the Modbus master. In case of failure the returned
    /// request ID will be 0.
    ///
    /// When successful this function will also invoke the [`get_modbus_master_write_single_coil_response_callback_receiver`]
    /// callback. In this receiver the Request ID provided by the receiver argument must be matched
    /// with the Request ID returned from this function to verify that the receiver is indeed for a
    /// particular request.
    pub fn modbus_master_write_single_coil(&self, slave_address: u8, coil_address: u32, coil_value: bool) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 6];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(slave_address));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(coil_address));
        payload[5..6].copy_from_slice(&<bool>::to_le_byte_vec(coil_value));

        self.device.get(u8::from(Rs485BrickletFunction::ModbusMasterWriteSingleCoil), payload)
    }

    /// In Modbus slave mode this function can be used to answer a master request to
    /// write a single register.
    ///
    /// * Request ID: Request ID of the corresponding request that is being answered.
    ///
    /// This function must be called from the [`get_modbus_slave_write_single_register_request_callback_receiver`]
    /// receiver with the Request ID, Register Address and Register Value as provided by
    /// the arguments of the receiver.
    pub fn modbus_slave_answer_write_single_register_request(&self, request_id: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(request_id));

        self.device.set(u8::from(Rs485BrickletFunction::ModbusSlaveAnswerWriteSingleRegisterRequest), payload)
    }

    /// In Modbus master mode this function can be used to write a single holding register of a
    /// slave. This function creates a Modbus function code 6 request.
    ///
    /// * Slave Address: Address of the target Modbus slave.
    /// * Register Address: Number of the holding register to be written. For backwards compatibility reasons, this parameter is called Starting Address. It is not an address, but instead a holding register number in the range of 1 to 65536. The prefix digit 4 (for holding register) is implicit and must be omitted.
    /// * Register Value: Value to be written.
    ///
    /// Upon success the function will return a non-zero request ID which will represent
    /// the current request initiated by the Modbus master. In case of failure the returned
    /// request ID will be 0.
    ///
    /// When successful this function will also invoke the [`get_modbus_master_write_single_register_response_callback_receiver`]
    /// callback. In this receiver the Request ID provided by the receiver argument must be matched
    /// with the Request ID returned from this function to verify that the receiver is indeed for a
    /// particular request.
    pub fn modbus_master_write_single_register(
        &self,
        slave_address: u8,
        register_address: u32,
        register_value: u16,
    ) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 7];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(slave_address));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(register_address));
        payload[5..7].copy_from_slice(&<u16>::to_le_byte_vec(register_value));

        self.device.get(u8::from(Rs485BrickletFunction::ModbusMasterWriteSingleRegister), payload)
    }

    /// In Modbus slave mode this function can be used to answer a master request to
    /// write multiple coils.
    ///
    /// * Request ID: Request ID of the corresponding request that is being answered.
    ///
    /// This function must be called from the [`get_modbus_slave_write_multiple_coils_request_callback_receiver`]
    /// receiver with the Request ID of the receiver.
    pub fn modbus_slave_answer_write_multiple_coils_request(&self, request_id: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(request_id));

        self.device.set(u8::from(Rs485BrickletFunction::ModbusSlaveAnswerWriteMultipleCoilsRequest), payload)
    }

    /// In Modbus master mode this function can be used to write multiple coils of a slave.
    /// This function creates a Modbus function code 15 request.
    ///
    /// * Slave Address: Address of the target Modbus slave.
    /// * Starting Address: Number of the first coil to write. For backwards compatibility reasons, this parameter is called Starting Address.It is not an address, but instead a coil number in the range of 1 to 65536.
    ///
    /// Upon success the function will return a non-zero request ID which will represent
    /// the current request initiated by the Modbus master. In case of failure the returned
    /// request ID will be 0.
    ///
    /// When successful this function will also invoke the [`get_modbus_master_write_multiple_coils_response_callback_receiver`]
    /// callback. In this receiver the Request ID provided by the receiver argument must be matched
    /// with the Request ID returned from this function to verify that the receiver is indeed for a
    /// particular request.
    pub fn modbus_master_write_multiple_coils_low_level(
        &self,
        slave_address: u8,
        starting_address: u32,
        coils_length: u16,
        coils_chunk_offset: u16,
        coils_chunk_data: [bool; 440],
    ) -> ConvertingReceiver<ModbusMasterWriteMultipleCoilsLowLevel> {
        let mut payload = vec![0; 64];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(slave_address));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(starting_address));
        payload[5..7].copy_from_slice(&<u16>::to_le_byte_vec(coils_length));
        payload[7..9].copy_from_slice(&<u16>::to_le_byte_vec(coils_chunk_offset));
        payload[9..64].copy_from_slice(&<[bool; 440]>::to_le_byte_vec(coils_chunk_data));

        self.device.get(u8::from(Rs485BrickletFunction::ModbusMasterWriteMultipleCoilsLowLevel), payload)
    }

    /// In Modbus master mode this function can be used to write multiple coils of a slave.
    /// This function creates a Modbus function code 15 request.
    ///
    /// * Slave Address: Address of the target Modbus slave.
    /// * Starting Address: Number of the first coil to write. For backwards compatibility reasons, this parameter is called Starting Address.It is not an address, but instead a coil number in the range of 1 to 65536.
    ///
    /// Upon success the function will return a non-zero request ID which will represent
    /// the current request initiated by the Modbus master. In case of failure the returned
    /// request ID will be 0.
    ///
    /// When successful this function will also invoke the [`get_modbus_master_write_multiple_coils_response_callback_receiver`]
    /// callback. In this receiver the Request ID provided by the receiver argument must be matched
    /// with the Request ID returned from this function to verify that the receiver is indeed for a
    /// particular request.
    pub fn modbus_master_write_multiple_coils(
        &self,
        slave_address: u8,
        starting_address: u32,
        coils: &[bool],
    ) -> Result<u8, BrickletRecvTimeoutError> {
        let ll_result = self.device.set_high_level(4, coils, 65535, 440, &mut |length: usize, chunk_offset: usize, chunk: &[bool]| {
            let chunk_length = chunk.len() as u16;
            let mut chunk_array = [<bool>::default(); 440];
            chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

            self.modbus_master_write_multiple_coils_low_level(
                slave_address,
                starting_address,
                length as u16,
                chunk_offset as u16,
                chunk_array,
            )
            .recv()
        })?;
        Ok(ll_result.1.request_id)
    }

    /// In Modbus slave mode this function can be used to answer a master request to
    /// write multiple registers.
    ///
    /// * Request ID: Request ID of the corresponding request that is being answered.
    ///
    /// This function must be called from the [`get_modbus_slave_write_multiple_registers_request_callback_receiver`]
    /// receiver with the Request ID of the receiver.
    pub fn modbus_slave_answer_write_multiple_registers_request(&self, request_id: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(request_id));

        self.device.set(u8::from(Rs485BrickletFunction::ModbusSlaveAnswerWriteMultipleRegistersRequest), payload)
    }

    /// In Modbus master mode this function can be used to write multiple registers of a slave.
    /// This function creates a Modbus function code 16 request.
    ///
    /// * Slave Address: Address of the target Modbus slave.
    /// * Starting Address: Number of the first holding register to write. For backwards compatibility reasons, this parameter is called Starting Address. It is not an address, but instead a holding register number in the range of 1 to 65536. The prefix digit 4 (for holding register) is implicit and must be omitted.
    ///
    /// Upon success the function will return a non-zero request ID which will represent
    /// the current request initiated by the Modbus master. In case of failure the returned
    /// request ID will be 0.
    ///
    /// When successful this function will also invoke the [`get_modbus_master_write_multiple_registers_response_callback_receiver`]
    /// callback. In this receiver the Request ID provided by the receiver argument must be matched
    /// with the Request ID returned from this function to verify that the receiver is indeed for a
    /// particular request.
    pub fn modbus_master_write_multiple_registers_low_level(
        &self,
        slave_address: u8,
        starting_address: u32,
        registers_length: u16,
        registers_chunk_offset: u16,
        registers_chunk_data: [u16; 27],
    ) -> ConvertingReceiver<ModbusMasterWriteMultipleRegistersLowLevel> {
        let mut payload = vec![0; 63];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(slave_address));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(starting_address));
        payload[5..7].copy_from_slice(&<u16>::to_le_byte_vec(registers_length));
        payload[7..9].copy_from_slice(&<u16>::to_le_byte_vec(registers_chunk_offset));
        payload[9..63].copy_from_slice(&<[u16; 27]>::to_le_byte_vec(registers_chunk_data));

        self.device.get(u8::from(Rs485BrickletFunction::ModbusMasterWriteMultipleRegistersLowLevel), payload)
    }

    /// In Modbus master mode this function can be used to write multiple registers of a slave.
    /// This function creates a Modbus function code 16 request.
    ///
    /// * Slave Address: Address of the target Modbus slave.
    /// * Starting Address: Number of the first holding register to write. For backwards compatibility reasons, this parameter is called Starting Address. It is not an address, but instead a holding register number in the range of 1 to 65536. The prefix digit 4 (for holding register) is implicit and must be omitted.
    ///
    /// Upon success the function will return a non-zero request ID which will represent
    /// the current request initiated by the Modbus master. In case of failure the returned
    /// request ID will be 0.
    ///
    /// When successful this function will also invoke the [`get_modbus_master_write_multiple_registers_response_callback_receiver`]
    /// callback. In this receiver the Request ID provided by the receiver argument must be matched
    /// with the Request ID returned from this function to verify that the receiver is indeed for a
    /// particular request.
    pub fn modbus_master_write_multiple_registers(
        &self,
        slave_address: u8,
        starting_address: u32,
        registers: &[u16],
    ) -> Result<u8, BrickletRecvTimeoutError> {
        let ll_result = self.device.set_high_level(5, registers, 65535, 27, &mut |length: usize, chunk_offset: usize, chunk: &[u16]| {
            let chunk_length = chunk.len() as u16;
            let mut chunk_array = [<u16>::default(); 27];
            chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

            self.modbus_master_write_multiple_registers_low_level(
                slave_address,
                starting_address,
                length as u16,
                chunk_offset as u16,
                chunk_array,
            )
            .recv()
        })?;
        Ok(ll_result.1.request_id)
    }

    /// In Modbus slave mode this function can be used to answer a master request to
    /// read discrete inputs.
    ///
    /// * Request ID: Request ID of the corresponding request that is being answered.
    /// * Discrete Inputs: Data that is to be sent to the Modbus master for the corresponding request.
    ///
    /// This function must be called from the [`get_modbus_slave_read_discrete_inputs_request_callback_receiver`]
    /// receiver with the Request ID as provided by the argument of the receiver.
    pub fn modbus_slave_answer_read_discrete_inputs_request_low_level(
        &self,
        request_id: u8,
        discrete_inputs_length: u16,
        discrete_inputs_chunk_offset: u16,
        discrete_inputs_chunk_data: [bool; 472],
    ) -> ConvertingReceiver<ModbusSlaveAnswerReadDiscreteInputsRequestLowLevel> {
        let mut payload = vec![0; 64];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(request_id));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(discrete_inputs_length));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(discrete_inputs_chunk_offset));
        payload[5..64].copy_from_slice(&<[bool; 472]>::to_le_byte_vec(discrete_inputs_chunk_data));

        self.device.set(u8::from(Rs485BrickletFunction::ModbusSlaveAnswerReadDiscreteInputsRequestLowLevel), payload)
    }

    /// In Modbus slave mode this function can be used to answer a master request to
    /// read discrete inputs.
    ///
    /// * Request ID: Request ID of the corresponding request that is being answered.
    /// * Discrete Inputs: Data that is to be sent to the Modbus master for the corresponding request.
    ///
    /// This function must be called from the [`get_modbus_slave_read_discrete_inputs_request_callback_receiver`]
    /// receiver with the Request ID as provided by the argument of the receiver.
    pub fn modbus_slave_answer_read_discrete_inputs_request(
        &self,
        request_id: u8,
        discrete_inputs: &[bool],
    ) -> Result<(), BrickletRecvTimeoutError> {
        let _ll_result =
            self.device.set_high_level(6, discrete_inputs, 65535, 472, &mut |length: usize, chunk_offset: usize, chunk: &[bool]| {
                let chunk_length = chunk.len() as u16;
                let mut chunk_array = [<bool>::default(); 472];
                chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

                let result = self
                    .modbus_slave_answer_read_discrete_inputs_request_low_level(request_id, length as u16, chunk_offset as u16, chunk_array)
                    .recv();
                if let Err(BrickletRecvTimeoutError::SuccessButResponseExpectedIsDisabled) = result {
                    Ok(Default::default())
                } else {
                    result
                }
            })?;
        Ok(())
    }

    /// In Modbus master mode this function can be used to read discrete inputs from a slave.
    /// This function creates a Modbus function code 2 request.
    ///
    /// * Slave Address: Address of the target Modbus slave.
    /// * Starting Address: Number of the first discrete input to read. For backwards compatibility reasons, this parameter is called Starting Address. It is not an address, but instead a discrete input number in the range of 1 to 65536. The prefix digit 1 (for discrete input) is implicit and must be omitted.
    /// * Count: Number of discrete inputs to read.
    ///
    /// Upon success the function will return a non-zero request ID which will represent
    /// the current request initiated by the Modbus master. In case of failure the returned
    /// request ID will be 0.
    ///
    /// When successful this function will also invoke the [`get_modbus_master_read_discrete_inputs_response_callback_receiver`]
    /// callback. In this receiver the Request ID provided by the receiver argument must be matched
    /// with the Request ID returned from this function to verify that the receiver is indeed for a
    /// particular request.
    pub fn modbus_master_read_discrete_inputs(&self, slave_address: u8, starting_address: u32, count: u16) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 7];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(slave_address));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(starting_address));
        payload[5..7].copy_from_slice(&<u16>::to_le_byte_vec(count));

        self.device.get(u8::from(Rs485BrickletFunction::ModbusMasterReadDiscreteInputs), payload)
    }

    /// In Modbus slave mode this function can be used to answer a master request to
    /// read input registers.
    ///
    /// * Request ID: Request ID of the corresponding request that is being answered.
    /// * Input Registers: Data that is to be sent to the Modbus master for the corresponding request.
    ///
    /// This function must be called from the [`get_modbus_slave_read_input_registers_request_callback_receiver`] receiver
    /// with the Request ID as provided by the argument of the receiver.
    pub fn modbus_slave_answer_read_input_registers_request_low_level(
        &self,
        request_id: u8,
        input_registers_length: u16,
        input_registers_chunk_offset: u16,
        input_registers_chunk_data: [u16; 29],
    ) -> ConvertingReceiver<ModbusSlaveAnswerReadInputRegistersRequestLowLevel> {
        let mut payload = vec![0; 63];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(request_id));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(input_registers_length));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(input_registers_chunk_offset));
        payload[5..63].copy_from_slice(&<[u16; 29]>::to_le_byte_vec(input_registers_chunk_data));

        self.device.set(u8::from(Rs485BrickletFunction::ModbusSlaveAnswerReadInputRegistersRequestLowLevel), payload)
    }

    /// In Modbus slave mode this function can be used to answer a master request to
    /// read input registers.
    ///
    /// * Request ID: Request ID of the corresponding request that is being answered.
    /// * Input Registers: Data that is to be sent to the Modbus master for the corresponding request.
    ///
    /// This function must be called from the [`get_modbus_slave_read_input_registers_request_callback_receiver`] receiver
    /// with the Request ID as provided by the argument of the receiver.
    pub fn modbus_slave_answer_read_input_registers_request(
        &self,
        request_id: u8,
        input_registers: &[u16],
    ) -> Result<(), BrickletRecvTimeoutError> {
        let _ll_result =
            self.device.set_high_level(7, input_registers, 65535, 29, &mut |length: usize, chunk_offset: usize, chunk: &[u16]| {
                let chunk_length = chunk.len() as u16;
                let mut chunk_array = [<u16>::default(); 29];
                chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

                let result = self
                    .modbus_slave_answer_read_input_registers_request_low_level(request_id, length as u16, chunk_offset as u16, chunk_array)
                    .recv();
                if let Err(BrickletRecvTimeoutError::SuccessButResponseExpectedIsDisabled) = result {
                    Ok(Default::default())
                } else {
                    result
                }
            })?;
        Ok(())
    }

    /// In Modbus master mode this function can be used to read input registers from a slave.
    /// This function creates a Modbus function code 4 request.
    ///
    /// * Slave Address: Address of the target Modbus slave.
    /// * Starting Address: Number of the first input register to read. For backwards compatibility reasons, this parameter is called Starting Address. It is not an address, but instead an input register number in the range of 1 to 65536. The prefix digit 3 (for input register) is implicit and must be omitted.
    /// * Count: Number of input registers to read.
    ///
    /// Upon success the function will return a non-zero request ID which will represent
    /// the current request initiated by the Modbus master. In case of failure the returned
    /// request ID will be 0.
    ///
    /// When successful this function will also invoke the [`get_modbus_master_read_input_registers_response_callback_receiver`]
    /// callback. In this receiver the Request ID provided by the receiver argument must be matched
    /// with the Request ID returned from this function to verify that the receiver is indeed for a
    /// particular request.
    pub fn modbus_master_read_input_registers(&self, slave_address: u8, starting_address: u32, count: u16) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 7];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(slave_address));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(starting_address));
        payload[5..7].copy_from_slice(&<u16>::to_le_byte_vec(count));

        self.device.get(u8::from(Rs485BrickletFunction::ModbusMasterReadInputRegisters), payload)
    }

    /// Configures the [`get_frame_readable_callback_receiver`] receiver. The frame size is the number of bytes, that have to be readable to trigger the receiver.
    /// A frame size of 0 disables the receiver. A frame size greater than 0 enables the receiver and disables the [`get_read_callback_receiver`] receiver.
    ///
    /// By default the receiver is disabled.
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Plugin)
    pub fn set_frame_readable_callback_configuration(&self, frame_size: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(frame_size));

        self.device.set(u8::from(Rs485BrickletFunction::SetFrameReadableCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_frame_readable_callback_configuration`].
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Plugin)
    pub fn get_frame_readable_callback_configuration(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs485BrickletFunction::GetFrameReadableCallbackConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs485BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * RS485_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* RS485_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* RS485_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* RS485_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* RS485_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* RS485_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* RS485_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* RS485_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* RS485_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* RS485_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* RS485_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(Rs485BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * RS485_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* RS485_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* RS485_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* RS485_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* RS485_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs485BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(Rs485BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(Rs485BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * RS485_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* RS485_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* RS485_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* RS485_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(Rs485BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * RS485_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* RS485_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* RS485_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* RS485_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs485BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs485BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Rs485BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(Rs485BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs485BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs485BrickletFunction::GetIdentity), payload)
    }
}
