/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! 360° rotary encoder with push-button.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/RotaryEncoderV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum RotaryEncoderV2BrickletFunction {
    GetCount,
    SetCountCallbackConfiguration,
    GetCountCallbackConfiguration,
    IsPressed,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackCount,
    CallbackPressed,
    CallbackReleased,
}
impl From<RotaryEncoderV2BrickletFunction> for u8 {
    fn from(fun: RotaryEncoderV2BrickletFunction) -> Self {
        match fun {
            RotaryEncoderV2BrickletFunction::GetCount => 1,
            RotaryEncoderV2BrickletFunction::SetCountCallbackConfiguration => 2,
            RotaryEncoderV2BrickletFunction::GetCountCallbackConfiguration => 3,
            RotaryEncoderV2BrickletFunction::IsPressed => 5,
            RotaryEncoderV2BrickletFunction::GetSpitfpErrorCount => 234,
            RotaryEncoderV2BrickletFunction::SetBootloaderMode => 235,
            RotaryEncoderV2BrickletFunction::GetBootloaderMode => 236,
            RotaryEncoderV2BrickletFunction::SetWriteFirmwarePointer => 237,
            RotaryEncoderV2BrickletFunction::WriteFirmware => 238,
            RotaryEncoderV2BrickletFunction::SetStatusLedConfig => 239,
            RotaryEncoderV2BrickletFunction::GetStatusLedConfig => 240,
            RotaryEncoderV2BrickletFunction::GetChipTemperature => 242,
            RotaryEncoderV2BrickletFunction::Reset => 243,
            RotaryEncoderV2BrickletFunction::WriteUid => 248,
            RotaryEncoderV2BrickletFunction::ReadUid => 249,
            RotaryEncoderV2BrickletFunction::GetIdentity => 255,
            RotaryEncoderV2BrickletFunction::CallbackCount => 4,
            RotaryEncoderV2BrickletFunction::CallbackPressed => 6,
            RotaryEncoderV2BrickletFunction::CallbackReleased => 7,
        }
    }
}
pub const ROTARY_ENCODER_V2_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const ROTARY_ENCODER_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const ROTARY_ENCODER_V2_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const ROTARY_ENCODER_V2_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const ROTARY_ENCODER_V2_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const ROTARY_ENCODER_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const ROTARY_ENCODER_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const ROTARY_ENCODER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const ROTARY_ENCODER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CountCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for CountCallbackConfiguration {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> CountCallbackConfiguration {
        CountCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <i32>::from_le_byte_slice(&bytes[6..10]),
            max: <i32>::from_le_byte_slice(&bytes[10..14]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// 360° rotary encoder with push-button
#[derive(Clone)]
pub struct RotaryEncoderV2Bricklet {
    device: Device,
}
impl RotaryEncoderV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 294;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Rotary Encoder Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> RotaryEncoderV2Bricklet {
        let mut result = RotaryEncoderV2Bricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(RotaryEncoderV2BrickletFunction::GetCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RotaryEncoderV2BrickletFunction::SetCountCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(RotaryEncoderV2BrickletFunction::GetCountCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RotaryEncoderV2BrickletFunction::IsPressed) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RotaryEncoderV2BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RotaryEncoderV2BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RotaryEncoderV2BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RotaryEncoderV2BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RotaryEncoderV2BrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RotaryEncoderV2BrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RotaryEncoderV2BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RotaryEncoderV2BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RotaryEncoderV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RotaryEncoderV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RotaryEncoderV2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RotaryEncoderV2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::rotary_encoder_v2_bricklet::RotaryEncoderV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::rotary_encoder_v2_bricklet::RotaryEncoderV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: RotaryEncoderV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: RotaryEncoderV2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_count_callback_configuration`].
    ///
    /// The parameter is the same as [`get_count`].
    ///
    /// [`get_count`]: #method.get_count
    /// [`set_count_callback_configuration`]: #method.set_count_callback_configuration
    pub fn get_count_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(RotaryEncoderV2BrickletFunction::CallbackCount))
    }

    /// This receiver is triggered when the button is pressed.
    pub fn get_pressed_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(RotaryEncoderV2BrickletFunction::CallbackPressed))
    }

    /// This receiver is triggered when the button is released.
    pub fn get_released_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(RotaryEncoderV2BrickletFunction::CallbackReleased))
    }

    /// Returns the current count of the encoder. If you set reset
    /// to true, the count is set back to 0 directly after the
    /// current count is read.
    ///
    /// The encoder has 24 steps per rotation.
    ///
    /// Turning the encoder to the left decrements the counter,
    /// so a negative count is possible.
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_count_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_count_callback_configuration`].
    pub fn get_count(&self, reset: bool) -> ConvertingReceiver<i32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(reset));

        self.device.get(u8::from(RotaryEncoderV2BrickletFunction::GetCount), payload)
    }

    /// The period is the period with which the [`get_count_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_count_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * ROTARY_ENCODER_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* ROTARY_ENCODER_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* ROTARY_ENCODER_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* ROTARY_ENCODER_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* ROTARY_ENCODER_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_count_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: i32,
        max: i32,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 14];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..10].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[10..14].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(RotaryEncoderV2BrickletFunction::SetCountCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_count_callback_configuration`].
    ///
    /// Associated constants:
    /// * ROTARY_ENCODER_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* ROTARY_ENCODER_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* ROTARY_ENCODER_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* ROTARY_ENCODER_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* ROTARY_ENCODER_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_count_callback_configuration(&self) -> ConvertingReceiver<CountCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RotaryEncoderV2BrickletFunction::GetCountCallbackConfiguration), payload)
    }

    /// Returns *true* if the button is pressed and *false* otherwise.
    ///
    /// It is recommended to use the [`get_pressed_callback_receiver`] and [`get_released_callback_receiver`] receivers
    /// to handle the button.
    pub fn is_pressed(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RotaryEncoderV2BrickletFunction::IsPressed), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RotaryEncoderV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(RotaryEncoderV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* ROTARY_ENCODER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RotaryEncoderV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(RotaryEncoderV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(RotaryEncoderV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * ROTARY_ENCODER_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* ROTARY_ENCODER_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* ROTARY_ENCODER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* ROTARY_ENCODER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(RotaryEncoderV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * ROTARY_ENCODER_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* ROTARY_ENCODER_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* ROTARY_ENCODER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* ROTARY_ENCODER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RotaryEncoderV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RotaryEncoderV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(RotaryEncoderV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(RotaryEncoderV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RotaryEncoderV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RotaryEncoderV2BrickletFunction::GetIdentity), payload)
    }
}
