/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Controls remote mains switches and receives signals from remotes.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/RemoteSwitchV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum RemoteSwitchV2BrickletFunction {
    GetSwitchingState,
    SetRepeats,
    GetRepeats,
    SwitchSocketA,
    SwitchSocketB,
    DimSocketB,
    SwitchSocketC,
    SetRemoteConfiguration,
    GetRemoteConfiguration,
    GetRemoteStatusA,
    GetRemoteStatusB,
    GetRemoteStatusC,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackSwitchingDone,
    CallbackRemoteStatusA,
    CallbackRemoteStatusB,
    CallbackRemoteStatusC,
}
impl From<RemoteSwitchV2BrickletFunction> for u8 {
    fn from(fun: RemoteSwitchV2BrickletFunction) -> Self {
        match fun {
            RemoteSwitchV2BrickletFunction::GetSwitchingState => 1,
            RemoteSwitchV2BrickletFunction::SetRepeats => 3,
            RemoteSwitchV2BrickletFunction::GetRepeats => 4,
            RemoteSwitchV2BrickletFunction::SwitchSocketA => 5,
            RemoteSwitchV2BrickletFunction::SwitchSocketB => 6,
            RemoteSwitchV2BrickletFunction::DimSocketB => 7,
            RemoteSwitchV2BrickletFunction::SwitchSocketC => 8,
            RemoteSwitchV2BrickletFunction::SetRemoteConfiguration => 9,
            RemoteSwitchV2BrickletFunction::GetRemoteConfiguration => 10,
            RemoteSwitchV2BrickletFunction::GetRemoteStatusA => 11,
            RemoteSwitchV2BrickletFunction::GetRemoteStatusB => 12,
            RemoteSwitchV2BrickletFunction::GetRemoteStatusC => 13,
            RemoteSwitchV2BrickletFunction::GetSpitfpErrorCount => 234,
            RemoteSwitchV2BrickletFunction::SetBootloaderMode => 235,
            RemoteSwitchV2BrickletFunction::GetBootloaderMode => 236,
            RemoteSwitchV2BrickletFunction::SetWriteFirmwarePointer => 237,
            RemoteSwitchV2BrickletFunction::WriteFirmware => 238,
            RemoteSwitchV2BrickletFunction::SetStatusLedConfig => 239,
            RemoteSwitchV2BrickletFunction::GetStatusLedConfig => 240,
            RemoteSwitchV2BrickletFunction::GetChipTemperature => 242,
            RemoteSwitchV2BrickletFunction::Reset => 243,
            RemoteSwitchV2BrickletFunction::WriteUid => 248,
            RemoteSwitchV2BrickletFunction::ReadUid => 249,
            RemoteSwitchV2BrickletFunction::GetIdentity => 255,
            RemoteSwitchV2BrickletFunction::CallbackSwitchingDone => 2,
            RemoteSwitchV2BrickletFunction::CallbackRemoteStatusA => 14,
            RemoteSwitchV2BrickletFunction::CallbackRemoteStatusB => 15,
            RemoteSwitchV2BrickletFunction::CallbackRemoteStatusC => 16,
        }
    }
}
pub const REMOTE_SWITCH_V2_BRICKLET_SWITCHING_STATE_READY: u8 = 0;
pub const REMOTE_SWITCH_V2_BRICKLET_SWITCHING_STATE_BUSY: u8 = 1;
pub const REMOTE_SWITCH_V2_BRICKLET_SWITCH_TO_OFF: u8 = 0;
pub const REMOTE_SWITCH_V2_BRICKLET_SWITCH_TO_ON: u8 = 1;
pub const REMOTE_SWITCH_V2_BRICKLET_REMOTE_TYPE_A: u8 = 0;
pub const REMOTE_SWITCH_V2_BRICKLET_REMOTE_TYPE_B: u8 = 1;
pub const REMOTE_SWITCH_V2_BRICKLET_REMOTE_TYPE_C: u8 = 2;
pub const REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const REMOTE_SWITCH_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const REMOTE_SWITCH_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const REMOTE_SWITCH_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const REMOTE_SWITCH_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct RemoteConfiguration {
    pub remote_type: u8,
    pub minimum_repeats: u16,
    pub callback_enabled: bool,
}
impl FromByteSlice for RemoteConfiguration {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> RemoteConfiguration {
        RemoteConfiguration {
            remote_type: <u8>::from_le_byte_slice(&bytes[0..1]),
            minimum_repeats: <u16>::from_le_byte_slice(&bytes[1..3]),
            callback_enabled: <bool>::from_le_byte_slice(&bytes[3..4]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct RemoteStatusA {
    pub house_code: u8,
    pub receiver_code: u8,
    pub switch_to: u8,
    pub repeats: u16,
}
impl FromByteSlice for RemoteStatusA {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> RemoteStatusA {
        RemoteStatusA {
            house_code: <u8>::from_le_byte_slice(&bytes[0..1]),
            receiver_code: <u8>::from_le_byte_slice(&bytes[1..2]),
            switch_to: <u8>::from_le_byte_slice(&bytes[2..3]),
            repeats: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct RemoteStatusB {
    pub address: u32,
    pub unit: u8,
    pub switch_to: u8,
    pub dim_value: u8,
    pub repeats: u16,
}
impl FromByteSlice for RemoteStatusB {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> RemoteStatusB {
        RemoteStatusB {
            address: <u32>::from_le_byte_slice(&bytes[0..4]),
            unit: <u8>::from_le_byte_slice(&bytes[4..5]),
            switch_to: <u8>::from_le_byte_slice(&bytes[5..6]),
            dim_value: <u8>::from_le_byte_slice(&bytes[6..7]),
            repeats: <u16>::from_le_byte_slice(&bytes[7..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct RemoteStatusC {
    pub system_code: char,
    pub device_code: u8,
    pub switch_to: u8,
    pub repeats: u16,
}
impl FromByteSlice for RemoteStatusC {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> RemoteStatusC {
        RemoteStatusC {
            system_code: <char>::from_le_byte_slice(&bytes[0..1]),
            device_code: <u8>::from_le_byte_slice(&bytes[1..2]),
            switch_to: <u8>::from_le_byte_slice(&bytes[2..3]),
            repeats: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct RemoteStatusAEvent {
    pub house_code: u8,
    pub receiver_code: u8,
    pub switch_to: u8,
    pub repeats: u16,
}
impl FromByteSlice for RemoteStatusAEvent {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> RemoteStatusAEvent {
        RemoteStatusAEvent {
            house_code: <u8>::from_le_byte_slice(&bytes[0..1]),
            receiver_code: <u8>::from_le_byte_slice(&bytes[1..2]),
            switch_to: <u8>::from_le_byte_slice(&bytes[2..3]),
            repeats: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct RemoteStatusBEvent {
    pub address: u32,
    pub unit: u8,
    pub switch_to: u8,
    pub dim_value: u8,
    pub repeats: u16,
}
impl FromByteSlice for RemoteStatusBEvent {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> RemoteStatusBEvent {
        RemoteStatusBEvent {
            address: <u32>::from_le_byte_slice(&bytes[0..4]),
            unit: <u8>::from_le_byte_slice(&bytes[4..5]),
            switch_to: <u8>::from_le_byte_slice(&bytes[5..6]),
            dim_value: <u8>::from_le_byte_slice(&bytes[6..7]),
            repeats: <u16>::from_le_byte_slice(&bytes[7..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct RemoteStatusCEvent {
    pub system_code: char,
    pub device_code: u8,
    pub switch_to: u8,
    pub repeats: u16,
}
impl FromByteSlice for RemoteStatusCEvent {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> RemoteStatusCEvent {
        RemoteStatusCEvent {
            system_code: <char>::from_le_byte_slice(&bytes[0..1]),
            device_code: <u8>::from_le_byte_slice(&bytes[1..2]),
            switch_to: <u8>::from_le_byte_slice(&bytes[2..3]),
            repeats: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Controls remote mains switches and receives signals from remotes
#[derive(Clone)]
pub struct RemoteSwitchV2Bricklet {
    device: Device,
}
impl RemoteSwitchV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 289;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Remote Switch Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> RemoteSwitchV2Bricklet {
        let mut result = RemoteSwitchV2Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::GetSwitchingState) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::SetRepeats) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::GetRepeats) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::SwitchSocketA) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::SwitchSocketB) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::DimSocketB) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::SwitchSocketC) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::SetRemoteConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::GetRemoteConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::GetRemoteStatusA) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::GetRemoteStatusB) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::GetRemoteStatusC) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RemoteSwitchV2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::remote_switch_v2_bricklet::RemoteSwitchV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::remote_switch_v2_bricklet::RemoteSwitchV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: RemoteSwitchV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: RemoteSwitchV2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered whenever the switching state changes
    /// from busy to ready, see [`get_switching_state`].
    ///
    /// [`get_switching_state`]: #method.get_switching_state
    pub fn get_switching_done_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(RemoteSwitchV2BrickletFunction::CallbackSwitchingDone))
    }

    /// Returns the house code, receiver code, switch state (on/off) and number of repeats for
    /// remote type A.
    ///
    /// The repeats are the number of received identical data packets. The longer the button is pressed,
    /// the higher the repeat number. The receiver is triggered with every repeat.
    ///
    /// You have to enable the receiver with [`set_remote_configuration`]. The number
    /// of repeats that you can set in the configuration is the minimum number of repeats that have
    /// to be seen before the receiver is triggered for the first time.
    pub fn get_remote_status_a_callback_receiver(&self) -> ConvertingCallbackReceiver<RemoteStatusAEvent> {
        self.device.get_callback_receiver(u8::from(RemoteSwitchV2BrickletFunction::CallbackRemoteStatusA))
    }

    /// Returns the address (unique per remote), unit (button number), switch state (on/off) and number of repeats for
    /// remote type B.
    ///
    /// If the remote supports dimming the dim value is used instead of the switch state.
    ///
    /// The repeats are the number of received identical data packets. The longer the button is pressed,
    /// the higher the repeat number. The receiver is triggered with every repeat.
    ///
    /// You have to enable the receiver with [`set_remote_configuration`]. The number
    /// of repeats that you can set in the configuration is the minimum number of repeats that have
    /// to be seen before the receiver is triggered for the first time.
    pub fn get_remote_status_b_callback_receiver(&self) -> ConvertingCallbackReceiver<RemoteStatusBEvent> {
        self.device.get_callback_receiver(u8::from(RemoteSwitchV2BrickletFunction::CallbackRemoteStatusB))
    }

    /// Returns the system code, device code, switch state (on/off) and number of repeats for
    /// remote type C.
    ///
    /// The repeats are the number of received identical data packets. The longer the button is pressed,
    /// the higher the repeat number. The receiver is triggered with every repeat.
    ///
    /// You have to enable the receiver with [`set_remote_configuration`]. The number
    /// of repeats that you can set in the configuration is the minimum number of repeats that have
    /// to be seen before the receiver is triggered for the first time.
    pub fn get_remote_status_c_callback_receiver(&self) -> ConvertingCallbackReceiver<RemoteStatusCEvent> {
        self.device.get_callback_receiver(u8::from(RemoteSwitchV2BrickletFunction::CallbackRemoteStatusC))
    }

    /// Returns the current switching state. If the current state is busy, the
    /// Bricklet is currently sending a code to switch a socket. It will not
    /// accept any calls of switch socket functions until the state changes to ready.
    ///
    /// How long the switching takes is dependent on the number of repeats, see
    /// [`set_repeats`].
    ///
    /// Associated constants:
    /// * REMOTE_SWITCH_V2_BRICKLET_SWITCHING_STATE_READY
    ///	* REMOTE_SWITCH_V2_BRICKLET_SWITCHING_STATE_BUSY
    pub fn get_switching_state(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RemoteSwitchV2BrickletFunction::GetSwitchingState), payload)
    }

    /// Sets the number of times the code is sent when one of the Switch Socket
    /// functions is called. The repeats basically correspond to the amount of time
    /// that a button of the remote is pressed.
    ///
    /// Some dimmers are controlled by the length of a button pressed,
    /// this can be simulated by increasing the repeats.
    pub fn set_repeats(&self, repeats: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(repeats));

        self.device.set(u8::from(RemoteSwitchV2BrickletFunction::SetRepeats), payload)
    }

    /// Returns the number of repeats as set by [`set_repeats`].
    pub fn get_repeats(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RemoteSwitchV2BrickletFunction::GetRepeats), payload)
    }

    /// To switch a type A socket you have to give the house code, receiver code and the
    /// state (on or off) you want to switch to.
    ///
    /// A detailed description on how you can figure out the house and receiver code
    /// can be found [here](remote_switch_bricklet_type_a_house_and_receiver_code).
    ///
    /// Associated constants:
    /// * REMOTE_SWITCH_V2_BRICKLET_SWITCH_TO_OFF
    ///	* REMOTE_SWITCH_V2_BRICKLET_SWITCH_TO_ON
    pub fn switch_socket_a(&self, house_code: u8, receiver_code: u8, switch_to: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(house_code));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(receiver_code));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(switch_to));

        self.device.set(u8::from(RemoteSwitchV2BrickletFunction::SwitchSocketA), payload)
    }

    /// To switch a type B socket you have to give the address, unit and the state
    /// (on or off) you want to switch to.
    ///
    /// To switch all devices with the same address use 255 for the unit.
    ///
    /// A detailed description on how you can teach a socket the address and unit can
    /// be found [here](remote_switch_bricklet_type_b_address_and_unit).
    ///
    /// Associated constants:
    /// * REMOTE_SWITCH_V2_BRICKLET_SWITCH_TO_OFF
    ///	* REMOTE_SWITCH_V2_BRICKLET_SWITCH_TO_ON
    pub fn switch_socket_b(&self, address: u32, unit: u8, switch_to: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(address));
        payload[4..5].copy_from_slice(&<u8>::to_le_byte_vec(unit));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(switch_to));

        self.device.set(u8::from(RemoteSwitchV2BrickletFunction::SwitchSocketB), payload)
    }

    /// To control a type B dimmer you have to give the address, unit and the
    /// dim value you want to set the dimmer to.
    ///
    /// A detailed description on how you can teach a dimmer the address and unit can
    /// be found [here](remote_switch_bricklet_type_b_address_and_unit).
    pub fn dim_socket_b(&self, address: u32, unit: u8, dim_value: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(address));
        payload[4..5].copy_from_slice(&<u8>::to_le_byte_vec(unit));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(dim_value));

        self.device.set(u8::from(RemoteSwitchV2BrickletFunction::DimSocketB), payload)
    }

    /// To switch a type C socket you have to give the system code, device code and the
    /// state (on or off) you want to switch to.
    ///
    /// A detailed description on how you can figure out the system and device code
    /// can be found [here](remote_switch_bricklet_type_c_system_and_device_code).
    ///
    /// Associated constants:
    /// * REMOTE_SWITCH_V2_BRICKLET_SWITCH_TO_OFF
    ///	* REMOTE_SWITCH_V2_BRICKLET_SWITCH_TO_ON
    pub fn switch_socket_c(&self, system_code: char, device_code: u8, switch_to: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(system_code));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(device_code));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(switch_to));

        self.device.set(u8::from(RemoteSwitchV2BrickletFunction::SwitchSocketC), payload)
    }

    /// Sets the configuration for **receiving** data from a remote of type A, B or C.
    ///
    /// * Remote Type: A, B or C depending on the type of remote you want to receive.
    /// * Minimum Repeats: The minimum number of repeated data packets until the receiver
    ///   is triggered (if enabled).
    /// * Receiver Enabled: Enable or disable receiver (see [`get_remote_status_a_callback_receiver`] receiver,
    ///   [`get_remote_status_b_callback_receiver`] receiver and [`get_remote_status_c_callback_receiver`] receiver).
    ///
    /// Associated constants:
    /// * REMOTE_SWITCH_V2_BRICKLET_REMOTE_TYPE_A
    ///	* REMOTE_SWITCH_V2_BRICKLET_REMOTE_TYPE_B
    ///	* REMOTE_SWITCH_V2_BRICKLET_REMOTE_TYPE_C
    pub fn set_remote_configuration(&self, remote_type: u8, minimum_repeats: u16, callback_enabled: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(remote_type));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(minimum_repeats));
        payload[3..4].copy_from_slice(&<bool>::to_le_byte_vec(callback_enabled));

        self.device.set(u8::from(RemoteSwitchV2BrickletFunction::SetRemoteConfiguration), payload)
    }

    /// Returns the remote configuration as set by [`set_remote_configuration`]
    ///
    /// Associated constants:
    /// * REMOTE_SWITCH_V2_BRICKLET_REMOTE_TYPE_A
    ///	* REMOTE_SWITCH_V2_BRICKLET_REMOTE_TYPE_B
    ///	* REMOTE_SWITCH_V2_BRICKLET_REMOTE_TYPE_C
    pub fn get_remote_configuration(&self) -> ConvertingReceiver<RemoteConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RemoteSwitchV2BrickletFunction::GetRemoteConfiguration), payload)
    }

    /// Returns the house code, receiver code, switch state (on/off) and number of
    /// repeats for remote type A.
    ///
    /// Repeats == 0 means there was no button press. Repeats >= 1 means there
    /// was a button press with the specified house/receiver code. The repeats are the
    /// number of received identical data packets. The longer the button is pressed,
    /// the higher the repeat number.
    ///
    /// Use the receiver to get this data automatically when a button is pressed,
    /// see [`set_remote_configuration`] and [`get_remote_status_a_callback_receiver`] receiver.
    ///
    /// Associated constants:
    /// * REMOTE_SWITCH_V2_BRICKLET_SWITCH_TO_OFF
    ///	* REMOTE_SWITCH_V2_BRICKLET_SWITCH_TO_ON
    pub fn get_remote_status_a(&self) -> ConvertingReceiver<RemoteStatusA> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RemoteSwitchV2BrickletFunction::GetRemoteStatusA), payload)
    }

    /// Returns the address (unique per remote), unit (button number), switch state
    /// (on/off) and number of repeats for remote type B.
    ///
    /// If the remote supports dimming the dim value is used instead of the switch state.
    ///
    /// If repeats=0 there was no button press. If repeats >= 1 there
    /// was a button press with the specified address/unit. The repeats are the number of received
    /// identical data packets. The longer the button is pressed, the higher the repeat number.
    ///
    /// Use the receiver to get this data automatically when a button is pressed,
    /// see [`set_remote_configuration`] and [`get_remote_status_b_callback_receiver`] receiver.
    ///
    /// Associated constants:
    /// * REMOTE_SWITCH_V2_BRICKLET_SWITCH_TO_OFF
    ///	* REMOTE_SWITCH_V2_BRICKLET_SWITCH_TO_ON
    pub fn get_remote_status_b(&self) -> ConvertingReceiver<RemoteStatusB> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RemoteSwitchV2BrickletFunction::GetRemoteStatusB), payload)
    }

    /// Returns the system code, device code, switch state (on/off) and number of repeats for
    /// remote type C.
    ///
    /// If repeats=0 there was no button press. If repeats >= 1 there
    /// was a button press with the specified system/device code. The repeats are the number of received
    /// identical data packets. The longer the button is pressed, the higher the repeat number.
    ///
    /// Use the receiver to get this data automatically when a button is pressed,
    /// see [`set_remote_configuration`] and [`get_remote_status_c_callback_receiver`] receiver.
    ///
    /// Associated constants:
    /// * REMOTE_SWITCH_V2_BRICKLET_SWITCH_TO_OFF
    ///	* REMOTE_SWITCH_V2_BRICKLET_SWITCH_TO_ON
    pub fn get_remote_status_c(&self) -> ConvertingReceiver<RemoteStatusC> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RemoteSwitchV2BrickletFunction::GetRemoteStatusC), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RemoteSwitchV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(RemoteSwitchV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* REMOTE_SWITCH_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RemoteSwitchV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(RemoteSwitchV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(RemoteSwitchV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * REMOTE_SWITCH_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* REMOTE_SWITCH_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* REMOTE_SWITCH_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* REMOTE_SWITCH_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(RemoteSwitchV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * REMOTE_SWITCH_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* REMOTE_SWITCH_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* REMOTE_SWITCH_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* REMOTE_SWITCH_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RemoteSwitchV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RemoteSwitchV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(RemoteSwitchV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(RemoteSwitchV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RemoteSwitchV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RemoteSwitchV2BrickletFunction::GetIdentity), payload)
    }
}
