/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Controls remote mains switches.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/RemoteSwitch_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum RemoteSwitchBrickletFunction {
    SwitchSocket,
    GetSwitchingState,
    SetRepeats,
    GetRepeats,
    SwitchSocketA,
    SwitchSocketB,
    DimSocketB,
    SwitchSocketC,
    GetIdentity,
    CallbackSwitchingDone,
}
impl From<RemoteSwitchBrickletFunction> for u8 {
    fn from(fun: RemoteSwitchBrickletFunction) -> Self {
        match fun {
            RemoteSwitchBrickletFunction::SwitchSocket => 1,
            RemoteSwitchBrickletFunction::GetSwitchingState => 2,
            RemoteSwitchBrickletFunction::SetRepeats => 4,
            RemoteSwitchBrickletFunction::GetRepeats => 5,
            RemoteSwitchBrickletFunction::SwitchSocketA => 6,
            RemoteSwitchBrickletFunction::SwitchSocketB => 7,
            RemoteSwitchBrickletFunction::DimSocketB => 8,
            RemoteSwitchBrickletFunction::SwitchSocketC => 9,
            RemoteSwitchBrickletFunction::GetIdentity => 255,
            RemoteSwitchBrickletFunction::CallbackSwitchingDone => 3,
        }
    }
}
pub const REMOTE_SWITCH_BRICKLET_SWITCH_TO_OFF: u8 = 0;
pub const REMOTE_SWITCH_BRICKLET_SWITCH_TO_ON: u8 = 1;
pub const REMOTE_SWITCH_BRICKLET_SWITCHING_STATE_READY: u8 = 0;
pub const REMOTE_SWITCH_BRICKLET_SWITCHING_STATE_BUSY: u8 = 1;

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Controls remote mains switches
#[derive(Clone)]
pub struct RemoteSwitchBricklet {
    device: Device,
}
impl RemoteSwitchBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 235;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Remote Switch Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> RemoteSwitchBricklet {
        let mut result = RemoteSwitchBricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(RemoteSwitchBrickletFunction::SwitchSocket) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RemoteSwitchBrickletFunction::GetSwitchingState) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RemoteSwitchBrickletFunction::SetRepeats) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RemoteSwitchBrickletFunction::GetRepeats) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RemoteSwitchBrickletFunction::SwitchSocketA) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RemoteSwitchBrickletFunction::SwitchSocketB) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RemoteSwitchBrickletFunction::DimSocketB) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RemoteSwitchBrickletFunction::SwitchSocketC) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RemoteSwitchBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::remote_switch_bricklet::RemoteSwitchBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::remote_switch_bricklet::RemoteSwitchBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: RemoteSwitchBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: RemoteSwitchBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered whenever the switching state changes
    /// from busy to ready, see [`get_switching_state`].
    ///
    /// [`get_switching_state`]: #method.get_switching_state
    pub fn get_switching_done_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(RemoteSwitchBrickletFunction::CallbackSwitchingDone))
    }

    /// This function is deprecated, use [`switch_socket_a`] instead.
    ///
    /// Associated constants:
    /// * REMOTE_SWITCH_BRICKLET_SWITCH_TO_OFF
    ///	* REMOTE_SWITCH_BRICKLET_SWITCH_TO_ON
    pub fn switch_socket(&self, house_code: u8, receiver_code: u8, switch_to: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(house_code));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(receiver_code));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(switch_to));

        self.device.set(u8::from(RemoteSwitchBrickletFunction::SwitchSocket), payload)
    }

    /// Returns the current switching state. If the current state is busy, the
    /// Bricklet is currently sending a code to switch a socket. It will not
    /// accept any requests to switch sockets until the state changes to ready.
    ///
    /// How long the switching takes is dependent on the number of repeats, see
    /// [`set_repeats`].
    ///
    /// Associated constants:
    /// * REMOTE_SWITCH_BRICKLET_SWITCHING_STATE_READY
    ///	* REMOTE_SWITCH_BRICKLET_SWITCHING_STATE_BUSY
    pub fn get_switching_state(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RemoteSwitchBrickletFunction::GetSwitchingState), payload)
    }

    /// Sets the number of times the code is sent when one of the switch socket
    /// functions is called. The repeats basically correspond to the amount of time
    /// that a button of the remote is pressed.
    ///
    /// Some dimmers are controlled by the length of a button pressed,
    /// this can be simulated by increasing the repeats.
    pub fn set_repeats(&self, repeats: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(repeats));

        self.device.set(u8::from(RemoteSwitchBrickletFunction::SetRepeats), payload)
    }

    /// Returns the number of repeats as set by [`set_repeats`].
    pub fn get_repeats(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RemoteSwitchBrickletFunction::GetRepeats), payload)
    }

    /// To switch a type A socket you have to give the house code, receiver code and the
    /// state (on or off) you want to switch to.
    ///
    /// A detailed description on how you can figure out the house and receiver code
    /// can be found [here](remote_switch_bricklet_type_a_house_and_receiver_code).
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * REMOTE_SWITCH_BRICKLET_SWITCH_TO_OFF
    ///	* REMOTE_SWITCH_BRICKLET_SWITCH_TO_ON
    pub fn switch_socket_a(&self, house_code: u8, receiver_code: u8, switch_to: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(house_code));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(receiver_code));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(switch_to));

        self.device.set(u8::from(RemoteSwitchBrickletFunction::SwitchSocketA), payload)
    }

    /// To switch a type B socket you have to give the address, unit and the state
    /// (on or off) you want to switch to.
    ///
    /// To switch all devices with the same address use 255 for the unit.
    ///
    /// A detailed description on how you can teach a socket the address and unit can
    /// be found [here](remote_switch_bricklet_type_b_address_and_unit).
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * REMOTE_SWITCH_BRICKLET_SWITCH_TO_OFF
    ///	* REMOTE_SWITCH_BRICKLET_SWITCH_TO_ON
    pub fn switch_socket_b(&self, address: u32, unit: u8, switch_to: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(address));
        payload[4..5].copy_from_slice(&<u8>::to_le_byte_vec(unit));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(switch_to));

        self.device.set(u8::from(RemoteSwitchBrickletFunction::SwitchSocketB), payload)
    }

    /// To control a type B dimmer you have to give the address, unit and the
    /// dim value you want to set the dimmer to.
    ///
    /// A detailed description on how you can teach a dimmer the address and unit can
    /// be found [here](remote_switch_bricklet_type_b_address_and_unit).
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    pub fn dim_socket_b(&self, address: u32, unit: u8, dim_value: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(address));
        payload[4..5].copy_from_slice(&<u8>::to_le_byte_vec(unit));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(dim_value));

        self.device.set(u8::from(RemoteSwitchBrickletFunction::DimSocketB), payload)
    }

    /// To switch a type C socket you have to give the system code, device code and the
    /// state (on or off) you want to switch to.
    ///
    /// A detailed description on how you can figure out the system and device code
    /// can be found [here](remote_switch_bricklet_type_c_system_and_device_code).
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * REMOTE_SWITCH_BRICKLET_SWITCH_TO_OFF
    ///	* REMOTE_SWITCH_BRICKLET_SWITCH_TO_ON
    pub fn switch_socket_c(&self, system_code: char, device_code: u8, switch_to: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(system_code));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(device_code));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(switch_to));

        self.device.set(u8::from(RemoteSwitchBrickletFunction::SwitchSocketC), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RemoteSwitchBrickletFunction::GetIdentity), payload)
    }
}
