/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Battery-backed real-time clock.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/RealTimeClockV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum RealTimeClockV2BrickletFunction {
    SetDateTime,
    GetDateTime,
    GetTimestamp,
    SetOffset,
    GetOffset,
    SetDateTimeCallbackConfiguration,
    GetDateTimeCallbackConfiguration,
    SetAlarm,
    GetAlarm,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackDateTime,
    CallbackAlarm,
}
impl From<RealTimeClockV2BrickletFunction> for u8 {
    fn from(fun: RealTimeClockV2BrickletFunction) -> Self {
        match fun {
            RealTimeClockV2BrickletFunction::SetDateTime => 1,
            RealTimeClockV2BrickletFunction::GetDateTime => 2,
            RealTimeClockV2BrickletFunction::GetTimestamp => 3,
            RealTimeClockV2BrickletFunction::SetOffset => 4,
            RealTimeClockV2BrickletFunction::GetOffset => 5,
            RealTimeClockV2BrickletFunction::SetDateTimeCallbackConfiguration => 6,
            RealTimeClockV2BrickletFunction::GetDateTimeCallbackConfiguration => 7,
            RealTimeClockV2BrickletFunction::SetAlarm => 8,
            RealTimeClockV2BrickletFunction::GetAlarm => 9,
            RealTimeClockV2BrickletFunction::GetSpitfpErrorCount => 234,
            RealTimeClockV2BrickletFunction::SetBootloaderMode => 235,
            RealTimeClockV2BrickletFunction::GetBootloaderMode => 236,
            RealTimeClockV2BrickletFunction::SetWriteFirmwarePointer => 237,
            RealTimeClockV2BrickletFunction::WriteFirmware => 238,
            RealTimeClockV2BrickletFunction::SetStatusLedConfig => 239,
            RealTimeClockV2BrickletFunction::GetStatusLedConfig => 240,
            RealTimeClockV2BrickletFunction::GetChipTemperature => 242,
            RealTimeClockV2BrickletFunction::Reset => 243,
            RealTimeClockV2BrickletFunction::WriteUid => 248,
            RealTimeClockV2BrickletFunction::ReadUid => 249,
            RealTimeClockV2BrickletFunction::GetIdentity => 255,
            RealTimeClockV2BrickletFunction::CallbackDateTime => 10,
            RealTimeClockV2BrickletFunction::CallbackAlarm => 11,
        }
    }
}
pub const REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_MONDAY: u8 = 1;
pub const REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_TUESDAY: u8 = 2;
pub const REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_WEDNESDAY: u8 = 3;
pub const REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_THURSDAY: u8 = 4;
pub const REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_FRIDAY: u8 = 5;
pub const REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_SATURDAY: u8 = 6;
pub const REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_SUNDAY: u8 = 7;
pub const REAL_TIME_CLOCK_V2_BRICKLET_ALARM_MATCH_DISABLED: i8 = -1;
pub const REAL_TIME_CLOCK_V2_BRICKLET_ALARM_INTERVAL_DISABLED: i32 = -1;
pub const REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const REAL_TIME_CLOCK_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const REAL_TIME_CLOCK_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const REAL_TIME_CLOCK_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const REAL_TIME_CLOCK_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct DateTime {
    pub year: u16,
    pub month: u8,
    pub day: u8,
    pub hour: u8,
    pub minute: u8,
    pub second: u8,
    pub centisecond: u8,
    pub weekday: u8,
    pub timestamp: i64,
}
impl FromByteSlice for DateTime {
    fn bytes_expected() -> usize { 17 }
    fn from_le_byte_slice(bytes: &[u8]) -> DateTime {
        DateTime {
            year: <u16>::from_le_byte_slice(&bytes[0..2]),
            month: <u8>::from_le_byte_slice(&bytes[2..3]),
            day: <u8>::from_le_byte_slice(&bytes[3..4]),
            hour: <u8>::from_le_byte_slice(&bytes[4..5]),
            minute: <u8>::from_le_byte_slice(&bytes[5..6]),
            second: <u8>::from_le_byte_slice(&bytes[6..7]),
            centisecond: <u8>::from_le_byte_slice(&bytes[7..8]),
            weekday: <u8>::from_le_byte_slice(&bytes[8..9]),
            timestamp: <i64>::from_le_byte_slice(&bytes[9..17]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Alarm {
    pub month: i8,
    pub day: i8,
    pub hour: i8,
    pub minute: i8,
    pub second: i8,
    pub weekday: i8,
    pub interval: i32,
}
impl FromByteSlice for Alarm {
    fn bytes_expected() -> usize { 10 }
    fn from_le_byte_slice(bytes: &[u8]) -> Alarm {
        Alarm {
            month: <i8>::from_le_byte_slice(&bytes[0..1]),
            day: <i8>::from_le_byte_slice(&bytes[1..2]),
            hour: <i8>::from_le_byte_slice(&bytes[2..3]),
            minute: <i8>::from_le_byte_slice(&bytes[3..4]),
            second: <i8>::from_le_byte_slice(&bytes[4..5]),
            weekday: <i8>::from_le_byte_slice(&bytes[5..6]),
            interval: <i32>::from_le_byte_slice(&bytes[6..10]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct DateTimeEvent {
    pub year: u16,
    pub month: u8,
    pub day: u8,
    pub hour: u8,
    pub minute: u8,
    pub second: u8,
    pub centisecond: u8,
    pub weekday: u8,
    pub timestamp: i64,
}
impl FromByteSlice for DateTimeEvent {
    fn bytes_expected() -> usize { 17 }
    fn from_le_byte_slice(bytes: &[u8]) -> DateTimeEvent {
        DateTimeEvent {
            year: <u16>::from_le_byte_slice(&bytes[0..2]),
            month: <u8>::from_le_byte_slice(&bytes[2..3]),
            day: <u8>::from_le_byte_slice(&bytes[3..4]),
            hour: <u8>::from_le_byte_slice(&bytes[4..5]),
            minute: <u8>::from_le_byte_slice(&bytes[5..6]),
            second: <u8>::from_le_byte_slice(&bytes[6..7]),
            centisecond: <u8>::from_le_byte_slice(&bytes[7..8]),
            weekday: <u8>::from_le_byte_slice(&bytes[8..9]),
            timestamp: <i64>::from_le_byte_slice(&bytes[9..17]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AlarmEvent {
    pub year: u16,
    pub month: u8,
    pub day: u8,
    pub hour: u8,
    pub minute: u8,
    pub second: u8,
    pub centisecond: u8,
    pub weekday: u8,
    pub timestamp: i64,
}
impl FromByteSlice for AlarmEvent {
    fn bytes_expected() -> usize { 17 }
    fn from_le_byte_slice(bytes: &[u8]) -> AlarmEvent {
        AlarmEvent {
            year: <u16>::from_le_byte_slice(&bytes[0..2]),
            month: <u8>::from_le_byte_slice(&bytes[2..3]),
            day: <u8>::from_le_byte_slice(&bytes[3..4]),
            hour: <u8>::from_le_byte_slice(&bytes[4..5]),
            minute: <u8>::from_le_byte_slice(&bytes[5..6]),
            second: <u8>::from_le_byte_slice(&bytes[6..7]),
            centisecond: <u8>::from_le_byte_slice(&bytes[7..8]),
            weekday: <u8>::from_le_byte_slice(&bytes[8..9]),
            timestamp: <i64>::from_le_byte_slice(&bytes[9..17]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Battery-backed real-time clock
#[derive(Clone)]
pub struct RealTimeClockV2Bricklet {
    device: Device,
}
impl RealTimeClockV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2106;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Real-Time Clock Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> RealTimeClockV2Bricklet {
        let mut result = RealTimeClockV2Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::SetDateTime) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::GetDateTime) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::GetTimestamp) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::SetOffset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::GetOffset) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::SetDateTimeCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::GetDateTimeCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::SetAlarm) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::GetAlarm) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RealTimeClockV2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::real_time_clock_v2_bricklet::RealTimeClockV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::real_time_clock_v2_bricklet::RealTimeClockV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: RealTimeClockV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: RealTimeClockV2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_date_time_callback_configuration`]. The parameters are the
    /// same as for [`get_date_time`].
    ///
    /// [`get_date_time`]: #method.get_date_time
    /// [`set_date_time_callback_configuration`]: #method.set_date_time_callback_configuration
    pub fn get_date_time_callback_receiver(&self) -> ConvertingCallbackReceiver<DateTimeEvent> {
        self.device.get_callback_receiver(u8::from(RealTimeClockV2BrickletFunction::CallbackDateTime))
    }

    /// This receiver is triggered every time the current date and time matches the
    /// configured alarm (see [`set_alarm`]). The parameters are the same
    /// as for [`get_date_time`].
    pub fn get_alarm_callback_receiver(&self) -> ConvertingCallbackReceiver<AlarmEvent> {
        self.device.get_callback_receiver(u8::from(RealTimeClockV2BrickletFunction::CallbackAlarm))
    }

    /// Sets the current date (including weekday) and the current time.
    ///
    /// If the backup battery is installed then the real-time clock keeps date and
    /// time even if the Bricklet is not powered by a Brick.
    ///
    /// The real-time clock handles leap year and inserts the 29th of February
    /// accordingly. But leap seconds, time zones and daylight saving time are not
    /// handled.
    ///
    /// Associated constants:
    /// * REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_MONDAY
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_TUESDAY
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_WEDNESDAY
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_THURSDAY
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_FRIDAY
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_SATURDAY
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_SUNDAY
    pub fn set_date_time(
        &self,
        year: u16,
        month: u8,
        day: u8,
        hour: u8,
        minute: u8,
        second: u8,
        centisecond: u8,
        weekday: u8,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(year));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(month));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(day));
        payload[4..5].copy_from_slice(&<u8>::to_le_byte_vec(hour));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(minute));
        payload[6..7].copy_from_slice(&<u8>::to_le_byte_vec(second));
        payload[7..8].copy_from_slice(&<u8>::to_le_byte_vec(centisecond));
        payload[8..9].copy_from_slice(&<u8>::to_le_byte_vec(weekday));

        self.device.set(u8::from(RealTimeClockV2BrickletFunction::SetDateTime), payload)
    }

    /// Returns the current date (including weekday) and the current time of the
    /// real-time.
    ///
    /// The timestamp represents the current date and the the current time of the
    /// real-time clock converted to milliseconds and is an offset to 2000-01-01 00:00:00.0000.
    ///
    /// Associated constants:
    /// * REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_MONDAY
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_TUESDAY
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_WEDNESDAY
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_THURSDAY
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_FRIDAY
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_SATURDAY
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_WEEKDAY_SUNDAY
    pub fn get_date_time(&self) -> ConvertingReceiver<DateTime> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RealTimeClockV2BrickletFunction::GetDateTime), payload)
    }

    /// Returns the current date and the time of the real-time clock converted to
    /// milliseconds. The timestamp has an effective resolution of hundredths of a
    /// second and is an offset to 2000-01-01 00:00:00.0000.
    pub fn get_timestamp(&self) -> ConvertingReceiver<i64> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RealTimeClockV2BrickletFunction::GetTimestamp), payload)
    }

    /// Sets the offset the real-time clock should compensate for in 2.17 ppm steps
    /// between -277.76 ppm (-128) and +275.59 ppm (127).
    ///
    /// The real-time clock time can deviate from the actual time due to the frequency
    /// deviation of its 32.768 kHz crystal. Even without compensation (factory
    /// default) the resulting time deviation should be at most ±20 ppm (±52.6
    /// seconds per month).
    ///
    /// This deviation can be calculated by comparing the same duration measured by the
    /// real-time clock (``rtc_duration``) an accurate reference clock
    /// (``ref_duration``).
    ///
    /// For best results the configured offset should be set to 0 ppm first and then a
    /// duration of at least 6 hours should be measured.
    ///
    /// The new offset (``new_offset``) can be calculated from the currently configured
    /// offset (``current_offset``) and the measured durations as follow::
    ///
    ///   new_offset = current_offset - round(1000000 * (rtc_duration - ref_duration) / rtc_duration / 2.17)
    ///
    /// If you want to calculate the offset, then we recommend using the calibration
    /// dialog in Brick Viewer, instead of doing it manually.
    ///
    /// The offset is saved in the EEPROM of the Bricklet and only needs to be
    /// configured once.
    pub fn set_offset(&self, offset: i8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<i8>::to_le_byte_vec(offset));

        self.device.set(u8::from(RealTimeClockV2BrickletFunction::SetOffset), payload)
    }

    /// Returns the offset as set by [`set_offset`].
    pub fn get_offset(&self) -> ConvertingReceiver<i8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RealTimeClockV2BrickletFunction::GetOffset), payload)
    }

    /// Sets the period with which the [`get_date_time_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    pub fn set_date_time_callback_configuration(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(RealTimeClockV2BrickletFunction::SetDateTimeCallbackConfiguration), payload)
    }

    /// Returns the period as set by [`set_date_time_callback_configuration`].
    pub fn get_date_time_callback_configuration(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RealTimeClockV2BrickletFunction::GetDateTimeCallbackConfiguration), payload)
    }

    /// Configures a repeatable alarm. The [`get_alarm_callback_receiver`] receiver is triggered if the
    /// current date and time matches the configured alarm.
    ///
    /// Setting a parameter to -1 means that it should be disabled and doesn't take part
    /// in the match. Setting all parameters to -1 disables the alarm completely.
    ///
    /// For example, to make the alarm trigger every day at 7:30 AM it can be
    /// configured as (-1, -1, 7, 30, -1, -1, -1). The hour is set to match 7 and the
    /// minute is set to match 30. The alarm is triggered if all enabled parameters
    /// match.
    ///
    /// The interval has a special role. It allows to make the alarm reconfigure itself.
    /// This is useful if you need a repeated alarm that cannot be expressed by matching
    /// the current date and time. For example, to make the alarm trigger every 23
    /// seconds it can be configured as (-1, -1, -1, -1, -1, -1, 23). Internally the
    /// Bricklet will take the current date and time, add 23 seconds to it and set the
    /// result as its alarm. The first alarm will be triggered 23 seconds after the
    /// call. Because the interval is not -1, the Bricklet will do the same again
    /// internally, take the current date and time, add 23 seconds to it and set that
    /// as its alarm. This results in a repeated alarm that triggers every 23 seconds.
    ///
    /// The interval can also be used in combination with the other parameters. For
    /// example, configuring the alarm as (-1, -1, 7, 30, -1, -1, 300) results in an
    /// alarm that triggers every day at 7:30 AM and is then repeated every 5 minutes.
    ///
    /// Associated constants:
    /// * REAL_TIME_CLOCK_V2_BRICKLET_ALARM_MATCH_DISABLED
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_ALARM_INTERVAL_DISABLED
    pub fn set_alarm(&self, month: i8, day: i8, hour: i8, minute: i8, second: i8, weekday: i8, interval: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 10];
        payload[0..1].copy_from_slice(&<i8>::to_le_byte_vec(month));
        payload[1..2].copy_from_slice(&<i8>::to_le_byte_vec(day));
        payload[2..3].copy_from_slice(&<i8>::to_le_byte_vec(hour));
        payload[3..4].copy_from_slice(&<i8>::to_le_byte_vec(minute));
        payload[4..5].copy_from_slice(&<i8>::to_le_byte_vec(second));
        payload[5..6].copy_from_slice(&<i8>::to_le_byte_vec(weekday));
        payload[6..10].copy_from_slice(&<i32>::to_le_byte_vec(interval));

        self.device.set(u8::from(RealTimeClockV2BrickletFunction::SetAlarm), payload)
    }

    /// Returns the alarm configuration as set by [`set_alarm`].
    ///
    /// Associated constants:
    /// * REAL_TIME_CLOCK_V2_BRICKLET_ALARM_MATCH_DISABLED
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_ALARM_INTERVAL_DISABLED
    pub fn get_alarm(&self) -> ConvertingReceiver<Alarm> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RealTimeClockV2BrickletFunction::GetAlarm), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RealTimeClockV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(RealTimeClockV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RealTimeClockV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(RealTimeClockV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(RealTimeClockV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * REAL_TIME_CLOCK_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(RealTimeClockV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * REAL_TIME_CLOCK_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* REAL_TIME_CLOCK_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RealTimeClockV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RealTimeClockV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(RealTimeClockV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(RealTimeClockV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RealTimeClockV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RealTimeClockV2BrickletFunction::GetIdentity), payload)
    }
}
