/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Creates beep and alarm with configurable volume and frequency.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/PiezoSpeakerV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum PiezoSpeakerV2BrickletFunction {
    SetBeep,
    GetBeep,
    SetAlarm,
    GetAlarm,
    UpdateVolume,
    UpdateFrequency,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackBeepFinished,
    CallbackAlarmFinished,
}
impl From<PiezoSpeakerV2BrickletFunction> for u8 {
    fn from(fun: PiezoSpeakerV2BrickletFunction) -> Self {
        match fun {
            PiezoSpeakerV2BrickletFunction::SetBeep => 1,
            PiezoSpeakerV2BrickletFunction::GetBeep => 2,
            PiezoSpeakerV2BrickletFunction::SetAlarm => 3,
            PiezoSpeakerV2BrickletFunction::GetAlarm => 4,
            PiezoSpeakerV2BrickletFunction::UpdateVolume => 5,
            PiezoSpeakerV2BrickletFunction::UpdateFrequency => 6,
            PiezoSpeakerV2BrickletFunction::GetSpitfpErrorCount => 234,
            PiezoSpeakerV2BrickletFunction::SetBootloaderMode => 235,
            PiezoSpeakerV2BrickletFunction::GetBootloaderMode => 236,
            PiezoSpeakerV2BrickletFunction::SetWriteFirmwarePointer => 237,
            PiezoSpeakerV2BrickletFunction::WriteFirmware => 238,
            PiezoSpeakerV2BrickletFunction::SetStatusLedConfig => 239,
            PiezoSpeakerV2BrickletFunction::GetStatusLedConfig => 240,
            PiezoSpeakerV2BrickletFunction::GetChipTemperature => 242,
            PiezoSpeakerV2BrickletFunction::Reset => 243,
            PiezoSpeakerV2BrickletFunction::WriteUid => 248,
            PiezoSpeakerV2BrickletFunction::ReadUid => 249,
            PiezoSpeakerV2BrickletFunction::GetIdentity => 255,
            PiezoSpeakerV2BrickletFunction::CallbackBeepFinished => 7,
            PiezoSpeakerV2BrickletFunction::CallbackAlarmFinished => 8,
        }
    }
}
pub const PIEZO_SPEAKER_V2_BRICKLET_BEEP_DURATION_OFF: u32 = 0;
pub const PIEZO_SPEAKER_V2_BRICKLET_BEEP_DURATION_INFINITE: u32 = 4_294_967_295;
pub const PIEZO_SPEAKER_V2_BRICKLET_ALARM_DURATION_OFF: u32 = 0;
pub const PIEZO_SPEAKER_V2_BRICKLET_ALARM_DURATION_INFINITE: u32 = 4_294_967_295;
pub const PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const PIEZO_SPEAKER_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const PIEZO_SPEAKER_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const PIEZO_SPEAKER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const PIEZO_SPEAKER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Beep {
    pub frequency: u16,
    pub volume: u8,
    pub duration: u32,
    pub duration_remaining: u32,
}
impl FromByteSlice for Beep {
    fn bytes_expected() -> usize { 11 }
    fn from_le_byte_slice(bytes: &[u8]) -> Beep {
        Beep {
            frequency: <u16>::from_le_byte_slice(&bytes[0..2]),
            volume: <u8>::from_le_byte_slice(&bytes[2..3]),
            duration: <u32>::from_le_byte_slice(&bytes[3..7]),
            duration_remaining: <u32>::from_le_byte_slice(&bytes[7..11]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Alarm {
    pub start_frequency: u16,
    pub end_frequency: u16,
    pub step_size: u16,
    pub step_delay: u16,
    pub volume: u8,
    pub duration: u32,
    pub duration_remaining: u32,
    pub current_frequency: u16,
}
impl FromByteSlice for Alarm {
    fn bytes_expected() -> usize { 19 }
    fn from_le_byte_slice(bytes: &[u8]) -> Alarm {
        Alarm {
            start_frequency: <u16>::from_le_byte_slice(&bytes[0..2]),
            end_frequency: <u16>::from_le_byte_slice(&bytes[2..4]),
            step_size: <u16>::from_le_byte_slice(&bytes[4..6]),
            step_delay: <u16>::from_le_byte_slice(&bytes[6..8]),
            volume: <u8>::from_le_byte_slice(&bytes[8..9]),
            duration: <u32>::from_le_byte_slice(&bytes[9..13]),
            duration_remaining: <u32>::from_le_byte_slice(&bytes[13..17]),
            current_frequency: <u16>::from_le_byte_slice(&bytes[17..19]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Creates beep and alarm with configurable volume and frequency
#[derive(Clone)]
pub struct PiezoSpeakerV2Bricklet {
    device: Device,
}
impl PiezoSpeakerV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2145;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Piezo Speaker Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> PiezoSpeakerV2Bricklet {
        let mut result = PiezoSpeakerV2Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(PiezoSpeakerV2BrickletFunction::SetBeep) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PiezoSpeakerV2BrickletFunction::GetBeep) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PiezoSpeakerV2BrickletFunction::SetAlarm) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PiezoSpeakerV2BrickletFunction::GetAlarm) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PiezoSpeakerV2BrickletFunction::UpdateVolume) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PiezoSpeakerV2BrickletFunction::UpdateFrequency) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PiezoSpeakerV2BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PiezoSpeakerV2BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PiezoSpeakerV2BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PiezoSpeakerV2BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PiezoSpeakerV2BrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PiezoSpeakerV2BrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PiezoSpeakerV2BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PiezoSpeakerV2BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PiezoSpeakerV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PiezoSpeakerV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PiezoSpeakerV2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PiezoSpeakerV2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::piezo_speaker_v2_bricklet::PiezoSpeakerV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::piezo_speaker_v2_bricklet::PiezoSpeakerV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: PiezoSpeakerV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: PiezoSpeakerV2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered if a beep set by [`set_beep`] is finished
    ///
    /// [`set_beep`]: #method.set_beep
    pub fn get_beep_finished_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(PiezoSpeakerV2BrickletFunction::CallbackBeepFinished))
    }

    /// This receiver is triggered if a alarm set by [`set_alarm`] is finished
    pub fn get_alarm_finished_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(PiezoSpeakerV2BrickletFunction::CallbackAlarmFinished))
    }

    /// Beeps with the given frequency and volume for the duration.
    ///
    /// A duration of 0 stops the current beep if any is ongoing.
    /// A duration of 4294967295 results in an infinite beep.
    ///
    /// Associated constants:
    /// * PIEZO_SPEAKER_V2_BRICKLET_BEEP_DURATION_OFF
    ///	* PIEZO_SPEAKER_V2_BRICKLET_BEEP_DURATION_INFINITE
    pub fn set_beep(&self, frequency: u16, volume: u8, duration: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 7];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(frequency));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(volume));
        payload[3..7].copy_from_slice(&<u32>::to_le_byte_vec(duration));

        self.device.set(u8::from(PiezoSpeakerV2BrickletFunction::SetBeep), payload)
    }

    /// Returns the last beep settings as set by [`set_beep`]. If a beep is currently
    /// running it also returns the remaining duration of the beep.
    ///
    /// If the frequency or volume is updated during a beep (with [`update_frequency`]
    /// or [`update_volume`]) this function returns the updated value.
    ///
    /// Associated constants:
    /// * PIEZO_SPEAKER_V2_BRICKLET_BEEP_DURATION_OFF
    ///	* PIEZO_SPEAKER_V2_BRICKLET_BEEP_DURATION_INFINITE
    pub fn get_beep(&self) -> ConvertingReceiver<Beep> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PiezoSpeakerV2BrickletFunction::GetBeep), payload)
    }

    /// Creates an alarm (a tone that goes back and force between two specified frequencies).
    ///
    /// The following parameters can be set:
    ///
    /// * Start Frequency: Start frequency of the alarm.
    /// * End Frequency: End frequency of the alarm.
    /// * Step Size: Size of one step of the sweep between the start/end frequencies.
    /// * Step Delay: Delay between two steps (duration of time that one tone is used in a sweep).
    /// * Duration: Duration of the alarm.
    ///
    /// A duration of 0 stops the current alarm if any is ongoing.
    /// A duration of 4294967295 results in an infinite alarm.
    ///
    /// Below you can find two sets of example settings that you can try out. You can use
    /// these as a starting point to find an alarm signal that suits your application.
    ///
    /// Example 1: 10 seconds of loud annoying fast alarm
    ///
    /// * Start Frequency = 800
    /// * End Frequency = 2000
    /// * Step Size = 10
    /// * Step Delay = 1
    /// * Volume = 10
    /// * Duration = 10000
    ///
    /// Example 2: 10 seconds of soft siren sound with slow build-up
    ///
    /// * Start Frequency = 250
    /// * End Frequency = 750
    /// * Step Size = 1
    /// * Step Delay = 5
    /// * Volume = 0
    /// * Duration = 10000
    ///
    /// The following conditions must be met:
    ///
    /// * Start Frequency: has to be smaller than end frequency
    /// * End Frequency: has to be bigger than start frequency
    /// * Step Size: has to be small enough to fit into the frequency range
    /// * Step Delay: has to be small enough to fit into the duration
    ///
    /// Associated constants:
    /// * PIEZO_SPEAKER_V2_BRICKLET_ALARM_DURATION_OFF
    ///	* PIEZO_SPEAKER_V2_BRICKLET_ALARM_DURATION_INFINITE
    pub fn set_alarm(
        &self,
        start_frequency: u16,
        end_frequency: u16,
        step_size: u16,
        step_delay: u16,
        volume: u8,
        duration: u32,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 13];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(start_frequency));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(end_frequency));
        payload[4..6].copy_from_slice(&<u16>::to_le_byte_vec(step_size));
        payload[6..8].copy_from_slice(&<u16>::to_le_byte_vec(step_delay));
        payload[8..9].copy_from_slice(&<u8>::to_le_byte_vec(volume));
        payload[9..13].copy_from_slice(&<u32>::to_le_byte_vec(duration));

        self.device.set(u8::from(PiezoSpeakerV2BrickletFunction::SetAlarm), payload)
    }

    /// Returns the last alarm settings as set by [`set_alarm`]. If an alarm is currently
    /// running it also returns the remaining duration of the alarm as well as the
    /// current frequency of the alarm.
    ///
    /// If the volume is updated during an alarm (with [`update_volume`])
    /// this function returns the updated value.
    ///
    /// Associated constants:
    /// * PIEZO_SPEAKER_V2_BRICKLET_ALARM_DURATION_OFF
    ///	* PIEZO_SPEAKER_V2_BRICKLET_ALARM_DURATION_INFINITE
    pub fn get_alarm(&self) -> ConvertingReceiver<Alarm> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PiezoSpeakerV2BrickletFunction::GetAlarm), payload)
    }

    /// Updates the volume of an ongoing beep or alarm.
    pub fn update_volume(&self, volume: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(volume));

        self.device.set(u8::from(PiezoSpeakerV2BrickletFunction::UpdateVolume), payload)
    }

    /// Updates the frequency of an ongoing beep.
    pub fn update_frequency(&self, frequency: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(frequency));

        self.device.set(u8::from(PiezoSpeakerV2BrickletFunction::UpdateFrequency), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PiezoSpeakerV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(PiezoSpeakerV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* PIEZO_SPEAKER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PiezoSpeakerV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(PiezoSpeakerV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(PiezoSpeakerV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * PIEZO_SPEAKER_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* PIEZO_SPEAKER_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* PIEZO_SPEAKER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* PIEZO_SPEAKER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(PiezoSpeakerV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * PIEZO_SPEAKER_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* PIEZO_SPEAKER_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* PIEZO_SPEAKER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* PIEZO_SPEAKER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PiezoSpeakerV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PiezoSpeakerV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(PiezoSpeakerV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(PiezoSpeakerV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PiezoSpeakerV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PiezoSpeakerV2BrickletFunction::GetIdentity), payload)
    }
}
