/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Creates beep with configurable frequency.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/PiezoSpeaker_Bricklet_Rust.html).
use crate::{
    byte_converter::*,
    converting_callback_receiver::ConvertingCallbackReceiver,
    converting_receiver::{BrickletError, ConvertingReceiver},
    device::*,
    ip_connection::GetRequestSender,
};
pub enum PiezoSpeakerBrickletFunction {
    Beep,
    MorseCode,
    Calibrate,
    GetIdentity,
    CallbackBeepFinished,
    CallbackMorseCodeFinished,
}
impl From<PiezoSpeakerBrickletFunction> for u8 {
    fn from(fun: PiezoSpeakerBrickletFunction) -> Self {
        match fun {
            PiezoSpeakerBrickletFunction::Beep => 1,
            PiezoSpeakerBrickletFunction::MorseCode => 2,
            PiezoSpeakerBrickletFunction::Calibrate => 3,
            PiezoSpeakerBrickletFunction::GetIdentity => 255,
            PiezoSpeakerBrickletFunction::CallbackBeepFinished => 4,
            PiezoSpeakerBrickletFunction::CallbackMorseCodeFinished => 5,
        }
    }
}
pub const PIEZO_SPEAKER_BRICKLET_BEEP_DURATION_OFF: u32 = 0;
pub const PIEZO_SPEAKER_BRICKLET_BEEP_DURATION_INFINITE: u32 = 4_294_967_295;

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Creates beep with configurable frequency
#[derive(Clone)]
pub struct PiezoSpeakerBricklet {
    device: Device,
}
impl PiezoSpeakerBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 242;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Piezo Speaker Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> PiezoSpeakerBricklet {
        let mut result = PiezoSpeakerBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(PiezoSpeakerBrickletFunction::Beep) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PiezoSpeakerBrickletFunction::MorseCode) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PiezoSpeakerBrickletFunction::Calibrate) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PiezoSpeakerBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::piezo_speaker_bricklet::PiezoSpeakerBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::piezo_speaker_bricklet::PiezoSpeakerBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: PiezoSpeakerBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: PiezoSpeakerBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered if a beep set by [`beep`] is finished
    ///
    /// [`beep`]: #method.beep
    pub fn get_beep_finished_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(PiezoSpeakerBrickletFunction::CallbackBeepFinished))
    }

    /// This receiver is triggered if the playback of the morse code set by
    /// [`morse_code`] is finished.
    pub fn get_morse_code_finished_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(PiezoSpeakerBrickletFunction::CallbackMorseCodeFinished))
    }

    /// Beeps with the given frequency for the given duration.
    ///
    /// .. versionchanged:: 2.0.2$nbsp;(Plugin)
    ///    A duration of 0 stops the current beep if any, the frequency parameter is
    ///    ignored. A duration of 4294967295 results in an infinite beep.
    ///
    /// The Piezo Speaker Bricklet can only approximate the frequency, it will play
    /// the best possible match by applying the calibration (see [`calibrate`]).
    ///
    /// Associated constants:
    /// * PIEZO_SPEAKER_BRICKLET_BEEP_DURATION_OFF
    ///	* PIEZO_SPEAKER_BRICKLET_BEEP_DURATION_INFINITE
    pub fn beep(&self, duration: u32, frequency: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(duration));
        payload[4..6].copy_from_slice(&<u16>::to_le_byte_vec(frequency));

        self.device.set(u8::from(PiezoSpeakerBrickletFunction::Beep), payload)
    }

    /// Sets morse code that will be played by the piezo buzzer. The morse code
    /// is given as a string consisting of . (dot), - (minus) and   (space)
    /// for *dits*, *dahs* and *pauses*. Every other character is ignored.
    ///
    /// For example: If you set the string ...---..., the piezo buzzer will beep
    /// nine times with the durations short short short long long long short
    /// short short.
    pub fn morse_code(&self, morse: String, frequency: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 62];
        match <String>::try_to_le_byte_vec(morse, 60) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[0..60].copy_from_slice(&bytes),
        }

        payload[60..62].copy_from_slice(&<u16>::to_le_byte_vec(frequency));

        self.device.set(u8::from(PiezoSpeakerBrickletFunction::MorseCode), payload)
    }

    /// The Piezo Speaker Bricklet can play 512 different tones. This function
    /// plays each tone and measures the exact frequency back. The result is a
    /// mapping between setting value and frequency. This mapping is stored
    /// in the EEPROM and loaded on startup.
    ///
    /// The Bricklet should come calibrated, you only need to call this
    /// function (once) every time you reflash the Bricklet plugin.
    ///
    /// Returns *true* after the calibration finishes.
    pub fn calibrate(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PiezoSpeakerBrickletFunction::Calibrate), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PiezoSpeakerBrickletFunction::GetIdentity), payload)
    }
}
