/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! 433MHz receiver for outdoor weather station.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/OutdoorWeather_Bricklet_Rust.html).
use crate::{
    byte_converter::*,
    converting_callback_receiver::ConvertingCallbackReceiver,
    converting_receiver::{BrickletRecvTimeoutError, ConvertingReceiver},
    device::*,
    ip_connection::GetRequestSender,
    low_level_traits::*,
};
pub enum OutdoorWeatherBrickletFunction {
    GetStationIdentifiersLowLevel,
    GetSensorIdentifiersLowLevel,
    GetStationData,
    GetSensorData,
    SetStationCallbackConfiguration,
    GetStationCallbackConfiguration,
    SetSensorCallbackConfiguration,
    GetSensorCallbackConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackStationData,
    CallbackSensorData,
}
impl From<OutdoorWeatherBrickletFunction> for u8 {
    fn from(fun: OutdoorWeatherBrickletFunction) -> Self {
        match fun {
            OutdoorWeatherBrickletFunction::GetStationIdentifiersLowLevel => 1,
            OutdoorWeatherBrickletFunction::GetSensorIdentifiersLowLevel => 2,
            OutdoorWeatherBrickletFunction::GetStationData => 3,
            OutdoorWeatherBrickletFunction::GetSensorData => 4,
            OutdoorWeatherBrickletFunction::SetStationCallbackConfiguration => 5,
            OutdoorWeatherBrickletFunction::GetStationCallbackConfiguration => 6,
            OutdoorWeatherBrickletFunction::SetSensorCallbackConfiguration => 7,
            OutdoorWeatherBrickletFunction::GetSensorCallbackConfiguration => 8,
            OutdoorWeatherBrickletFunction::GetSpitfpErrorCount => 234,
            OutdoorWeatherBrickletFunction::SetBootloaderMode => 235,
            OutdoorWeatherBrickletFunction::GetBootloaderMode => 236,
            OutdoorWeatherBrickletFunction::SetWriteFirmwarePointer => 237,
            OutdoorWeatherBrickletFunction::WriteFirmware => 238,
            OutdoorWeatherBrickletFunction::SetStatusLedConfig => 239,
            OutdoorWeatherBrickletFunction::GetStatusLedConfig => 240,
            OutdoorWeatherBrickletFunction::GetChipTemperature => 242,
            OutdoorWeatherBrickletFunction::Reset => 243,
            OutdoorWeatherBrickletFunction::WriteUid => 248,
            OutdoorWeatherBrickletFunction::ReadUid => 249,
            OutdoorWeatherBrickletFunction::GetIdentity => 255,
            OutdoorWeatherBrickletFunction::CallbackStationData => 9,
            OutdoorWeatherBrickletFunction::CallbackSensorData => 10,
        }
    }
}
pub const OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_N: u8 = 0;
pub const OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_NNE: u8 = 1;
pub const OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_NE: u8 = 2;
pub const OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_ENE: u8 = 3;
pub const OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_E: u8 = 4;
pub const OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_ESE: u8 = 5;
pub const OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_SE: u8 = 6;
pub const OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_SSE: u8 = 7;
pub const OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_S: u8 = 8;
pub const OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_SSW: u8 = 9;
pub const OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_SW: u8 = 10;
pub const OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_WSW: u8 = 11;
pub const OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_W: u8 = 12;
pub const OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_WNW: u8 = 13;
pub const OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_NW: u8 = 14;
pub const OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_NNW: u8 = 15;
pub const OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_ERROR: u8 = 255;
pub const OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const OUTDOOR_WEATHER_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const OUTDOOR_WEATHER_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const OUTDOOR_WEATHER_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const OUTDOOR_WEATHER_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy)]
pub struct StationIdentifiersLowLevel {
    pub identifiers_length: u16,
    pub identifiers_chunk_offset: u16,
    pub identifiers_chunk_data: [u8; 60],
}
impl FromByteSlice for StationIdentifiersLowLevel {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> StationIdentifiersLowLevel {
        StationIdentifiersLowLevel {
            identifiers_length: <u16>::from_le_byte_slice(&bytes[0..2]),
            identifiers_chunk_offset: <u16>::from_le_byte_slice(&bytes[2..4]),
            identifiers_chunk_data: <[u8; 60]>::from_le_byte_slice(&bytes[4..64]),
        }
    }
}
impl LowLevelRead<u8, StationIdentifiersResult> for StationIdentifiersLowLevel {
    fn ll_message_length(&self) -> usize { self.identifiers_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.identifiers_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[u8] { &self.identifiers_chunk_data }

    fn get_result(&self) -> StationIdentifiersResult { StationIdentifiersResult {} }
}

#[derive(Clone, Copy)]
pub struct SensorIdentifiersLowLevel {
    pub identifiers_length: u16,
    pub identifiers_chunk_offset: u16,
    pub identifiers_chunk_data: [u8; 60],
}
impl FromByteSlice for SensorIdentifiersLowLevel {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> SensorIdentifiersLowLevel {
        SensorIdentifiersLowLevel {
            identifiers_length: <u16>::from_le_byte_slice(&bytes[0..2]),
            identifiers_chunk_offset: <u16>::from_le_byte_slice(&bytes[2..4]),
            identifiers_chunk_data: <[u8; 60]>::from_le_byte_slice(&bytes[4..64]),
        }
    }
}
impl LowLevelRead<u8, SensorIdentifiersResult> for SensorIdentifiersLowLevel {
    fn ll_message_length(&self) -> usize { self.identifiers_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.identifiers_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[u8] { &self.identifiers_chunk_data }

    fn get_result(&self) -> SensorIdentifiersResult { SensorIdentifiersResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct StationData {
    pub temperature: i16,
    pub humidity: u8,
    pub wind_speed: u32,
    pub gust_speed: u32,
    pub rain: u32,
    pub wind_direction: u8,
    pub battery_low: bool,
    pub last_change: u16,
}
impl FromByteSlice for StationData {
    fn bytes_expected() -> usize { 19 }
    fn from_le_byte_slice(bytes: &[u8]) -> StationData {
        StationData {
            temperature: <i16>::from_le_byte_slice(&bytes[0..2]),
            humidity: <u8>::from_le_byte_slice(&bytes[2..3]),
            wind_speed: <u32>::from_le_byte_slice(&bytes[3..7]),
            gust_speed: <u32>::from_le_byte_slice(&bytes[7..11]),
            rain: <u32>::from_le_byte_slice(&bytes[11..15]),
            wind_direction: <u8>::from_le_byte_slice(&bytes[15..16]),
            battery_low: <bool>::from_le_byte_slice(&bytes[16..17]),
            last_change: <u16>::from_le_byte_slice(&bytes[17..19]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SensorData {
    pub temperature: i16,
    pub humidity: u8,
    pub last_change: u16,
}
impl FromByteSlice for SensorData {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> SensorData {
        SensorData {
            temperature: <i16>::from_le_byte_slice(&bytes[0..2]),
            humidity: <u8>::from_le_byte_slice(&bytes[2..3]),
            last_change: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct StationDataEvent {
    pub identifier: u8,
    pub temperature: i16,
    pub humidity: u8,
    pub wind_speed: u32,
    pub gust_speed: u32,
    pub rain: u32,
    pub wind_direction: u8,
    pub battery_low: bool,
}
impl FromByteSlice for StationDataEvent {
    fn bytes_expected() -> usize { 18 }
    fn from_le_byte_slice(bytes: &[u8]) -> StationDataEvent {
        StationDataEvent {
            identifier: <u8>::from_le_byte_slice(&bytes[0..1]),
            temperature: <i16>::from_le_byte_slice(&bytes[1..3]),
            humidity: <u8>::from_le_byte_slice(&bytes[3..4]),
            wind_speed: <u32>::from_le_byte_slice(&bytes[4..8]),
            gust_speed: <u32>::from_le_byte_slice(&bytes[8..12]),
            rain: <u32>::from_le_byte_slice(&bytes[12..16]),
            wind_direction: <u8>::from_le_byte_slice(&bytes[16..17]),
            battery_low: <bool>::from_le_byte_slice(&bytes[17..18]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SensorDataEvent {
    pub identifier: u8,
    pub temperature: i16,
    pub humidity: u8,
}
impl FromByteSlice for SensorDataEvent {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> SensorDataEvent {
        SensorDataEvent {
            identifier: <u8>::from_le_byte_slice(&bytes[0..1]),
            temperature: <i16>::from_le_byte_slice(&bytes[1..3]),
            humidity: <u8>::from_le_byte_slice(&bytes[3..4]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct StationIdentifiersResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SensorIdentifiersResult {}

/// 433MHz receiver for outdoor weather station
#[derive(Clone)]
pub struct OutdoorWeatherBricklet {
    device: Device,
}
impl OutdoorWeatherBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 288;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Outdoor Weather Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> OutdoorWeatherBricklet {
        let mut result = OutdoorWeatherBricklet { device: Device::new([2, 0, 0], uid, req_sender, 2) };
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::GetStationIdentifiersLowLevel) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::GetSensorIdentifiersLowLevel) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::GetStationData) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::GetSensorData) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::SetStationCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::GetStationCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::SetSensorCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::GetSensorCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(OutdoorWeatherBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::outdoor_weather_bricklet::OutdoorWeatherBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::outdoor_weather_bricklet::OutdoorWeatherBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: OutdoorWeatherBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: OutdoorWeatherBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// Reports the station data every time a new data packet is received.
    /// See [`get_station_data`] for information about the data.
    ///
    /// For each station the receiver will be triggered about every 45 seconds.
    ///
    /// Turn the receiver on/off with [`set_station_callback_configuration`]
    /// (by default it is turned off).
    ///
    /// [`get_station_data`]: #method.get_station_data
    /// [`set_station_callback_configuration`]: #method.set_station_callback_configuration
    pub fn get_station_data_callback_receiver(&self) -> ConvertingCallbackReceiver<StationDataEvent> {
        self.device.get_callback_receiver(u8::from(OutdoorWeatherBrickletFunction::CallbackStationData))
    }

    /// Reports the sensor data every time a new data packet is received.
    /// See [`get_sensor_data`] for information about the data.
    ///
    /// For each sensor the receiver will be called about every 45 seconds.
    ///
    /// Turn the receiver on/off with [`set_sensor_callback_configuration`]
    /// (by default it is turned off).
    pub fn get_sensor_data_callback_receiver(&self) -> ConvertingCallbackReceiver<SensorDataEvent> {
        self.device.get_callback_receiver(u8::from(OutdoorWeatherBrickletFunction::CallbackSensorData))
    }

    /// Returns the identifiers (number between 0 and 255) of all `stations
    /// <https://www.tinkerforge.com/en/shop/accessories/sensors/outdoor-weather-station-ws-6147.html>`__
    /// that have been seen since the startup of the Bricklet.
    ///
    /// Each station gives itself a random identifier on first startup.
    ///
    /// Since firmware version 2.0.2 a station is removed from the list if no data was received for
    /// 12 hours.
    pub fn get_station_identifiers_low_level(&self) -> ConvertingReceiver<StationIdentifiersLowLevel> {
        let payload = vec![0; 0];

        self.device.get(u8::from(OutdoorWeatherBrickletFunction::GetStationIdentifiersLowLevel), payload)
    }

    /// Returns the identifiers (number between 0 and 255) of all `stations
    /// <https://www.tinkerforge.com/en/shop/accessories/sensors/outdoor-weather-station-ws-6147.html>`__
    /// that have been seen since the startup of the Bricklet.
    ///
    /// Each station gives itself a random identifier on first startup.
    ///
    /// Since firmware version 2.0.2 a station is removed from the list if no data was received for
    /// 12 hours.
    pub fn get_station_identifiers(&self) -> Result<Vec<u8>, BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(0, &mut || self.get_station_identifiers_low_level().recv())?;
        Ok(ll_result.0)
    }

    /// Returns the identifiers (number between 0 and 255) of all `sensors
    /// <https://www.tinkerforge.com/en/shop/accessories/sensors/temperature-humidity-sensor-th-6148.html>`__
    /// that have been seen since the startup of the Bricklet.
    ///
    /// Each sensor gives itself a random identifier on first startup.
    ///
    /// Since firmware version 2.0.2 a sensor is removed from the list if no data was received for
    /// 12 hours.
    pub fn get_sensor_identifiers_low_level(&self) -> ConvertingReceiver<SensorIdentifiersLowLevel> {
        let payload = vec![0; 0];

        self.device.get(u8::from(OutdoorWeatherBrickletFunction::GetSensorIdentifiersLowLevel), payload)
    }

    /// Returns the identifiers (number between 0 and 255) of all `sensors
    /// <https://www.tinkerforge.com/en/shop/accessories/sensors/temperature-humidity-sensor-th-6148.html>`__
    /// that have been seen since the startup of the Bricklet.
    ///
    /// Each sensor gives itself a random identifier on first startup.
    ///
    /// Since firmware version 2.0.2 a sensor is removed from the list if no data was received for
    /// 12 hours.
    pub fn get_sensor_identifiers(&self) -> Result<Vec<u8>, BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(1, &mut || self.get_sensor_identifiers_low_level().recv())?;
        Ok(ll_result.0)
    }

    /// Returns the last received data for a station with the given identifier.
    /// Call [`get_station_identifiers`] for a list of all available identifiers.
    ///
    /// The return values are:
    ///
    /// * Temperature,
    /// * Humidity,
    /// * Wind Speed,
    /// * Gust Speed,
    /// * Rain Fall (accumulated since station power-up),
    /// * Wind Direction,
    /// * Battery Low (true if battery is low) and
    /// * Last Change (seconds since the reception of this data).
    ///
    /// Associated constants:
    /// * OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_N
    ///	* OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_NNE
    ///	* OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_NE
    ///	* OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_ENE
    ///	* OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_E
    ///	* OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_ESE
    ///	* OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_SE
    ///	* OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_SSE
    ///	* OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_S
    ///	* OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_SSW
    ///	* OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_SW
    ///	* OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_WSW
    ///	* OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_W
    ///	* OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_WNW
    ///	* OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_NW
    ///	* OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_NNW
    ///	* OUTDOOR_WEATHER_BRICKLET_WIND_DIRECTION_ERROR
    pub fn get_station_data(&self, identifier: u8) -> ConvertingReceiver<StationData> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(identifier));

        self.device.get(u8::from(OutdoorWeatherBrickletFunction::GetStationData), payload)
    }

    /// Returns the last measured data for a sensor with the given identifier.
    /// Call [`get_sensor_identifiers`] for a list of all available identifiers.
    ///
    /// The return values are:
    ///
    /// * Temperature,
    /// * Humidity and
    /// * Last Change (seconds since the last reception of data).
    pub fn get_sensor_data(&self, identifier: u8) -> ConvertingReceiver<SensorData> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(identifier));

        self.device.get(u8::from(OutdoorWeatherBrickletFunction::GetSensorData), payload)
    }

    /// Turns receiver for station data on or off.
    pub fn set_station_callback_configuration(&self, enable_callback: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enable_callback));

        self.device.set(u8::from(OutdoorWeatherBrickletFunction::SetStationCallbackConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_station_callback_configuration`].
    pub fn get_station_callback_configuration(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(OutdoorWeatherBrickletFunction::GetStationCallbackConfiguration), payload)
    }

    /// Turns receiver for sensor data on or off.
    pub fn set_sensor_callback_configuration(&self, enable_callback: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enable_callback));

        self.device.set(u8::from(OutdoorWeatherBrickletFunction::SetSensorCallbackConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_sensor_callback_configuration`].
    pub fn get_sensor_callback_configuration(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(OutdoorWeatherBrickletFunction::GetSensorCallbackConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(OutdoorWeatherBrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(OutdoorWeatherBrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* OUTDOOR_WEATHER_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(OutdoorWeatherBrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(OutdoorWeatherBrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(OutdoorWeatherBrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * OUTDOOR_WEATHER_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* OUTDOOR_WEATHER_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* OUTDOOR_WEATHER_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* OUTDOOR_WEATHER_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(OutdoorWeatherBrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * OUTDOOR_WEATHER_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* OUTDOOR_WEATHER_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* OUTDOOR_WEATHER_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* OUTDOOR_WEATHER_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(OutdoorWeatherBrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(OutdoorWeatherBrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(OutdoorWeatherBrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(OutdoorWeatherBrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(OutdoorWeatherBrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(OutdoorWeatherBrickletFunction::GetIdentity), payload)
    }
}
