/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! 1.68cm (0.66") OLED display with 64x48 pixels.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/OLED64x48_Bricklet_Rust.html).
use crate::{
    byte_converter::*,
    converting_receiver::{BrickletError, ConvertingReceiver},
    device::*,
    ip_connection::GetRequestSender,
};
pub enum Oled64x48BrickletFunction {
    Write,
    NewWindow,
    ClearDisplay,
    SetDisplayConfiguration,
    GetDisplayConfiguration,
    WriteLine,
    GetIdentity,
}
impl From<Oled64x48BrickletFunction> for u8 {
    fn from(fun: Oled64x48BrickletFunction) -> Self {
        match fun {
            Oled64x48BrickletFunction::Write => 1,
            Oled64x48BrickletFunction::NewWindow => 2,
            Oled64x48BrickletFunction::ClearDisplay => 3,
            Oled64x48BrickletFunction::SetDisplayConfiguration => 4,
            Oled64x48BrickletFunction::GetDisplayConfiguration => 5,
            Oled64x48BrickletFunction::WriteLine => 6,
            Oled64x48BrickletFunction::GetIdentity => 255,
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct DisplayConfiguration {
    pub contrast: u8,
    pub invert: bool,
}
impl FromByteSlice for DisplayConfiguration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> DisplayConfiguration {
        DisplayConfiguration { contrast: <u8>::from_le_byte_slice(&bytes[0..1]), invert: <bool>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// 1.68cm (0.66") OLED display with 64x48 pixels
#[derive(Clone)]
pub struct Oled64x48Bricklet {
    device: Device,
}
impl Oled64x48Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 264;
    pub const DEVICE_DISPLAY_NAME: &'static str = "OLED 64x48 Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> Oled64x48Bricklet {
        let mut result = Oled64x48Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(Oled64x48BrickletFunction::Write) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Oled64x48BrickletFunction::NewWindow) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Oled64x48BrickletFunction::ClearDisplay) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Oled64x48BrickletFunction::SetDisplayConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Oled64x48BrickletFunction::GetDisplayConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Oled64x48BrickletFunction::WriteLine) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Oled64x48BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::oled_64x48_bricklet::Oled64x48Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::oled_64x48_bricklet::Oled64x48Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: Oled64x48BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: Oled64x48BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// Appends 64 byte of data to the window as set by [`new_window`].
    ///
    /// Each row has a height of 8 pixels which corresponds to one byte of data.
    ///
    /// Example: if you call [`new_window`] with column from 0 to 63 and row
    /// from 0 to 5 (the whole display) each call of [`write`] (red arrow) will
    /// write one row.
    ///
    /// .. image:: /Images/Bricklets/bricklet_oled_64x48_display.png
    ///    :scale: 100 %
    ///    :alt: Display pixel order
    ///    :align: center
    ///    :target: ../../_images/Bricklets/bricklet_oled_64x48_display.png
    ///
    /// The LSB (D0) of each data byte is at the top and the MSB (D7) is at the
    /// bottom of the row.
    ///
    /// The next call of [`write`] will write the second row and so on. To
    /// fill the whole display you need to call [`write`] 6 times.
    ///
    /// [`write`]: #method.write
    /// [`new_window`]: #method.new_window
    pub fn write(&self, data: [u8; 64]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.set(u8::from(Oled64x48BrickletFunction::Write), payload)
    }

    /// Sets the window in which you can write with [`write`]. One row
    /// has a height of 8 pixels.
    pub fn new_window(&self, column_from: u8, column_to: u8, row_from: u8, row_to: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(column_from));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(column_to));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(row_from));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(row_to));

        self.device.set(u8::from(Oled64x48BrickletFunction::NewWindow), payload)
    }

    /// Clears the current content of the window as set by [`new_window`].
    pub fn clear_display(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Oled64x48BrickletFunction::ClearDisplay), payload)
    }

    /// Sets the configuration of the display.
    ///
    /// You can set a contrast value from 0 to 255 and you can invert the color
    /// (black/white) of the display.
    pub fn set_display_configuration(&self, contrast: u8, invert: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(contrast));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(invert));

        self.device.set(u8::from(Oled64x48BrickletFunction::SetDisplayConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_display_configuration`].
    pub fn get_display_configuration(&self) -> ConvertingReceiver<DisplayConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Oled64x48BrickletFunction::GetDisplayConfiguration), payload)
    }

    /// Writes text to a specific line with a specific position.
    /// The text can have a maximum of 13 characters.
    ///
    /// For example: (1, 4, Hello) will write *Hello* in the middle of the
    /// second line of the display.
    ///
    /// You can draw to the display with [`write`] and then add text to it
    /// afterwards.
    ///
    /// The display uses a special 5x7 pixel charset. You can view the characters
    /// of the charset in Brick Viewer.
    ///
    /// The font conforms to code page 437.
    pub fn write_line(&self, line: u8, position: u8, text: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 15];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(line));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(position));
        match <String>::try_to_le_byte_vec(text, 13) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[2..15].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(Oled64x48BrickletFunction::WriteLine), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Oled64x48BrickletFunction::GetIdentity), payload)
    }
}
