/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Reads and writes NFC and RFID tags.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/NFCRFID_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum NfcRfidBrickletFunction {
    RequestTagId,
    GetTagId,
    GetState,
    AuthenticateMifareClassicPage,
    WritePage,
    RequestPage,
    GetPage,
    GetIdentity,
    CallbackStateChanged,
}
impl From<NfcRfidBrickletFunction> for u8 {
    fn from(fun: NfcRfidBrickletFunction) -> Self {
        match fun {
            NfcRfidBrickletFunction::RequestTagId => 1,
            NfcRfidBrickletFunction::GetTagId => 2,
            NfcRfidBrickletFunction::GetState => 3,
            NfcRfidBrickletFunction::AuthenticateMifareClassicPage => 4,
            NfcRfidBrickletFunction::WritePage => 5,
            NfcRfidBrickletFunction::RequestPage => 6,
            NfcRfidBrickletFunction::GetPage => 7,
            NfcRfidBrickletFunction::GetIdentity => 255,
            NfcRfidBrickletFunction::CallbackStateChanged => 8,
        }
    }
}
pub const NFC_RFID_BRICKLET_TAG_TYPE_MIFARE_CLASSIC: u8 = 0;
pub const NFC_RFID_BRICKLET_TAG_TYPE_TYPE1: u8 = 1;
pub const NFC_RFID_BRICKLET_TAG_TYPE_TYPE2: u8 = 2;
pub const NFC_RFID_BRICKLET_STATE_INITIALIZATION: u8 = 0;
pub const NFC_RFID_BRICKLET_STATE_IDLE: u8 = 128;
pub const NFC_RFID_BRICKLET_STATE_ERROR: u8 = 192;
pub const NFC_RFID_BRICKLET_STATE_REQUEST_TAG_ID: u8 = 2;
pub const NFC_RFID_BRICKLET_STATE_REQUEST_TAG_ID_READY: u8 = 130;
pub const NFC_RFID_BRICKLET_STATE_REQUEST_TAG_ID_ERROR: u8 = 194;
pub const NFC_RFID_BRICKLET_STATE_AUTHENTICATING_MIFARE_CLASSIC_PAGE: u8 = 3;
pub const NFC_RFID_BRICKLET_STATE_AUTHENTICATING_MIFARE_CLASSIC_PAGE_READY: u8 = 131;
pub const NFC_RFID_BRICKLET_STATE_AUTHENTICATING_MIFARE_CLASSIC_PAGE_ERROR: u8 = 195;
pub const NFC_RFID_BRICKLET_STATE_WRITE_PAGE: u8 = 4;
pub const NFC_RFID_BRICKLET_STATE_WRITE_PAGE_READY: u8 = 132;
pub const NFC_RFID_BRICKLET_STATE_WRITE_PAGE_ERROR: u8 = 196;
pub const NFC_RFID_BRICKLET_STATE_REQUEST_PAGE: u8 = 5;
pub const NFC_RFID_BRICKLET_STATE_REQUEST_PAGE_READY: u8 = 133;
pub const NFC_RFID_BRICKLET_STATE_REQUEST_PAGE_ERROR: u8 = 197;
pub const NFC_RFID_BRICKLET_KEY_A: u8 = 0;
pub const NFC_RFID_BRICKLET_KEY_B: u8 = 1;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct TagId {
    pub tag_type: u8,
    pub tid_length: u8,
    pub tid: [u8; 7],
}
impl FromByteSlice for TagId {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> TagId {
        TagId {
            tag_type: <u8>::from_le_byte_slice(&bytes[0..1]),
            tid_length: <u8>::from_le_byte_slice(&bytes[1..2]),
            tid: <[u8; 7]>::from_le_byte_slice(&bytes[2..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct State {
    pub state: u8,
    pub idle: bool,
}
impl FromByteSlice for State {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> State {
        State { state: <u8>::from_le_byte_slice(&bytes[0..1]), idle: <bool>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct StateChangedEvent {
    pub state: u8,
    pub idle: bool,
}
impl FromByteSlice for StateChangedEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> StateChangedEvent {
        StateChangedEvent { state: <u8>::from_le_byte_slice(&bytes[0..1]), idle: <bool>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Reads and writes NFC and RFID tags
#[derive(Clone)]
pub struct NfcRfidBricklet {
    device: Device,
}
impl NfcRfidBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 246;
    pub const DEVICE_DISPLAY_NAME: &'static str = "NFC/RFID Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> NfcRfidBricklet {
        let mut result = NfcRfidBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(NfcRfidBrickletFunction::RequestTagId) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(NfcRfidBrickletFunction::GetTagId) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcRfidBrickletFunction::GetState) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcRfidBrickletFunction::AuthenticateMifareClassicPage) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(NfcRfidBrickletFunction::WritePage) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(NfcRfidBrickletFunction::RequestPage) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(NfcRfidBrickletFunction::GetPage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcRfidBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::nfc_rfid_bricklet::NfcRfidBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::nfc_rfid_bricklet::NfcRfidBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: NfcRfidBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: NfcRfidBrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is called if the state of the NFC/RFID Bricklet changes.
    /// See [`get_state`] for more information about the possible states.
    ///
    /// [`get_state`]: #method.get_state
    pub fn get_state_changed_callback_receiver(&self) -> ConvertingCallbackReceiver<StateChangedEvent> {
        self.device.get_callback_receiver(u8::from(NfcRfidBrickletFunction::CallbackStateChanged))
    }

    /// To read or write a tag that is in proximity of the NFC/RFID Bricklet you
    /// first have to call this function with the expected tag type as parameter.
    /// It is no problem if you don't know the tag type. You can cycle through
    /// the available tag types until the tag gives an answer to the request.
    ///
    /// Currently the following tag types are supported:
    ///
    /// * Mifare Classic
    /// * NFC Forum Type 1
    /// * NFC Forum Type 2
    ///
    /// After you call [`request_tag_id`] the NFC/RFID Bricklet will try to read
    /// the tag ID from the tag. After this process is done the state will change.
    /// You can either register the [`get_state_changed_callback_receiver`] receiver or you can poll
    /// [`get_state`] to find out about the state change.
    ///
    /// If the state changes to *RequestTagIDError* it means that either there was
    /// no tag present or that the tag is of an incompatible type. If the state
    /// changes to *RequestTagIDReady* it means that a compatible tag was found
    /// and that the tag ID could be read out. You can now get the tag ID by
    /// calling [`get_tag_id`].
    ///
    /// If two tags are in the proximity of the NFC/RFID Bricklet, this
    /// function will cycle through the tags. To select a specific tag you have
    /// to call [`request_tag_id`] until the correct tag id is found.
    ///
    /// In case of any *Error* state the selection is lost and you have to
    /// start again by calling [`request_tag_id`].
    ///
    /// Associated constants:
    /// * NFC_RFID_BRICKLET_TAG_TYPE_MIFARE_CLASSIC
    ///	* NFC_RFID_BRICKLET_TAG_TYPE_TYPE1
    ///	* NFC_RFID_BRICKLET_TAG_TYPE_TYPE2
    pub fn request_tag_id(&self, tag_type: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(tag_type));

        self.device.set(u8::from(NfcRfidBrickletFunction::RequestTagId), payload)
    }

    /// Returns the tag type, tag ID and the length of the tag ID
    /// (4 or 7 bytes are possible length). This function can only be called if the
    /// NFC/RFID is currently in one of the *Ready* states. The returned ID
    /// is the ID that was saved through the last call of [`request_tag_id`].
    ///
    /// To get the tag ID of a tag the approach is as follows:
    ///
    /// 1. Call [`request_tag_id`]
    /// 2. Wait for state to change to *RequestTagIDReady* (see [`get_state`] or
    ///    [`get_state_changed_callback_receiver`] receiver)
    /// 3. Call [`get_tag_id`]
    ///
    /// Associated constants:
    /// * NFC_RFID_BRICKLET_TAG_TYPE_MIFARE_CLASSIC
    ///	* NFC_RFID_BRICKLET_TAG_TYPE_TYPE1
    ///	* NFC_RFID_BRICKLET_TAG_TYPE_TYPE2
    pub fn get_tag_id(&self) -> ConvertingReceiver<TagId> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcRfidBrickletFunction::GetTagId), payload)
    }

    /// Returns the current state of the NFC/RFID Bricklet.
    ///
    /// On startup the Bricklet will be in the *Initialization* state. The
    /// initialization will only take about 20ms. After that it changes to *Idle*.
    ///
    /// The functions of this Bricklet can be called in the *Idle* state and all of
    /// the *Ready* and *Error* states.
    ///
    /// Example: If you call [`request_page`], the state will change to
    /// *RequestPage* until the reading of the page is finished. Then it will change
    /// to either *RequestPageReady* if it worked or to *RequestPageError* if it
    /// didn't. If the request worked you can get the page by calling [`get_page`].
    ///
    /// The same approach is used analogously for the other API functions.
    ///
    /// Associated constants:
    /// * NFC_RFID_BRICKLET_STATE_INITIALIZATION
    ///	* NFC_RFID_BRICKLET_STATE_IDLE
    ///	* NFC_RFID_BRICKLET_STATE_ERROR
    ///	* NFC_RFID_BRICKLET_STATE_REQUEST_TAG_ID
    ///	* NFC_RFID_BRICKLET_STATE_REQUEST_TAG_ID_READY
    ///	* NFC_RFID_BRICKLET_STATE_REQUEST_TAG_ID_ERROR
    ///	* NFC_RFID_BRICKLET_STATE_AUTHENTICATING_MIFARE_CLASSIC_PAGE
    ///	* NFC_RFID_BRICKLET_STATE_AUTHENTICATING_MIFARE_CLASSIC_PAGE_READY
    ///	* NFC_RFID_BRICKLET_STATE_AUTHENTICATING_MIFARE_CLASSIC_PAGE_ERROR
    ///	* NFC_RFID_BRICKLET_STATE_WRITE_PAGE
    ///	* NFC_RFID_BRICKLET_STATE_WRITE_PAGE_READY
    ///	* NFC_RFID_BRICKLET_STATE_WRITE_PAGE_ERROR
    ///	* NFC_RFID_BRICKLET_STATE_REQUEST_PAGE
    ///	* NFC_RFID_BRICKLET_STATE_REQUEST_PAGE_READY
    ///	* NFC_RFID_BRICKLET_STATE_REQUEST_PAGE_ERROR
    pub fn get_state(&self) -> ConvertingReceiver<State> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcRfidBrickletFunction::GetState), payload)
    }

    /// Mifare Classic tags use authentication. If you want to read from or write to
    /// a Mifare Classic page you have to authenticate it beforehand.
    /// Each page can be authenticated with two keys: A (``key_number`` = 0) and B
    /// (``key_number`` = 1). A new Mifare Classic
    /// tag that has not yet been written to can be accessed with key A
    /// and the default key ``[0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF]``.
    ///
    /// The approach to read or write a Mifare Classic page is as follows:
    ///
    /// 1. Call [`request_tag_id`]
    /// 2. Wait for state to change to *RequestTagIDReady* (see [`get_state`]
    ///    or [`get_state_changed_callback_receiver`] receiver)
    /// 3. If looking for a specific tag then call [`get_tag_id`] and check if the
    ///    expected tag was found, if it was not found go back to step 1
    /// 4. Call [`authenticate_mifare_classic_page`] with page and key for the page
    /// 5. Wait for state to change to *AuthenticatingMifareClassicPageReady* (see
    ///    [`get_state`] or [`get_state_changed_callback_receiver`] receiver)
    /// 6. Call [`request_page`] or [`write_page`] to read/write page
    ///
    /// Associated constants:
    /// * NFC_RFID_BRICKLET_KEY_A
    ///	* NFC_RFID_BRICKLET_KEY_B
    pub fn authenticate_mifare_classic_page(&self, page: u16, key_number: u8, key: [u8; 6]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(page));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(key_number));
        payload[3..9].copy_from_slice(&<[u8; 6]>::to_le_byte_vec(key));

        self.device.set(u8::from(NfcRfidBrickletFunction::AuthenticateMifareClassicPage), payload)
    }

    /// Writes 16 bytes starting from the given page. How many pages are written
    /// depends on the tag type. The page sizes are as follows:
    ///
    /// * Mifare Classic page size: 16 byte (one page is written)
    /// * NFC Forum Type 1 page size: 8 byte (two pages are written)
    /// * NFC Forum Type 2 page size: 4 byte (four pages are written)
    ///
    /// The general approach for writing to a tag is as follows:
    ///
    /// 1. Call [`request_tag_id`]
    /// 2. Wait for state to change to *RequestTagIDReady* (see [`get_state`] or
    ///    [`get_state_changed_callback_receiver`] receiver)
    /// 3. If looking for a specific tag then call [`get_tag_id`] and check if the
    ///    expected tag was found, if it was not found got back to step 1
    /// 4. Call [`write_page`] with page number and data
    /// 5. Wait for state to change to *WritePageReady* (see [`get_state`] or
    ///    [`get_state_changed_callback_receiver`] receiver)
    ///
    /// If you use a Mifare Classic tag you have to authenticate a page before you
    /// can write to it. See [`authenticate_mifare_classic_page`].
    pub fn write_page(&self, page: u16, data: [u8; 16]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 18];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(page));
        payload[2..18].copy_from_slice(&<[u8; 16]>::to_le_byte_vec(data));

        self.device.set(u8::from(NfcRfidBrickletFunction::WritePage), payload)
    }

    /// Reads 16 bytes starting from the given page and stores them into a buffer.
    /// The buffer can then be read out with [`get_page`].
    /// How many pages are read depends on the tag type. The page sizes are
    /// as follows:
    ///
    /// * Mifare Classic page size: 16 byte (one page is read)
    /// * NFC Forum Type 1 page size: 8 byte (two pages are read)
    /// * NFC Forum Type 2 page size: 4 byte (four pages are read)
    ///
    /// The general approach for reading a tag is as follows:
    ///
    /// 1. Call [`request_tag_id`]
    /// 2. Wait for state to change to *RequestTagIDReady* (see [`get_state`]
    ///    or [`get_state_changed_callback_receiver`] receiver)
    /// 3. If looking for a specific tag then call [`get_tag_id`] and check if the
    ///    expected tag was found, if it was not found got back to step 1
    /// 4. Call [`request_page`] with page number
    /// 5. Wait for state to change to *RequestPageReady* (see [`get_state`]
    ///    or [`get_state_changed_callback_receiver`] receiver)
    /// 6. Call [`get_page`] to retrieve the page from the buffer
    ///
    /// If you use a Mifare Classic tag you have to authenticate a page before you
    /// can read it. See [`authenticate_mifare_classic_page`].
    pub fn request_page(&self, page: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(page));

        self.device.set(u8::from(NfcRfidBrickletFunction::RequestPage), payload)
    }

    /// Returns 16 bytes of data from an internal buffer. To fill the buffer
    /// with specific pages you have to call [`request_page`] beforehand.
    pub fn get_page(&self) -> ConvertingReceiver<[u8; 16]> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcRfidBrickletFunction::GetPage), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcRfidBrickletFunction::GetIdentity), payload)
    }
}
