/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Passive infrared (PIR) motion sensor with 7m range.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/MotionDetector_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum MotionDetectorBrickletFunction {
    GetMotionDetected,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetIdentity,
    CallbackMotionDetected,
    CallbackDetectionCycleEnded,
}
impl From<MotionDetectorBrickletFunction> for u8 {
    fn from(fun: MotionDetectorBrickletFunction) -> Self {
        match fun {
            MotionDetectorBrickletFunction::GetMotionDetected => 1,
            MotionDetectorBrickletFunction::SetStatusLedConfig => 4,
            MotionDetectorBrickletFunction::GetStatusLedConfig => 5,
            MotionDetectorBrickletFunction::GetIdentity => 255,
            MotionDetectorBrickletFunction::CallbackMotionDetected => 2,
            MotionDetectorBrickletFunction::CallbackDetectionCycleEnded => 3,
        }
    }
}
pub const MOTION_DETECTOR_BRICKLET_MOTION_NOT_DETECTED: u8 = 0;
pub const MOTION_DETECTOR_BRICKLET_MOTION_DETECTED: u8 = 1;
pub const MOTION_DETECTOR_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const MOTION_DETECTOR_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const MOTION_DETECTOR_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 2;

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Passive infrared (PIR) motion sensor with 7m range
#[derive(Clone)]
pub struct MotionDetectorBricklet {
    device: Device,
}
impl MotionDetectorBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 233;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Motion Detector Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> MotionDetectorBricklet {
        let mut result = MotionDetectorBricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(MotionDetectorBrickletFunction::GetMotionDetected) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MotionDetectorBrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MotionDetectorBrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MotionDetectorBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::motion_detector_bricklet::MotionDetectorBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::motion_detector_bricklet::MotionDetectorBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: MotionDetectorBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: MotionDetectorBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is called after a motion was detected.
    pub fn get_motion_detected_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(MotionDetectorBrickletFunction::CallbackMotionDetected))
    }

    /// This receiver is called when the detection cycle ended. When this
    /// receiver is called, a new motion can be detected again after approximately 2
    /// seconds.
    pub fn get_detection_cycle_ended_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(MotionDetectorBrickletFunction::CallbackDetectionCycleEnded))
    }

    /// Returns 1 if a motion was detected. How long this returns 1 after a motion
    /// was detected can be adjusted with one of the small potentiometers on the
    /// Motion Detector Bricklet, see `here
    /// <motion_detector_bricklet_sensitivity_delay_block_time>`.
    ///
    /// There is also a blue LED on the Bricklet that is on as long as the Bricklet is
    /// in the motion detected state.
    ///
    /// Associated constants:
    /// * MOTION_DETECTOR_BRICKLET_MOTION_NOT_DETECTED
    ///	* MOTION_DETECTOR_BRICKLET_MOTION_DETECTED
    pub fn get_motion_detected(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MotionDetectorBrickletFunction::GetMotionDetected), payload)
    }

    /// Sets the status led configuration.
    ///
    /// By default the status LED turns on if a motion is detected and off is no motion
    /// is detected.
    ///
    /// You can also turn the LED permanently on/off.
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * MOTION_DETECTOR_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* MOTION_DETECTOR_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* MOTION_DETECTOR_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(MotionDetectorBrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`].
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * MOTION_DETECTOR_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* MOTION_DETECTOR_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* MOTION_DETECTOR_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MotionDetectorBrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MotionDetectorBrickletFunction::GetIdentity), payload)
    }
}
