/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures soil moisture.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/Moisture_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum MoistureBrickletFunction {
    GetMoistureValue,
    SetMoistureCallbackPeriod,
    GetMoistureCallbackPeriod,
    SetMoistureCallbackThreshold,
    GetMoistureCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    SetMovingAverage,
    GetMovingAverage,
    GetIdentity,
    CallbackMoisture,
    CallbackMoistureReached,
}
impl From<MoistureBrickletFunction> for u8 {
    fn from(fun: MoistureBrickletFunction) -> Self {
        match fun {
            MoistureBrickletFunction::GetMoistureValue => 1,
            MoistureBrickletFunction::SetMoistureCallbackPeriod => 2,
            MoistureBrickletFunction::GetMoistureCallbackPeriod => 3,
            MoistureBrickletFunction::SetMoistureCallbackThreshold => 4,
            MoistureBrickletFunction::GetMoistureCallbackThreshold => 5,
            MoistureBrickletFunction::SetDebouncePeriod => 6,
            MoistureBrickletFunction::GetDebouncePeriod => 7,
            MoistureBrickletFunction::SetMovingAverage => 10,
            MoistureBrickletFunction::GetMovingAverage => 11,
            MoistureBrickletFunction::GetIdentity => 255,
            MoistureBrickletFunction::CallbackMoisture => 8,
            MoistureBrickletFunction::CallbackMoistureReached => 9,
        }
    }
}
pub const MOISTURE_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const MOISTURE_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const MOISTURE_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const MOISTURE_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const MOISTURE_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MoistureCallbackThreshold {
    pub option: char,
    pub min: u16,
    pub max: u16,
}
impl FromByteSlice for MoistureCallbackThreshold {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> MoistureCallbackThreshold {
        MoistureCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <u16>::from_le_byte_slice(&bytes[1..3]),
            max: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures soil moisture
#[derive(Clone)]
pub struct MoistureBricklet {
    device: Device,
}
impl MoistureBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 232;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Moisture Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> MoistureBricklet {
        let mut result = MoistureBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(MoistureBrickletFunction::GetMoistureValue) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MoistureBrickletFunction::SetMoistureCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(MoistureBrickletFunction::GetMoistureCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MoistureBrickletFunction::SetMoistureCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(MoistureBrickletFunction::GetMoistureCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MoistureBrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(MoistureBrickletFunction::GetDebouncePeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MoistureBrickletFunction::SetMovingAverage) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MoistureBrickletFunction::GetMovingAverage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MoistureBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::moisture_bricklet::MoistureBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::moisture_bricklet::MoistureBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: MoistureBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: MoistureBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_moisture_callback_period`]. The parameter is the
    /// moisture value of the sensor.
    ///
    /// The [`get_moisture_callback_receiver`] receiver is only triggered if the moisture value has changed
    /// since the last triggering.
    ///
    /// [`set_moisture_callback_period`]: #method.set_moisture_callback_period
    /// [`get_moisture_callback_receiver`]: #method.get_moisture_callback_receiver
    pub fn get_moisture_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(MoistureBrickletFunction::CallbackMoisture))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_moisture_callback_threshold`] is reached.
    /// The parameter is the moisture value of the sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_moisture_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(MoistureBrickletFunction::CallbackMoistureReached))
    }

    /// Returns the current moisture value.
    /// A small value corresponds to little moisture, a big
    /// value corresponds to much moisture.
    ///
    /// If you want to get the moisture value periodically, it is recommended
    /// to use the [`get_moisture_callback_receiver`] receiver and set the period with
    /// [`set_moisture_callback_period`].
    pub fn get_moisture_value(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MoistureBrickletFunction::GetMoistureValue), payload)
    }

    /// Sets the period with which the [`get_moisture_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_moisture_callback_receiver`] receiver is only triggered if the moisture value has changed
    /// since the last triggering.
    pub fn set_moisture_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(MoistureBrickletFunction::SetMoistureCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_moisture_callback_period`].
    pub fn get_moisture_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MoistureBrickletFunction::GetMoistureCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_moisture_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the moisture value is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the moisture value is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the moisture value is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the moisture value is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * MOISTURE_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* MOISTURE_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* MOISTURE_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* MOISTURE_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* MOISTURE_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_moisture_callback_threshold(&self, option: char, min: u16, max: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(max));

        self.device.set(u8::from(MoistureBrickletFunction::SetMoistureCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_moisture_callback_threshold`].
    ///
    /// Associated constants:
    /// * MOISTURE_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* MOISTURE_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* MOISTURE_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* MOISTURE_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* MOISTURE_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_moisture_callback_threshold(&self) -> ConvertingReceiver<MoistureCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MoistureBrickletFunction::GetMoistureCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receiver
    ///
    /// * [`get_moisture_reached_callback_receiver`]
    ///
    /// is triggered, if the threshold
    ///
    /// * [`set_moisture_callback_threshold`]
    ///
    /// keeps being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(MoistureBrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MoistureBrickletFunction::GetDebouncePeriod), payload)
    }

    /// Sets the length of a [moving averaging](https://en.wikipedia.org/wiki/Moving_average)__
    /// for the moisture value.
    ///
    /// Setting the length to 0 will turn the averaging completely off. With less
    /// averaging, there is more noise on the data.
    pub fn set_moving_average(&self, average: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(average));

        self.device.set(u8::from(MoistureBrickletFunction::SetMovingAverage), payload)
    }

    /// Returns the length moving average as set by [`set_moving_average`].
    pub fn get_moving_average(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MoistureBrickletFunction::GetMovingAverage), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MoistureBrickletFunction::GetIdentity), payload)
    }
}
