/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Basis to build stacks and has 4 Bricklet ports.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricks/Master_Brick_Rust.html).
use crate::{
    byte_converter::*,
    converting_callback_receiver::ConvertingCallbackReceiver,
    converting_receiver::{BrickletError, ConvertingReceiver},
    device::*,
    ip_connection::GetRequestSender,
};
pub enum MasterBrickFunction {
    GetStackVoltage,
    GetStackCurrent,
    SetExtensionType,
    GetExtensionType,
    IsChibiPresent,
    SetChibiAddress,
    GetChibiAddress,
    SetChibiMasterAddress,
    GetChibiMasterAddress,
    SetChibiSlaveAddress,
    GetChibiSlaveAddress,
    GetChibiSignalStrength,
    GetChibiErrorLog,
    SetChibiFrequency,
    GetChibiFrequency,
    SetChibiChannel,
    GetChibiChannel,
    IsRs485Present,
    SetRs485Address,
    GetRs485Address,
    SetRs485SlaveAddress,
    GetRs485SlaveAddress,
    GetRs485ErrorLog,
    SetRs485Configuration,
    GetRs485Configuration,
    IsWifiPresent,
    SetWifiConfiguration,
    GetWifiConfiguration,
    SetWifiEncryption,
    GetWifiEncryption,
    GetWifiStatus,
    RefreshWifiStatus,
    SetWifiCertificate,
    GetWifiCertificate,
    SetWifiPowerMode,
    GetWifiPowerMode,
    GetWifiBufferInfo,
    SetWifiRegulatoryDomain,
    GetWifiRegulatoryDomain,
    GetUsbVoltage,
    SetLongWifiKey,
    GetLongWifiKey,
    SetWifiHostname,
    GetWifiHostname,
    SetStackCurrentCallbackPeriod,
    GetStackCurrentCallbackPeriod,
    SetStackVoltageCallbackPeriod,
    GetStackVoltageCallbackPeriod,
    SetUsbVoltageCallbackPeriod,
    GetUsbVoltageCallbackPeriod,
    SetStackCurrentCallbackThreshold,
    GetStackCurrentCallbackThreshold,
    SetStackVoltageCallbackThreshold,
    GetStackVoltageCallbackThreshold,
    SetUsbVoltageCallbackThreshold,
    GetUsbVoltageCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    IsEthernetPresent,
    SetEthernetConfiguration,
    GetEthernetConfiguration,
    GetEthernetStatus,
    SetEthernetHostname,
    SetEthernetMacAddress,
    SetEthernetWebsocketConfiguration,
    GetEthernetWebsocketConfiguration,
    SetEthernetAuthenticationSecret,
    GetEthernetAuthenticationSecret,
    SetWifiAuthenticationSecret,
    GetWifiAuthenticationSecret,
    GetConnectionType,
    IsWifi2Present,
    StartWifi2Bootloader,
    WriteWifi2SerialPort,
    ReadWifi2SerialPort,
    SetWifi2AuthenticationSecret,
    GetWifi2AuthenticationSecret,
    SetWifi2Configuration,
    GetWifi2Configuration,
    GetWifi2Status,
    SetWifi2ClientConfiguration,
    GetWifi2ClientConfiguration,
    SetWifi2ClientHostname,
    GetWifi2ClientHostname,
    SetWifi2ClientPassword,
    GetWifi2ClientPassword,
    SetWifi2ApConfiguration,
    GetWifi2ApConfiguration,
    SetWifi2ApPassword,
    GetWifi2ApPassword,
    SaveWifi2Configuration,
    GetWifi2FirmwareVersion,
    EnableWifi2StatusLed,
    DisableWifi2StatusLed,
    IsWifi2StatusLedEnabled,
    SetWifi2MeshConfiguration,
    GetWifi2MeshConfiguration,
    SetWifi2MeshRouterSsid,
    GetWifi2MeshRouterSsid,
    SetWifi2MeshRouterPassword,
    GetWifi2MeshRouterPassword,
    GetWifi2MeshCommonStatus,
    GetWifi2MeshClientStatus,
    GetWifi2MeshApStatus,
    SetBrickletXmcFlashConfig,
    SetBrickletXmcFlashData,
    SetBrickletsEnabled,
    GetBrickletsEnabled,
    SetSpitfpBaudrateConfig,
    GetSpitfpBaudrateConfig,
    GetSendTimeoutCount,
    SetSpitfpBaudrate,
    GetSpitfpBaudrate,
    GetSpitfpErrorCount,
    EnableStatusLed,
    DisableStatusLed,
    IsStatusLedEnabled,
    GetProtocol1BrickletName,
    GetChipTemperature,
    Reset,
    WriteBrickletPlugin,
    ReadBrickletPlugin,
    GetIdentity,
    CallbackStackCurrent,
    CallbackStackVoltage,
    CallbackUsbVoltage,
    CallbackStackCurrentReached,
    CallbackStackVoltageReached,
    CallbackUsbVoltageReached,
}
impl From<MasterBrickFunction> for u8 {
    fn from(fun: MasterBrickFunction) -> Self {
        match fun {
            MasterBrickFunction::GetStackVoltage => 1,
            MasterBrickFunction::GetStackCurrent => 2,
            MasterBrickFunction::SetExtensionType => 3,
            MasterBrickFunction::GetExtensionType => 4,
            MasterBrickFunction::IsChibiPresent => 5,
            MasterBrickFunction::SetChibiAddress => 6,
            MasterBrickFunction::GetChibiAddress => 7,
            MasterBrickFunction::SetChibiMasterAddress => 8,
            MasterBrickFunction::GetChibiMasterAddress => 9,
            MasterBrickFunction::SetChibiSlaveAddress => 10,
            MasterBrickFunction::GetChibiSlaveAddress => 11,
            MasterBrickFunction::GetChibiSignalStrength => 12,
            MasterBrickFunction::GetChibiErrorLog => 13,
            MasterBrickFunction::SetChibiFrequency => 14,
            MasterBrickFunction::GetChibiFrequency => 15,
            MasterBrickFunction::SetChibiChannel => 16,
            MasterBrickFunction::GetChibiChannel => 17,
            MasterBrickFunction::IsRs485Present => 18,
            MasterBrickFunction::SetRs485Address => 19,
            MasterBrickFunction::GetRs485Address => 20,
            MasterBrickFunction::SetRs485SlaveAddress => 21,
            MasterBrickFunction::GetRs485SlaveAddress => 22,
            MasterBrickFunction::GetRs485ErrorLog => 23,
            MasterBrickFunction::SetRs485Configuration => 24,
            MasterBrickFunction::GetRs485Configuration => 25,
            MasterBrickFunction::IsWifiPresent => 26,
            MasterBrickFunction::SetWifiConfiguration => 27,
            MasterBrickFunction::GetWifiConfiguration => 28,
            MasterBrickFunction::SetWifiEncryption => 29,
            MasterBrickFunction::GetWifiEncryption => 30,
            MasterBrickFunction::GetWifiStatus => 31,
            MasterBrickFunction::RefreshWifiStatus => 32,
            MasterBrickFunction::SetWifiCertificate => 33,
            MasterBrickFunction::GetWifiCertificate => 34,
            MasterBrickFunction::SetWifiPowerMode => 35,
            MasterBrickFunction::GetWifiPowerMode => 36,
            MasterBrickFunction::GetWifiBufferInfo => 37,
            MasterBrickFunction::SetWifiRegulatoryDomain => 38,
            MasterBrickFunction::GetWifiRegulatoryDomain => 39,
            MasterBrickFunction::GetUsbVoltage => 40,
            MasterBrickFunction::SetLongWifiKey => 41,
            MasterBrickFunction::GetLongWifiKey => 42,
            MasterBrickFunction::SetWifiHostname => 43,
            MasterBrickFunction::GetWifiHostname => 44,
            MasterBrickFunction::SetStackCurrentCallbackPeriod => 45,
            MasterBrickFunction::GetStackCurrentCallbackPeriod => 46,
            MasterBrickFunction::SetStackVoltageCallbackPeriod => 47,
            MasterBrickFunction::GetStackVoltageCallbackPeriod => 48,
            MasterBrickFunction::SetUsbVoltageCallbackPeriod => 49,
            MasterBrickFunction::GetUsbVoltageCallbackPeriod => 50,
            MasterBrickFunction::SetStackCurrentCallbackThreshold => 51,
            MasterBrickFunction::GetStackCurrentCallbackThreshold => 52,
            MasterBrickFunction::SetStackVoltageCallbackThreshold => 53,
            MasterBrickFunction::GetStackVoltageCallbackThreshold => 54,
            MasterBrickFunction::SetUsbVoltageCallbackThreshold => 55,
            MasterBrickFunction::GetUsbVoltageCallbackThreshold => 56,
            MasterBrickFunction::SetDebouncePeriod => 57,
            MasterBrickFunction::GetDebouncePeriod => 58,
            MasterBrickFunction::IsEthernetPresent => 65,
            MasterBrickFunction::SetEthernetConfiguration => 66,
            MasterBrickFunction::GetEthernetConfiguration => 67,
            MasterBrickFunction::GetEthernetStatus => 68,
            MasterBrickFunction::SetEthernetHostname => 69,
            MasterBrickFunction::SetEthernetMacAddress => 70,
            MasterBrickFunction::SetEthernetWebsocketConfiguration => 71,
            MasterBrickFunction::GetEthernetWebsocketConfiguration => 72,
            MasterBrickFunction::SetEthernetAuthenticationSecret => 73,
            MasterBrickFunction::GetEthernetAuthenticationSecret => 74,
            MasterBrickFunction::SetWifiAuthenticationSecret => 75,
            MasterBrickFunction::GetWifiAuthenticationSecret => 76,
            MasterBrickFunction::GetConnectionType => 77,
            MasterBrickFunction::IsWifi2Present => 78,
            MasterBrickFunction::StartWifi2Bootloader => 79,
            MasterBrickFunction::WriteWifi2SerialPort => 80,
            MasterBrickFunction::ReadWifi2SerialPort => 81,
            MasterBrickFunction::SetWifi2AuthenticationSecret => 82,
            MasterBrickFunction::GetWifi2AuthenticationSecret => 83,
            MasterBrickFunction::SetWifi2Configuration => 84,
            MasterBrickFunction::GetWifi2Configuration => 85,
            MasterBrickFunction::GetWifi2Status => 86,
            MasterBrickFunction::SetWifi2ClientConfiguration => 87,
            MasterBrickFunction::GetWifi2ClientConfiguration => 88,
            MasterBrickFunction::SetWifi2ClientHostname => 89,
            MasterBrickFunction::GetWifi2ClientHostname => 90,
            MasterBrickFunction::SetWifi2ClientPassword => 91,
            MasterBrickFunction::GetWifi2ClientPassword => 92,
            MasterBrickFunction::SetWifi2ApConfiguration => 93,
            MasterBrickFunction::GetWifi2ApConfiguration => 94,
            MasterBrickFunction::SetWifi2ApPassword => 95,
            MasterBrickFunction::GetWifi2ApPassword => 96,
            MasterBrickFunction::SaveWifi2Configuration => 97,
            MasterBrickFunction::GetWifi2FirmwareVersion => 98,
            MasterBrickFunction::EnableWifi2StatusLed => 99,
            MasterBrickFunction::DisableWifi2StatusLed => 100,
            MasterBrickFunction::IsWifi2StatusLedEnabled => 101,
            MasterBrickFunction::SetWifi2MeshConfiguration => 102,
            MasterBrickFunction::GetWifi2MeshConfiguration => 103,
            MasterBrickFunction::SetWifi2MeshRouterSsid => 104,
            MasterBrickFunction::GetWifi2MeshRouterSsid => 105,
            MasterBrickFunction::SetWifi2MeshRouterPassword => 106,
            MasterBrickFunction::GetWifi2MeshRouterPassword => 107,
            MasterBrickFunction::GetWifi2MeshCommonStatus => 108,
            MasterBrickFunction::GetWifi2MeshClientStatus => 109,
            MasterBrickFunction::GetWifi2MeshApStatus => 110,
            MasterBrickFunction::SetBrickletXmcFlashConfig => 111,
            MasterBrickFunction::SetBrickletXmcFlashData => 112,
            MasterBrickFunction::SetBrickletsEnabled => 113,
            MasterBrickFunction::GetBrickletsEnabled => 114,
            MasterBrickFunction::SetSpitfpBaudrateConfig => 231,
            MasterBrickFunction::GetSpitfpBaudrateConfig => 232,
            MasterBrickFunction::GetSendTimeoutCount => 233,
            MasterBrickFunction::SetSpitfpBaudrate => 234,
            MasterBrickFunction::GetSpitfpBaudrate => 235,
            MasterBrickFunction::GetSpitfpErrorCount => 237,
            MasterBrickFunction::EnableStatusLed => 238,
            MasterBrickFunction::DisableStatusLed => 239,
            MasterBrickFunction::IsStatusLedEnabled => 240,
            MasterBrickFunction::GetProtocol1BrickletName => 241,
            MasterBrickFunction::GetChipTemperature => 242,
            MasterBrickFunction::Reset => 243,
            MasterBrickFunction::WriteBrickletPlugin => 246,
            MasterBrickFunction::ReadBrickletPlugin => 247,
            MasterBrickFunction::GetIdentity => 255,
            MasterBrickFunction::CallbackStackCurrent => 59,
            MasterBrickFunction::CallbackStackVoltage => 60,
            MasterBrickFunction::CallbackUsbVoltage => 61,
            MasterBrickFunction::CallbackStackCurrentReached => 62,
            MasterBrickFunction::CallbackStackVoltageReached => 63,
            MasterBrickFunction::CallbackUsbVoltageReached => 64,
        }
    }
}
pub const MASTER_BRICK_EXTENSION_TYPE_CHIBI: u32 = 1;
pub const MASTER_BRICK_EXTENSION_TYPE_RS485: u32 = 2;
pub const MASTER_BRICK_EXTENSION_TYPE_WIFI: u32 = 3;
pub const MASTER_BRICK_EXTENSION_TYPE_ETHERNET: u32 = 4;
pub const MASTER_BRICK_EXTENSION_TYPE_WIFI2: u32 = 5;
pub const MASTER_BRICK_CHIBI_FREQUENCY_OQPSK_868_MHZ: u8 = 0;
pub const MASTER_BRICK_CHIBI_FREQUENCY_OQPSK_915_MHZ: u8 = 1;
pub const MASTER_BRICK_CHIBI_FREQUENCY_OQPSK_780_MHZ: u8 = 2;
pub const MASTER_BRICK_CHIBI_FREQUENCY_BPSK40_915_MHZ: u8 = 3;
pub const MASTER_BRICK_RS485_PARITY_NONE: char = 'n';
pub const MASTER_BRICK_RS485_PARITY_EVEN: char = 'e';
pub const MASTER_BRICK_RS485_PARITY_ODD: char = 'o';
pub const MASTER_BRICK_WIFI_CONNECTION_DHCP: u8 = 0;
pub const MASTER_BRICK_WIFI_CONNECTION_STATIC_IP: u8 = 1;
pub const MASTER_BRICK_WIFI_CONNECTION_ACCESS_POINT_DHCP: u8 = 2;
pub const MASTER_BRICK_WIFI_CONNECTION_ACCESS_POINT_STATIC_IP: u8 = 3;
pub const MASTER_BRICK_WIFI_CONNECTION_AD_HOC_DHCP: u8 = 4;
pub const MASTER_BRICK_WIFI_CONNECTION_AD_HOC_STATIC_IP: u8 = 5;
pub const MASTER_BRICK_WIFI_ENCRYPTION_WPA_WPA2: u8 = 0;
pub const MASTER_BRICK_WIFI_ENCRYPTION_WPA_ENTERPRISE: u8 = 1;
pub const MASTER_BRICK_WIFI_ENCRYPTION_WEP: u8 = 2;
pub const MASTER_BRICK_WIFI_ENCRYPTION_NO_ENCRYPTION: u8 = 3;
pub const MASTER_BRICK_WIFI_EAP_OPTION_OUTER_AUTH_EAP_FAST: u8 = 0;
pub const MASTER_BRICK_WIFI_EAP_OPTION_OUTER_AUTH_EAP_TLS: u8 = 1;
pub const MASTER_BRICK_WIFI_EAP_OPTION_OUTER_AUTH_EAP_TTLS: u8 = 2;
pub const MASTER_BRICK_WIFI_EAP_OPTION_OUTER_AUTH_EAP_PEAP: u8 = 3;
pub const MASTER_BRICK_WIFI_EAP_OPTION_INNER_AUTH_EAP_MSCHAP: u8 = 0;
pub const MASTER_BRICK_WIFI_EAP_OPTION_INNER_AUTH_EAP_GTC: u8 = 4;
pub const MASTER_BRICK_WIFI_EAP_OPTION_CERT_TYPE_CA_CERT: u8 = 0;
pub const MASTER_BRICK_WIFI_EAP_OPTION_CERT_TYPE_CLIENT_CERT: u8 = 8;
pub const MASTER_BRICK_WIFI_EAP_OPTION_CERT_TYPE_PRIVATE_KEY: u8 = 16;
pub const MASTER_BRICK_WIFI_STATE_DISASSOCIATED: u8 = 0;
pub const MASTER_BRICK_WIFI_STATE_ASSOCIATED: u8 = 1;
pub const MASTER_BRICK_WIFI_STATE_ASSOCIATING: u8 = 2;
pub const MASTER_BRICK_WIFI_STATE_ERROR: u8 = 3;
pub const MASTER_BRICK_WIFI_STATE_NOT_INITIALIZED_YET: u8 = 255;
pub const MASTER_BRICK_WIFI_POWER_MODE_FULL_SPEED: u8 = 0;
pub const MASTER_BRICK_WIFI_POWER_MODE_LOW_POWER: u8 = 1;
pub const MASTER_BRICK_WIFI_DOMAIN_CHANNEL_1TO11: u8 = 0;
pub const MASTER_BRICK_WIFI_DOMAIN_CHANNEL_1TO13: u8 = 1;
pub const MASTER_BRICK_WIFI_DOMAIN_CHANNEL_1TO14: u8 = 2;
pub const MASTER_BRICK_THRESHOLD_OPTION_OFF: char = 'x';
pub const MASTER_BRICK_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const MASTER_BRICK_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const MASTER_BRICK_THRESHOLD_OPTION_SMALLER: char = '<';
pub const MASTER_BRICK_THRESHOLD_OPTION_GREATER: char = '>';
pub const MASTER_BRICK_ETHERNET_CONNECTION_DHCP: u8 = 0;
pub const MASTER_BRICK_ETHERNET_CONNECTION_STATIC_IP: u8 = 1;
pub const MASTER_BRICK_CONNECTION_TYPE_NONE: u8 = 0;
pub const MASTER_BRICK_CONNECTION_TYPE_USB: u8 = 1;
pub const MASTER_BRICK_CONNECTION_TYPE_SPI_STACK: u8 = 2;
pub const MASTER_BRICK_CONNECTION_TYPE_CHIBI: u8 = 3;
pub const MASTER_BRICK_CONNECTION_TYPE_RS485: u8 = 4;
pub const MASTER_BRICK_CONNECTION_TYPE_WIFI: u8 = 5;
pub const MASTER_BRICK_CONNECTION_TYPE_ETHERNET: u8 = 6;
pub const MASTER_BRICK_CONNECTION_TYPE_WIFI2: u8 = 7;
pub const MASTER_BRICK_WIFI2_PHY_MODE_B: u8 = 0;
pub const MASTER_BRICK_WIFI2_PHY_MODE_G: u8 = 1;
pub const MASTER_BRICK_WIFI2_PHY_MODE_N: u8 = 2;
pub const MASTER_BRICK_WIFI2_CLIENT_STATUS_IDLE: u8 = 0;
pub const MASTER_BRICK_WIFI2_CLIENT_STATUS_CONNECTING: u8 = 1;
pub const MASTER_BRICK_WIFI2_CLIENT_STATUS_WRONG_PASSWORD: u8 = 2;
pub const MASTER_BRICK_WIFI2_CLIENT_STATUS_NO_AP_FOUND: u8 = 3;
pub const MASTER_BRICK_WIFI2_CLIENT_STATUS_CONNECT_FAILED: u8 = 4;
pub const MASTER_BRICK_WIFI2_CLIENT_STATUS_GOT_IP: u8 = 5;
pub const MASTER_BRICK_WIFI2_CLIENT_STATUS_UNKNOWN: u8 = 255;
pub const MASTER_BRICK_WIFI2_AP_ENCRYPTION_OPEN: u8 = 0;
pub const MASTER_BRICK_WIFI2_AP_ENCRYPTION_WEP: u8 = 1;
pub const MASTER_BRICK_WIFI2_AP_ENCRYPTION_WPA_PSK: u8 = 2;
pub const MASTER_BRICK_WIFI2_AP_ENCRYPTION_WPA2_PSK: u8 = 3;
pub const MASTER_BRICK_WIFI2_AP_ENCRYPTION_WPA_WPA2_PSK: u8 = 4;
pub const MASTER_BRICK_WIFI2_MESH_STATUS_DISABLED: u8 = 0;
pub const MASTER_BRICK_WIFI2_MESH_STATUS_WIFI_CONNECTING: u8 = 1;
pub const MASTER_BRICK_WIFI2_MESH_STATUS_GOT_IP: u8 = 2;
pub const MASTER_BRICK_WIFI2_MESH_STATUS_MESH_LOCAL: u8 = 3;
pub const MASTER_BRICK_WIFI2_MESH_STATUS_MESH_ONLINE: u8 = 4;
pub const MASTER_BRICK_WIFI2_MESH_STATUS_AP_AVAILABLE: u8 = 5;
pub const MASTER_BRICK_WIFI2_MESH_STATUS_AP_SETUP: u8 = 6;
pub const MASTER_BRICK_WIFI2_MESH_STATUS_LEAF_AVAILABLE: u8 = 7;
pub const MASTER_BRICK_COMMUNICATION_METHOD_NONE: u8 = 0;
pub const MASTER_BRICK_COMMUNICATION_METHOD_USB: u8 = 1;
pub const MASTER_BRICK_COMMUNICATION_METHOD_SPI_STACK: u8 = 2;
pub const MASTER_BRICK_COMMUNICATION_METHOD_CHIBI: u8 = 3;
pub const MASTER_BRICK_COMMUNICATION_METHOD_RS485: u8 = 4;
pub const MASTER_BRICK_COMMUNICATION_METHOD_WIFI: u8 = 5;
pub const MASTER_BRICK_COMMUNICATION_METHOD_ETHERNET: u8 = 6;
pub const MASTER_BRICK_COMMUNICATION_METHOD_WIFI_V2: u8 = 7;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ChibiErrorLog {
    pub underrun: u16,
    pub crc_error: u16,
    pub no_ack: u16,
    pub overflow: u16,
}
impl FromByteSlice for ChibiErrorLog {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> ChibiErrorLog {
        ChibiErrorLog {
            underrun: <u16>::from_le_byte_slice(&bytes[0..2]),
            crc_error: <u16>::from_le_byte_slice(&bytes[2..4]),
            no_ack: <u16>::from_le_byte_slice(&bytes[4..6]),
            overflow: <u16>::from_le_byte_slice(&bytes[6..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Rs485Configuration {
    pub speed: u32,
    pub parity: char,
    pub stopbits: u8,
}
impl FromByteSlice for Rs485Configuration {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> Rs485Configuration {
        Rs485Configuration {
            speed: <u32>::from_le_byte_slice(&bytes[0..4]),
            parity: <char>::from_le_byte_slice(&bytes[4..5]),
            stopbits: <u8>::from_le_byte_slice(&bytes[5..6]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct WifiConfiguration {
    pub ssid: String,
    pub connection: u8,
    pub ip: [u8; 4],
    pub subnet_mask: [u8; 4],
    pub gateway: [u8; 4],
    pub port: u16,
}
impl FromByteSlice for WifiConfiguration {
    fn bytes_expected() -> usize { 47 }
    fn from_le_byte_slice(bytes: &[u8]) -> WifiConfiguration {
        WifiConfiguration {
            ssid: <String>::from_le_byte_slice(&bytes[0..32]),
            connection: <u8>::from_le_byte_slice(&bytes[32..33]),
            ip: <[u8; 4]>::from_le_byte_slice(&bytes[33..37]),
            subnet_mask: <[u8; 4]>::from_le_byte_slice(&bytes[37..41]),
            gateway: <[u8; 4]>::from_le_byte_slice(&bytes[41..45]),
            port: <u16>::from_le_byte_slice(&bytes[45..47]),
        }
    }
}

#[derive(Clone)]
pub struct WifiEncryption {
    pub encryption: u8,
    pub key: String,
    pub key_index: u8,
    pub eap_options: u8,
    pub ca_certificate_length: u16,
    pub client_certificate_length: u16,
    pub private_key_length: u16,
}
impl FromByteSlice for WifiEncryption {
    fn bytes_expected() -> usize { 59 }
    fn from_le_byte_slice(bytes: &[u8]) -> WifiEncryption {
        WifiEncryption {
            encryption: <u8>::from_le_byte_slice(&bytes[0..1]),
            key: <String>::from_le_byte_slice(&bytes[1..51]),
            key_index: <u8>::from_le_byte_slice(&bytes[51..52]),
            eap_options: <u8>::from_le_byte_slice(&bytes[52..53]),
            ca_certificate_length: <u16>::from_le_byte_slice(&bytes[53..55]),
            client_certificate_length: <u16>::from_le_byte_slice(&bytes[55..57]),
            private_key_length: <u16>::from_le_byte_slice(&bytes[57..59]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WifiStatus {
    pub mac_address: [u8; 6],
    pub bssid: [u8; 6],
    pub channel: u8,
    pub rssi: i16,
    pub ip: [u8; 4],
    pub subnet_mask: [u8; 4],
    pub gateway: [u8; 4],
    pub rx_count: u32,
    pub tx_count: u32,
    pub state: u8,
}
impl FromByteSlice for WifiStatus {
    fn bytes_expected() -> usize { 36 }
    fn from_le_byte_slice(bytes: &[u8]) -> WifiStatus {
        WifiStatus {
            mac_address: <[u8; 6]>::from_le_byte_slice(&bytes[0..6]),
            bssid: <[u8; 6]>::from_le_byte_slice(&bytes[6..12]),
            channel: <u8>::from_le_byte_slice(&bytes[12..13]),
            rssi: <i16>::from_le_byte_slice(&bytes[13..15]),
            ip: <[u8; 4]>::from_le_byte_slice(&bytes[15..19]),
            subnet_mask: <[u8; 4]>::from_le_byte_slice(&bytes[19..23]),
            gateway: <[u8; 4]>::from_le_byte_slice(&bytes[23..27]),
            rx_count: <u32>::from_le_byte_slice(&bytes[27..31]),
            tx_count: <u32>::from_le_byte_slice(&bytes[31..35]),
            state: <u8>::from_le_byte_slice(&bytes[35..36]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WifiCertificate {
    pub data: [u8; 32],
    pub data_length: u8,
}
impl FromByteSlice for WifiCertificate {
    fn bytes_expected() -> usize { 33 }
    fn from_le_byte_slice(bytes: &[u8]) -> WifiCertificate {
        WifiCertificate { data: <[u8; 32]>::from_le_byte_slice(&bytes[0..32]), data_length: <u8>::from_le_byte_slice(&bytes[32..33]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WifiBufferInfo {
    pub overflow: u32,
    pub low_watermark: u16,
    pub used: u16,
}
impl FromByteSlice for WifiBufferInfo {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> WifiBufferInfo {
        WifiBufferInfo {
            overflow: <u32>::from_le_byte_slice(&bytes[0..4]),
            low_watermark: <u16>::from_le_byte_slice(&bytes[4..6]),
            used: <u16>::from_le_byte_slice(&bytes[6..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct StackCurrentCallbackThreshold {
    pub option: char,
    pub min: u16,
    pub max: u16,
}
impl FromByteSlice for StackCurrentCallbackThreshold {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> StackCurrentCallbackThreshold {
        StackCurrentCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <u16>::from_le_byte_slice(&bytes[1..3]),
            max: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct StackVoltageCallbackThreshold {
    pub option: char,
    pub min: u16,
    pub max: u16,
}
impl FromByteSlice for StackVoltageCallbackThreshold {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> StackVoltageCallbackThreshold {
        StackVoltageCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <u16>::from_le_byte_slice(&bytes[1..3]),
            max: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct UsbVoltageCallbackThreshold {
    pub option: char,
    pub min: u16,
    pub max: u16,
}
impl FromByteSlice for UsbVoltageCallbackThreshold {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> UsbVoltageCallbackThreshold {
        UsbVoltageCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <u16>::from_le_byte_slice(&bytes[1..3]),
            max: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct EthernetConfiguration {
    pub connection: u8,
    pub ip: [u8; 4],
    pub subnet_mask: [u8; 4],
    pub gateway: [u8; 4],
    pub port: u16,
}
impl FromByteSlice for EthernetConfiguration {
    fn bytes_expected() -> usize { 15 }
    fn from_le_byte_slice(bytes: &[u8]) -> EthernetConfiguration {
        EthernetConfiguration {
            connection: <u8>::from_le_byte_slice(&bytes[0..1]),
            ip: <[u8; 4]>::from_le_byte_slice(&bytes[1..5]),
            subnet_mask: <[u8; 4]>::from_le_byte_slice(&bytes[5..9]),
            gateway: <[u8; 4]>::from_le_byte_slice(&bytes[9..13]),
            port: <u16>::from_le_byte_slice(&bytes[13..15]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct EthernetStatus {
    pub mac_address: [u8; 6],
    pub ip: [u8; 4],
    pub subnet_mask: [u8; 4],
    pub gateway: [u8; 4],
    pub rx_count: u32,
    pub tx_count: u32,
    pub hostname: String,
}
impl FromByteSlice for EthernetStatus {
    fn bytes_expected() -> usize { 58 }
    fn from_le_byte_slice(bytes: &[u8]) -> EthernetStatus {
        EthernetStatus {
            mac_address: <[u8; 6]>::from_le_byte_slice(&bytes[0..6]),
            ip: <[u8; 4]>::from_le_byte_slice(&bytes[6..10]),
            subnet_mask: <[u8; 4]>::from_le_byte_slice(&bytes[10..14]),
            gateway: <[u8; 4]>::from_le_byte_slice(&bytes[14..18]),
            rx_count: <u32>::from_le_byte_slice(&bytes[18..22]),
            tx_count: <u32>::from_le_byte_slice(&bytes[22..26]),
            hostname: <String>::from_le_byte_slice(&bytes[26..58]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct EthernetWebsocketConfiguration {
    pub sockets: u8,
    pub port: u16,
}
impl FromByteSlice for EthernetWebsocketConfiguration {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> EthernetWebsocketConfiguration {
        EthernetWebsocketConfiguration { sockets: <u8>::from_le_byte_slice(&bytes[0..1]), port: <u16>::from_le_byte_slice(&bytes[1..3]) }
    }
}

#[derive(Clone, Copy)]
pub struct ReadWifi2SerialPort {
    pub data: [u8; 60],
    pub result: u8,
}
impl FromByteSlice for ReadWifi2SerialPort {
    fn bytes_expected() -> usize { 61 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReadWifi2SerialPort {
        ReadWifi2SerialPort { data: <[u8; 60]>::from_le_byte_slice(&bytes[0..60]), result: <u8>::from_le_byte_slice(&bytes[60..61]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Wifi2Configuration {
    pub port: u16,
    pub websocket_port: u16,
    pub website_port: u16,
    pub phy_mode: u8,
    pub sleep_mode: u8,
    pub website: u8,
}
impl FromByteSlice for Wifi2Configuration {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> Wifi2Configuration {
        Wifi2Configuration {
            port: <u16>::from_le_byte_slice(&bytes[0..2]),
            websocket_port: <u16>::from_le_byte_slice(&bytes[2..4]),
            website_port: <u16>::from_le_byte_slice(&bytes[4..6]),
            phy_mode: <u8>::from_le_byte_slice(&bytes[6..7]),
            sleep_mode: <u8>::from_le_byte_slice(&bytes[7..8]),
            website: <u8>::from_le_byte_slice(&bytes[8..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Wifi2Status {
    pub client_enabled: bool,
    pub client_status: u8,
    pub client_ip: [u8; 4],
    pub client_subnet_mask: [u8; 4],
    pub client_gateway: [u8; 4],
    pub client_mac_address: [u8; 6],
    pub client_rx_count: u32,
    pub client_tx_count: u32,
    pub client_rssi: i8,
    pub ap_enabled: bool,
    pub ap_ip: [u8; 4],
    pub ap_subnet_mask: [u8; 4],
    pub ap_gateway: [u8; 4],
    pub ap_mac_address: [u8; 6],
    pub ap_rx_count: u32,
    pub ap_tx_count: u32,
    pub ap_connected_count: u8,
}
impl FromByteSlice for Wifi2Status {
    fn bytes_expected() -> usize { 57 }
    fn from_le_byte_slice(bytes: &[u8]) -> Wifi2Status {
        Wifi2Status {
            client_enabled: <bool>::from_le_byte_slice(&bytes[0..1]),
            client_status: <u8>::from_le_byte_slice(&bytes[1..2]),
            client_ip: <[u8; 4]>::from_le_byte_slice(&bytes[2..6]),
            client_subnet_mask: <[u8; 4]>::from_le_byte_slice(&bytes[6..10]),
            client_gateway: <[u8; 4]>::from_le_byte_slice(&bytes[10..14]),
            client_mac_address: <[u8; 6]>::from_le_byte_slice(&bytes[14..20]),
            client_rx_count: <u32>::from_le_byte_slice(&bytes[20..24]),
            client_tx_count: <u32>::from_le_byte_slice(&bytes[24..28]),
            client_rssi: <i8>::from_le_byte_slice(&bytes[28..29]),
            ap_enabled: <bool>::from_le_byte_slice(&bytes[29..30]),
            ap_ip: <[u8; 4]>::from_le_byte_slice(&bytes[30..34]),
            ap_subnet_mask: <[u8; 4]>::from_le_byte_slice(&bytes[34..38]),
            ap_gateway: <[u8; 4]>::from_le_byte_slice(&bytes[38..42]),
            ap_mac_address: <[u8; 6]>::from_le_byte_slice(&bytes[42..48]),
            ap_rx_count: <u32>::from_le_byte_slice(&bytes[48..52]),
            ap_tx_count: <u32>::from_le_byte_slice(&bytes[52..56]),
            ap_connected_count: <u8>::from_le_byte_slice(&bytes[56..57]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Wifi2ClientConfiguration {
    pub enable: bool,
    pub ssid: String,
    pub ip: [u8; 4],
    pub subnet_mask: [u8; 4],
    pub gateway: [u8; 4],
    pub mac_address: [u8; 6],
    pub bssid: [u8; 6],
}
impl FromByteSlice for Wifi2ClientConfiguration {
    fn bytes_expected() -> usize { 57 }
    fn from_le_byte_slice(bytes: &[u8]) -> Wifi2ClientConfiguration {
        Wifi2ClientConfiguration {
            enable: <bool>::from_le_byte_slice(&bytes[0..1]),
            ssid: <String>::from_le_byte_slice(&bytes[1..33]),
            ip: <[u8; 4]>::from_le_byte_slice(&bytes[33..37]),
            subnet_mask: <[u8; 4]>::from_le_byte_slice(&bytes[37..41]),
            gateway: <[u8; 4]>::from_le_byte_slice(&bytes[41..45]),
            mac_address: <[u8; 6]>::from_le_byte_slice(&bytes[45..51]),
            bssid: <[u8; 6]>::from_le_byte_slice(&bytes[51..57]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Wifi2ApConfiguration {
    pub enable: bool,
    pub ssid: String,
    pub ip: [u8; 4],
    pub subnet_mask: [u8; 4],
    pub gateway: [u8; 4],
    pub encryption: u8,
    pub hidden: bool,
    pub channel: u8,
    pub mac_address: [u8; 6],
}
impl FromByteSlice for Wifi2ApConfiguration {
    fn bytes_expected() -> usize { 54 }
    fn from_le_byte_slice(bytes: &[u8]) -> Wifi2ApConfiguration {
        Wifi2ApConfiguration {
            enable: <bool>::from_le_byte_slice(&bytes[0..1]),
            ssid: <String>::from_le_byte_slice(&bytes[1..33]),
            ip: <[u8; 4]>::from_le_byte_slice(&bytes[33..37]),
            subnet_mask: <[u8; 4]>::from_le_byte_slice(&bytes[37..41]),
            gateway: <[u8; 4]>::from_le_byte_slice(&bytes[41..45]),
            encryption: <u8>::from_le_byte_slice(&bytes[45..46]),
            hidden: <bool>::from_le_byte_slice(&bytes[46..47]),
            channel: <u8>::from_le_byte_slice(&bytes[47..48]),
            mac_address: <[u8; 6]>::from_le_byte_slice(&bytes[48..54]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Wifi2MeshConfiguration {
    pub enable: bool,
    pub root_ip: [u8; 4],
    pub root_subnet_mask: [u8; 4],
    pub root_gateway: [u8; 4],
    pub router_bssid: [u8; 6],
    pub group_id: [u8; 6],
    pub group_ssid_prefix: String,
    pub gateway_ip: [u8; 4],
    pub gateway_port: u16,
}
impl FromByteSlice for Wifi2MeshConfiguration {
    fn bytes_expected() -> usize { 47 }
    fn from_le_byte_slice(bytes: &[u8]) -> Wifi2MeshConfiguration {
        Wifi2MeshConfiguration {
            enable: <bool>::from_le_byte_slice(&bytes[0..1]),
            root_ip: <[u8; 4]>::from_le_byte_slice(&bytes[1..5]),
            root_subnet_mask: <[u8; 4]>::from_le_byte_slice(&bytes[5..9]),
            root_gateway: <[u8; 4]>::from_le_byte_slice(&bytes[9..13]),
            router_bssid: <[u8; 6]>::from_le_byte_slice(&bytes[13..19]),
            group_id: <[u8; 6]>::from_le_byte_slice(&bytes[19..25]),
            group_ssid_prefix: <String>::from_le_byte_slice(&bytes[25..41]),
            gateway_ip: <[u8; 4]>::from_le_byte_slice(&bytes[41..45]),
            gateway_port: <u16>::from_le_byte_slice(&bytes[45..47]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Wifi2MeshCommonStatus {
    pub status: u8,
    pub root_node: bool,
    pub root_candidate: bool,
    pub connected_nodes: u16,
    pub rx_count: u32,
    pub tx_count: u32,
}
impl FromByteSlice for Wifi2MeshCommonStatus {
    fn bytes_expected() -> usize { 13 }
    fn from_le_byte_slice(bytes: &[u8]) -> Wifi2MeshCommonStatus {
        Wifi2MeshCommonStatus {
            status: <u8>::from_le_byte_slice(&bytes[0..1]),
            root_node: <bool>::from_le_byte_slice(&bytes[1..2]),
            root_candidate: <bool>::from_le_byte_slice(&bytes[2..3]),
            connected_nodes: <u16>::from_le_byte_slice(&bytes[3..5]),
            rx_count: <u32>::from_le_byte_slice(&bytes[5..9]),
            tx_count: <u32>::from_le_byte_slice(&bytes[9..13]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Wifi2MeshClientStatus {
    pub hostname: String,
    pub ip: [u8; 4],
    pub subnet_mask: [u8; 4],
    pub gateway: [u8; 4],
    pub mac_address: [u8; 6],
}
impl FromByteSlice for Wifi2MeshClientStatus {
    fn bytes_expected() -> usize { 50 }
    fn from_le_byte_slice(bytes: &[u8]) -> Wifi2MeshClientStatus {
        Wifi2MeshClientStatus {
            hostname: <String>::from_le_byte_slice(&bytes[0..32]),
            ip: <[u8; 4]>::from_le_byte_slice(&bytes[32..36]),
            subnet_mask: <[u8; 4]>::from_le_byte_slice(&bytes[36..40]),
            gateway: <[u8; 4]>::from_le_byte_slice(&bytes[40..44]),
            mac_address: <[u8; 6]>::from_le_byte_slice(&bytes[44..50]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Wifi2MeshApStatus {
    pub ssid: String,
    pub ip: [u8; 4],
    pub subnet_mask: [u8; 4],
    pub gateway: [u8; 4],
    pub mac_address: [u8; 6],
}
impl FromByteSlice for Wifi2MeshApStatus {
    fn bytes_expected() -> usize { 50 }
    fn from_le_byte_slice(bytes: &[u8]) -> Wifi2MeshApStatus {
        Wifi2MeshApStatus {
            ssid: <String>::from_le_byte_slice(&bytes[0..32]),
            ip: <[u8; 4]>::from_le_byte_slice(&bytes[32..36]),
            subnet_mask: <[u8; 4]>::from_le_byte_slice(&bytes[36..40]),
            gateway: <[u8; 4]>::from_le_byte_slice(&bytes[40..44]),
            mac_address: <[u8; 6]>::from_le_byte_slice(&bytes[44..50]),
        }
    }
}

#[derive(Clone, Copy)]
pub struct SetBrickletXmcFlashConfig {
    pub return_value: u32,
    pub return_data: [u8; 60],
}
impl FromByteSlice for SetBrickletXmcFlashConfig {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> SetBrickletXmcFlashConfig {
        SetBrickletXmcFlashConfig {
            return_value: <u32>::from_le_byte_slice(&bytes[0..4]),
            return_data: <[u8; 60]>::from_le_byte_slice(&bytes[4..64]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpBaudrateConfig {
    pub enable_dynamic_baudrate: bool,
    pub minimum_dynamic_baudrate: u32,
}
impl FromByteSlice for SpitfpBaudrateConfig {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpBaudrateConfig {
        SpitfpBaudrateConfig {
            enable_dynamic_baudrate: <bool>::from_le_byte_slice(&bytes[0..1]),
            minimum_dynamic_baudrate: <u32>::from_le_byte_slice(&bytes[1..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone)]
pub struct Protocol1BrickletName {
    pub protocol_version: u8,
    pub firmware_version: [u8; 3],
    pub name: String,
}
impl FromByteSlice for Protocol1BrickletName {
    fn bytes_expected() -> usize { 44 }
    fn from_le_byte_slice(bytes: &[u8]) -> Protocol1BrickletName {
        Protocol1BrickletName {
            protocol_version: <u8>::from_le_byte_slice(&bytes[0..1]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[1..4]),
            name: <String>::from_le_byte_slice(&bytes[4..44]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Basis to build stacks and has 4 Bricklet ports
#[derive(Clone)]
pub struct MasterBrick {
    device: Device,
}
impl MasterBrick {
    pub const DEVICE_IDENTIFIER: u16 = 13;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Master Brick";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> MasterBrick {
        let mut result = MasterBrick { device: Device::new([2, 0, 10], uid, req_sender, 0) };
        result.device.response_expected[u8::from(MasterBrickFunction::GetStackVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::GetStackCurrent) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetExtensionType) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetExtensionType) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::IsChibiPresent) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetChibiAddress) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetChibiAddress) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetChibiMasterAddress) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetChibiMasterAddress) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetChibiSlaveAddress) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetChibiSlaveAddress) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::GetChibiSignalStrength) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::GetChibiErrorLog) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetChibiFrequency) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetChibiFrequency) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetChibiChannel) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetChibiChannel) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::IsRs485Present) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetRs485Address) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetRs485Address) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetRs485SlaveAddress) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetRs485SlaveAddress) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::GetRs485ErrorLog) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetRs485Configuration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetRs485Configuration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::IsWifiPresent) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetWifiConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifiConfiguration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetWifiEncryption) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifiEncryption) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifiStatus) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::RefreshWifiStatus) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::SetWifiCertificate) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifiCertificate) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetWifiPowerMode) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifiPowerMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifiBufferInfo) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetWifiRegulatoryDomain) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifiRegulatoryDomain) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::GetUsbVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetLongWifiKey) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetLongWifiKey) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetWifiHostname) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifiHostname) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetStackCurrentCallbackPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(MasterBrickFunction::GetStackCurrentCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetStackVoltageCallbackPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(MasterBrickFunction::GetStackVoltageCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetUsbVoltageCallbackPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(MasterBrickFunction::GetUsbVoltageCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetStackCurrentCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(MasterBrickFunction::GetStackCurrentCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetStackVoltageCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(MasterBrickFunction::GetStackVoltageCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetUsbVoltageCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(MasterBrickFunction::GetUsbVoltageCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(MasterBrickFunction::GetDebouncePeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::IsEthernetPresent) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetEthernetConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetEthernetConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::GetEthernetStatus) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetEthernetHostname) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::SetEthernetMacAddress) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::SetEthernetWebsocketConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetEthernetWebsocketConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetEthernetAuthenticationSecret) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetEthernetAuthenticationSecret) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetWifiAuthenticationSecret) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifiAuthenticationSecret) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::GetConnectionType) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::IsWifi2Present) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::StartWifi2Bootloader) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::WriteWifi2SerialPort) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::ReadWifi2SerialPort) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetWifi2AuthenticationSecret) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifi2AuthenticationSecret) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetWifi2Configuration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifi2Configuration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifi2Status) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetWifi2ClientConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifi2ClientConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetWifi2ClientHostname) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifi2ClientHostname) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetWifi2ClientPassword) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifi2ClientPassword) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetWifi2ApConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifi2ApConfiguration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetWifi2ApPassword) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifi2ApPassword) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SaveWifi2Configuration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifi2FirmwareVersion) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::EnableWifi2StatusLed) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::DisableWifi2StatusLed) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::IsWifi2StatusLedEnabled) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetWifi2MeshConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifi2MeshConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetWifi2MeshRouterSsid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifi2MeshRouterSsid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetWifi2MeshRouterPassword) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifi2MeshRouterPassword) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifi2MeshCommonStatus) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifi2MeshClientStatus) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::GetWifi2MeshApStatus) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetBrickletXmcFlashConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetBrickletXmcFlashData) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetBrickletsEnabled) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetBrickletsEnabled) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetSpitfpBaudrateConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetSpitfpBaudrateConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::GetSendTimeoutCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::SetSpitfpBaudrate) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::GetSpitfpBaudrate) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::EnableStatusLed) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::DisableStatusLed) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::IsStatusLedEnabled) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::GetProtocol1BrickletName) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::WriteBrickletPlugin) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MasterBrickFunction::ReadBrickletPlugin) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MasterBrickFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::master_brick::MasterBrick::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::master_brick::MasterBrick::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: MasterBrickFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: MasterBrickFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_stack_current_callback_period`]. The parameter is the current
    /// of the sensor.
    ///
    /// The [`get_stack_current_callback_receiver`] receiver is only triggered if the current has changed
    /// since the last triggering.
    ///
    /// [`set_stack_current_callback_period`]: #method.set_stack_current_callback_period
    /// [`get_stack_current_callback_receiver`]: #method.get_stack_current_callback_receiver
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    pub fn get_stack_current_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(MasterBrickFunction::CallbackStackCurrent))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_stack_voltage_callback_period`]. The parameter is the voltage
    /// of the sensor.
    ///
    /// The [`get_stack_voltage_callback_receiver`] receiver is only triggered if the voltage has changed
    /// since the last triggering.
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    pub fn get_stack_voltage_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(MasterBrickFunction::CallbackStackVoltage))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_usb_voltage_callback_period`]. The parameter is the USB
    /// voltage.
    ///
    /// The [`get_usb_voltage_callback_receiver`] receiver is only triggered if the USB voltage has changed
    /// since the last triggering.
    ///
    /// Does not work with hardware version 2.1 or newer.
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    pub fn get_usb_voltage_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(MasterBrickFunction::CallbackUsbVoltage))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_stack_current_callback_threshold`] is reached.
    /// The parameter is the stack current.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    pub fn get_stack_current_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(MasterBrickFunction::CallbackStackCurrentReached))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_stack_voltage_callback_threshold`] is reached.
    /// The parameter is the stack voltage.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    pub fn get_stack_voltage_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(MasterBrickFunction::CallbackStackVoltageReached))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_usb_voltage_callback_threshold`] is reached.
    /// The parameter is the voltage of the sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    pub fn get_usb_voltage_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(MasterBrickFunction::CallbackUsbVoltageReached))
    }

    /// Returns the stack voltage. The stack voltage is the
    /// voltage that is supplied via the stack, i.e. it is given by a
    /// Step-Down or Step-Up Power Supply.
    ///
    /// # Note
    ///  It is not possible to measure voltages supplied per PoE or USB with this function.
    pub fn get_stack_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetStackVoltage), payload)
    }

    /// Returns the stack current. The stack current is the
    /// current that is drawn via the stack, i.e. it is given by a
    /// Step-Down or Step-Up Power Supply.
    ///
    /// # Note
    ///  It is not possible to measure the current drawn via PoE or USB with this function.
    pub fn get_stack_current(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetStackCurrent), payload)
    }

    /// Writes the extension type to the EEPROM of a specified extension.
    /// The extension is either 0 or 1 (0 is the lower one, 1 is the upper one,
    /// if only one extension is present use 0).
    ///
    /// Possible extension types:
    ///
    ///  Type| Description
    ///  --- | ---
    ///  1|    Chibi
    ///  2|    RS485
    ///  3|    WIFI
    ///  4|    Ethernet
    ///  5|    WIFI 2.0
    ///
    /// The extension type is already set when bought and it can be set with the
    /// Brick Viewer, it is unlikely that you need this function.
    ///
    /// Associated constants:
    /// * MASTER_BRICK_EXTENSION_TYPE_CHIBI
    ///	* MASTER_BRICK_EXTENSION_TYPE_RS485
    ///	* MASTER_BRICK_EXTENSION_TYPE_WIFI
    ///	* MASTER_BRICK_EXTENSION_TYPE_ETHERNET
    ///	* MASTER_BRICK_EXTENSION_TYPE_WIFI2
    pub fn set_extension_type(&self, extension: u8, exttype: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(extension));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(exttype));

        self.device.set(u8::from(MasterBrickFunction::SetExtensionType), payload)
    }

    /// Returns the type for a given extension as set by [`set_extension_type`].
    ///
    /// Associated constants:
    /// * MASTER_BRICK_EXTENSION_TYPE_CHIBI
    ///	* MASTER_BRICK_EXTENSION_TYPE_RS485
    ///	* MASTER_BRICK_EXTENSION_TYPE_WIFI
    ///	* MASTER_BRICK_EXTENSION_TYPE_ETHERNET
    ///	* MASTER_BRICK_EXTENSION_TYPE_WIFI2
    pub fn get_extension_type(&self, extension: u8) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(extension));

        self.device.get(u8::from(MasterBrickFunction::GetExtensionType), payload)
    }

    /// Returns *true* if the Master Brick is at position 0 in the stack and a Chibi
    /// Extension is available.
    pub fn is_chibi_present(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::IsChibiPresent), payload)
    }

    /// Sets the address belonging to the Chibi Extension.
    ///
    /// It is possible to set the address with the Brick Viewer and it will be
    /// saved in the EEPROM of the Chibi Extension, it does not
    /// have to be set on every startup.
    pub fn set_chibi_address(&self, address: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(address));

        self.device.set(u8::from(MasterBrickFunction::SetChibiAddress), payload)
    }

    /// Returns the address as set by [`set_chibi_address`].
    pub fn get_chibi_address(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetChibiAddress), payload)
    }

    /// Sets the address of the Chibi Master. This address is used if the
    /// Chibi Extension is used as slave (i.e. it does not have a USB connection).
    ///
    /// It is possible to set the address with the Brick Viewer and it will be
    /// saved in the EEPROM of the Chibi Extension, it does not
    /// have to be set on every startup.
    pub fn set_chibi_master_address(&self, address: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(address));

        self.device.set(u8::from(MasterBrickFunction::SetChibiMasterAddress), payload)
    }

    /// Returns the address as set by [`set_chibi_master_address`].
    pub fn get_chibi_master_address(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetChibiMasterAddress), payload)
    }

    /// Sets up to 254 slave addresses. 0 has a
    /// special meaning, it is used as list terminator and not allowed as normal slave
    /// address. The address numeration (via \c num parameter) has to be used
    /// ascending from 0. For example: If you use the Chibi Extension in Master mode
    /// (i.e. the stack has an USB connection) and you want to talk to three other
    /// Chibi stacks with the slave addresses 17, 23, and 42, you should call with
    /// ``(0, 17)``, ``(1, 23)``, ``(2, 42)`` and ``(3, 0)``. The last call with
    /// ``(3, 0)`` is a list terminator and indicates that the Chibi slave address
    /// list contains 3 addresses in this case.
    ///
    /// It is possible to set the addresses with the Brick Viewer, that will take care
    /// of correct address numeration and list termination.
    ///
    /// The slave addresses will be saved in the EEPROM of the Chibi Extension, they
    /// don't have to be set on every startup.
    pub fn set_chibi_slave_address(&self, num: u8, address: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(num));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(address));

        self.device.set(u8::from(MasterBrickFunction::SetChibiSlaveAddress), payload)
    }

    /// Returns the slave address for a given \c num as set by
    /// [`set_chibi_slave_address`].
    pub fn get_chibi_slave_address(&self, num: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(num));

        self.device.get(u8::from(MasterBrickFunction::GetChibiSlaveAddress), payload)
    }

    /// Returns the signal strength in dBm. The signal strength updates every time a
    /// packet is received.
    pub fn get_chibi_signal_strength(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetChibiSignalStrength), payload)
    }

    /// Returns underrun, CRC error, no ACK and overflow error counts of the Chibi
    /// communication. If these errors start rising, it is likely that either the
    /// distance between two Chibi stacks is becoming too big or there are
    /// interferences.
    pub fn get_chibi_error_log(&self) -> ConvertingReceiver<ChibiErrorLog> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetChibiErrorLog), payload)
    }

    /// Sets the Chibi frequency range for the Chibi Extension. Possible values are:
    ///
    ///  Type| Description
    ///  --- | ---
    ///  0|    OQPSK 868MHz (Europe)
    ///  1|    OQPSK 915MHz (US)
    ///  2|    OQPSK 780MHz (China)
    ///  3|    BPSK40 915MHz
    ///
    /// It is possible to set the frequency with the Brick Viewer and it will be
    /// saved in the EEPROM of the Chibi Extension, it does not
    /// have to be set on every startup.
    ///
    /// Associated constants:
    /// * MASTER_BRICK_CHIBI_FREQUENCY_OQPSK_868_MHZ
    ///	* MASTER_BRICK_CHIBI_FREQUENCY_OQPSK_915_MHZ
    ///	* MASTER_BRICK_CHIBI_FREQUENCY_OQPSK_780_MHZ
    ///	* MASTER_BRICK_CHIBI_FREQUENCY_BPSK40_915_MHZ
    pub fn set_chibi_frequency(&self, frequency: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(frequency));

        self.device.set(u8::from(MasterBrickFunction::SetChibiFrequency), payload)
    }

    /// Returns the frequency value as set by [`set_chibi_frequency`].
    ///
    /// Associated constants:
    /// * MASTER_BRICK_CHIBI_FREQUENCY_OQPSK_868_MHZ
    ///	* MASTER_BRICK_CHIBI_FREQUENCY_OQPSK_915_MHZ
    ///	* MASTER_BRICK_CHIBI_FREQUENCY_OQPSK_780_MHZ
    ///	* MASTER_BRICK_CHIBI_FREQUENCY_BPSK40_915_MHZ
    pub fn get_chibi_frequency(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetChibiFrequency), payload)
    }

    /// Sets the channel used by the Chibi Extension. Possible channels are
    /// different for different frequencies:
    ///
    ///  Frequency| Possible Channels
    ///  --- | ---
    ///  OQPSK 868MHz (Europe)| 0
    ///  OQPSK 915MHz (US)|     1| 2| 3| 4| 5| 6| 7| 8| 9| 10
    ///  OQPSK 780MHz (China)|  0| 1| 2| 3
    ///  BPSK40 915MHz|         1| 2| 3| 4| 5| 6| 7| 8| 9| 10
    ///
    /// It is possible to set the channel with the Brick Viewer and it will be
    /// saved in the EEPROM of the Chibi Extension, it does not
    /// have to be set on every startup.
    pub fn set_chibi_channel(&self, channel: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.set(u8::from(MasterBrickFunction::SetChibiChannel), payload)
    }

    /// Returns the channel as set by [`set_chibi_channel`].
    pub fn get_chibi_channel(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetChibiChannel), payload)
    }

    /// Returns *true* if the Master Brick is at position 0 in the stack and a RS485
    /// Extension is available.
    pub fn is_rs485_present(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::IsRs485Present), payload)
    }

    /// Sets the address (0-255) belonging to the RS485 Extension.
    ///
    /// Set to 0 if the RS485 Extension should be the RS485 Master (i.e.
    /// connected to a PC via USB).
    ///
    /// It is possible to set the address with the Brick Viewer and it will be
    /// saved in the EEPROM of the RS485 Extension, it does not
    /// have to be set on every startup.
    pub fn set_rs485_address(&self, address: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(address));

        self.device.set(u8::from(MasterBrickFunction::SetRs485Address), payload)
    }

    /// Returns the address as set by [`set_rs485_address`].
    pub fn get_rs485_address(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetRs485Address), payload)
    }

    /// Sets up to 255 slave addresses. Valid addresses are in range 1-255. 0 has a
    /// special meaning, it is used as list terminator and not allowed as normal slave
    /// address. The address numeration (via ``num`` parameter) has to be used
    /// ascending from 0. For example: If you use the RS485 Extension in Master mode
    /// (i.e. the stack has an USB connection) and you want to talk to three other
    /// RS485 stacks with the addresses 17, 23, and 42, you should call with
    /// ``(0, 17)``, ``(1, 23)``, ``(2, 42)`` and ``(3, 0)``. The last call with
    /// ``(3, 0)`` is a list terminator and indicates that the RS485 slave address list
    /// contains 3 addresses in this case.
    ///
    /// It is possible to set the addresses with the Brick Viewer, that will take care
    /// of correct address numeration and list termination.
    ///
    /// The slave addresses will be saved in the EEPROM of the Chibi Extension, they
    /// don't have to be set on every startup.
    pub fn set_rs485_slave_address(&self, num: u8, address: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(num));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(address));

        self.device.set(u8::from(MasterBrickFunction::SetRs485SlaveAddress), payload)
    }

    /// Returns the slave address for a given ``num`` as set by
    /// [`set_rs485_slave_address`].
    pub fn get_rs485_slave_address(&self, num: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(num));

        self.device.get(u8::from(MasterBrickFunction::GetRs485SlaveAddress), payload)
    }

    /// Returns CRC error counts of the RS485 communication.
    /// If this counter starts rising, it is likely that the distance
    /// between the RS485 nodes is too big or there is some kind of
    /// interference.
    pub fn get_rs485_error_log(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetRs485ErrorLog), payload)
    }

    /// Sets the configuration of the RS485 Extension. The
    /// Master Brick will try to match the given baud rate as exactly as possible.
    /// The maximum recommended baud rate is 2000000 (2MBd).
    /// Possible values for parity are 'n' (none), 'e' (even) and 'o' (odd).
    ///
    /// If your RS485 is unstable (lost messages etc.), the first thing you should
    /// try is to decrease the speed. On very large bus (e.g. 1km), you probably
    /// should use a value in the range of 100000 (100kBd).
    ///
    /// The values are stored in the EEPROM and only applied on startup. That means
    /// you have to restart the Master Brick after configuration.
    ///
    /// Associated constants:
    /// * MASTER_BRICK_RS485_PARITY_NONE
    ///	* MASTER_BRICK_RS485_PARITY_EVEN
    ///	* MASTER_BRICK_RS485_PARITY_ODD
    pub fn set_rs485_configuration(&self, speed: u32, parity: char, stopbits: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(speed));
        payload[4..5].copy_from_slice(&<char>::to_le_byte_vec(parity));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(stopbits));

        self.device.set(u8::from(MasterBrickFunction::SetRs485Configuration), payload)
    }

    /// Returns the configuration as set by [`set_rs485_configuration`].
    ///
    /// Associated constants:
    /// * MASTER_BRICK_RS485_PARITY_NONE
    ///	* MASTER_BRICK_RS485_PARITY_EVEN
    ///	* MASTER_BRICK_RS485_PARITY_ODD
    pub fn get_rs485_configuration(&self) -> ConvertingReceiver<Rs485Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetRs485Configuration), payload)
    }

    /// Returns *true* if the Master Brick is at position 0 in the stack and a WIFI
    /// Extension is available.
    pub fn is_wifi_present(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::IsWifiPresent), payload)
    }

    /// Sets the configuration of the WIFI Extension. The ``ssid`` can have a max length
    /// of 32 characters. Possible values for ``connection`` are:
    ///
    ///  Value| Description
    ///  --- | ---
    ///  0| DHCP
    ///  1| Static IP
    ///  2| Access Point: DHCP
    ///  3| Access Point: Static IP
    ///  4| Ad Hoc: DHCP
    ///  5| Ad Hoc: Static IP
    ///
    /// If you set ``connection`` to one of the static IP options then you have to
    /// supply ``ip``, ``subnet_mask`` and ``gateway`` as an array of size 4 (first
    /// element of the array is the least significant byte of the address). If
    /// ``connection`` is set to one of the DHCP options then ``ip``, ``subnet_mask``
    /// and ``gateway`` are ignored, you can set them to 0.
    ///
    /// The last parameter is the port that your program will connect to.
    ///
    /// The values are stored in the EEPROM and only applied on startup. That means
    /// you have to restart the Master Brick after configuration.
    ///
    /// It is recommended to use the Brick Viewer to set the WIFI configuration.
    ///
    /// Associated constants:
    /// * MASTER_BRICK_WIFI_CONNECTION_DHCP
    ///	* MASTER_BRICK_WIFI_CONNECTION_STATIC_IP
    ///	* MASTER_BRICK_WIFI_CONNECTION_ACCESS_POINT_DHCP
    ///	* MASTER_BRICK_WIFI_CONNECTION_ACCESS_POINT_STATIC_IP
    ///	* MASTER_BRICK_WIFI_CONNECTION_AD_HOC_DHCP
    ///	* MASTER_BRICK_WIFI_CONNECTION_AD_HOC_STATIC_IP
    pub fn set_wifi_configuration(
        &self,
        ssid: String,
        connection: u8,
        ip: [u8; 4],
        subnet_mask: [u8; 4],
        gateway: [u8; 4],
        port: u16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 47];
        match <String>::try_to_le_byte_vec(ssid, 32) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[0..32].copy_from_slice(&bytes),
        }

        payload[32..33].copy_from_slice(&<u8>::to_le_byte_vec(connection));
        payload[33..37].copy_from_slice(&<[u8; 4]>::to_le_byte_vec(ip));
        payload[37..41].copy_from_slice(&<[u8; 4]>::to_le_byte_vec(subnet_mask));
        payload[41..45].copy_from_slice(&<[u8; 4]>::to_le_byte_vec(gateway));
        payload[45..47].copy_from_slice(&<u16>::to_le_byte_vec(port));

        self.device.set(u8::from(MasterBrickFunction::SetWifiConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_wifi_configuration`].
    ///
    /// Associated constants:
    /// * MASTER_BRICK_WIFI_CONNECTION_DHCP
    ///	* MASTER_BRICK_WIFI_CONNECTION_STATIC_IP
    ///	* MASTER_BRICK_WIFI_CONNECTION_ACCESS_POINT_DHCP
    ///	* MASTER_BRICK_WIFI_CONNECTION_ACCESS_POINT_STATIC_IP
    ///	* MASTER_BRICK_WIFI_CONNECTION_AD_HOC_DHCP
    ///	* MASTER_BRICK_WIFI_CONNECTION_AD_HOC_STATIC_IP
    pub fn get_wifi_configuration(&self) -> ConvertingReceiver<WifiConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifiConfiguration), payload)
    }

    /// Sets the encryption of the WIFI Extension. The first parameter is the
    /// type of the encryption. Possible values are:
    ///
    ///  Value| Description
    ///  --- | ---
    ///  0| WPA/WPA2
    ///  1| WPA Enterprise (EAP-FAST| EAP-TLS| EAP-TTLS| PEAP)
    ///  2| WEP
    ///  3| No Encryption
    ///
    /// The ``key`` has a max length of 50 characters and is used if ``encryption``
    /// is set to 0 or 2 (WPA/WPA2 or WEP). Otherwise the value is ignored.
    ///
    /// For WPA/WPA2 the key has to be at least 8 characters long. If you want to set
    /// a key with more than 50 characters, see [`set_long_wifi_key`].
    ///
    /// For WEP the key has to be either 10 or 26 hexadecimal digits long. It is
    /// possible to set the WEP ``key_index`` (1-4). If you don't know your
    /// ``key_index``, it is likely 1.
    ///
    /// If you choose WPA Enterprise as encryption, you have to set ``eap_options`` and
    /// the length of the certificates (for other encryption types these parameters
    /// are ignored). The certificates
    /// themselves can be set with [`set_wifi_certificate`]. ``eap_options`` consist
    /// of the outer authentication (bits 1-2), inner authentication (bit 3) and
    /// certificate type (bits 4-5):
    ///
    ///  Option| Bits| Description
    ///  --- | --- | ---
    ///  outer authentication| 1-2| 0=EAP-FAST| 1=EAP-TLS| 2=EAP-TTLS| 3=EAP-PEAP
    ///  inner authentication| 3| 0=EAP-MSCHAP| 1=EAP-GTC
    ///  certificate type| 4-5| 0=CA Certificate| 1=Client Certificate| 2=Private Key
    ///
    /// Example for EAP-TTLS + EAP-GTC + Private Key: ``option = 2 | (1 << 2) | (2 << 3)``.
    ///
    /// The values are stored in the EEPROM and only applied on startup. That means
    /// you have to restart the Master Brick after configuration.
    ///
    /// It is recommended to use the Brick Viewer to set the Wi-Fi encryption.
    ///
    /// Associated constants:
    /// * MASTER_BRICK_WIFI_ENCRYPTION_WPA_WPA2
    ///	* MASTER_BRICK_WIFI_ENCRYPTION_WPA_ENTERPRISE
    ///	* MASTER_BRICK_WIFI_ENCRYPTION_WEP
    ///	* MASTER_BRICK_WIFI_ENCRYPTION_NO_ENCRYPTION
    ///	* MASTER_BRICK_WIFI_EAP_OPTION_OUTER_AUTH_EAP_FAST
    ///	* MASTER_BRICK_WIFI_EAP_OPTION_OUTER_AUTH_EAP_TLS
    ///	* MASTER_BRICK_WIFI_EAP_OPTION_OUTER_AUTH_EAP_TTLS
    ///	* MASTER_BRICK_WIFI_EAP_OPTION_OUTER_AUTH_EAP_PEAP
    ///	* MASTER_BRICK_WIFI_EAP_OPTION_INNER_AUTH_EAP_MSCHAP
    ///	* MASTER_BRICK_WIFI_EAP_OPTION_INNER_AUTH_EAP_GTC
    ///	* MASTER_BRICK_WIFI_EAP_OPTION_CERT_TYPE_CA_CERT
    ///	* MASTER_BRICK_WIFI_EAP_OPTION_CERT_TYPE_CLIENT_CERT
    ///	* MASTER_BRICK_WIFI_EAP_OPTION_CERT_TYPE_PRIVATE_KEY
    pub fn set_wifi_encryption(
        &self,
        encryption: u8,
        key: String,
        key_index: u8,
        eap_options: u8,
        ca_certificate_length: u16,
        client_certificate_length: u16,
        private_key_length: u16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 59];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(encryption));
        match <String>::try_to_le_byte_vec(key, 50) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[1..51].copy_from_slice(&bytes),
        }

        payload[51..52].copy_from_slice(&<u8>::to_le_byte_vec(key_index));
        payload[52..53].copy_from_slice(&<u8>::to_le_byte_vec(eap_options));
        payload[53..55].copy_from_slice(&<u16>::to_le_byte_vec(ca_certificate_length));
        payload[55..57].copy_from_slice(&<u16>::to_le_byte_vec(client_certificate_length));
        payload[57..59].copy_from_slice(&<u16>::to_le_byte_vec(private_key_length));

        self.device.set(u8::from(MasterBrickFunction::SetWifiEncryption), payload)
    }

    /// Returns the encryption as set by [`set_wifi_encryption`].
    ///
    /// # Note
    ///  Since Master Brick Firmware version 2.4.4 the key is not returned anymore.
    ///
    /// Associated constants:
    /// * MASTER_BRICK_WIFI_ENCRYPTION_WPA_WPA2
    ///	* MASTER_BRICK_WIFI_ENCRYPTION_WPA_ENTERPRISE
    ///	* MASTER_BRICK_WIFI_ENCRYPTION_WEP
    ///	* MASTER_BRICK_WIFI_ENCRYPTION_NO_ENCRYPTION
    ///	* MASTER_BRICK_WIFI_EAP_OPTION_OUTER_AUTH_EAP_FAST
    ///	* MASTER_BRICK_WIFI_EAP_OPTION_OUTER_AUTH_EAP_TLS
    ///	* MASTER_BRICK_WIFI_EAP_OPTION_OUTER_AUTH_EAP_TTLS
    ///	* MASTER_BRICK_WIFI_EAP_OPTION_OUTER_AUTH_EAP_PEAP
    ///	* MASTER_BRICK_WIFI_EAP_OPTION_INNER_AUTH_EAP_MSCHAP
    ///	* MASTER_BRICK_WIFI_EAP_OPTION_INNER_AUTH_EAP_GTC
    ///	* MASTER_BRICK_WIFI_EAP_OPTION_CERT_TYPE_CA_CERT
    ///	* MASTER_BRICK_WIFI_EAP_OPTION_CERT_TYPE_CLIENT_CERT
    ///	* MASTER_BRICK_WIFI_EAP_OPTION_CERT_TYPE_PRIVATE_KEY
    pub fn get_wifi_encryption(&self) -> ConvertingReceiver<WifiEncryption> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifiEncryption), payload)
    }

    /// Returns the status of the WIFI Extension. The ``state`` is updated automatically,
    /// all of the other parameters are updated on startup and every time
    /// [`refresh_wifi_status`] is called.
    ///
    /// Possible states are:
    ///
    ///  State| Description
    ///  --- | ---
    ///  0| Disassociated
    ///  1| Associated
    ///  2| Associating
    ///  3| Error
    ///  255| Not initialized yet
    ///
    /// Associated constants:
    /// * MASTER_BRICK_WIFI_STATE_DISASSOCIATED
    ///	* MASTER_BRICK_WIFI_STATE_ASSOCIATED
    ///	* MASTER_BRICK_WIFI_STATE_ASSOCIATING
    ///	* MASTER_BRICK_WIFI_STATE_ERROR
    ///	* MASTER_BRICK_WIFI_STATE_NOT_INITIALIZED_YET
    pub fn get_wifi_status(&self) -> ConvertingReceiver<WifiStatus> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifiStatus), payload)
    }

    /// Refreshes the Wi-Fi status (see [`get_wifi_status`]). To read the status
    /// of the Wi-Fi module, the Master Brick has to change from data mode to
    /// command mode and back. This transaction and the readout itself is
    /// unfortunately time consuming. This means, that it might take some ms
    /// until the stack with attached WIFI Extension reacts again after this
    /// function is called.
    pub fn refresh_wifi_status(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(MasterBrickFunction::RefreshWifiStatus), payload)
    }

    /// This function is used to set the certificate as well as password and username
    /// for WPA Enterprise. To set the username use index 0xFFFF,
    /// to set the password use index 0xFFFE. The max length of username and
    /// password is 32.
    ///
    /// The certificate is written in chunks of size 32 and the index is used as
    /// the index of the chunk. ``data_length`` should nearly always be 32. Only
    /// the last chunk can have a length that is not equal to 32.
    ///
    /// The starting index of the CA Certificate is 0, of the Client Certificate
    /// 10000 and for the Private Key 20000. Maximum sizes are 1312, 1312 and
    /// 4320 byte respectively.
    ///
    /// The values are stored in the EEPROM and only applied on startup. That means
    /// you have to restart the Master Brick after uploading the certificate.
    ///
    /// It is recommended to use the Brick Viewer to set the certificate, username
    /// and password.
    pub fn set_wifi_certificate(&self, index: u16, data: [u8; 32], data_length: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 35];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(index));
        payload[2..34].copy_from_slice(&<[u8; 32]>::to_le_byte_vec(data));
        payload[34..35].copy_from_slice(&<u8>::to_le_byte_vec(data_length));

        self.device.set(u8::from(MasterBrickFunction::SetWifiCertificate), payload)
    }

    /// Returns the certificate for a given index as set by [`set_wifi_certificate`].
    pub fn get_wifi_certificate(&self, index: u16) -> ConvertingReceiver<WifiCertificate> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(index));

        self.device.get(u8::from(MasterBrickFunction::GetWifiCertificate), payload)
    }

    /// Sets the power mode of the WIFI Extension. Possible modes are:
    ///
    ///  Mode| Description
    ///  --- | ---
    ///  0| Full Speed (high power consumption| high throughput)
    ///  1| Low Power (low power consumption| low throughput)
    ///
    /// Associated constants:
    /// * MASTER_BRICK_WIFI_POWER_MODE_FULL_SPEED
    ///	* MASTER_BRICK_WIFI_POWER_MODE_LOW_POWER
    pub fn set_wifi_power_mode(&self, mode: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.set(u8::from(MasterBrickFunction::SetWifiPowerMode), payload)
    }

    /// Returns the power mode as set by [`set_wifi_power_mode`].
    ///
    /// Associated constants:
    /// * MASTER_BRICK_WIFI_POWER_MODE_FULL_SPEED
    ///	* MASTER_BRICK_WIFI_POWER_MODE_LOW_POWER
    pub fn get_wifi_power_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifiPowerMode), payload)
    }

    /// Returns informations about the Wi-Fi receive buffer. The Wi-Fi
    /// receive buffer has a max size of 1500 byte and if data is transfered
    /// too fast, it might overflow.
    ///
    /// The return values are the number of overflows, the low watermark
    /// (i.e. the smallest number of bytes that were free in the buffer) and
    /// the bytes that are currently used.
    ///
    /// You should always try to keep the buffer empty, otherwise you will
    /// have a permanent latency. A good rule of thumb is, that you can transfer
    /// 1000 messages per second without problems.
    ///
    /// Try to not send more then 50 messages at a time without any kind of
    /// break between them.
    pub fn get_wifi_buffer_info(&self) -> ConvertingReceiver<WifiBufferInfo> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifiBufferInfo), payload)
    }

    /// Sets the regulatory domain of the WIFI Extension. Possible domains are:
    ///
    ///  Domain| Description
    ///  --- | ---
    ///  0| FCC: Channel 1-11 (N/S America| Australia| New Zealand)
    ///  1| ETSI: Channel 1-13 (Europe| Middle East| Africa)
    ///  2| TELEC: Channel 1-14 (Japan)
    ///
    /// Associated constants:
    /// * MASTER_BRICK_WIFI_DOMAIN_CHANNEL_1TO11
    ///	* MASTER_BRICK_WIFI_DOMAIN_CHANNEL_1TO13
    ///	* MASTER_BRICK_WIFI_DOMAIN_CHANNEL_1TO14
    pub fn set_wifi_regulatory_domain(&self, domain: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(domain));

        self.device.set(u8::from(MasterBrickFunction::SetWifiRegulatoryDomain), payload)
    }

    /// Returns the regulatory domain as set by [`set_wifi_regulatory_domain`].
    ///
    /// Associated constants:
    /// * MASTER_BRICK_WIFI_DOMAIN_CHANNEL_1TO11
    ///	* MASTER_BRICK_WIFI_DOMAIN_CHANNEL_1TO13
    ///	* MASTER_BRICK_WIFI_DOMAIN_CHANNEL_1TO14
    pub fn get_wifi_regulatory_domain(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifiRegulatoryDomain), payload)
    }

    /// Returns the USB voltage. Does not work with hardware version 2.1 or newer.
    pub fn get_usb_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetUsbVoltage), payload)
    }

    /// Sets a long Wi-Fi key (up to 63 chars, at least 8 chars) for WPA encryption.
    /// This key will be used
    /// if the key in [`set_wifi_encryption`] is set to -. In the old protocol,
    /// a payload of size 63 was not possible, so the maximum key length was 50 chars.
    ///
    /// With the new protocol this is possible, since we didn't want to break API,
    /// this function was added additionally.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Firmware)
    pub fn set_long_wifi_key(&self, key: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 64];
        match <String>::try_to_le_byte_vec(key, 64) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[0..64].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(MasterBrickFunction::SetLongWifiKey), payload)
    }

    /// Returns the encryption key as set by [`set_long_wifi_key`].
    ///
    /// # Note
    ///  Since Master Brick firmware version 2.4.4 the key is not returned anymore.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Firmware)
    pub fn get_long_wifi_key(&self) -> ConvertingReceiver<String> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetLongWifiKey), payload)
    }

    /// Sets the hostname of the WIFI Extension. The hostname will be displayed
    /// by access points as the hostname in the DHCP clients table.
    ///
    /// Setting an empty String will restore the default hostname.
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    pub fn set_wifi_hostname(&self, hostname: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 16];
        match <String>::try_to_le_byte_vec(hostname, 16) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[0..16].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(MasterBrickFunction::SetWifiHostname), payload)
    }

    /// Returns the hostname as set by [`set_wifi_hostname`].
    ///
    /// An empty String means, that the default hostname is used.
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    pub fn get_wifi_hostname(&self) -> ConvertingReceiver<String> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifiHostname), payload)
    }

    /// Sets the period with which the [`get_stack_current_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_stack_current_callback_receiver`] receiver is only triggered if the current has changed
    /// since the last triggering.
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    pub fn set_stack_current_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(MasterBrickFunction::SetStackCurrentCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_stack_current_callback_period`].
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    pub fn get_stack_current_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetStackCurrentCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_stack_voltage_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_stack_voltage_callback_receiver`] receiver is only triggered if the voltage has changed
    /// since the last triggering.
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    pub fn set_stack_voltage_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(MasterBrickFunction::SetStackVoltageCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_stack_voltage_callback_period`].
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    pub fn get_stack_voltage_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetStackVoltageCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_usb_voltage_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_usb_voltage_callback_receiver`] receiver is only triggered if the voltage has changed
    /// since the last triggering.
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    pub fn set_usb_voltage_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(MasterBrickFunction::SetUsbVoltageCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_usb_voltage_callback_period`].
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    pub fn get_usb_voltage_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetUsbVoltageCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_stack_current_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the current is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the current is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the current is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the current is greater than the min value (max is ignored)
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * MASTER_BRICK_THRESHOLD_OPTION_OFF
    ///	* MASTER_BRICK_THRESHOLD_OPTION_OUTSIDE
    ///	* MASTER_BRICK_THRESHOLD_OPTION_INSIDE
    ///	* MASTER_BRICK_THRESHOLD_OPTION_SMALLER
    ///	* MASTER_BRICK_THRESHOLD_OPTION_GREATER
    pub fn set_stack_current_callback_threshold(&self, option: char, min: u16, max: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(max));

        self.device.set(u8::from(MasterBrickFunction::SetStackCurrentCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_stack_current_callback_threshold`].
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * MASTER_BRICK_THRESHOLD_OPTION_OFF
    ///	* MASTER_BRICK_THRESHOLD_OPTION_OUTSIDE
    ///	* MASTER_BRICK_THRESHOLD_OPTION_INSIDE
    ///	* MASTER_BRICK_THRESHOLD_OPTION_SMALLER
    ///	* MASTER_BRICK_THRESHOLD_OPTION_GREATER
    pub fn get_stack_current_callback_threshold(&self) -> ConvertingReceiver<StackCurrentCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetStackCurrentCallbackThreshold), payload)
    }

    /// Sets the thresholds for the [`get_stack_voltage_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the voltage is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the voltage is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the voltage is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the voltage is greater than the min value (max is ignored)
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * MASTER_BRICK_THRESHOLD_OPTION_OFF
    ///	* MASTER_BRICK_THRESHOLD_OPTION_OUTSIDE
    ///	* MASTER_BRICK_THRESHOLD_OPTION_INSIDE
    ///	* MASTER_BRICK_THRESHOLD_OPTION_SMALLER
    ///	* MASTER_BRICK_THRESHOLD_OPTION_GREATER
    pub fn set_stack_voltage_callback_threshold(&self, option: char, min: u16, max: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(max));

        self.device.set(u8::from(MasterBrickFunction::SetStackVoltageCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_stack_voltage_callback_threshold`].
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * MASTER_BRICK_THRESHOLD_OPTION_OFF
    ///	* MASTER_BRICK_THRESHOLD_OPTION_OUTSIDE
    ///	* MASTER_BRICK_THRESHOLD_OPTION_INSIDE
    ///	* MASTER_BRICK_THRESHOLD_OPTION_SMALLER
    ///	* MASTER_BRICK_THRESHOLD_OPTION_GREATER
    pub fn get_stack_voltage_callback_threshold(&self) -> ConvertingReceiver<StackVoltageCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetStackVoltageCallbackThreshold), payload)
    }

    /// Sets the thresholds for the [`get_usb_voltage_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the voltage is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the voltage is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the voltage is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the voltage is greater than the min value (max is ignored)
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * MASTER_BRICK_THRESHOLD_OPTION_OFF
    ///	* MASTER_BRICK_THRESHOLD_OPTION_OUTSIDE
    ///	* MASTER_BRICK_THRESHOLD_OPTION_INSIDE
    ///	* MASTER_BRICK_THRESHOLD_OPTION_SMALLER
    ///	* MASTER_BRICK_THRESHOLD_OPTION_GREATER
    pub fn set_usb_voltage_callback_threshold(&self, option: char, min: u16, max: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(max));

        self.device.set(u8::from(MasterBrickFunction::SetUsbVoltageCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_usb_voltage_callback_threshold`].
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * MASTER_BRICK_THRESHOLD_OPTION_OFF
    ///	* MASTER_BRICK_THRESHOLD_OPTION_OUTSIDE
    ///	* MASTER_BRICK_THRESHOLD_OPTION_INSIDE
    ///	* MASTER_BRICK_THRESHOLD_OPTION_SMALLER
    ///	* MASTER_BRICK_THRESHOLD_OPTION_GREATER
    pub fn get_usb_voltage_callback_threshold(&self) -> ConvertingReceiver<UsbVoltageCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetUsbVoltageCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receivers
    ///
    /// * [`get_stack_current_reached_callback_receiver`],
    /// * [`get_stack_voltage_reached_callback_receiver`],
    /// * [`get_usb_voltage_reached_callback_receiver`]
    ///
    /// are triggered, if the thresholds
    ///
    /// * [`set_stack_current_callback_threshold`],
    /// * [`set_stack_voltage_callback_threshold`],
    /// * [`set_usb_voltage_callback_threshold`]
    ///
    /// keep being reached.
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(MasterBrickFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetDebouncePeriod), payload)
    }

    /// Returns *true* if the Master Brick is at position 0 in the stack and an Ethernet
    /// Extension is available.
    ///
    ///
    /// .. versionadded:: 2.1.0$nbsp;(Firmware)
    pub fn is_ethernet_present(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::IsEthernetPresent), payload)
    }

    /// Sets the configuration of the Ethernet Extension. Possible values for
    /// ``connection`` are:
    ///
    ///  Value| Description
    ///  --- | ---
    ///  0| DHCP
    ///  1| Static IP
    ///
    /// If you set ``connection`` to static IP options then you have to supply ``ip``,
    /// ``subnet_mask`` and ``gateway`` as an array of size 4 (first element of the
    /// array is the least significant byte of the address). If ``connection`` is set
    /// to the DHCP options then ``ip``, ``subnet_mask`` and ``gateway`` are ignored,
    /// you can set them to 0.
    ///
    /// The last parameter is the port that your program will connect to.
    ///
    /// The values are stored in the EEPROM and only applied on startup. That means
    /// you have to restart the Master Brick after configuration.
    ///
    /// It is recommended to use the Brick Viewer to set the Ethernet configuration.
    ///
    ///
    /// .. versionadded:: 2.1.0$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * MASTER_BRICK_ETHERNET_CONNECTION_DHCP
    ///	* MASTER_BRICK_ETHERNET_CONNECTION_STATIC_IP
    pub fn set_ethernet_configuration(
        &self,
        connection: u8,
        ip: [u8; 4],
        subnet_mask: [u8; 4],
        gateway: [u8; 4],
        port: u16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 15];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(connection));
        payload[1..5].copy_from_slice(&<[u8; 4]>::to_le_byte_vec(ip));
        payload[5..9].copy_from_slice(&<[u8; 4]>::to_le_byte_vec(subnet_mask));
        payload[9..13].copy_from_slice(&<[u8; 4]>::to_le_byte_vec(gateway));
        payload[13..15].copy_from_slice(&<u16>::to_le_byte_vec(port));

        self.device.set(u8::from(MasterBrickFunction::SetEthernetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_ethernet_configuration`].
    ///
    ///
    /// .. versionadded:: 2.1.0$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * MASTER_BRICK_ETHERNET_CONNECTION_DHCP
    ///	* MASTER_BRICK_ETHERNET_CONNECTION_STATIC_IP
    pub fn get_ethernet_configuration(&self) -> ConvertingReceiver<EthernetConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetEthernetConfiguration), payload)
    }

    /// Returns the status of the Ethernet Extension.
    ///
    /// ``mac_address``, ``ip``, ``subnet_mask`` and ``gateway`` are given as an array.
    /// The first element of the array is the least significant byte of the address.
    ///
    /// ``rx_count`` and ``tx_count`` are the number of bytes that have been
    /// received/send since last restart.
    ///
    /// ``hostname`` is the currently used hostname.
    ///
    ///
    /// .. versionadded:: 2.1.0$nbsp;(Firmware)
    pub fn get_ethernet_status(&self) -> ConvertingReceiver<EthernetStatus> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetEthernetStatus), payload)
    }

    /// Sets the hostname of the Ethernet Extension. The hostname will be displayed
    /// by access points as the hostname in the DHCP clients table.
    ///
    /// Setting an empty String will restore the default hostname.
    ///
    /// The current hostname can be discovered with [`get_ethernet_status`].
    ///
    ///
    /// .. versionadded:: 2.1.0$nbsp;(Firmware)
    pub fn set_ethernet_hostname(&self, hostname: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 32];
        match <String>::try_to_le_byte_vec(hostname, 32) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[0..32].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(MasterBrickFunction::SetEthernetHostname), payload)
    }

    /// Sets the MAC address of the Ethernet Extension. The Ethernet Extension should
    /// come configured with a valid MAC address, that is also written on a
    /// sticker of the extension itself.
    ///
    /// The MAC address can be read out again with [`get_ethernet_status`].
    ///
    ///
    /// .. versionadded:: 2.1.0$nbsp;(Firmware)
    pub fn set_ethernet_mac_address(&self, mac_address: [u8; 6]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..6].copy_from_slice(&<[u8; 6]>::to_le_byte_vec(mac_address));

        self.device.set(u8::from(MasterBrickFunction::SetEthernetMacAddress), payload)
    }

    /// Sets the Ethernet WebSocket configuration. The first parameter sets the number of socket
    /// connections that are reserved for WebSockets. The range is 0-7. The connections
    /// are shared with the plain sockets. Example: If you set the connections to 3,
    /// there will be 3 WebSocket and 4 plain socket connections available.
    ///
    /// The second parameter is the port for the WebSocket connections. The port can
    /// not be the same as the port for the plain socket connections.
    ///
    /// The values are stored in the EEPROM and only applied on startup. That means
    /// you have to restart the Master Brick after configuration.
    ///
    /// It is recommended to use the Brick Viewer to set the Ethernet configuration.
    ///
    ///
    /// .. versionadded:: 2.2.0$nbsp;(Firmware)
    pub fn set_ethernet_websocket_configuration(&self, sockets: u8, port: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(sockets));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(port));

        self.device.set(u8::from(MasterBrickFunction::SetEthernetWebsocketConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_ethernet_configuration`].
    ///
    ///
    /// .. versionadded:: 2.2.0$nbsp;(Firmware)
    pub fn get_ethernet_websocket_configuration(&self) -> ConvertingReceiver<EthernetWebsocketConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetEthernetWebsocketConfiguration), payload)
    }

    /// Sets the Ethernet authentication secret. The secret can be a string of up to 64
    /// characters. An empty string disables the authentication.
    ///
    /// See the [authentication tutorial](tutorial_authentication) for more
    /// information.
    ///
    /// The secret is stored in the EEPROM and only applied on startup. That means
    /// you have to restart the Master Brick after configuration.
    ///
    /// It is recommended to use the Brick Viewer to set the Ethernet authentication secret.
    ///
    /// The default value is an empty string (authentication disabled).
    ///
    ///
    /// .. versionadded:: 2.2.0$nbsp;(Firmware)
    pub fn set_ethernet_authentication_secret(&self, secret: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 64];
        match <String>::try_to_le_byte_vec(secret, 64) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[0..64].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(MasterBrickFunction::SetEthernetAuthenticationSecret), payload)
    }

    /// Returns the authentication secret as set by
    /// [`set_ethernet_authentication_secret`].
    ///
    ///
    /// .. versionadded:: 2.2.0$nbsp;(Firmware)
    pub fn get_ethernet_authentication_secret(&self) -> ConvertingReceiver<String> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetEthernetAuthenticationSecret), payload)
    }

    /// Sets the WIFI authentication secret. The secret can be a string of up to 64
    /// characters. An empty string disables the authentication.
    ///
    /// See the [authentication tutorial](tutorial_authentication) for more
    /// information.
    ///
    /// The secret is stored in the EEPROM and only applied on startup. That means
    /// you have to restart the Master Brick after configuration.
    ///
    /// It is recommended to use the Brick Viewer to set the WIFI authentication secret.
    ///
    /// The default value is an empty string (authentication disabled).
    ///
    ///
    /// .. versionadded:: 2.2.0$nbsp;(Firmware)
    pub fn set_wifi_authentication_secret(&self, secret: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 64];
        match <String>::try_to_le_byte_vec(secret, 64) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[0..64].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(MasterBrickFunction::SetWifiAuthenticationSecret), payload)
    }

    /// Returns the authentication secret as set by
    /// [`set_wifi_authentication_secret`].
    ///
    ///
    /// .. versionadded:: 2.2.0$nbsp;(Firmware)
    pub fn get_wifi_authentication_secret(&self) -> ConvertingReceiver<String> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifiAuthenticationSecret), payload)
    }

    /// Returns the type of the connection over which this function was called.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * MASTER_BRICK_CONNECTION_TYPE_NONE
    ///	* MASTER_BRICK_CONNECTION_TYPE_USB
    ///	* MASTER_BRICK_CONNECTION_TYPE_SPI_STACK
    ///	* MASTER_BRICK_CONNECTION_TYPE_CHIBI
    ///	* MASTER_BRICK_CONNECTION_TYPE_RS485
    ///	* MASTER_BRICK_CONNECTION_TYPE_WIFI
    ///	* MASTER_BRICK_CONNECTION_TYPE_ETHERNET
    ///	* MASTER_BRICK_CONNECTION_TYPE_WIFI2
    pub fn get_connection_type(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetConnectionType), payload)
    }

    /// Returns *true* if the Master Brick is at position 0 in the stack and a WIFI
    /// Extension 2.0 is available.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    pub fn is_wifi2_present(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::IsWifi2Present), payload)
    }

    /// Starts the bootloader of the WIFI Extension 2.0. Returns 0 on success.
    /// Afterwards the [`write_wifi2_serial_port`] and [`read_wifi2_serial_port`]
    /// functions can be used to communicate with the bootloader to flash a new
    /// firmware.
    ///
    /// The bootloader should only be started over a USB connection. It cannot be
    /// started over a WIFI2 connection, see the [`get_connection_type`] function.
    ///
    /// It is recommended to use the Brick Viewer to update the firmware of the WIFI
    /// Extension 2.0.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    pub fn start_wifi2_bootloader(&self) -> ConvertingReceiver<i8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::StartWifi2Bootloader), payload)
    }

    /// Writes up to 60 bytes (number of bytes to be written specified by ``length``)
    /// to the serial port of the bootloader of the WIFI Extension 2.0. Returns 0 on
    /// success.
    ///
    /// Before this function can be used the bootloader has to be started using the
    /// [`start_wifi2_bootloader`] function.
    ///
    /// It is recommended to use the Brick Viewer to update the firmware of the WIFI
    /// Extension 2.0.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    pub fn write_wifi2_serial_port(&self, data: [u8; 60], length: u8) -> ConvertingReceiver<i8> {
        let mut payload = vec![0; 61];
        payload[0..60].copy_from_slice(&<[u8; 60]>::to_le_byte_vec(data));
        payload[60..61].copy_from_slice(&<u8>::to_le_byte_vec(length));

        self.device.get(u8::from(MasterBrickFunction::WriteWifi2SerialPort), payload)
    }

    /// Reads up to 60 bytes (number of bytes to be read specified by ``length``)
    /// from the serial port of the bootloader of the WIFI Extension 2.0.
    /// Returns the number of actually read bytes.
    ///
    /// Before this function can be used the bootloader has to be started using the
    /// [`start_wifi2_bootloader`] function.
    ///
    /// It is recommended to use the Brick Viewer to update the firmware of the WIFI
    /// Extension 2.0.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    pub fn read_wifi2_serial_port(&self, length: u8) -> ConvertingReceiver<ReadWifi2SerialPort> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(length));

        self.device.get(u8::from(MasterBrickFunction::ReadWifi2SerialPort), payload)
    }

    /// Sets the WIFI authentication secret. The secret can be a string of up to 64
    /// characters. An empty string disables the authentication. The default value is
    /// an empty string (authentication disabled).
    ///
    /// See the [authentication tutorial](tutorial_authentication) for more
    /// information.
    ///
    /// To apply configuration changes to the WIFI Extension 2.0 the
    /// [`save_wifi2_configuration`] function has to be called and the Master Brick
    /// has to be restarted afterwards.
    ///
    /// It is recommended to use the Brick Viewer to configure the WIFI Extension 2.0.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    pub fn set_wifi2_authentication_secret(&self, secret: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 64];
        match <String>::try_to_le_byte_vec(secret, 64) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[0..64].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(MasterBrickFunction::SetWifi2AuthenticationSecret), payload)
    }

    /// Returns the WIFI authentication secret as set by
    /// [`set_wifi2_authentication_secret`].
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    pub fn get_wifi2_authentication_secret(&self) -> ConvertingReceiver<String> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifi2AuthenticationSecret), payload)
    }

    /// Sets the general configuration of the WIFI Extension 2.0.
    ///
    /// The ``port`` parameter sets the port number that your programm will connect
    /// to.
    ///
    /// The ``websocket_port`` parameter sets the WebSocket port number that your
    /// JavaScript programm will connect to.
    ///
    /// The ``website_port`` parameter sets the port number for the website of the
    /// WIFI Extension 2.0.
    ///
    /// The ``phy_mode`` parameter sets the specific wireless network mode to be used.
    /// Possible values are B, G and N.
    ///
    /// The ``sleep_mode`` parameter is currently unused.
    ///
    /// The ``website`` parameter is used to enable or disable the web interface of
    /// the WIFI Extension 2.0, which is available from firmware version 2.0.1. Note
    /// that, for firmware version 2.0.3 and older, to disable the the web interface
    /// the ``website_port`` parameter must be set to 1 and greater than 1 to enable
    /// the web interface. For firmware version 2.0.4 and later, setting this parameter
    /// to 1 will enable the web interface and setting it to 0 will disable the web
    /// interface.
    ///
    /// To apply configuration changes to the WIFI Extension 2.0 the
    /// [`save_wifi2_configuration`] function has to be called and the Master Brick
    /// has to be restarted afterwards.
    ///
    /// It is recommended to use the Brick Viewer to configure the WIFI Extension 2.0.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * MASTER_BRICK_WIFI2_PHY_MODE_B
    ///	* MASTER_BRICK_WIFI2_PHY_MODE_G
    ///	* MASTER_BRICK_WIFI2_PHY_MODE_N
    pub fn set_wifi2_configuration(
        &self,
        port: u16,
        websocket_port: u16,
        website_port: u16,
        phy_mode: u8,
        sleep_mode: u8,
        website: u8,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(port));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(websocket_port));
        payload[4..6].copy_from_slice(&<u16>::to_le_byte_vec(website_port));
        payload[6..7].copy_from_slice(&<u8>::to_le_byte_vec(phy_mode));
        payload[7..8].copy_from_slice(&<u8>::to_le_byte_vec(sleep_mode));
        payload[8..9].copy_from_slice(&<u8>::to_le_byte_vec(website));

        self.device.set(u8::from(MasterBrickFunction::SetWifi2Configuration), payload)
    }

    /// Returns the general configuration as set by [`set_wifi2_configuration`].
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * MASTER_BRICK_WIFI2_PHY_MODE_B
    ///	* MASTER_BRICK_WIFI2_PHY_MODE_G
    ///	* MASTER_BRICK_WIFI2_PHY_MODE_N
    pub fn get_wifi2_configuration(&self) -> ConvertingReceiver<Wifi2Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifi2Configuration), payload)
    }

    /// Returns the client and access point status of the WIFI Extension 2.0.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * MASTER_BRICK_WIFI2_CLIENT_STATUS_IDLE
    ///	* MASTER_BRICK_WIFI2_CLIENT_STATUS_CONNECTING
    ///	* MASTER_BRICK_WIFI2_CLIENT_STATUS_WRONG_PASSWORD
    ///	* MASTER_BRICK_WIFI2_CLIENT_STATUS_NO_AP_FOUND
    ///	* MASTER_BRICK_WIFI2_CLIENT_STATUS_CONNECT_FAILED
    ///	* MASTER_BRICK_WIFI2_CLIENT_STATUS_GOT_IP
    ///	* MASTER_BRICK_WIFI2_CLIENT_STATUS_UNKNOWN
    pub fn get_wifi2_status(&self) -> ConvertingReceiver<Wifi2Status> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifi2Status), payload)
    }

    /// Sets the client specific configuration of the WIFI Extension 2.0.
    ///
    /// The ``enable`` parameter enables or disables the client part of the
    /// WIFI Extension 2.0.
    ///
    /// The ``ssid`` parameter sets the SSID (up to 32 characters) of the access point
    /// to connect to.
    ///
    /// If the ``ip`` parameter is set to all zero then ``subnet_mask`` and ``gateway``
    /// parameters are also set to all zero and DHCP is used for IP address configuration.
    /// Otherwise those three parameters can be used to configure a static IP address.
    /// The default configuration is DHCP.
    ///
    /// If the ``mac_address`` parameter is set to all zero then the factory MAC
    /// address is used. Otherwise this parameter can be used to set a custom MAC
    /// address.
    ///
    /// If the ``bssid`` parameter is set to all zero then WIFI Extension 2.0 will
    /// connect to any access point that matches the configured SSID. Otherwise this
    /// parameter can be used to make the WIFI Extension 2.0 only connect to an
    /// access point if SSID and BSSID match.
    ///
    /// To apply configuration changes to the WIFI Extension 2.0 the
    /// [`save_wifi2_configuration`] function has to be called and the Master Brick
    /// has to be restarted afterwards.
    ///
    /// It is recommended to use the Brick Viewer to configure the WIFI Extension 2.0.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    pub fn set_wifi2_client_configuration(
        &self,
        enable: bool,
        ssid: String,
        ip: [u8; 4],
        subnet_mask: [u8; 4],
        gateway: [u8; 4],
        mac_address: [u8; 6],
        bssid: [u8; 6],
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 57];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enable));
        match <String>::try_to_le_byte_vec(ssid, 32) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[1..33].copy_from_slice(&bytes),
        }

        payload[33..37].copy_from_slice(&<[u8; 4]>::to_le_byte_vec(ip));
        payload[37..41].copy_from_slice(&<[u8; 4]>::to_le_byte_vec(subnet_mask));
        payload[41..45].copy_from_slice(&<[u8; 4]>::to_le_byte_vec(gateway));
        payload[45..51].copy_from_slice(&<[u8; 6]>::to_le_byte_vec(mac_address));
        payload[51..57].copy_from_slice(&<[u8; 6]>::to_le_byte_vec(bssid));

        self.device.set(u8::from(MasterBrickFunction::SetWifi2ClientConfiguration), payload)
    }

    /// Returns the client configuration as set by [`set_wifi2_client_configuration`].
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    pub fn get_wifi2_client_configuration(&self) -> ConvertingReceiver<Wifi2ClientConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifi2ClientConfiguration), payload)
    }

    /// Sets the client hostname (up to 32 characters) of the WIFI Extension 2.0. The
    /// hostname will be displayed by access points as the hostname in the DHCP clients
    /// table.
    ///
    /// To apply configuration changes to the WIFI Extension 2.0 the
    /// [`save_wifi2_configuration`] function has to be called and the Master Brick
    /// has to be restarted afterwards.
    ///
    /// It is recommended to use the Brick Viewer to configure the WIFI Extension 2.0.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    pub fn set_wifi2_client_hostname(&self, hostname: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 32];
        match <String>::try_to_le_byte_vec(hostname, 32) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[0..32].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(MasterBrickFunction::SetWifi2ClientHostname), payload)
    }

    /// Returns the client hostname as set by [`set_wifi2_client_hostname`].
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    pub fn get_wifi2_client_hostname(&self) -> ConvertingReceiver<String> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifi2ClientHostname), payload)
    }

    /// Sets the client password (up to 63 chars) for WPA/WPA2 encryption.
    ///
    /// To apply configuration changes to the WIFI Extension 2.0 the
    /// [`save_wifi2_configuration`] function has to be called and the Master Brick
    /// has to be restarted afterwards.
    ///
    /// It is recommended to use the Brick Viewer to configure the WIFI Extension 2.0.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    pub fn set_wifi2_client_password(&self, password: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 64];
        match <String>::try_to_le_byte_vec(password, 64) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[0..64].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(MasterBrickFunction::SetWifi2ClientPassword), payload)
    }

    /// Returns the client password as set by [`set_wifi2_client_password`].
    ///
    /// # Note
    ///  Since WIFI Extension 2.0 firmware version 2.1.3 the password is not
    ///  returned anymore.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    pub fn get_wifi2_client_password(&self) -> ConvertingReceiver<String> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifi2ClientPassword), payload)
    }

    /// Sets the access point specific configuration of the WIFI Extension 2.0.
    ///
    /// The ``enable`` parameter enables or disables the access point part of the
    /// WIFI Extension 2.0.
    ///
    /// The ``ssid`` parameter sets the SSID (up to 32 characters) of the access point.
    ///
    /// If the ``ip`` parameter is set to all zero then ``subnet_mask`` and ``gateway``
    /// parameters are also set to all zero and DHCP is used for IP address configuration.
    /// Otherwise those three parameters can be used to configure a static IP address.
    /// The default configuration is DHCP.
    ///
    /// The ``encryption`` parameter sets the encryption mode to be used. Possible
    /// values are Open (no encryption), WEP or WPA/WPA2 PSK.
    /// Use the [`set_wifi2_ap_password`] function to set the encryption
    /// password.
    ///
    /// The ``hidden`` parameter makes the access point hide or show its SSID.
    ///
    /// The ``channel`` parameter sets the channel (1 to 13) of the access point.
    ///
    /// If the ``mac_address`` parameter is set to all zero then the factory MAC
    /// address is used. Otherwise this parameter can be used to set a custom MAC
    /// address.
    ///
    /// To apply configuration changes to the WIFI Extension 2.0 the
    /// [`save_wifi2_configuration`] function has to be called and the Master Brick
    /// has to be restarted afterwards.
    ///
    /// It is recommended to use the Brick Viewer to configure the WIFI Extension 2.0.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * MASTER_BRICK_WIFI2_AP_ENCRYPTION_OPEN
    ///	* MASTER_BRICK_WIFI2_AP_ENCRYPTION_WEP
    ///	* MASTER_BRICK_WIFI2_AP_ENCRYPTION_WPA_PSK
    ///	* MASTER_BRICK_WIFI2_AP_ENCRYPTION_WPA2_PSK
    ///	* MASTER_BRICK_WIFI2_AP_ENCRYPTION_WPA_WPA2_PSK
    pub fn set_wifi2_ap_configuration(
        &self,
        enable: bool,
        ssid: String,
        ip: [u8; 4],
        subnet_mask: [u8; 4],
        gateway: [u8; 4],
        encryption: u8,
        hidden: bool,
        channel: u8,
        mac_address: [u8; 6],
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 54];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enable));
        match <String>::try_to_le_byte_vec(ssid, 32) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[1..33].copy_from_slice(&bytes),
        }

        payload[33..37].copy_from_slice(&<[u8; 4]>::to_le_byte_vec(ip));
        payload[37..41].copy_from_slice(&<[u8; 4]>::to_le_byte_vec(subnet_mask));
        payload[41..45].copy_from_slice(&<[u8; 4]>::to_le_byte_vec(gateway));
        payload[45..46].copy_from_slice(&<u8>::to_le_byte_vec(encryption));
        payload[46..47].copy_from_slice(&<bool>::to_le_byte_vec(hidden));
        payload[47..48].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[48..54].copy_from_slice(&<[u8; 6]>::to_le_byte_vec(mac_address));

        self.device.set(u8::from(MasterBrickFunction::SetWifi2ApConfiguration), payload)
    }

    /// Returns the access point configuration as set by [`set_wifi2_ap_configuration`].
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * MASTER_BRICK_WIFI2_AP_ENCRYPTION_OPEN
    ///	* MASTER_BRICK_WIFI2_AP_ENCRYPTION_WEP
    ///	* MASTER_BRICK_WIFI2_AP_ENCRYPTION_WPA_PSK
    ///	* MASTER_BRICK_WIFI2_AP_ENCRYPTION_WPA2_PSK
    ///	* MASTER_BRICK_WIFI2_AP_ENCRYPTION_WPA_WPA2_PSK
    pub fn get_wifi2_ap_configuration(&self) -> ConvertingReceiver<Wifi2ApConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifi2ApConfiguration), payload)
    }

    /// Sets the access point password (at least 8 and up to 63 chars) for the configured encryption
    /// mode, see [`set_wifi2_ap_configuration`].
    ///
    /// To apply configuration changes to the WIFI Extension 2.0 the
    /// [`save_wifi2_configuration`] function has to be called and the Master Brick
    /// has to be restarted afterwards.
    ///
    /// It is recommended to use the Brick Viewer to configure the WIFI Extension 2.0.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    pub fn set_wifi2_ap_password(&self, password: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 64];
        match <String>::try_to_le_byte_vec(password, 64) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[0..64].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(MasterBrickFunction::SetWifi2ApPassword), payload)
    }

    /// Returns the access point password as set by [`set_wifi2_ap_password`].
    ///
    /// # Note
    ///  Since WIFI Extension 2.0 firmware version 2.1.3 the password is not
    ///  returned anymore.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    pub fn get_wifi2_ap_password(&self) -> ConvertingReceiver<String> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifi2ApPassword), payload)
    }

    /// All configuration functions for the WIFI Extension 2.0 do not change the
    /// values permanently. After configuration this function has to be called to
    /// permanently store the values.
    ///
    /// The values are stored in the EEPROM and only applied on startup. That means
    /// you have to restart the Master Brick after configuration.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    pub fn save_wifi2_configuration(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::SaveWifi2Configuration), payload)
    }

    /// Returns the current version of the WIFI Extension 2.0 firmware.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    pub fn get_wifi2_firmware_version(&self) -> ConvertingReceiver<[u8; 3]> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifi2FirmwareVersion), payload)
    }

    /// Turns the green status LED of the WIFI Extension 2.0 on.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    pub fn enable_wifi2_status_led(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(MasterBrickFunction::EnableWifi2StatusLed), payload)
    }

    /// Turns the green status LED of the WIFI Extension 2.0 off.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    pub fn disable_wifi2_status_led(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(MasterBrickFunction::DisableWifi2StatusLed), payload)
    }

    /// Returns *true* if the green status LED of the WIFI Extension 2.0 is turned on.
    ///
    ///
    /// .. versionadded:: 2.4.0$nbsp;(Firmware)
    pub fn is_wifi2_status_led_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::IsWifi2StatusLedEnabled), payload)
    }

    /// Requires WIFI Extension 2.0 firmware 2.1.0.
    ///
    /// Sets the mesh specific configuration of the WIFI Extension 2.0.
    ///
    /// The ``enable`` parameter enables or disables the mesh part of the
    /// WIFI Extension 2.0. The mesh part cannot be
    /// enabled together with the client and access-point part.
    ///
    /// If the ``root_ip`` parameter is set to all zero then ``root_subnet_mask``
    /// and ``root_gateway`` parameters are also set to all zero and DHCP is used for
    /// IP address configuration. Otherwise those three parameters can be used to
    /// configure a static IP address. The default configuration is DHCP.
    ///
    /// If the ``router_bssid`` parameter is set to all zero then the information is
    /// taken from Wi-Fi scan when connecting the SSID as set by
    /// [`set_wifi2_mesh_router_ssid`]. This only works if the the SSID is not hidden.
    /// In case the router has hidden SSID this parameter must be specified, otherwise
    /// the node will not be able to reach the mesh router.
    ///
    /// The ``group_id`` and the ``group_ssid_prefix`` parameters identifies a
    /// particular mesh network and nodes configured with same ``group_id`` and the
    /// ``group_ssid_prefix`` are considered to be in the same mesh network.
    ///
    /// The ``gateway_ip`` and the ``gateway_port`` parameters specifies the location
    /// of the brickd that supports mesh feature.
    ///
    /// To apply configuration changes to the WIFI Extension 2.0 the
    /// [`save_wifi2_configuration`] function has to be called and the Master Brick
    /// has to be restarted afterwards.
    ///
    /// It is recommended to use the Brick Viewer to configure the WIFI Extension 2.0.
    ///
    ///
    /// .. versionadded:: 2.4.2$nbsp;(Firmware)
    pub fn set_wifi2_mesh_configuration(
        &self,
        enable: bool,
        root_ip: [u8; 4],
        root_subnet_mask: [u8; 4],
        root_gateway: [u8; 4],
        router_bssid: [u8; 6],
        group_id: [u8; 6],
        group_ssid_prefix: String,
        gateway_ip: [u8; 4],
        gateway_port: u16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 47];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enable));
        payload[1..5].copy_from_slice(&<[u8; 4]>::to_le_byte_vec(root_ip));
        payload[5..9].copy_from_slice(&<[u8; 4]>::to_le_byte_vec(root_subnet_mask));
        payload[9..13].copy_from_slice(&<[u8; 4]>::to_le_byte_vec(root_gateway));
        payload[13..19].copy_from_slice(&<[u8; 6]>::to_le_byte_vec(router_bssid));
        payload[19..25].copy_from_slice(&<[u8; 6]>::to_le_byte_vec(group_id));
        match <String>::try_to_le_byte_vec(group_ssid_prefix, 16) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[25..41].copy_from_slice(&bytes),
        }

        payload[41..45].copy_from_slice(&<[u8; 4]>::to_le_byte_vec(gateway_ip));
        payload[45..47].copy_from_slice(&<u16>::to_le_byte_vec(gateway_port));

        self.device.set(u8::from(MasterBrickFunction::SetWifi2MeshConfiguration), payload)
    }

    /// Requires WIFI Extension 2.0 firmware 2.1.0.
    ///
    /// Returns the mesh configuration as set by [`set_wifi2_mesh_configuration`].
    ///
    ///
    /// .. versionadded:: 2.4.2$nbsp;(Firmware)
    pub fn get_wifi2_mesh_configuration(&self) -> ConvertingReceiver<Wifi2MeshConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifi2MeshConfiguration), payload)
    }

    /// Requires WIFI Extension 2.0 firmware 2.1.0.
    ///
    /// Sets the mesh router SSID of the WIFI Extension 2.0.
    /// It is used to specify the mesh router to connect to.
    ///
    /// Note that even though in the argument of this function a 32 characters long SSID
    /// is allowed, in practice valid SSID should have a maximum of 31 characters. This
    /// is due to a bug in the mesh library that we use in the firmware of the extension.
    ///
    /// To apply configuration changes to the WIFI Extension 2.0 the
    /// [`save_wifi2_configuration`] function has to be called and the Master Brick
    /// has to be restarted afterwards.
    ///
    /// It is recommended to use the Brick Viewer to configure the WIFI Extension 2.0.
    ///
    ///
    /// .. versionadded:: 2.4.2$nbsp;(Firmware)
    pub fn set_wifi2_mesh_router_ssid(&self, ssid: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 32];
        match <String>::try_to_le_byte_vec(ssid, 32) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[0..32].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(MasterBrickFunction::SetWifi2MeshRouterSsid), payload)
    }

    /// Requires WIFI Extension 2.0 firmware 2.1.0.
    ///
    /// Returns the mesh router SSID as set by [`set_wifi2_mesh_router_ssid`].
    ///
    ///
    /// .. versionadded:: 2.4.2$nbsp;(Firmware)
    pub fn get_wifi2_mesh_router_ssid(&self) -> ConvertingReceiver<String> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifi2MeshRouterSsid), payload)
    }

    /// Requires WIFI Extension 2.0 firmware 2.1.0.
    ///
    /// Sets the mesh router password (up to 64 characters) for WPA/WPA2 encryption.
    /// The password will be used to connect to the mesh router.
    ///
    /// To apply configuration changes to the WIFI Extension 2.0 the
    /// [`save_wifi2_configuration`] function has to be called and the Master Brick
    /// has to be restarted afterwards.
    ///
    /// It is recommended to use the Brick Viewer to configure the WIFI Extension 2.0.
    ///
    ///
    /// .. versionadded:: 2.4.2$nbsp;(Firmware)
    pub fn set_wifi2_mesh_router_password(&self, password: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 64];
        match <String>::try_to_le_byte_vec(password, 64) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[0..64].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(MasterBrickFunction::SetWifi2MeshRouterPassword), payload)
    }

    /// Requires WIFI Extension 2.0 firmware 2.1.0.
    ///
    /// Returns the mesh router password as set by [`set_wifi2_mesh_router_password`].
    ///
    ///
    /// .. versionadded:: 2.4.2$nbsp;(Firmware)
    pub fn get_wifi2_mesh_router_password(&self) -> ConvertingReceiver<String> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifi2MeshRouterPassword), payload)
    }

    /// Requires WIFI Extension 2.0 firmware 2.1.0.
    ///
    /// Returns the common mesh status of the WIFI Extension 2.0.
    ///
    ///
    /// .. versionadded:: 2.4.2$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * MASTER_BRICK_WIFI2_MESH_STATUS_DISABLED
    ///	* MASTER_BRICK_WIFI2_MESH_STATUS_WIFI_CONNECTING
    ///	* MASTER_BRICK_WIFI2_MESH_STATUS_GOT_IP
    ///	* MASTER_BRICK_WIFI2_MESH_STATUS_MESH_LOCAL
    ///	* MASTER_BRICK_WIFI2_MESH_STATUS_MESH_ONLINE
    ///	* MASTER_BRICK_WIFI2_MESH_STATUS_AP_AVAILABLE
    ///	* MASTER_BRICK_WIFI2_MESH_STATUS_AP_SETUP
    ///	* MASTER_BRICK_WIFI2_MESH_STATUS_LEAF_AVAILABLE
    pub fn get_wifi2_mesh_common_status(&self) -> ConvertingReceiver<Wifi2MeshCommonStatus> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifi2MeshCommonStatus), payload)
    }

    /// Requires WIFI Extension 2.0 firmware 2.1.0.
    ///
    /// Returns the mesh client status of the WIFI Extension 2.0.
    ///
    ///
    /// .. versionadded:: 2.4.2$nbsp;(Firmware)
    pub fn get_wifi2_mesh_client_status(&self) -> ConvertingReceiver<Wifi2MeshClientStatus> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifi2MeshClientStatus), payload)
    }

    /// Requires WIFI Extension 2.0 firmware 2.1.0.
    ///
    /// Returns the mesh AP status of the WIFI Extension 2.0.
    ///
    ///
    /// .. versionadded:: 2.4.2$nbsp;(Firmware)
    pub fn get_wifi2_mesh_ap_status(&self) -> ConvertingReceiver<Wifi2MeshApStatus> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetWifi2MeshApStatus), payload)
    }

    /// This function is for internal use to flash the initial
    /// bootstrapper and bootloader to the Bricklets.
    ///
    /// If you need to flash a boostrapper/bootloader (for exmaple
    /// because you made your own Bricklet from scratch) please
    /// take a look at our open source flash and test tool at
    /// [https://github.com/Tinkerforge/flash-test](https://github.com/Tinkerforge/flash-test)__
    ///
    /// Don't use this function directly.
    ///
    ///
    /// .. versionadded:: 2.5.0$nbsp;(Firmware)
    pub fn set_bricklet_xmc_flash_config(
        &self,
        config: u32,
        parameter1: u32,
        parameter2: u32,
        data: [u8; 52],
    ) -> ConvertingReceiver<SetBrickletXmcFlashConfig> {
        let mut payload = vec![0; 64];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(config));
        payload[4..8].copy_from_slice(&<u32>::to_le_byte_vec(parameter1));
        payload[8..12].copy_from_slice(&<u32>::to_le_byte_vec(parameter2));
        payload[12..64].copy_from_slice(&<[u8; 52]>::to_le_byte_vec(data));

        self.device.get(u8::from(MasterBrickFunction::SetBrickletXmcFlashConfig), payload)
    }

    /// This function is for internal use to flash the initial
    /// bootstrapper and bootloader to the Bricklets.
    ///
    /// If you need to flash a boostrapper/bootloader (for exmaple
    /// because you made your own Bricklet from scratch) please
    /// take a look at our open source flash and test tool at
    /// [https://github.com/Tinkerforge/flash-test](https://github.com/Tinkerforge/flash-test)__
    ///
    /// Don't use this function directly.
    ///
    ///
    /// .. versionadded:: 2.5.0$nbsp;(Firmware)
    pub fn set_bricklet_xmc_flash_data(&self, data: [u8; 64]) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(MasterBrickFunction::SetBrickletXmcFlashData), payload)
    }

    /// This function is only available in Master Brick hardware version >= 3.0.
    ///
    /// Enables/disables all four Bricklets if set to true/false.
    ///
    /// If you disable the Bricklets the power supply to the Bricklets will be disconnected.
    /// The Bricklets will lose all configurations if disabled.
    ///
    ///
    /// .. versionadded:: 2.5.0$nbsp;(Firmware)
    pub fn set_bricklets_enabled(&self, bricklets_enabled: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(bricklets_enabled));

        self.device.set(u8::from(MasterBrickFunction::SetBrickletsEnabled), payload)
    }

    /// Returns *true* if the Bricklets are enabled, *false* otherwise.
    ///
    ///
    /// .. versionadded:: 2.5.0$nbsp;(Firmware)
    pub fn get_bricklets_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetBrickletsEnabled), payload)
    }

    /// The SPITF protocol can be used with a dynamic baudrate. If the dynamic baudrate is
    /// enabled, the Brick will try to adapt the baudrate for the communication
    /// between Bricks and Bricklets according to the amount of data that is transferred.
    ///
    /// The baudrate will be increased exponentially if lots of data is sent/received and
    /// decreased linearly if little data is sent/received.
    ///
    /// This lowers the baudrate in applications where little data is transferred (e.g.
    /// a weather station) and increases the robustness. If there is lots of data to transfer
    /// (e.g. Thermal Imaging Bricklet) it automatically increases the baudrate as needed.
    ///
    /// In cases where some data has to transferred as fast as possible every few seconds
    /// (e.g. RS485 Bricklet with a high baudrate but small payload) you may want to turn
    /// the dynamic baudrate off to get the highest possible performance.
    ///
    /// The maximum value of the baudrate can be set per port with the function
    /// [`set_spitfp_baudrate`]. If the dynamic baudrate is disabled, the baudrate
    /// as set by [`set_spitfp_baudrate`] will be used statically.
    ///
    ///
    /// .. versionadded:: 2.4.6$nbsp;(Firmware)
    pub fn set_spitfp_baudrate_config(&self, enable_dynamic_baudrate: bool, minimum_dynamic_baudrate: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enable_dynamic_baudrate));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(minimum_dynamic_baudrate));

        self.device.set(u8::from(MasterBrickFunction::SetSpitfpBaudrateConfig), payload)
    }

    /// Returns the baudrate config, see [`set_spitfp_baudrate_config`].
    ///
    ///
    /// .. versionadded:: 2.4.6$nbsp;(Firmware)
    pub fn get_spitfp_baudrate_config(&self) -> ConvertingReceiver<SpitfpBaudrateConfig> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetSpitfpBaudrateConfig), payload)
    }

    /// Returns the timeout count for the different communication methods.
    ///
    /// The methods 0-2 are available for all Bricks, 3-7 only for Master Bricks.
    ///
    /// This function is mostly used for debugging during development, in normal operation
    /// the counters should nearly always stay at 0.
    ///
    ///
    /// .. versionadded:: 2.4.3$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * MASTER_BRICK_COMMUNICATION_METHOD_NONE
    ///	* MASTER_BRICK_COMMUNICATION_METHOD_USB
    ///	* MASTER_BRICK_COMMUNICATION_METHOD_SPI_STACK
    ///	* MASTER_BRICK_COMMUNICATION_METHOD_CHIBI
    ///	* MASTER_BRICK_COMMUNICATION_METHOD_RS485
    ///	* MASTER_BRICK_COMMUNICATION_METHOD_WIFI
    ///	* MASTER_BRICK_COMMUNICATION_METHOD_ETHERNET
    ///	* MASTER_BRICK_COMMUNICATION_METHOD_WIFI_V2
    pub fn get_send_timeout_count(&self, communication_method: u8) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(communication_method));

        self.device.get(u8::from(MasterBrickFunction::GetSendTimeoutCount), payload)
    }

    /// Sets the baudrate for a specific Bricklet port.
    ///
    /// If you want to increase the throughput of Bricklets you can increase
    /// the baudrate. If you get a high error count because of high
    /// interference (see [`get_spitfp_error_count`]) you can decrease the
    /// baudrate.
    ///
    /// If the dynamic baudrate feature is enabled, the baudrate set by this
    /// function corresponds to the maximum baudrate (see [`set_spitfp_baudrate_config`]).
    ///
    /// Regulatory testing is done with the default baudrate. If CE compatibility
    /// or similar is necessary in your applications we recommend to not change
    /// the baudrate.
    ///
    ///
    /// .. versionadded:: 2.4.3$nbsp;(Firmware)
    pub fn set_spitfp_baudrate(&self, bricklet_port: char, baudrate: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(baudrate));

        self.device.set(u8::from(MasterBrickFunction::SetSpitfpBaudrate), payload)
    }

    /// Returns the baudrate for a given Bricklet port, see [`set_spitfp_baudrate`].
    ///
    ///
    /// .. versionadded:: 2.4.3$nbsp;(Firmware)
    pub fn get_spitfp_baudrate(&self, bricklet_port: char) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));

        self.device.get(u8::from(MasterBrickFunction::GetSpitfpBaudrate), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Brick side. All
    /// Bricklets have a similar function that returns the errors on the Bricklet side.
    ///
    ///
    /// .. versionadded:: 2.4.3$nbsp;(Firmware)
    pub fn get_spitfp_error_count(&self, bricklet_port: char) -> ConvertingReceiver<SpitfpErrorCount> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));

        self.device.get(u8::from(MasterBrickFunction::GetSpitfpErrorCount), payload)
    }

    /// Enables the status LED.
    ///
    /// The status LED is the blue LED next to the USB connector. If enabled is is
    /// on and it flickers if data is transfered. If disabled it is always off.
    ///
    /// The default state is enabled.
    ///
    ///
    /// .. versionadded:: 2.3.2$nbsp;(Firmware)
    pub fn enable_status_led(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(MasterBrickFunction::EnableStatusLed), payload)
    }

    /// Disables the status LED.
    ///
    /// The status LED is the blue LED next to the USB connector. If enabled is is
    /// on and it flickers if data is transfered. If disabled it is always off.
    ///
    /// The default state is enabled.
    ///
    ///
    /// .. versionadded:: 2.3.2$nbsp;(Firmware)
    pub fn disable_status_led(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(MasterBrickFunction::DisableStatusLed), payload)
    }

    /// Returns *true* if the status LED is enabled, *false* otherwise.
    ///
    ///
    /// .. versionadded:: 2.3.2$nbsp;(Firmware)
    pub fn is_status_led_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::IsStatusLedEnabled), payload)
    }

    /// Returns the firmware and protocol version and the name of the Bricklet for a
    /// given port.
    ///
    /// This functions sole purpose is to allow automatic flashing of v1.x.y Bricklet
    /// plugins.
    pub fn get_protocol1_bricklet_name(&self, port: char) -> ConvertingReceiver<Protocol1BrickletName> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));

        self.device.get(u8::from(MasterBrickFunction::GetProtocol1BrickletName), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has an
    /// accuracy of ±15%. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Brick. Calling this function
    /// on a Brick inside of a stack will reset the whole stack.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(MasterBrickFunction::Reset), payload)
    }

    /// Writes 32 bytes of firmware to the bricklet attached at the given port.
    /// The bytes are written to the position offset * 32.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_bricklet_plugin(&self, port: char, offset: u8, chunk: [u8; 32]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 34];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(offset));
        payload[2..34].copy_from_slice(&<[u8; 32]>::to_le_byte_vec(chunk));

        self.device.set(u8::from(MasterBrickFunction::WriteBrickletPlugin), payload)
    }

    /// Reads 32 bytes of firmware from the bricklet attached at the given port.
    /// The bytes are read starting at the position offset * 32.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn read_bricklet_plugin(&self, port: char, offset: u8) -> ConvertingReceiver<[u8; 32]> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(offset));

        self.device.get(u8::from(MasterBrickFunction::ReadBrickletPlugin), payload)
    }

    /// Returns the UID, the UID where the Brick is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position is the position in the stack from '0' (bottom) to '8' (top).
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MasterBrickFunction::GetIdentity), payload)
    }
}
