/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures weight with a load cell.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/LoadCellV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum LoadCellV2BrickletFunction {
    GetWeight,
    SetWeightCallbackConfiguration,
    GetWeightCallbackConfiguration,
    SetMovingAverage,
    GetMovingAverage,
    SetInfoLedConfig,
    GetInfoLedConfig,
    Calibrate,
    Tare,
    SetConfiguration,
    GetConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackWeight,
}
impl From<LoadCellV2BrickletFunction> for u8 {
    fn from(fun: LoadCellV2BrickletFunction) -> Self {
        match fun {
            LoadCellV2BrickletFunction::GetWeight => 1,
            LoadCellV2BrickletFunction::SetWeightCallbackConfiguration => 2,
            LoadCellV2BrickletFunction::GetWeightCallbackConfiguration => 3,
            LoadCellV2BrickletFunction::SetMovingAverage => 5,
            LoadCellV2BrickletFunction::GetMovingAverage => 6,
            LoadCellV2BrickletFunction::SetInfoLedConfig => 7,
            LoadCellV2BrickletFunction::GetInfoLedConfig => 8,
            LoadCellV2BrickletFunction::Calibrate => 9,
            LoadCellV2BrickletFunction::Tare => 10,
            LoadCellV2BrickletFunction::SetConfiguration => 11,
            LoadCellV2BrickletFunction::GetConfiguration => 12,
            LoadCellV2BrickletFunction::GetSpitfpErrorCount => 234,
            LoadCellV2BrickletFunction::SetBootloaderMode => 235,
            LoadCellV2BrickletFunction::GetBootloaderMode => 236,
            LoadCellV2BrickletFunction::SetWriteFirmwarePointer => 237,
            LoadCellV2BrickletFunction::WriteFirmware => 238,
            LoadCellV2BrickletFunction::SetStatusLedConfig => 239,
            LoadCellV2BrickletFunction::GetStatusLedConfig => 240,
            LoadCellV2BrickletFunction::GetChipTemperature => 242,
            LoadCellV2BrickletFunction::Reset => 243,
            LoadCellV2BrickletFunction::WriteUid => 248,
            LoadCellV2BrickletFunction::ReadUid => 249,
            LoadCellV2BrickletFunction::GetIdentity => 255,
            LoadCellV2BrickletFunction::CallbackWeight => 4,
        }
    }
}
pub const LOAD_CELL_V2_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const LOAD_CELL_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const LOAD_CELL_V2_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const LOAD_CELL_V2_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const LOAD_CELL_V2_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const LOAD_CELL_V2_BRICKLET_INFO_LED_CONFIG_OFF: u8 = 0;
pub const LOAD_CELL_V2_BRICKLET_INFO_LED_CONFIG_ON: u8 = 1;
pub const LOAD_CELL_V2_BRICKLET_INFO_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const LOAD_CELL_V2_BRICKLET_RATE_10HZ: u8 = 0;
pub const LOAD_CELL_V2_BRICKLET_RATE_80HZ: u8 = 1;
pub const LOAD_CELL_V2_BRICKLET_GAIN_128X: u8 = 0;
pub const LOAD_CELL_V2_BRICKLET_GAIN_64X: u8 = 1;
pub const LOAD_CELL_V2_BRICKLET_GAIN_32X: u8 = 2;
pub const LOAD_CELL_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const LOAD_CELL_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const LOAD_CELL_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const LOAD_CELL_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const LOAD_CELL_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const LOAD_CELL_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const LOAD_CELL_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const LOAD_CELL_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const LOAD_CELL_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const LOAD_CELL_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const LOAD_CELL_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const LOAD_CELL_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const LOAD_CELL_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const LOAD_CELL_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const LOAD_CELL_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WeightCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for WeightCallbackConfiguration {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> WeightCallbackConfiguration {
        WeightCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <i32>::from_le_byte_slice(&bytes[6..10]),
            max: <i32>::from_le_byte_slice(&bytes[10..14]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub rate: u8,
    pub gain: u8,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration { rate: <u8>::from_le_byte_slice(&bytes[0..1]), gain: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures weight with a load cell
#[derive(Clone)]
pub struct LoadCellV2Bricklet {
    device: Device,
}
impl LoadCellV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2104;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Load Cell Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> LoadCellV2Bricklet {
        let mut result = LoadCellV2Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::GetWeight) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::SetWeightCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::GetWeightCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::SetMovingAverage) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::GetMovingAverage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::SetInfoLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::GetInfoLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::Calibrate) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::Tare) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::SetConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::GetConfiguration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LoadCellV2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::load_cell_v2_bricklet::LoadCellV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::load_cell_v2_bricklet::LoadCellV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: LoadCellV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: LoadCellV2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_weight_callback_configuration`].
    ///
    /// The parameter is the same as [`get_weight`].
    ///
    /// [`get_weight`]: #method.get_weight
    /// [`set_weight_callback_configuration`]: #method.set_weight_callback_configuration
    pub fn get_weight_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(LoadCellV2BrickletFunction::CallbackWeight))
    }

    /// Returns the currently measured weight.
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_weight_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_weight_callback_configuration`].
    pub fn get_weight(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LoadCellV2BrickletFunction::GetWeight), payload)
    }

    /// The period is the period with which the [`get_weight_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_weight_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * LOAD_CELL_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* LOAD_CELL_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* LOAD_CELL_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* LOAD_CELL_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* LOAD_CELL_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_weight_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: i32,
        max: i32,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 14];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..10].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[10..14].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(LoadCellV2BrickletFunction::SetWeightCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_weight_callback_configuration`].
    ///
    /// Associated constants:
    /// * LOAD_CELL_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* LOAD_CELL_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* LOAD_CELL_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* LOAD_CELL_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* LOAD_CELL_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_weight_callback_configuration(&self) -> ConvertingReceiver<WeightCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LoadCellV2BrickletFunction::GetWeightCallbackConfiguration), payload)
    }

    /// Sets the length of a [moving averaging](https://en.wikipedia.org/wiki/Moving_average)__
    /// for the weight value.
    ///
    /// Setting the length to 1 will turn the averaging off. With less
    /// averaging, there is more noise on the data.
    pub fn set_moving_average(&self, average: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(average));

        self.device.set(u8::from(LoadCellV2BrickletFunction::SetMovingAverage), payload)
    }

    /// Returns the length moving average as set by [`set_moving_average`].
    pub fn get_moving_average(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LoadCellV2BrickletFunction::GetMovingAverage), payload)
    }

    /// Configures the info LED to be either turned off, turned on, or blink in
    /// heartbeat mode.
    ///
    /// Associated constants:
    /// * LOAD_CELL_V2_BRICKLET_INFO_LED_CONFIG_OFF
    ///	* LOAD_CELL_V2_BRICKLET_INFO_LED_CONFIG_ON
    ///	* LOAD_CELL_V2_BRICKLET_INFO_LED_CONFIG_SHOW_HEARTBEAT
    pub fn set_info_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(LoadCellV2BrickletFunction::SetInfoLedConfig), payload)
    }

    /// Returns the LED configuration as set by [`set_info_led_config`]
    ///
    /// Associated constants:
    /// * LOAD_CELL_V2_BRICKLET_INFO_LED_CONFIG_OFF
    ///	* LOAD_CELL_V2_BRICKLET_INFO_LED_CONFIG_ON
    ///	* LOAD_CELL_V2_BRICKLET_INFO_LED_CONFIG_SHOW_HEARTBEAT
    pub fn get_info_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LoadCellV2BrickletFunction::GetInfoLedConfig), payload)
    }

    /// To calibrate your Load Cell Bricklet 2.0 you have to
    ///
    /// * empty the scale and call this function with 0 and
    /// * add a known weight to the scale and call this function with the weight.
    ///
    /// The calibration is saved in the flash of the Bricklet and only
    /// needs to be done once.
    ///
    /// We recommend to use the Brick Viewer for calibration, you don't need
    /// to call this function in your source code.
    pub fn calibrate(&self, weight: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(weight));

        self.device.set(u8::from(LoadCellV2BrickletFunction::Calibrate), payload)
    }

    /// Sets the currently measured weight as tare weight.
    pub fn tare(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(LoadCellV2BrickletFunction::Tare), payload)
    }

    /// The measurement rate and gain are configurable.
    ///
    /// The rate can be either 10Hz or 80Hz. A faster rate will produce more noise.
    /// It is additionally possible to add a moving average
    /// (see [`set_moving_average`]) to the measurements.
    ///
    /// The gain can be 128x, 64x or 32x. It represents a measurement range of
    /// ±20mV, ±40mV and ±80mV respectively. The Load Cell Bricklet uses an
    /// excitation voltage of 5V and most load cells use an output of 2mV/V. That
    /// means the voltage range is ±15mV for most load cells (i.e. gain of 128x
    /// is best). If you don't know what all of this means you should keep it at
    /// 128x, it will most likely be correct.
    ///
    /// Associated constants:
    /// * LOAD_CELL_V2_BRICKLET_RATE_10HZ
    ///	* LOAD_CELL_V2_BRICKLET_RATE_80HZ
    ///	* LOAD_CELL_V2_BRICKLET_GAIN_128X
    ///	* LOAD_CELL_V2_BRICKLET_GAIN_64X
    ///	* LOAD_CELL_V2_BRICKLET_GAIN_32X
    pub fn set_configuration(&self, rate: u8, gain: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(rate));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(gain));

        self.device.set(u8::from(LoadCellV2BrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    ///
    /// Associated constants:
    /// * LOAD_CELL_V2_BRICKLET_RATE_10HZ
    ///	* LOAD_CELL_V2_BRICKLET_RATE_80HZ
    ///	* LOAD_CELL_V2_BRICKLET_GAIN_128X
    ///	* LOAD_CELL_V2_BRICKLET_GAIN_64X
    ///	* LOAD_CELL_V2_BRICKLET_GAIN_32X
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LoadCellV2BrickletFunction::GetConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LoadCellV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * LOAD_CELL_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* LOAD_CELL_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* LOAD_CELL_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* LOAD_CELL_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* LOAD_CELL_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* LOAD_CELL_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* LOAD_CELL_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* LOAD_CELL_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* LOAD_CELL_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* LOAD_CELL_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* LOAD_CELL_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(LoadCellV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * LOAD_CELL_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* LOAD_CELL_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* LOAD_CELL_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* LOAD_CELL_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* LOAD_CELL_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LoadCellV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(LoadCellV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(LoadCellV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * LOAD_CELL_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* LOAD_CELL_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* LOAD_CELL_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* LOAD_CELL_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(LoadCellV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * LOAD_CELL_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* LOAD_CELL_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* LOAD_CELL_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* LOAD_CELL_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LoadCellV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LoadCellV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(LoadCellV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(LoadCellV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LoadCellV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LoadCellV2BrickletFunction::GetIdentity), payload)
    }
}
