/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures weight with a load cell.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/LoadCell_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum LoadCellBrickletFunction {
    GetWeight,
    SetWeightCallbackPeriod,
    GetWeightCallbackPeriod,
    SetWeightCallbackThreshold,
    GetWeightCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    SetMovingAverage,
    GetMovingAverage,
    LedOn,
    LedOff,
    IsLedOn,
    Calibrate,
    Tare,
    SetConfiguration,
    GetConfiguration,
    GetIdentity,
    CallbackWeight,
    CallbackWeightReached,
}
impl From<LoadCellBrickletFunction> for u8 {
    fn from(fun: LoadCellBrickletFunction) -> Self {
        match fun {
            LoadCellBrickletFunction::GetWeight => 1,
            LoadCellBrickletFunction::SetWeightCallbackPeriod => 2,
            LoadCellBrickletFunction::GetWeightCallbackPeriod => 3,
            LoadCellBrickletFunction::SetWeightCallbackThreshold => 4,
            LoadCellBrickletFunction::GetWeightCallbackThreshold => 5,
            LoadCellBrickletFunction::SetDebouncePeriod => 6,
            LoadCellBrickletFunction::GetDebouncePeriod => 7,
            LoadCellBrickletFunction::SetMovingAverage => 8,
            LoadCellBrickletFunction::GetMovingAverage => 9,
            LoadCellBrickletFunction::LedOn => 10,
            LoadCellBrickletFunction::LedOff => 11,
            LoadCellBrickletFunction::IsLedOn => 12,
            LoadCellBrickletFunction::Calibrate => 13,
            LoadCellBrickletFunction::Tare => 14,
            LoadCellBrickletFunction::SetConfiguration => 15,
            LoadCellBrickletFunction::GetConfiguration => 16,
            LoadCellBrickletFunction::GetIdentity => 255,
            LoadCellBrickletFunction::CallbackWeight => 17,
            LoadCellBrickletFunction::CallbackWeightReached => 18,
        }
    }
}
pub const LOAD_CELL_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const LOAD_CELL_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const LOAD_CELL_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const LOAD_CELL_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const LOAD_CELL_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const LOAD_CELL_BRICKLET_RATE_10HZ: u8 = 0;
pub const LOAD_CELL_BRICKLET_RATE_80HZ: u8 = 1;
pub const LOAD_CELL_BRICKLET_GAIN_128X: u8 = 0;
pub const LOAD_CELL_BRICKLET_GAIN_64X: u8 = 1;
pub const LOAD_CELL_BRICKLET_GAIN_32X: u8 = 2;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WeightCallbackThreshold {
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for WeightCallbackThreshold {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> WeightCallbackThreshold {
        WeightCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <i32>::from_le_byte_slice(&bytes[1..5]),
            max: <i32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub rate: u8,
    pub gain: u8,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration { rate: <u8>::from_le_byte_slice(&bytes[0..1]), gain: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures weight with a load cell
#[derive(Clone)]
pub struct LoadCellBricklet {
    device: Device,
}
impl LoadCellBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 253;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Load Cell Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> LoadCellBricklet {
        let mut result = LoadCellBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(LoadCellBrickletFunction::GetWeight) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LoadCellBrickletFunction::SetWeightCallbackPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(LoadCellBrickletFunction::GetWeightCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LoadCellBrickletFunction::SetWeightCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(LoadCellBrickletFunction::GetWeightCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LoadCellBrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(LoadCellBrickletFunction::GetDebouncePeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LoadCellBrickletFunction::SetMovingAverage) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LoadCellBrickletFunction::GetMovingAverage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LoadCellBrickletFunction::LedOn) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LoadCellBrickletFunction::LedOff) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LoadCellBrickletFunction::IsLedOn) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LoadCellBrickletFunction::Calibrate) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LoadCellBrickletFunction::Tare) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LoadCellBrickletFunction::SetConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LoadCellBrickletFunction::GetConfiguration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LoadCellBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::load_cell_bricklet::LoadCellBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::load_cell_bricklet::LoadCellBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: LoadCellBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: LoadCellBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_weight_callback_period`]. The parameter is the weight
    /// as measured by the load cell.
    ///
    /// The [`get_weight_callback_receiver`] receiver is only triggered if the weight has changed since the
    /// last triggering.
    ///
    /// [`set_weight_callback_period`]: #method.set_weight_callback_period
    /// [`get_weight_callback_receiver`]: #method.get_weight_callback_receiver
    pub fn get_weight_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(LoadCellBrickletFunction::CallbackWeight))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_weight_callback_threshold`] is reached.
    /// The parameter is the weight as measured by the load cell.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_weight_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(LoadCellBrickletFunction::CallbackWeightReached))
    }

    /// Returns the currently measured weight.
    ///
    /// If you want to get the weight periodically, it is recommended
    /// to use the [`get_weight_callback_receiver`] receiver and set the period with
    /// [`set_weight_callback_period`].
    pub fn get_weight(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LoadCellBrickletFunction::GetWeight), payload)
    }

    /// Sets the period with which the [`get_weight_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_weight_callback_receiver`] receiver is only triggered if the weight has changed since the
    /// last triggering.
    pub fn set_weight_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(LoadCellBrickletFunction::SetWeightCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_weight_callback_period`].
    pub fn get_weight_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LoadCellBrickletFunction::GetWeightCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_weight_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the weight is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the weight is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the weight is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the weight is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * LOAD_CELL_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* LOAD_CELL_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* LOAD_CELL_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* LOAD_CELL_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* LOAD_CELL_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_weight_callback_threshold(&self, option: char, min: i32, max: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..5].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[5..9].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(LoadCellBrickletFunction::SetWeightCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_weight_callback_threshold`].
    ///
    /// Associated constants:
    /// * LOAD_CELL_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* LOAD_CELL_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* LOAD_CELL_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* LOAD_CELL_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* LOAD_CELL_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_weight_callback_threshold(&self) -> ConvertingReceiver<WeightCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LoadCellBrickletFunction::GetWeightCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receiver
    ///
    /// * [`get_weight_reached_callback_receiver`]
    ///
    /// is triggered, if the threshold
    ///
    /// * [`set_weight_callback_threshold`]
    ///
    /// keeps being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(LoadCellBrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LoadCellBrickletFunction::GetDebouncePeriod), payload)
    }

    /// Sets the length of a [moving averaging](https://en.wikipedia.org/wiki/Moving_average)__
    /// for the weight value.
    ///
    /// Setting the length to 1 will turn the averaging off. With less
    /// averaging, there is more noise on the data.
    pub fn set_moving_average(&self, average: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(average));

        self.device.set(u8::from(LoadCellBrickletFunction::SetMovingAverage), payload)
    }

    /// Returns the length moving average as set by [`set_moving_average`].
    pub fn get_moving_average(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LoadCellBrickletFunction::GetMovingAverage), payload)
    }

    /// Turns the LED on.
    pub fn led_on(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(LoadCellBrickletFunction::LedOn), payload)
    }

    /// Turns the LED off.
    pub fn led_off(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(LoadCellBrickletFunction::LedOff), payload)
    }

    /// Returns *true* if the led is on, *false* otherwise.
    pub fn is_led_on(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LoadCellBrickletFunction::IsLedOn), payload)
    }

    /// To calibrate your Load Cell Bricklet you have to
    ///
    /// * empty the scale and call this function with 0 and
    /// * add a known weight to the scale and call this function with the weight.
    ///
    /// The calibration is saved in the EEPROM of the Bricklet and only
    /// needs to be done once.
    ///
    /// We recommend to use the Brick Viewer for calibration, you don't need
    /// to call this function in your source code.
    pub fn calibrate(&self, weight: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(weight));

        self.device.set(u8::from(LoadCellBrickletFunction::Calibrate), payload)
    }

    /// Sets the currently measured weight as tare weight.
    pub fn tare(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(LoadCellBrickletFunction::Tare), payload)
    }

    /// The measurement rate and gain are configurable.
    ///
    /// The rate can be either 10Hz or 80Hz. A faster rate will produce more noise.
    /// It is additionally possible to add a moving average
    /// (see [`set_moving_average`]) to the measurements.
    ///
    /// The gain can be 128x, 64x or 32x. It represents a measurement range of
    /// ±20mV, ±40mV and ±80mV respectively. The Load Cell Bricklet uses an
    /// excitation voltage of 5V and most load cells use an output of 2mV/V. That
    /// means the voltage range is ±15mV for most load cells (i.e. gain of 128x
    /// is best). If you don't know what all of this means you should keep it at
    /// 128x, it will most likely be correct.
    ///
    /// The configuration is saved in the EEPROM of the Bricklet and only
    /// needs to be done once.
    ///
    /// We recommend to use the Brick Viewer for configuration, you don't need
    /// to call this function in your source code.
    ///
    /// Associated constants:
    /// * LOAD_CELL_BRICKLET_RATE_10HZ
    ///	* LOAD_CELL_BRICKLET_RATE_80HZ
    ///	* LOAD_CELL_BRICKLET_GAIN_128X
    ///	* LOAD_CELL_BRICKLET_GAIN_64X
    ///	* LOAD_CELL_BRICKLET_GAIN_32X
    pub fn set_configuration(&self, rate: u8, gain: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(rate));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(gain));

        self.device.set(u8::from(LoadCellBrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    ///
    /// Associated constants:
    /// * LOAD_CELL_BRICKLET_RATE_10HZ
    ///	* LOAD_CELL_BRICKLET_RATE_80HZ
    ///	* LOAD_CELL_BRICKLET_GAIN_128X
    ///	* LOAD_CELL_BRICKLET_GAIN_64X
    ///	* LOAD_CELL_BRICKLET_GAIN_32X
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LoadCellBrickletFunction::GetConfiguration), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LoadCellBrickletFunction::GetIdentity), payload)
    }
}
