/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! 7.1cm (2.8") display with 128x64 pixel and touch screen.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/LCD128x64_Bricklet_Rust.html).
use crate::{
    byte_converter::*,
    converting_callback_receiver::ConvertingCallbackReceiver,
    converting_receiver::{BrickletError, BrickletRecvTimeoutError, ConvertingReceiver},
    device::*,
    ip_connection::GetRequestSender,
    low_level_traits::*,
};
pub enum Lcd128x64BrickletFunction {
    WritePixelsLowLevel,
    ReadPixelsLowLevel,
    ClearDisplay,
    SetDisplayConfiguration,
    GetDisplayConfiguration,
    WriteLine,
    DrawBufferedFrame,
    GetTouchPosition,
    SetTouchPositionCallbackConfiguration,
    GetTouchPositionCallbackConfiguration,
    GetTouchGesture,
    SetTouchGestureCallbackConfiguration,
    GetTouchGestureCallbackConfiguration,
    DrawLine,
    DrawBox,
    DrawText,
    SetGuiButton,
    GetGuiButton,
    RemoveGuiButton,
    SetGuiButtonPressedCallbackConfiguration,
    GetGuiButtonPressedCallbackConfiguration,
    GetGuiButtonPressed,
    SetGuiSlider,
    GetGuiSlider,
    RemoveGuiSlider,
    SetGuiSliderValueCallbackConfiguration,
    GetGuiSliderValueCallbackConfiguration,
    GetGuiSliderValue,
    SetGuiTabConfiguration,
    GetGuiTabConfiguration,
    SetGuiTabText,
    GetGuiTabText,
    SetGuiTabIcon,
    GetGuiTabIcon,
    RemoveGuiTab,
    SetGuiTabSelected,
    SetGuiTabSelectedCallbackConfiguration,
    GetGuiTabSelectedCallbackConfiguration,
    GetGuiTabSelected,
    SetGuiGraphConfiguration,
    GetGuiGraphConfiguration,
    SetGuiGraphDataLowLevel,
    GetGuiGraphDataLowLevel,
    RemoveGuiGraph,
    RemoveAllGui,
    SetTouchLedConfig,
    GetTouchLedConfig,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackTouchPosition,
    CallbackTouchGesture,
    CallbackGuiButtonPressed,
    CallbackGuiSliderValue,
    CallbackGuiTabSelected,
}
impl From<Lcd128x64BrickletFunction> for u8 {
    fn from(fun: Lcd128x64BrickletFunction) -> Self {
        match fun {
            Lcd128x64BrickletFunction::WritePixelsLowLevel => 1,
            Lcd128x64BrickletFunction::ReadPixelsLowLevel => 2,
            Lcd128x64BrickletFunction::ClearDisplay => 3,
            Lcd128x64BrickletFunction::SetDisplayConfiguration => 4,
            Lcd128x64BrickletFunction::GetDisplayConfiguration => 5,
            Lcd128x64BrickletFunction::WriteLine => 6,
            Lcd128x64BrickletFunction::DrawBufferedFrame => 7,
            Lcd128x64BrickletFunction::GetTouchPosition => 8,
            Lcd128x64BrickletFunction::SetTouchPositionCallbackConfiguration => 9,
            Lcd128x64BrickletFunction::GetTouchPositionCallbackConfiguration => 10,
            Lcd128x64BrickletFunction::GetTouchGesture => 12,
            Lcd128x64BrickletFunction::SetTouchGestureCallbackConfiguration => 13,
            Lcd128x64BrickletFunction::GetTouchGestureCallbackConfiguration => 14,
            Lcd128x64BrickletFunction::DrawLine => 16,
            Lcd128x64BrickletFunction::DrawBox => 17,
            Lcd128x64BrickletFunction::DrawText => 18,
            Lcd128x64BrickletFunction::SetGuiButton => 19,
            Lcd128x64BrickletFunction::GetGuiButton => 20,
            Lcd128x64BrickletFunction::RemoveGuiButton => 21,
            Lcd128x64BrickletFunction::SetGuiButtonPressedCallbackConfiguration => 22,
            Lcd128x64BrickletFunction::GetGuiButtonPressedCallbackConfiguration => 23,
            Lcd128x64BrickletFunction::GetGuiButtonPressed => 24,
            Lcd128x64BrickletFunction::SetGuiSlider => 26,
            Lcd128x64BrickletFunction::GetGuiSlider => 27,
            Lcd128x64BrickletFunction::RemoveGuiSlider => 28,
            Lcd128x64BrickletFunction::SetGuiSliderValueCallbackConfiguration => 29,
            Lcd128x64BrickletFunction::GetGuiSliderValueCallbackConfiguration => 30,
            Lcd128x64BrickletFunction::GetGuiSliderValue => 31,
            Lcd128x64BrickletFunction::SetGuiTabConfiguration => 33,
            Lcd128x64BrickletFunction::GetGuiTabConfiguration => 34,
            Lcd128x64BrickletFunction::SetGuiTabText => 35,
            Lcd128x64BrickletFunction::GetGuiTabText => 36,
            Lcd128x64BrickletFunction::SetGuiTabIcon => 37,
            Lcd128x64BrickletFunction::GetGuiTabIcon => 38,
            Lcd128x64BrickletFunction::RemoveGuiTab => 39,
            Lcd128x64BrickletFunction::SetGuiTabSelected => 40,
            Lcd128x64BrickletFunction::SetGuiTabSelectedCallbackConfiguration => 41,
            Lcd128x64BrickletFunction::GetGuiTabSelectedCallbackConfiguration => 42,
            Lcd128x64BrickletFunction::GetGuiTabSelected => 43,
            Lcd128x64BrickletFunction::SetGuiGraphConfiguration => 45,
            Lcd128x64BrickletFunction::GetGuiGraphConfiguration => 46,
            Lcd128x64BrickletFunction::SetGuiGraphDataLowLevel => 47,
            Lcd128x64BrickletFunction::GetGuiGraphDataLowLevel => 48,
            Lcd128x64BrickletFunction::RemoveGuiGraph => 49,
            Lcd128x64BrickletFunction::RemoveAllGui => 50,
            Lcd128x64BrickletFunction::SetTouchLedConfig => 51,
            Lcd128x64BrickletFunction::GetTouchLedConfig => 52,
            Lcd128x64BrickletFunction::GetSpitfpErrorCount => 234,
            Lcd128x64BrickletFunction::SetBootloaderMode => 235,
            Lcd128x64BrickletFunction::GetBootloaderMode => 236,
            Lcd128x64BrickletFunction::SetWriteFirmwarePointer => 237,
            Lcd128x64BrickletFunction::WriteFirmware => 238,
            Lcd128x64BrickletFunction::SetStatusLedConfig => 239,
            Lcd128x64BrickletFunction::GetStatusLedConfig => 240,
            Lcd128x64BrickletFunction::GetChipTemperature => 242,
            Lcd128x64BrickletFunction::Reset => 243,
            Lcd128x64BrickletFunction::WriteUid => 248,
            Lcd128x64BrickletFunction::ReadUid => 249,
            Lcd128x64BrickletFunction::GetIdentity => 255,
            Lcd128x64BrickletFunction::CallbackTouchPosition => 11,
            Lcd128x64BrickletFunction::CallbackTouchGesture => 15,
            Lcd128x64BrickletFunction::CallbackGuiButtonPressed => 25,
            Lcd128x64BrickletFunction::CallbackGuiSliderValue => 32,
            Lcd128x64BrickletFunction::CallbackGuiTabSelected => 44,
        }
    }
}
pub const LCD_128X64_BRICKLET_GESTURE_LEFT_TO_RIGHT: u8 = 0;
pub const LCD_128X64_BRICKLET_GESTURE_RIGHT_TO_LEFT: u8 = 1;
pub const LCD_128X64_BRICKLET_GESTURE_TOP_TO_BOTTOM: u8 = 2;
pub const LCD_128X64_BRICKLET_GESTURE_BOTTOM_TO_TOP: u8 = 3;
pub const LCD_128X64_BRICKLET_COLOR_WHITE: bool = false;
pub const LCD_128X64_BRICKLET_COLOR_BLACK: bool = true;
pub const LCD_128X64_BRICKLET_FONT_6X8: u8 = 0;
pub const LCD_128X64_BRICKLET_FONT_6X16: u8 = 1;
pub const LCD_128X64_BRICKLET_FONT_6X24: u8 = 2;
pub const LCD_128X64_BRICKLET_FONT_6X32: u8 = 3;
pub const LCD_128X64_BRICKLET_FONT_12X16: u8 = 4;
pub const LCD_128X64_BRICKLET_FONT_12X24: u8 = 5;
pub const LCD_128X64_BRICKLET_FONT_12X32: u8 = 6;
pub const LCD_128X64_BRICKLET_FONT_18X24: u8 = 7;
pub const LCD_128X64_BRICKLET_FONT_18X32: u8 = 8;
pub const LCD_128X64_BRICKLET_FONT_24X32: u8 = 9;
pub const LCD_128X64_BRICKLET_DIRECTION_HORIZONTAL: u8 = 0;
pub const LCD_128X64_BRICKLET_DIRECTION_VERTICAL: u8 = 1;
pub const LCD_128X64_BRICKLET_CHANGE_TAB_ON_CLICK: u8 = 1;
pub const LCD_128X64_BRICKLET_CHANGE_TAB_ON_SWIPE: u8 = 2;
pub const LCD_128X64_BRICKLET_CHANGE_TAB_ON_CLICK_AND_SWIPE: u8 = 3;
pub const LCD_128X64_BRICKLET_GRAPH_TYPE_DOT: u8 = 0;
pub const LCD_128X64_BRICKLET_GRAPH_TYPE_LINE: u8 = 1;
pub const LCD_128X64_BRICKLET_GRAPH_TYPE_BAR: u8 = 2;
pub const LCD_128X64_BRICKLET_TOUCH_LED_CONFIG_OFF: u8 = 0;
pub const LCD_128X64_BRICKLET_TOUCH_LED_CONFIG_ON: u8 = 1;
pub const LCD_128X64_BRICKLET_TOUCH_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const LCD_128X64_BRICKLET_TOUCH_LED_CONFIG_SHOW_TOUCH: u8 = 3;
pub const LCD_128X64_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const LCD_128X64_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const LCD_128X64_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const LCD_128X64_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const LCD_128X64_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const LCD_128X64_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const LCD_128X64_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const LCD_128X64_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const LCD_128X64_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const LCD_128X64_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const LCD_128X64_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const LCD_128X64_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const LCD_128X64_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const LCD_128X64_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const LCD_128X64_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WritePixelsLowLevel {}
impl FromByteSlice for WritePixelsLowLevel {
    fn bytes_expected() -> usize { 0 }
    fn from_le_byte_slice(_bytes: &[u8]) -> WritePixelsLowLevel { WritePixelsLowLevel {} }
}
impl LowLevelWrite<WritePixelsResult> for WritePixelsLowLevel {
    fn ll_message_written(&self) -> usize { 448 }

    fn get_result(&self) -> WritePixelsResult { WritePixelsResult {} }
}

#[derive(Clone, Copy)]
pub struct ReadPixelsLowLevel {
    pub pixels_length: u16,
    pub pixels_chunk_offset: u16,
    pub pixels_chunk_data: [bool; 480],
}
impl FromByteSlice for ReadPixelsLowLevel {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReadPixelsLowLevel {
        ReadPixelsLowLevel {
            pixels_length: <u16>::from_le_byte_slice(&bytes[0..2]),
            pixels_chunk_offset: <u16>::from_le_byte_slice(&bytes[2..4]),
            pixels_chunk_data: <[bool; 480]>::from_le_byte_slice(&bytes[4..64]),
        }
    }
}
impl LowLevelRead<bool, ReadPixelsResult> for ReadPixelsLowLevel {
    fn ll_message_length(&self) -> usize { self.pixels_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.pixels_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[bool] { &self.pixels_chunk_data }

    fn get_result(&self) -> ReadPixelsResult { ReadPixelsResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct DisplayConfiguration {
    pub contrast: u8,
    pub backlight: u8,
    pub invert: bool,
    pub automatic_draw: bool,
}
impl FromByteSlice for DisplayConfiguration {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> DisplayConfiguration {
        DisplayConfiguration {
            contrast: <u8>::from_le_byte_slice(&bytes[0..1]),
            backlight: <u8>::from_le_byte_slice(&bytes[1..2]),
            invert: <bool>::from_le_byte_slice(&bytes[2..3]),
            automatic_draw: <bool>::from_le_byte_slice(&bytes[3..4]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct TouchPosition {
    pub pressure: u16,
    pub x: u16,
    pub y: u16,
    pub age: u32,
}
impl FromByteSlice for TouchPosition {
    fn bytes_expected() -> usize { 10 }
    fn from_le_byte_slice(bytes: &[u8]) -> TouchPosition {
        TouchPosition {
            pressure: <u16>::from_le_byte_slice(&bytes[0..2]),
            x: <u16>::from_le_byte_slice(&bytes[2..4]),
            y: <u16>::from_le_byte_slice(&bytes[4..6]),
            age: <u32>::from_le_byte_slice(&bytes[6..10]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct TouchPositionCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for TouchPositionCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> TouchPositionCallbackConfiguration {
        TouchPositionCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct TouchPositionEvent {
    pub pressure: u16,
    pub x: u16,
    pub y: u16,
    pub age: u32,
}
impl FromByteSlice for TouchPositionEvent {
    fn bytes_expected() -> usize { 10 }
    fn from_le_byte_slice(bytes: &[u8]) -> TouchPositionEvent {
        TouchPositionEvent {
            pressure: <u16>::from_le_byte_slice(&bytes[0..2]),
            x: <u16>::from_le_byte_slice(&bytes[2..4]),
            y: <u16>::from_le_byte_slice(&bytes[4..6]),
            age: <u32>::from_le_byte_slice(&bytes[6..10]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct TouchGesture {
    pub gesture: u8,
    pub duration: u32,
    pub pressure_max: u16,
    pub x_start: u16,
    pub y_start: u16,
    pub x_end: u16,
    pub y_end: u16,
    pub age: u32,
}
impl FromByteSlice for TouchGesture {
    fn bytes_expected() -> usize { 19 }
    fn from_le_byte_slice(bytes: &[u8]) -> TouchGesture {
        TouchGesture {
            gesture: <u8>::from_le_byte_slice(&bytes[0..1]),
            duration: <u32>::from_le_byte_slice(&bytes[1..5]),
            pressure_max: <u16>::from_le_byte_slice(&bytes[5..7]),
            x_start: <u16>::from_le_byte_slice(&bytes[7..9]),
            y_start: <u16>::from_le_byte_slice(&bytes[9..11]),
            x_end: <u16>::from_le_byte_slice(&bytes[11..13]),
            y_end: <u16>::from_le_byte_slice(&bytes[13..15]),
            age: <u32>::from_le_byte_slice(&bytes[15..19]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct TouchGestureCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for TouchGestureCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> TouchGestureCallbackConfiguration {
        TouchGestureCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct TouchGestureEvent {
    pub gesture: u8,
    pub duration: u32,
    pub pressure_max: u16,
    pub x_start: u16,
    pub y_start: u16,
    pub x_end: u16,
    pub y_end: u16,
    pub age: u32,
}
impl FromByteSlice for TouchGestureEvent {
    fn bytes_expected() -> usize { 19 }
    fn from_le_byte_slice(bytes: &[u8]) -> TouchGestureEvent {
        TouchGestureEvent {
            gesture: <u8>::from_le_byte_slice(&bytes[0..1]),
            duration: <u32>::from_le_byte_slice(&bytes[1..5]),
            pressure_max: <u16>::from_le_byte_slice(&bytes[5..7]),
            x_start: <u16>::from_le_byte_slice(&bytes[7..9]),
            y_start: <u16>::from_le_byte_slice(&bytes[9..11]),
            x_end: <u16>::from_le_byte_slice(&bytes[11..13]),
            y_end: <u16>::from_le_byte_slice(&bytes[13..15]),
            age: <u32>::from_le_byte_slice(&bytes[15..19]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct GuiButton {
    pub active: bool,
    pub position_x: u8,
    pub position_y: u8,
    pub width: u8,
    pub height: u8,
    pub text: String,
}
impl FromByteSlice for GuiButton {
    fn bytes_expected() -> usize { 21 }
    fn from_le_byte_slice(bytes: &[u8]) -> GuiButton {
        GuiButton {
            active: <bool>::from_le_byte_slice(&bytes[0..1]),
            position_x: <u8>::from_le_byte_slice(&bytes[1..2]),
            position_y: <u8>::from_le_byte_slice(&bytes[2..3]),
            width: <u8>::from_le_byte_slice(&bytes[3..4]),
            height: <u8>::from_le_byte_slice(&bytes[4..5]),
            text: <String>::from_le_byte_slice(&bytes[5..21]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct GuiButtonPressedCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for GuiButtonPressedCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> GuiButtonPressedCallbackConfiguration {
        GuiButtonPressedCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct GuiButtonPressedEvent {
    pub index: u8,
    pub pressed: bool,
}
impl FromByteSlice for GuiButtonPressedEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> GuiButtonPressedEvent {
        GuiButtonPressedEvent { index: <u8>::from_le_byte_slice(&bytes[0..1]), pressed: <bool>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct GuiSlider {
    pub active: bool,
    pub position_x: u8,
    pub position_y: u8,
    pub length: u8,
    pub direction: u8,
    pub value: u8,
}
impl FromByteSlice for GuiSlider {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> GuiSlider {
        GuiSlider {
            active: <bool>::from_le_byte_slice(&bytes[0..1]),
            position_x: <u8>::from_le_byte_slice(&bytes[1..2]),
            position_y: <u8>::from_le_byte_slice(&bytes[2..3]),
            length: <u8>::from_le_byte_slice(&bytes[3..4]),
            direction: <u8>::from_le_byte_slice(&bytes[4..5]),
            value: <u8>::from_le_byte_slice(&bytes[5..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct GuiSliderValueCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for GuiSliderValueCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> GuiSliderValueCallbackConfiguration {
        GuiSliderValueCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct GuiSliderValueEvent {
    pub index: u8,
    pub value: u8,
}
impl FromByteSlice for GuiSliderValueEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> GuiSliderValueEvent {
        GuiSliderValueEvent { index: <u8>::from_le_byte_slice(&bytes[0..1]), value: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct GuiTabConfiguration {
    pub change_tab_config: u8,
    pub clear_gui: bool,
}
impl FromByteSlice for GuiTabConfiguration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> GuiTabConfiguration {
        GuiTabConfiguration {
            change_tab_config: <u8>::from_le_byte_slice(&bytes[0..1]),
            clear_gui: <bool>::from_le_byte_slice(&bytes[1..2]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct GuiTabText {
    pub active: bool,
    pub text: String,
}
impl FromByteSlice for GuiTabText {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> GuiTabText {
        GuiTabText { active: <bool>::from_le_byte_slice(&bytes[0..1]), text: <String>::from_le_byte_slice(&bytes[1..6]) }
    }
}

#[derive(Clone, Copy)]
pub struct GuiTabIcon {
    pub active: bool,
    pub icon: [bool; 168],
}
impl FromByteSlice for GuiTabIcon {
    fn bytes_expected() -> usize { 22 }
    fn from_le_byte_slice(bytes: &[u8]) -> GuiTabIcon {
        GuiTabIcon { active: <bool>::from_le_byte_slice(&bytes[0..1]), icon: <[bool; 168]>::from_le_byte_slice(&bytes[1..22]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct GuiTabSelectedCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for GuiTabSelectedCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> GuiTabSelectedCallbackConfiguration {
        GuiTabSelectedCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct GuiGraphConfiguration {
    pub active: bool,
    pub graph_type: u8,
    pub position_x: u8,
    pub position_y: u8,
    pub width: u8,
    pub height: u8,
    pub text_x: String,
    pub text_y: String,
}
impl FromByteSlice for GuiGraphConfiguration {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> GuiGraphConfiguration {
        GuiGraphConfiguration {
            active: <bool>::from_le_byte_slice(&bytes[0..1]),
            graph_type: <u8>::from_le_byte_slice(&bytes[1..2]),
            position_x: <u8>::from_le_byte_slice(&bytes[2..3]),
            position_y: <u8>::from_le_byte_slice(&bytes[3..4]),
            width: <u8>::from_le_byte_slice(&bytes[4..5]),
            height: <u8>::from_le_byte_slice(&bytes[5..6]),
            text_x: <String>::from_le_byte_slice(&bytes[6..10]),
            text_y: <String>::from_le_byte_slice(&bytes[10..14]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SetGuiGraphDataLowLevel {}
impl FromByteSlice for SetGuiGraphDataLowLevel {
    fn bytes_expected() -> usize { 0 }
    fn from_le_byte_slice(_bytes: &[u8]) -> SetGuiGraphDataLowLevel { SetGuiGraphDataLowLevel {} }
}
impl LowLevelWrite<SetGuiGraphDataResult> for SetGuiGraphDataLowLevel {
    fn ll_message_written(&self) -> usize { 59 }

    fn get_result(&self) -> SetGuiGraphDataResult { SetGuiGraphDataResult {} }
}

#[derive(Clone, Copy)]
pub struct GuiGraphDataLowLevel {
    pub data_length: u16,
    pub data_chunk_offset: u16,
    pub data_chunk_data: [u8; 59],
}
impl FromByteSlice for GuiGraphDataLowLevel {
    fn bytes_expected() -> usize { 63 }
    fn from_le_byte_slice(bytes: &[u8]) -> GuiGraphDataLowLevel {
        GuiGraphDataLowLevel {
            data_length: <u16>::from_le_byte_slice(&bytes[0..2]),
            data_chunk_offset: <u16>::from_le_byte_slice(&bytes[2..4]),
            data_chunk_data: <[u8; 59]>::from_le_byte_slice(&bytes[4..63]),
        }
    }
}
impl LowLevelRead<u8, GuiGraphDataResult> for GuiGraphDataLowLevel {
    fn ll_message_length(&self) -> usize { self.data_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.data_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[u8] { &self.data_chunk_data }

    fn get_result(&self) -> GuiGraphDataResult { GuiGraphDataResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WritePixelsResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReadPixelsResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SetGuiGraphDataResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct GuiGraphDataResult {}

/// 7.1cm (2.8") display with 128x64 pixel and touch screen
#[derive(Clone)]
pub struct Lcd128x64Bricklet {
    device: Device,
}
impl Lcd128x64Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 298;
    pub const DEVICE_DISPLAY_NAME: &'static str = "LCD 128x64 Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> Lcd128x64Bricklet {
        let mut result = Lcd128x64Bricklet { device: Device::new([2, 0, 1], uid, req_sender, 4) };
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::WritePixelsLowLevel) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::ReadPixelsLowLevel) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::ClearDisplay) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::SetDisplayConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetDisplayConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::WriteLine) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::DrawBufferedFrame) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetTouchPosition) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::SetTouchPositionCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetTouchPositionCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetTouchGesture) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::SetTouchGestureCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetTouchGestureCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::DrawLine) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::DrawBox) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::DrawText) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::SetGuiButton) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetGuiButton) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::RemoveGuiButton) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::SetGuiButtonPressedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetGuiButtonPressedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetGuiButtonPressed) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::SetGuiSlider) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetGuiSlider) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::RemoveGuiSlider) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::SetGuiSliderValueCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetGuiSliderValueCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetGuiSliderValue) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::SetGuiTabConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetGuiTabConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::SetGuiTabText) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetGuiTabText) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::SetGuiTabIcon) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetGuiTabIcon) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::RemoveGuiTab) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::SetGuiTabSelected) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::SetGuiTabSelectedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetGuiTabSelectedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetGuiTabSelected) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::SetGuiGraphConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetGuiGraphConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::SetGuiGraphDataLowLevel) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetGuiGraphDataLowLevel) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::RemoveGuiGraph) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::RemoveAllGui) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::SetTouchLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetTouchLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::SetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd128x64BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::lcd_128x64_bricklet::Lcd128x64Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::lcd_128x64_bricklet::Lcd128x64Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: Lcd128x64BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: Lcd128x64BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_touch_position_callback_configuration`]. The parameters are the
    /// same as for [`get_touch_position`].
    ///
    /// [`get_touch_position`]: #method.get_touch_position
    /// [`set_touch_position_callback_configuration`]: #method.set_touch_position_callback_configuration
    pub fn get_touch_position_callback_receiver(&self) -> ConvertingCallbackReceiver<TouchPositionEvent> {
        self.device.get_callback_receiver(u8::from(Lcd128x64BrickletFunction::CallbackTouchPosition))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_touch_gesture_callback_configuration`]. The parameters are the
    /// same as for [`get_touch_gesture`].
    pub fn get_touch_gesture_callback_receiver(&self) -> ConvertingCallbackReceiver<TouchGestureEvent> {
        self.device.get_callback_receiver(u8::from(Lcd128x64BrickletFunction::CallbackTouchGesture))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_gui_button_pressed_callback_configuration`]. The parameters are the
    /// same as for [`get_gui_button_pressed`].
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_gui_button_pressed_callback_receiver(&self) -> ConvertingCallbackReceiver<GuiButtonPressedEvent> {
        self.device.get_callback_receiver(u8::from(Lcd128x64BrickletFunction::CallbackGuiButtonPressed))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_gui_slider_value_callback_configuration`]. The parameters are the
    /// same as for [`get_gui_slider_value`].
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_gui_slider_value_callback_receiver(&self) -> ConvertingCallbackReceiver<GuiSliderValueEvent> {
        self.device.get_callback_receiver(u8::from(Lcd128x64BrickletFunction::CallbackGuiSliderValue))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_gui_tab_selected_callback_configuration`]. The parameters are the
    /// same as for [`get_gui_tab_selected`].
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_gui_tab_selected_callback_receiver(&self) -> ConvertingCallbackReceiver<i8> {
        self.device.get_callback_receiver(u8::from(Lcd128x64BrickletFunction::CallbackGuiTabSelected))
    }

    /// Writes pixels to the specified window.
    ///
    /// The pixels are written into the window line by line top to bottom
    /// and each line is written from left to right.
    ///
    /// If automatic draw is enabled (default) the pixels are directly written to
    /// the screen. Only pixels that have actually changed are updated on the screen,
    /// the rest stays the same.
    ///
    /// If automatic draw is disabled the pixels are written to an internal buffer and
    /// the buffer is transferred to the display only after [`draw_buffered_frame`]
    /// is called. This can be used to avoid flicker when drawing a complex frame in
    /// multiple steps.
    ///
    /// Automatic draw can be configured with the [`set_display_configuration`]
    /// function.
    pub fn write_pixels_low_level(
        &self,
        x_start: u8,
        y_start: u8,
        x_end: u8,
        y_end: u8,
        pixels_length: u16,
        pixels_chunk_offset: u16,
        pixels_chunk_data: [bool; 448],
    ) -> ConvertingReceiver<WritePixelsLowLevel> {
        let mut payload = vec![0; 64];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(x_start));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(y_start));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(x_end));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(y_end));
        payload[4..6].copy_from_slice(&<u16>::to_le_byte_vec(pixels_length));
        payload[6..8].copy_from_slice(&<u16>::to_le_byte_vec(pixels_chunk_offset));
        payload[8..64].copy_from_slice(&<[bool; 448]>::to_le_byte_vec(pixels_chunk_data));

        self.device.set(u8::from(Lcd128x64BrickletFunction::WritePixelsLowLevel), payload)
    }

    /// Writes pixels to the specified window.
    ///
    /// The pixels are written into the window line by line top to bottom
    /// and each line is written from left to right.
    ///
    /// If automatic draw is enabled (default) the pixels are directly written to
    /// the screen. Only pixels that have actually changed are updated on the screen,
    /// the rest stays the same.
    ///
    /// If automatic draw is disabled the pixels are written to an internal buffer and
    /// the buffer is transferred to the display only after [`draw_buffered_frame`]
    /// is called. This can be used to avoid flicker when drawing a complex frame in
    /// multiple steps.
    ///
    /// Automatic draw can be configured with the [`set_display_configuration`]
    /// function.
    pub fn write_pixels(&self, x_start: u8, y_start: u8, x_end: u8, y_end: u8, pixels: &[bool]) -> Result<(), BrickletRecvTimeoutError> {
        let _ll_result = self.device.set_high_level(0, pixels, 65535, 448, &mut |length: usize, chunk_offset: usize, chunk: &[bool]| {
            let chunk_length = chunk.len() as u16;
            let mut chunk_array = [<bool>::default(); 448];
            chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

            let result =
                self.write_pixels_low_level(x_start, y_start, x_end, y_end, length as u16, chunk_offset as u16, chunk_array).recv();
            if let Err(BrickletRecvTimeoutError::SuccessButResponseExpectedIsDisabled) = result {
                Ok(Default::default())
            } else {
                result
            }
        })?;
        Ok(())
    }

    /// Reads pixels from the specified window.
    ///
    /// The pixels are read from the window line by line top to bottom
    /// and each line is read from left to right.
    ///
    /// If automatic draw is enabled (default) the pixels that are read are always the
    /// same that are shown on the display.
    ///
    /// If automatic draw is disabled the pixels are read from the internal buffer
    /// (see [`draw_buffered_frame`]).
    ///
    /// Automatic draw can be configured with the [`set_display_configuration`]
    /// function.
    pub fn read_pixels_low_level(&self, x_start: u8, y_start: u8, x_end: u8, y_end: u8) -> ConvertingReceiver<ReadPixelsLowLevel> {
        let mut payload = vec![0; 4];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(x_start));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(y_start));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(x_end));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(y_end));

        self.device.get(u8::from(Lcd128x64BrickletFunction::ReadPixelsLowLevel), payload)
    }

    /// Reads pixels from the specified window.
    ///
    /// The pixels are read from the window line by line top to bottom
    /// and each line is read from left to right.
    ///
    /// If automatic draw is enabled (default) the pixels that are read are always the
    /// same that are shown on the display.
    ///
    /// If automatic draw is disabled the pixels are read from the internal buffer
    /// (see [`draw_buffered_frame`]).
    ///
    /// Automatic draw can be configured with the [`set_display_configuration`]
    /// function.
    pub fn read_pixels(&self, x_start: u8, y_start: u8, x_end: u8, y_end: u8) -> Result<Vec<bool>, BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(1, &mut || self.read_pixels_low_level(x_start, y_start, x_end, y_end).recv())?;
        Ok(ll_result.0)
    }

    /// Clears the complete content of the display.
    ///
    /// If automatic draw is enabled (default) the pixels are directly cleared.
    ///
    /// If automatic draw is disabled the the internal buffer is cleared and
    /// the buffer is transferred to the display only after [`draw_buffered_frame`]
    /// is called. This can be used to avoid flicker when drawing a complex frame in
    /// multiple steps.
    ///
    /// Automatic draw can be configured with the [`set_display_configuration`]
    /// function.
    pub fn clear_display(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Lcd128x64BrickletFunction::ClearDisplay), payload)
    }

    /// Sets the configuration of the display.
    ///
    /// If automatic draw is set to *true*, the display is automatically updated with every
    /// call of [`write_pixels`] and [`write_line`]. If it is set to false, the
    /// changes are written into an internal buffer and only shown on the display after
    /// a call of [`draw_buffered_frame`].
    pub fn set_display_configuration(&self, contrast: u8, backlight: u8, invert: bool, automatic_draw: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(contrast));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(backlight));
        payload[2..3].copy_from_slice(&<bool>::to_le_byte_vec(invert));
        payload[3..4].copy_from_slice(&<bool>::to_le_byte_vec(automatic_draw));

        self.device.set(u8::from(Lcd128x64BrickletFunction::SetDisplayConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_display_configuration`].
    pub fn get_display_configuration(&self) -> ConvertingReceiver<DisplayConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetDisplayConfiguration), payload)
    }

    /// Writes text to a specific line with a specific position.
    ///
    /// For example: (1, 10, Hello) will write *Hello* in the middle of the
    /// second line of the display.
    ///
    /// The display uses a special 5x7 pixel charset. You can view the characters
    /// of the charset in Brick Viewer.
    ///
    /// If automatic draw is enabled (default) the text is directly written to
    /// the screen. Only pixels that have actually changed are updated on the screen,
    /// the rest stays the same.
    ///
    /// If automatic draw is disabled the text is written to an internal buffer and
    /// the buffer is transferred to the display only after [`draw_buffered_frame`]
    /// is called. This can be used to avoid flicker when drawing a complex frame in
    /// multiple steps.
    ///
    /// Automatic draw can be configured with the [`set_display_configuration`]
    /// function.
    ///
    /// This function is a 1:1 replacement for the function with the same name
    /// in the LCD 20x4 Bricklet. You can draw text at a specific pixel position
    /// and with different font sizes with the [`draw_text`] function.
    pub fn write_line(&self, line: u8, position: u8, text: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 24];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(line));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(position));
        match <String>::try_to_le_byte_vec(text, 22) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[2..24].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(Lcd128x64BrickletFunction::WriteLine), payload)
    }

    /// Draws the currently buffered frame. Normally each call of [`write_pixels`] and
    /// [`write_line`] draws directly onto the display. If you turn automatic draw off
    /// ([`set_display_configuration`]), the data is written in an internal buffer and
    /// only transferred to the display by calling this function. This can be used to
    /// avoid flicker when drawing a complex frame in multiple steps.
    ///
    /// Set the `force complete redraw` to *true* to redraw the whole display
    /// instead of only the changed parts. Normally it should not be necessary to set this to
    /// *true*. It may only become necessary in case of stuck pixels because of errors.
    pub fn draw_buffered_frame(&self, force_complete_redraw: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(force_complete_redraw));

        self.device.set(u8::from(Lcd128x64BrickletFunction::DrawBufferedFrame), payload)
    }

    /// Returns the last valid touch position:
    ///
    /// * Pressure: Amount of pressure applied by the user
    /// * X: Touch position on x-axis
    /// * Y: Touch position on y-axis
    /// * Age: Age of touch press (how long ago it was)
    pub fn get_touch_position(&self) -> ConvertingReceiver<TouchPosition> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetTouchPosition), payload)
    }

    /// The period is the period with which the [`get_touch_position_callback_receiver`] receiver
    /// is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_touch_position_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(Lcd128x64BrickletFunction::SetTouchPositionCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_touch_position_callback_configuration`].
    pub fn get_touch_position_callback_configuration(&self) -> ConvertingReceiver<TouchPositionCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetTouchPositionCallbackConfiguration), payload)
    }

    /// Returns one of four touch gestures that can be automatically detected by the Bricklet.
    ///
    /// The gestures are swipes from left to right, right to left, top to bottom and bottom to top.
    ///
    /// Additionally to the gestures a vector with a start and end position of the gesture is
    /// provided. You can use this vector do determine a more exact location of the gesture (e.g.
    /// the swipe from top to bottom was on the left or right part of the screen).
    ///
    /// The age parameter corresponds to the age of gesture (how long ago it was).
    ///
    /// Associated constants:
    /// * LCD_128X64_BRICKLET_GESTURE_LEFT_TO_RIGHT
    ///	* LCD_128X64_BRICKLET_GESTURE_RIGHT_TO_LEFT
    ///	* LCD_128X64_BRICKLET_GESTURE_TOP_TO_BOTTOM
    ///	* LCD_128X64_BRICKLET_GESTURE_BOTTOM_TO_TOP
    pub fn get_touch_gesture(&self) -> ConvertingReceiver<TouchGesture> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetTouchGesture), payload)
    }

    /// The period is the period with which the [`get_touch_gesture_callback_receiver`] receiver
    /// is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_touch_gesture_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(Lcd128x64BrickletFunction::SetTouchGestureCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_touch_gesture_callback_configuration`].
    pub fn get_touch_gesture_callback_configuration(&self) -> ConvertingReceiver<TouchGestureCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetTouchGestureCallbackConfiguration), payload)
    }

    /// Draws a white or black line from (x, y)-start to (x, y)-end.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * LCD_128X64_BRICKLET_COLOR_WHITE
    ///	* LCD_128X64_BRICKLET_COLOR_BLACK
    pub fn draw_line(
        &self,
        position_x_start: u8,
        position_y_start: u8,
        position_x_end: u8,
        position_y_end: u8,
        color: bool,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(position_x_start));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(position_y_start));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(position_x_end));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(position_y_end));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(color));

        self.device.set(u8::from(Lcd128x64BrickletFunction::DrawLine), payload)
    }

    /// Draws a white or black box from (x, y)-start to (x, y)-end.
    ///
    /// If you set fill to true, the box will be filled with the
    /// color. Otherwise only the outline will be drawn.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * LCD_128X64_BRICKLET_COLOR_WHITE
    ///	* LCD_128X64_BRICKLET_COLOR_BLACK
    pub fn draw_box(
        &self,
        position_x_start: u8,
        position_y_start: u8,
        position_x_end: u8,
        position_y_end: u8,
        fill: bool,
        color: bool,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(position_x_start));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(position_y_start));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(position_x_end));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(position_y_end));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(fill));
        payload[5..6].copy_from_slice(&<bool>::to_le_byte_vec(color));

        self.device.set(u8::from(Lcd128x64BrickletFunction::DrawBox), payload)
    }

    /// Draws a text at the pixel position (x, y).
    ///
    /// You can use one of 9 different font sizes and draw the text in white or black.
    ///
    /// The font conforms to code page 437.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * LCD_128X64_BRICKLET_FONT_6X8
    ///	* LCD_128X64_BRICKLET_FONT_6X16
    ///	* LCD_128X64_BRICKLET_FONT_6X24
    ///	* LCD_128X64_BRICKLET_FONT_6X32
    ///	* LCD_128X64_BRICKLET_FONT_12X16
    ///	* LCD_128X64_BRICKLET_FONT_12X24
    ///	* LCD_128X64_BRICKLET_FONT_12X32
    ///	* LCD_128X64_BRICKLET_FONT_18X24
    ///	* LCD_128X64_BRICKLET_FONT_18X32
    ///	* LCD_128X64_BRICKLET_FONT_24X32
    ///	* LCD_128X64_BRICKLET_COLOR_WHITE
    ///	* LCD_128X64_BRICKLET_COLOR_BLACK
    pub fn draw_text(&self, position_x: u8, position_y: u8, font: u8, color: bool, text: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 26];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(position_x));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(position_y));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(font));
        payload[3..4].copy_from_slice(&<bool>::to_le_byte_vec(color));
        match <String>::try_to_le_byte_vec(text, 22) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[4..26].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(Lcd128x64BrickletFunction::DrawText), payload)
    }

    /// Draws a clickable button at position (x, y) with the given text.
    ///
    /// You can use up to 12 buttons.
    ///
    /// The x position + width has to be within the range of 1 to 128 and the y
    /// position + height has to be within the range of 1 to 64.
    ///
    /// The minimum useful width/height of a button is 3.
    ///
    /// You can enable a receiver for a button press with
    /// [`set_gui_button_pressed_callback_configuration`]. The receiver will
    /// be triggered for press and release-events.
    ///
    /// The button is drawn in a separate GUI buffer and the button-frame will
    /// always stay on top of the graphics drawn with [`write_pixels`]. To
    /// remove the button use [`remove_gui_button`].
    ///
    /// If you want an icon instead of text, you can draw the icon inside of the
    /// button with [`write_pixels`].
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn set_gui_button(&self, index: u8, position_x: u8, position_y: u8, width: u8, height: u8, text: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 21];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(position_x));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(position_y));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(width));
        payload[4..5].copy_from_slice(&<u8>::to_le_byte_vec(height));
        match <String>::try_to_le_byte_vec(text, 16) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[5..21].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(Lcd128x64BrickletFunction::SetGuiButton), payload)
    }

    /// Returns the button properties for a given `Index` as set by [`set_gui_button`].
    ///
    /// Additionally the `Active` parameter shows if a button is currently active/visible
    /// or not.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_gui_button(&self, index: u8) -> ConvertingReceiver<GuiButton> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetGuiButton), payload)
    }

    /// Removes the button with the given index.
    ///
    /// You can use index 255 to remove all buttons.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn remove_gui_button(&self, index: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));

        self.device.set(u8::from(Lcd128x64BrickletFunction::RemoveGuiButton), payload)
    }

    /// The period is the period with which the [`get_gui_button_pressed_callback_receiver`] receiver
    /// is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn set_gui_button_pressed_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(Lcd128x64BrickletFunction::SetGuiButtonPressedCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_gui_button_pressed_callback_configuration`].
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_gui_button_pressed_callback_configuration(&self) -> ConvertingReceiver<GuiButtonPressedCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetGuiButtonPressedCallbackConfiguration), payload)
    }

    /// Returns the state of the button for the given index.
    ///
    /// The state can either be pressed (true) or released (false).
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_gui_button_pressed(&self, index: u8) -> ConvertingReceiver<bool> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetGuiButtonPressed), payload)
    }

    /// Draws a slider at position (x, y) with the given length.
    ///
    /// You can use up to 6 sliders.
    ///
    /// If you use the horizontal direction, the x position + length has to be
    /// within the range of 1 to 128 and the y position has to be within
    /// the range of 0 to 46.
    ///
    /// If you use the vertical direction, the y position + length has to be
    /// within the range of 1 to 64 and the x position has to be within
    /// the range of 0 to 110.
    ///
    /// The minimum length of a slider is 8.
    ///
    /// The parameter value is the start-position of the slider, it can
    /// be between 0 and length-8.
    ///
    /// You can enable a receiver for the slider value with
    /// [`set_gui_slider_value_callback_configuration`].
    ///
    /// The slider is drawn in a separate GUI buffer and it will
    /// always stay on top of the graphics drawn with [`write_pixels`]. To
    /// remove the button use [`remove_gui_slider`].
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * LCD_128X64_BRICKLET_DIRECTION_HORIZONTAL
    ///	* LCD_128X64_BRICKLET_DIRECTION_VERTICAL
    pub fn set_gui_slider(
        &self,
        index: u8,
        position_x: u8,
        position_y: u8,
        length: u8,
        direction: u8,
        value: u8,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(position_x));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(position_y));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(length));
        payload[4..5].copy_from_slice(&<u8>::to_le_byte_vec(direction));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(value));

        self.device.set(u8::from(Lcd128x64BrickletFunction::SetGuiSlider), payload)
    }

    /// Returns the slider properties for a given `Index` as set by [`set_gui_slider`].
    ///
    /// Additionally the `Active` parameter shows if a button is currently active/visible
    /// or not.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * LCD_128X64_BRICKLET_DIRECTION_HORIZONTAL
    ///	* LCD_128X64_BRICKLET_DIRECTION_VERTICAL
    pub fn get_gui_slider(&self, index: u8) -> ConvertingReceiver<GuiSlider> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetGuiSlider), payload)
    }

    /// Removes the slider with the given index.
    ///
    /// You can use index 255 to remove all slider.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn remove_gui_slider(&self, index: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));

        self.device.set(u8::from(Lcd128x64BrickletFunction::RemoveGuiSlider), payload)
    }

    /// The period is the period with which the [`get_gui_slider_value_callback_receiver`] receiver
    /// is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn set_gui_slider_value_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(Lcd128x64BrickletFunction::SetGuiSliderValueCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_gui_slider_value_callback_configuration`].
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_gui_slider_value_callback_configuration(&self) -> ConvertingReceiver<GuiSliderValueCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetGuiSliderValueCallbackConfiguration), payload)
    }

    /// Returns the current slider value for the given index.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_gui_slider_value(&self, index: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetGuiSliderValue), payload)
    }

    /// Sets the general configuration for tabs. You can configure the tabs to only
    /// accept clicks or only swipes (gesture left/right and right/left) or both.
    ///
    /// Additionally, if you set `Clear GUI` to true, all of the GUI elements (buttons,
    /// slider, graphs) will automatically be removed on every tab change.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * LCD_128X64_BRICKLET_CHANGE_TAB_ON_CLICK
    ///	* LCD_128X64_BRICKLET_CHANGE_TAB_ON_SWIPE
    ///	* LCD_128X64_BRICKLET_CHANGE_TAB_ON_CLICK_AND_SWIPE
    pub fn set_gui_tab_configuration(&self, change_tab_config: u8, clear_gui: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(change_tab_config));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(clear_gui));

        self.device.set(u8::from(Lcd128x64BrickletFunction::SetGuiTabConfiguration), payload)
    }

    /// Returns the tab configuration as set by [`set_gui_tab_configuration`].
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * LCD_128X64_BRICKLET_CHANGE_TAB_ON_CLICK
    ///	* LCD_128X64_BRICKLET_CHANGE_TAB_ON_SWIPE
    ///	* LCD_128X64_BRICKLET_CHANGE_TAB_ON_CLICK_AND_SWIPE
    pub fn get_gui_tab_configuration(&self) -> ConvertingReceiver<GuiTabConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetGuiTabConfiguration), payload)
    }

    /// Adds a text-tab with the given index.
    ///
    /// You can use up to 10 tabs.
    ///
    /// A text-tab with the same index as a icon-tab will overwrite the icon-tab.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn set_gui_tab_text(&self, index: u8, text: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));
        match <String>::try_to_le_byte_vec(text, 5) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[1..6].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(Lcd128x64BrickletFunction::SetGuiTabText), payload)
    }

    /// Returns the text for a given index as set by [`set_gui_tab_text`].
    ///
    /// Additionally the `Active` parameter shows if the tab is currently active/visible
    /// or not.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_gui_tab_text(&self, index: u8) -> ConvertingReceiver<GuiTabText> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetGuiTabText), payload)
    }

    /// Adds a icon-tab with the given index. The icon can have a width of 28 pixels
    /// with a height of 6 pixels. It is drawn line-by-line from left to right.
    ///
    /// You can use up to 10 tabs.
    ///
    /// A icon-tab with the same index as a text-tab will overwrite the text-tab.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn set_gui_tab_icon(&self, index: u8, icon: [bool; 168]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 22];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));
        payload[1..22].copy_from_slice(&<[bool; 168]>::to_le_byte_vec(icon));

        self.device.set(u8::from(Lcd128x64BrickletFunction::SetGuiTabIcon), payload)
    }

    /// Returns the icon for a given index as set by [`set_gui_tab_icon`].
    ///
    /// Additionally the `Active` parameter shows if the tab is currently active/visible
    /// or not.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_gui_tab_icon(&self, index: u8) -> ConvertingReceiver<GuiTabIcon> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetGuiTabIcon), payload)
    }

    /// Removes the tab with the given index.
    ///
    /// You can use index 255 to remove all tabs.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn remove_gui_tab(&self, index: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));

        self.device.set(u8::from(Lcd128x64BrickletFunction::RemoveGuiTab), payload)
    }

    /// Sets the tab with the given index as selected (drawn as selected on the display).
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn set_gui_tab_selected(&self, index: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));

        self.device.set(u8::from(Lcd128x64BrickletFunction::SetGuiTabSelected), payload)
    }

    /// The period is the period with which the [`get_gui_tab_selected_callback_receiver`] receiver
    /// is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn set_gui_tab_selected_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(Lcd128x64BrickletFunction::SetGuiTabSelectedCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_gui_tab_selected_callback_configuration`].
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_gui_tab_selected_callback_configuration(&self) -> ConvertingReceiver<GuiTabSelectedCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetGuiTabSelectedCallbackConfiguration), payload)
    }

    /// Returns the index of the currently selected tab.
    /// If there are not tabs, the returned index is -1.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_gui_tab_selected(&self) -> ConvertingReceiver<i8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetGuiTabSelected), payload)
    }

    /// Sets the configuration for up to four graphs.
    ///
    /// The graph type can be dot-, line- or bar-graph.
    ///
    /// The x and y position are pixel positions.
    ///
    /// You can add a text for the x and y axis.
    /// The text is drawn at the inside of the graph and it can overwrite some
    /// of the graph data. If you need the text outside of the graph you can
    /// leave this text here empty and use [`draw_text`] to draw the caption
    /// outside of the graph.
    ///
    /// The data of the graph can be set and updated with [`set_gui_graph_data`].
    ///
    /// The graph is drawn in a separate GUI buffer and the graph-frame and data will
    /// always stay on top of the graphics drawn with [`write_pixels`]. To
    /// remove the graph use [`remove_gui_graph`].
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * LCD_128X64_BRICKLET_GRAPH_TYPE_DOT
    ///	* LCD_128X64_BRICKLET_GRAPH_TYPE_LINE
    ///	* LCD_128X64_BRICKLET_GRAPH_TYPE_BAR
    pub fn set_gui_graph_configuration(
        &self,
        index: u8,
        graph_type: u8,
        position_x: u8,
        position_y: u8,
        width: u8,
        height: u8,
        text_x: String,
        text_y: String,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 14];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(graph_type));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(position_x));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(position_y));
        payload[4..5].copy_from_slice(&<u8>::to_le_byte_vec(width));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(height));
        match <String>::try_to_le_byte_vec(text_x, 4) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[6..10].copy_from_slice(&bytes),
        }

        match <String>::try_to_le_byte_vec(text_y, 4) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[10..14].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(Lcd128x64BrickletFunction::SetGuiGraphConfiguration), payload)
    }

    /// Returns the graph properties for a given `Index` as set by [`set_gui_graph_configuration`].
    ///
    /// Additionally the `Active` parameter shows if a graph is currently active/visible
    /// or not.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * LCD_128X64_BRICKLET_GRAPH_TYPE_DOT
    ///	* LCD_128X64_BRICKLET_GRAPH_TYPE_LINE
    ///	* LCD_128X64_BRICKLET_GRAPH_TYPE_BAR
    pub fn get_gui_graph_configuration(&self, index: u8) -> ConvertingReceiver<GuiGraphConfiguration> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetGuiGraphConfiguration), payload)
    }

    /// Sets the data for a graph with the given index. You have to configure the graph with
    /// [`set_gui_graph_configuration`] before you can set the first data.
    ///
    /// The graph will show the first n values of the data that you set, where
    /// n is the width set with [`set_gui_graph_configuration`]. If you set
    /// less then n values it will show the rest of the values as zero.
    ///
    /// The maximum number of data-points you can set is 118 (which also corresponds to the
    /// maximum width of the graph).
    ///
    /// You have to scale your values to be between 0 and 255. 0 will be shown
    /// at the bottom of the graph and 255 at the top.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn set_gui_graph_data_low_level(
        &self,
        index: u8,
        data_length: u16,
        data_chunk_offset: u16,
        data_chunk_data: [u8; 59],
    ) -> ConvertingReceiver<SetGuiGraphDataLowLevel> {
        let mut payload = vec![0; 64];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(data_length));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(data_chunk_offset));
        payload[5..64].copy_from_slice(&<[u8; 59]>::to_le_byte_vec(data_chunk_data));

        self.device.set(u8::from(Lcd128x64BrickletFunction::SetGuiGraphDataLowLevel), payload)
    }

    /// Sets the data for a graph with the given index. You have to configure the graph with
    /// [`set_gui_graph_configuration`] before you can set the first data.
    ///
    /// The graph will show the first n values of the data that you set, where
    /// n is the width set with [`set_gui_graph_configuration`]. If you set
    /// less then n values it will show the rest of the values as zero.
    ///
    /// The maximum number of data-points you can set is 118 (which also corresponds to the
    /// maximum width of the graph).
    ///
    /// You have to scale your values to be between 0 and 255. 0 will be shown
    /// at the bottom of the graph and 255 at the top.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn set_gui_graph_data(&self, index: u8, data: &[u8]) -> Result<(), BrickletRecvTimeoutError> {
        let _ll_result = self.device.set_high_level(2, data, 65535, 59, &mut |length: usize, chunk_offset: usize, chunk: &[u8]| {
            let chunk_length = chunk.len() as u16;
            let mut chunk_array = [<u8>::default(); 59];
            chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

            let result = self.set_gui_graph_data_low_level(index, length as u16, chunk_offset as u16, chunk_array).recv();
            if let Err(BrickletRecvTimeoutError::SuccessButResponseExpectedIsDisabled) = result {
                Ok(Default::default())
            } else {
                result
            }
        })?;
        Ok(())
    }

    /// Returns the graph data for a given index as set by [`set_gui_graph_data`].
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_gui_graph_data_low_level(&self, index: u8) -> ConvertingReceiver<GuiGraphDataLowLevel> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetGuiGraphDataLowLevel), payload)
    }

    /// Returns the graph data for a given index as set by [`set_gui_graph_data`].
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_gui_graph_data(&self, index: u8) -> Result<Vec<u8>, BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(3, &mut || self.get_gui_graph_data_low_level(index).recv())?;
        Ok(ll_result.0)
    }

    /// Removes the graph with the given index.
    ///
    /// You can use index 255 to remove all graphs.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn remove_gui_graph(&self, index: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));

        self.device.set(u8::from(Lcd128x64BrickletFunction::RemoveGuiGraph), payload)
    }

    /// Removes all GUI elements (buttons, slider, graphs, tabs).
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn remove_all_gui(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Lcd128x64BrickletFunction::RemoveAllGui), payload)
    }

    /// Sets the touch LED configuration. By default the LED is on if the
    /// LCD is touched.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is off.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * LCD_128X64_BRICKLET_TOUCH_LED_CONFIG_OFF
    ///	* LCD_128X64_BRICKLET_TOUCH_LED_CONFIG_ON
    ///	* LCD_128X64_BRICKLET_TOUCH_LED_CONFIG_SHOW_HEARTBEAT
    ///	* LCD_128X64_BRICKLET_TOUCH_LED_CONFIG_SHOW_TOUCH
    pub fn set_touch_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(Lcd128x64BrickletFunction::SetTouchLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_touch_led_config`]
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * LCD_128X64_BRICKLET_TOUCH_LED_CONFIG_OFF
    ///	* LCD_128X64_BRICKLET_TOUCH_LED_CONFIG_ON
    ///	* LCD_128X64_BRICKLET_TOUCH_LED_CONFIG_SHOW_HEARTBEAT
    ///	* LCD_128X64_BRICKLET_TOUCH_LED_CONFIG_SHOW_TOUCH
    pub fn get_touch_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetTouchLedConfig), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * LCD_128X64_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* LCD_128X64_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* LCD_128X64_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* LCD_128X64_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* LCD_128X64_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* LCD_128X64_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* LCD_128X64_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* LCD_128X64_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* LCD_128X64_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* LCD_128X64_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* LCD_128X64_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(Lcd128x64BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * LCD_128X64_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* LCD_128X64_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* LCD_128X64_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* LCD_128X64_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* LCD_128X64_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(Lcd128x64BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(Lcd128x64BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * LCD_128X64_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* LCD_128X64_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* LCD_128X64_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* LCD_128X64_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(Lcd128x64BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * LCD_128X64_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* LCD_128X64_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* LCD_128X64_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* LCD_128X64_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Lcd128x64BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(Lcd128x64BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd128x64BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd128x64BrickletFunction::GetIdentity), payload)
    }
}
