/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures distance up to 40m with laser light.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/LaserRangeFinderV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum LaserRangeFinderV2BrickletFunction {
    GetDistance,
    SetDistanceCallbackConfiguration,
    GetDistanceCallbackConfiguration,
    GetVelocity,
    SetVelocityCallbackConfiguration,
    GetVelocityCallbackConfiguration,
    SetEnable,
    GetEnable,
    SetConfiguration,
    GetConfiguration,
    SetMovingAverage,
    GetMovingAverage,
    SetOffsetCalibration,
    GetOffsetCalibration,
    SetDistanceLedConfig,
    GetDistanceLedConfig,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackDistance,
    CallbackVelocity,
}
impl From<LaserRangeFinderV2BrickletFunction> for u8 {
    fn from(fun: LaserRangeFinderV2BrickletFunction) -> Self {
        match fun {
            LaserRangeFinderV2BrickletFunction::GetDistance => 1,
            LaserRangeFinderV2BrickletFunction::SetDistanceCallbackConfiguration => 2,
            LaserRangeFinderV2BrickletFunction::GetDistanceCallbackConfiguration => 3,
            LaserRangeFinderV2BrickletFunction::GetVelocity => 5,
            LaserRangeFinderV2BrickletFunction::SetVelocityCallbackConfiguration => 6,
            LaserRangeFinderV2BrickletFunction::GetVelocityCallbackConfiguration => 7,
            LaserRangeFinderV2BrickletFunction::SetEnable => 9,
            LaserRangeFinderV2BrickletFunction::GetEnable => 10,
            LaserRangeFinderV2BrickletFunction::SetConfiguration => 11,
            LaserRangeFinderV2BrickletFunction::GetConfiguration => 12,
            LaserRangeFinderV2BrickletFunction::SetMovingAverage => 13,
            LaserRangeFinderV2BrickletFunction::GetMovingAverage => 14,
            LaserRangeFinderV2BrickletFunction::SetOffsetCalibration => 15,
            LaserRangeFinderV2BrickletFunction::GetOffsetCalibration => 16,
            LaserRangeFinderV2BrickletFunction::SetDistanceLedConfig => 17,
            LaserRangeFinderV2BrickletFunction::GetDistanceLedConfig => 18,
            LaserRangeFinderV2BrickletFunction::GetSpitfpErrorCount => 234,
            LaserRangeFinderV2BrickletFunction::SetBootloaderMode => 235,
            LaserRangeFinderV2BrickletFunction::GetBootloaderMode => 236,
            LaserRangeFinderV2BrickletFunction::SetWriteFirmwarePointer => 237,
            LaserRangeFinderV2BrickletFunction::WriteFirmware => 238,
            LaserRangeFinderV2BrickletFunction::SetStatusLedConfig => 239,
            LaserRangeFinderV2BrickletFunction::GetStatusLedConfig => 240,
            LaserRangeFinderV2BrickletFunction::GetChipTemperature => 242,
            LaserRangeFinderV2BrickletFunction::Reset => 243,
            LaserRangeFinderV2BrickletFunction::WriteUid => 248,
            LaserRangeFinderV2BrickletFunction::ReadUid => 249,
            LaserRangeFinderV2BrickletFunction::GetIdentity => 255,
            LaserRangeFinderV2BrickletFunction::CallbackDistance => 4,
            LaserRangeFinderV2BrickletFunction::CallbackVelocity => 8,
        }
    }
}
pub const LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const LASER_RANGE_FINDER_V2_BRICKLET_DISTANCE_LED_CONFIG_OFF: u8 = 0;
pub const LASER_RANGE_FINDER_V2_BRICKLET_DISTANCE_LED_CONFIG_ON: u8 = 1;
pub const LASER_RANGE_FINDER_V2_BRICKLET_DISTANCE_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const LASER_RANGE_FINDER_V2_BRICKLET_DISTANCE_LED_CONFIG_SHOW_DISTANCE: u8 = 3;
pub const LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const LASER_RANGE_FINDER_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const LASER_RANGE_FINDER_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const LASER_RANGE_FINDER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const LASER_RANGE_FINDER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct DistanceCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: i16,
    pub max: i16,
}
impl FromByteSlice for DistanceCallbackConfiguration {
    fn bytes_expected() -> usize { 10 }
    fn from_le_byte_slice(bytes: &[u8]) -> DistanceCallbackConfiguration {
        DistanceCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <i16>::from_le_byte_slice(&bytes[6..8]),
            max: <i16>::from_le_byte_slice(&bytes[8..10]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct VelocityCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: i16,
    pub max: i16,
}
impl FromByteSlice for VelocityCallbackConfiguration {
    fn bytes_expected() -> usize { 10 }
    fn from_le_byte_slice(bytes: &[u8]) -> VelocityCallbackConfiguration {
        VelocityCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <i16>::from_le_byte_slice(&bytes[6..8]),
            max: <i16>::from_le_byte_slice(&bytes[8..10]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub acquisition_count: u8,
    pub enable_quick_termination: bool,
    pub threshold_value: u8,
    pub measurement_frequency: u16,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration {
            acquisition_count: <u8>::from_le_byte_slice(&bytes[0..1]),
            enable_quick_termination: <bool>::from_le_byte_slice(&bytes[1..2]),
            threshold_value: <u8>::from_le_byte_slice(&bytes[2..3]),
            measurement_frequency: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MovingAverage {
    pub distance_average_length: u8,
    pub velocity_average_length: u8,
}
impl FromByteSlice for MovingAverage {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> MovingAverage {
        MovingAverage {
            distance_average_length: <u8>::from_le_byte_slice(&bytes[0..1]),
            velocity_average_length: <u8>::from_le_byte_slice(&bytes[1..2]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures distance up to 40m with laser light
#[derive(Clone)]
pub struct LaserRangeFinderV2Bricklet {
    device: Device,
}
impl LaserRangeFinderV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2144;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Laser Range Finder Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> LaserRangeFinderV2Bricklet {
        let mut result = LaserRangeFinderV2Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::GetDistance) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::SetDistanceCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::GetDistanceCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::GetVelocity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::SetVelocityCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::GetVelocityCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::SetEnable) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::GetEnable) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::SetConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::GetConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::SetMovingAverage) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::GetMovingAverage) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::SetOffsetCalibration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::GetOffsetCalibration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::SetDistanceLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::GetDistanceLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderV2BrickletFunction::GetIdentity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::laser_range_finder_v2_bricklet::LaserRangeFinderV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::laser_range_finder_v2_bricklet::LaserRangeFinderV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: LaserRangeFinderV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: LaserRangeFinderV2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_distance_callback_configuration`].
    ///
    /// The parameter is the same as [`get_distance`].
    ///
    /// [`get_distance`]: #method.get_distance
    /// [`set_distance_callback_configuration`]: #method.set_distance_callback_configuration
    pub fn get_distance_callback_receiver(&self) -> ConvertingCallbackReceiver<i16> {
        self.device.get_callback_receiver(u8::from(LaserRangeFinderV2BrickletFunction::CallbackDistance))
    }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_velocity_callback_configuration`].
    ///
    /// The parameter is the same as [`get_velocity`].
    pub fn get_velocity_callback_receiver(&self) -> ConvertingCallbackReceiver<i16> {
        self.device.get_callback_receiver(u8::from(LaserRangeFinderV2BrickletFunction::CallbackVelocity))
    }

    /// Returns the measured distance.
    ///
    /// The laser has to be enabled, see [`set_enable`].
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_distance_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_distance_callback_configuration`].
    pub fn get_distance(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderV2BrickletFunction::GetDistance), payload)
    }

    /// The period is the period with which the [`get_distance_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_distance_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_distance_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: i16,
        max: i16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 10];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..8].copy_from_slice(&<i16>::to_le_byte_vec(min));
        payload[8..10].copy_from_slice(&<i16>::to_le_byte_vec(max));

        self.device.set(u8::from(LaserRangeFinderV2BrickletFunction::SetDistanceCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_distance_callback_configuration`].
    ///
    /// Associated constants:
    /// * LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_distance_callback_configuration(&self) -> ConvertingReceiver<DistanceCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderV2BrickletFunction::GetDistanceCallbackConfiguration), payload)
    }

    /// Returns the measured velocity. The value has a range of -12800 to 12700
    /// and is given in 1/100 m/s.
    ///
    /// The velocity measurement only produces stables results if a fixed
    /// measurement rate (see [`set_configuration`]) is configured. Also the laser
    /// has to be enabled, see [`set_enable`].
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_velocity_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_velocity_callback_configuration`].
    pub fn get_velocity(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderV2BrickletFunction::GetVelocity), payload)
    }

    /// The period is the period with which the [`get_velocity_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_velocity_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_velocity_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: i16,
        max: i16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 10];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..8].copy_from_slice(&<i16>::to_le_byte_vec(min));
        payload[8..10].copy_from_slice(&<i16>::to_le_byte_vec(max));

        self.device.set(u8::from(LaserRangeFinderV2BrickletFunction::SetVelocityCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_velocity_callback_configuration`].
    ///
    /// Associated constants:
    /// * LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_velocity_callback_configuration(&self) -> ConvertingReceiver<VelocityCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderV2BrickletFunction::GetVelocityCallbackConfiguration), payload)
    }

    /// Enables the laser of the LIDAR if set to *true*.
    ///
    /// We recommend that you wait 250ms after enabling the laser before
    /// the first call of [`get_distance`] to ensure stable measurements.
    pub fn set_enable(&self, enable: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enable));

        self.device.set(u8::from(LaserRangeFinderV2BrickletFunction::SetEnable), payload)
    }

    /// Returns the value as set by [`set_enable`].
    pub fn get_enable(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderV2BrickletFunction::GetEnable), payload)
    }

    /// The **Acquisition Count** defines the number of times the Laser Range Finder Bricklet
    /// will integrate acquisitions to find a correlation record peak. With a higher count,
    /// the Bricklet can measure longer distances. With a lower count, the rate increases. The
    /// allowed values are 1-255.
    ///
    /// If you set **Enable Quick Termination** to true, the distance measurement will be terminated
    /// early if a high peak was already detected. This means that a higher measurement rate can be achieved
    /// and long distances can be measured at the same time. However, the chance of false-positive
    /// distance measurements increases.
    ///
    /// Normally the distance is calculated with a detection algorithm that uses peak value,
    /// signal strength and noise. You can however also define a fixed **Threshold Value**.
    /// Set this to a low value if you want to measure the distance to something that has
    /// very little reflection (e.g. glass) and set it to a high value if you want to measure
    /// the distance to something with a very high reflection (e.g. mirror). Set this to 0 to
    /// use the default algorithm. The other allowed values are 1-255.
    ///
    /// Set the **Measurement Frequency** to force a fixed measurement rate. If set to 0,
    /// the Laser Range Finder Bricklet will use the optimal frequency according to the other
    /// configurations and the actual measured distance. Since the rate is not fixed in this case,
    /// the velocity measurement is not stable. For a stable velocity measurement you should
    /// set a fixed measurement frequency. The lower the frequency, the higher is the resolution
    /// of the calculated velocity. The allowed values are 10Hz-500Hz (and 0 to turn the fixed
    /// frequency off).
    ///
    /// The default values for Acquisition Count, Enable Quick Termination, Threshold Value and
    /// Measurement Frequency are 128, false, 0 and 0.
    pub fn set_configuration(
        &self,
        acquisition_count: u8,
        enable_quick_termination: bool,
        threshold_value: u8,
        measurement_frequency: u16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(acquisition_count));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(enable_quick_termination));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(threshold_value));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(measurement_frequency));

        self.device.set(u8::from(LaserRangeFinderV2BrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderV2BrickletFunction::GetConfiguration), payload)
    }

    /// Sets the length of a [moving averaging](https://en.wikipedia.org/wiki/Moving_average)__
    /// for the distance and velocity.
    ///
    /// Setting the length to 0 will turn the averaging completely off. With less
    /// averaging, there is more noise on the data.
    pub fn set_moving_average(&self, distance_average_length: u8, velocity_average_length: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(distance_average_length));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(velocity_average_length));

        self.device.set(u8::from(LaserRangeFinderV2BrickletFunction::SetMovingAverage), payload)
    }

    /// Returns the length moving average as set by [`set_moving_average`].
    pub fn get_moving_average(&self) -> ConvertingReceiver<MovingAverage> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderV2BrickletFunction::GetMovingAverage), payload)
    }

    /// The offset is added to the measured distance.
    /// It is saved in non-volatile memory, you only have to set it once.
    ///
    /// The Bricklet comes with a per-sensor factory-calibrated offset value,
    /// you should not have to call this function.
    ///
    /// If you want to re-calibrate the offset you first have to set it to 0.
    /// Calculate the offset by measuring the distance to a known distance
    /// and set it again.
    pub fn set_offset_calibration(&self, offset: i16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<i16>::to_le_byte_vec(offset));

        self.device.set(u8::from(LaserRangeFinderV2BrickletFunction::SetOffsetCalibration), payload)
    }

    /// Returns the offset value as set by [`set_offset_calibration`].
    pub fn get_offset_calibration(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderV2BrickletFunction::GetOffsetCalibration), payload)
    }

    /// Configures the distance LED to be either turned off, turned on, blink in
    /// heartbeat mode or show the distance (brighter = object is nearer).
    ///
    /// Associated constants:
    /// * LASER_RANGE_FINDER_V2_BRICKLET_DISTANCE_LED_CONFIG_OFF
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_DISTANCE_LED_CONFIG_ON
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_DISTANCE_LED_CONFIG_SHOW_HEARTBEAT
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_DISTANCE_LED_CONFIG_SHOW_DISTANCE
    pub fn set_distance_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(LaserRangeFinderV2BrickletFunction::SetDistanceLedConfig), payload)
    }

    /// Returns the LED configuration as set by [`set_distance_led_config`]
    ///
    /// Associated constants:
    /// * LASER_RANGE_FINDER_V2_BRICKLET_DISTANCE_LED_CONFIG_OFF
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_DISTANCE_LED_CONFIG_ON
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_DISTANCE_LED_CONFIG_SHOW_HEARTBEAT
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_DISTANCE_LED_CONFIG_SHOW_DISTANCE
    pub fn get_distance_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderV2BrickletFunction::GetDistanceLedConfig), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(LaserRangeFinderV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(LaserRangeFinderV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(LaserRangeFinderV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * LASER_RANGE_FINDER_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(LaserRangeFinderV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * LASER_RANGE_FINDER_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* LASER_RANGE_FINDER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(LaserRangeFinderV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(LaserRangeFinderV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderV2BrickletFunction::GetIdentity), payload)
    }
}
