/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! 2-axis joystick with push-button.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/Joystick_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum JoystickBrickletFunction {
    GetPosition,
    IsPressed,
    GetAnalogValue,
    Calibrate,
    SetPositionCallbackPeriod,
    GetPositionCallbackPeriod,
    SetAnalogValueCallbackPeriod,
    GetAnalogValueCallbackPeriod,
    SetPositionCallbackThreshold,
    GetPositionCallbackThreshold,
    SetAnalogValueCallbackThreshold,
    GetAnalogValueCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    GetIdentity,
    CallbackPosition,
    CallbackAnalogValue,
    CallbackPositionReached,
    CallbackAnalogValueReached,
    CallbackPressed,
    CallbackReleased,
}
impl From<JoystickBrickletFunction> for u8 {
    fn from(fun: JoystickBrickletFunction) -> Self {
        match fun {
            JoystickBrickletFunction::GetPosition => 1,
            JoystickBrickletFunction::IsPressed => 2,
            JoystickBrickletFunction::GetAnalogValue => 3,
            JoystickBrickletFunction::Calibrate => 4,
            JoystickBrickletFunction::SetPositionCallbackPeriod => 5,
            JoystickBrickletFunction::GetPositionCallbackPeriod => 6,
            JoystickBrickletFunction::SetAnalogValueCallbackPeriod => 7,
            JoystickBrickletFunction::GetAnalogValueCallbackPeriod => 8,
            JoystickBrickletFunction::SetPositionCallbackThreshold => 9,
            JoystickBrickletFunction::GetPositionCallbackThreshold => 10,
            JoystickBrickletFunction::SetAnalogValueCallbackThreshold => 11,
            JoystickBrickletFunction::GetAnalogValueCallbackThreshold => 12,
            JoystickBrickletFunction::SetDebouncePeriod => 13,
            JoystickBrickletFunction::GetDebouncePeriod => 14,
            JoystickBrickletFunction::GetIdentity => 255,
            JoystickBrickletFunction::CallbackPosition => 15,
            JoystickBrickletFunction::CallbackAnalogValue => 16,
            JoystickBrickletFunction::CallbackPositionReached => 17,
            JoystickBrickletFunction::CallbackAnalogValueReached => 18,
            JoystickBrickletFunction::CallbackPressed => 19,
            JoystickBrickletFunction::CallbackReleased => 20,
        }
    }
}
pub const JOYSTICK_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const JOYSTICK_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const JOYSTICK_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const JOYSTICK_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const JOYSTICK_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Position {
    pub x: i16,
    pub y: i16,
}
impl FromByteSlice for Position {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> Position {
        Position { x: <i16>::from_le_byte_slice(&bytes[0..2]), y: <i16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AnalogValue {
    pub x: u16,
    pub y: u16,
}
impl FromByteSlice for AnalogValue {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> AnalogValue {
        AnalogValue { x: <u16>::from_le_byte_slice(&bytes[0..2]), y: <u16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct PositionCallbackThreshold {
    pub option: char,
    pub min_x: i16,
    pub max_x: i16,
    pub min_y: i16,
    pub max_y: i16,
}
impl FromByteSlice for PositionCallbackThreshold {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> PositionCallbackThreshold {
        PositionCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min_x: <i16>::from_le_byte_slice(&bytes[1..3]),
            max_x: <i16>::from_le_byte_slice(&bytes[3..5]),
            min_y: <i16>::from_le_byte_slice(&bytes[5..7]),
            max_y: <i16>::from_le_byte_slice(&bytes[7..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AnalogValueCallbackThreshold {
    pub option: char,
    pub min_x: u16,
    pub max_x: u16,
    pub min_y: u16,
    pub max_y: u16,
}
impl FromByteSlice for AnalogValueCallbackThreshold {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> AnalogValueCallbackThreshold {
        AnalogValueCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min_x: <u16>::from_le_byte_slice(&bytes[1..3]),
            max_x: <u16>::from_le_byte_slice(&bytes[3..5]),
            min_y: <u16>::from_le_byte_slice(&bytes[5..7]),
            max_y: <u16>::from_le_byte_slice(&bytes[7..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct PositionEvent {
    pub x: i16,
    pub y: i16,
}
impl FromByteSlice for PositionEvent {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> PositionEvent {
        PositionEvent { x: <i16>::from_le_byte_slice(&bytes[0..2]), y: <i16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AnalogValueEvent {
    pub x: u16,
    pub y: u16,
}
impl FromByteSlice for AnalogValueEvent {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> AnalogValueEvent {
        AnalogValueEvent { x: <u16>::from_le_byte_slice(&bytes[0..2]), y: <u16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct PositionReachedEvent {
    pub x: i16,
    pub y: i16,
}
impl FromByteSlice for PositionReachedEvent {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> PositionReachedEvent {
        PositionReachedEvent { x: <i16>::from_le_byte_slice(&bytes[0..2]), y: <i16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AnalogValueReachedEvent {
    pub x: u16,
    pub y: u16,
}
impl FromByteSlice for AnalogValueReachedEvent {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> AnalogValueReachedEvent {
        AnalogValueReachedEvent { x: <u16>::from_le_byte_slice(&bytes[0..2]), y: <u16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// 2-axis joystick with push-button
#[derive(Clone)]
pub struct JoystickBricklet {
    device: Device,
}
impl JoystickBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 210;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Joystick Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> JoystickBricklet {
        let mut result = JoystickBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(JoystickBrickletFunction::GetPosition) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(JoystickBrickletFunction::IsPressed) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(JoystickBrickletFunction::GetAnalogValue) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(JoystickBrickletFunction::Calibrate) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(JoystickBrickletFunction::SetPositionCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(JoystickBrickletFunction::GetPositionCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(JoystickBrickletFunction::SetAnalogValueCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(JoystickBrickletFunction::GetAnalogValueCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(JoystickBrickletFunction::SetPositionCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(JoystickBrickletFunction::GetPositionCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(JoystickBrickletFunction::SetAnalogValueCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(JoystickBrickletFunction::GetAnalogValueCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(JoystickBrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(JoystickBrickletFunction::GetDebouncePeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(JoystickBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::joystick_bricklet::JoystickBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::joystick_bricklet::JoystickBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: JoystickBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: JoystickBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_position_callback_period`]. The parameter is the position of the
    /// joystick.
    ///
    /// The [`get_position_callback_receiver`] receiver is only triggered if the position has changed since the
    /// last triggering.
    ///
    /// [`set_position_callback_period`]: #method.set_position_callback_period
    /// [`get_position_callback_receiver`]: #method.get_position_callback_receiver
    pub fn get_position_callback_receiver(&self) -> ConvertingCallbackReceiver<PositionEvent> {
        self.device.get_callback_receiver(u8::from(JoystickBrickletFunction::CallbackPosition))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_analog_value_callback_period`]. The parameters are the
    /// analog values of the joystick.
    ///
    /// The [`get_analog_value_callback_receiver`] receiver is only triggered if the values have changed
    /// since the last triggering.
    pub fn get_analog_value_callback_receiver(&self) -> ConvertingCallbackReceiver<AnalogValueEvent> {
        self.device.get_callback_receiver(u8::from(JoystickBrickletFunction::CallbackAnalogValue))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_position_callback_threshold`] is reached.
    /// The parameters are the position of the joystick.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_position_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<PositionReachedEvent> {
        self.device.get_callback_receiver(u8::from(JoystickBrickletFunction::CallbackPositionReached))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_analog_value_callback_threshold`] is reached.
    /// The parameters are the analog values of the joystick.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_analog_value_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<AnalogValueReachedEvent> {
        self.device.get_callback_receiver(u8::from(JoystickBrickletFunction::CallbackAnalogValueReached))
    }

    /// This receiver is triggered when the button is pressed.
    pub fn get_pressed_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(JoystickBrickletFunction::CallbackPressed))
    }

    /// This receiver is triggered when the button is released.
    pub fn get_released_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(JoystickBrickletFunction::CallbackReleased))
    }

    /// Returns the position of the joystick. The middle position of the joystick is x=0, y=0.
    /// The returned values are averaged and calibrated (see [`calibrate`]).
    ///
    /// If you want to get the position periodically, it is recommended to use the
    /// [`get_position_callback_receiver`] receiver and set the period with
    /// [`set_position_callback_period`].
    pub fn get_position(&self) -> ConvertingReceiver<Position> {
        let payload = vec![0; 0];

        self.device.get(u8::from(JoystickBrickletFunction::GetPosition), payload)
    }

    /// Returns *true* if the button is pressed and *false* otherwise.
    ///
    /// It is recommended to use the [`get_pressed_callback_receiver`] and [`get_released_callback_receiver`] receivers
    /// to handle the button.
    pub fn is_pressed(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(JoystickBrickletFunction::IsPressed), payload)
    }

    /// Returns the values as read by a 12-bit analog-to-digital converter.
    ///
    /// # Note
    ///  The values returned by [`get_position`] are averaged over several samples
    ///  to yield less noise, while [`get_analog_value`] gives back raw
    ///  unfiltered analog values. The only reason to use [`get_analog_value`] is,
    ///  if you need the full resolution of the analog-to-digital converter.
    ///
    /// If you want the analog values periodically, it is recommended to use the
    /// [`get_analog_value_callback_receiver`] receiver and set the period with
    /// [`set_analog_value_callback_period`].
    pub fn get_analog_value(&self) -> ConvertingReceiver<AnalogValue> {
        let payload = vec![0; 0];

        self.device.get(u8::from(JoystickBrickletFunction::GetAnalogValue), payload)
    }

    /// Calibrates the middle position of the joystick. If your Joystick Bricklet
    /// does not return x=0 and y=0 in the middle position, call this function
    /// while the joystick is standing still in the middle position.
    ///
    /// The resulting calibration will be saved on the EEPROM of the Joystick
    /// Bricklet, thus you only have to calibrate it once.
    pub fn calibrate(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(JoystickBrickletFunction::Calibrate), payload)
    }

    /// Sets the period with which the [`get_position_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_position_callback_receiver`] receiver is only triggered if the position has changed since the
    /// last triggering.
    pub fn set_position_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(JoystickBrickletFunction::SetPositionCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_position_callback_period`].
    pub fn get_position_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(JoystickBrickletFunction::GetPositionCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_analog_value_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_analog_value_callback_receiver`] receiver is only triggered if the analog values have
    /// changed since the last triggering.
    pub fn set_analog_value_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(JoystickBrickletFunction::SetAnalogValueCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_analog_value_callback_period`].
    pub fn get_analog_value_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(JoystickBrickletFunction::GetAnalogValueCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_position_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the position is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the position is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the position is smaller than the min values (max is ignored)
    ///  '>'|    Receiver is triggered when the position is greater than the min values (max is ignored)
    ///
    /// Associated constants:
    /// * JOYSTICK_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* JOYSTICK_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* JOYSTICK_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* JOYSTICK_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* JOYSTICK_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_position_callback_threshold(&self, option: char, min_x: i16, max_x: i16, min_y: i16, max_y: i16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<i16>::to_le_byte_vec(min_x));
        payload[3..5].copy_from_slice(&<i16>::to_le_byte_vec(max_x));
        payload[5..7].copy_from_slice(&<i16>::to_le_byte_vec(min_y));
        payload[7..9].copy_from_slice(&<i16>::to_le_byte_vec(max_y));

        self.device.set(u8::from(JoystickBrickletFunction::SetPositionCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_position_callback_threshold`].
    ///
    /// Associated constants:
    /// * JOYSTICK_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* JOYSTICK_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* JOYSTICK_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* JOYSTICK_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* JOYSTICK_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_position_callback_threshold(&self) -> ConvertingReceiver<PositionCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(JoystickBrickletFunction::GetPositionCallbackThreshold), payload)
    }

    /// Sets the thresholds for the [`get_analog_value_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the analog values are *outside* the min and max values
    ///  'i'|    Receiver is triggered when the analog values are *inside* the min and max values
    ///  '<'|    Receiver is triggered when the analog values are smaller than the min values (max is ignored)
    ///  '>'|    Receiver is triggered when the analog values are greater than the min values (max is ignored)
    ///
    /// Associated constants:
    /// * JOYSTICK_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* JOYSTICK_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* JOYSTICK_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* JOYSTICK_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* JOYSTICK_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_analog_value_callback_threshold(
        &self,
        option: char,
        min_x: u16,
        max_x: u16,
        min_y: u16,
        max_y: u16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(min_x));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(max_x));
        payload[5..7].copy_from_slice(&<u16>::to_le_byte_vec(min_y));
        payload[7..9].copy_from_slice(&<u16>::to_le_byte_vec(max_y));

        self.device.set(u8::from(JoystickBrickletFunction::SetAnalogValueCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_analog_value_callback_threshold`].
    ///
    /// Associated constants:
    /// * JOYSTICK_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* JOYSTICK_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* JOYSTICK_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* JOYSTICK_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* JOYSTICK_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_analog_value_callback_threshold(&self) -> ConvertingReceiver<AnalogValueCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(JoystickBrickletFunction::GetAnalogValueCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receivers
    ///
    /// * [`get_position_reached_callback_receiver`],
    /// * [`get_analog_value_reached_callback_receiver`]
    ///
    /// are triggered, if the thresholds
    ///
    /// * [`set_position_callback_threshold`],
    /// * [`set_analog_value_callback_threshold`]
    ///
    /// keep being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(JoystickBrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(JoystickBrickletFunction::GetDebouncePeriod), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(JoystickBrickletFunction::GetIdentity), payload)
    }
}
