/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Galvanically isolates any Bricklet from any Brick.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/Isolator_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum IsolatorBrickletFunction {
    GetStatistics,
    SetSpitfpBaudrateConfig,
    GetSpitfpBaudrateConfig,
    SetSpitfpBaudrate,
    GetSpitfpBaudrate,
    GetIsolatorSpitfpErrorCount,
    SetStatisticsCallbackConfiguration,
    GetStatisticsCallbackConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackStatistics,
}
impl From<IsolatorBrickletFunction> for u8 {
    fn from(fun: IsolatorBrickletFunction) -> Self {
        match fun {
            IsolatorBrickletFunction::GetStatistics => 1,
            IsolatorBrickletFunction::SetSpitfpBaudrateConfig => 2,
            IsolatorBrickletFunction::GetSpitfpBaudrateConfig => 3,
            IsolatorBrickletFunction::SetSpitfpBaudrate => 4,
            IsolatorBrickletFunction::GetSpitfpBaudrate => 5,
            IsolatorBrickletFunction::GetIsolatorSpitfpErrorCount => 6,
            IsolatorBrickletFunction::SetStatisticsCallbackConfiguration => 7,
            IsolatorBrickletFunction::GetStatisticsCallbackConfiguration => 8,
            IsolatorBrickletFunction::GetSpitfpErrorCount => 234,
            IsolatorBrickletFunction::SetBootloaderMode => 235,
            IsolatorBrickletFunction::GetBootloaderMode => 236,
            IsolatorBrickletFunction::SetWriteFirmwarePointer => 237,
            IsolatorBrickletFunction::WriteFirmware => 238,
            IsolatorBrickletFunction::SetStatusLedConfig => 239,
            IsolatorBrickletFunction::GetStatusLedConfig => 240,
            IsolatorBrickletFunction::GetChipTemperature => 242,
            IsolatorBrickletFunction::Reset => 243,
            IsolatorBrickletFunction::WriteUid => 248,
            IsolatorBrickletFunction::ReadUid => 249,
            IsolatorBrickletFunction::GetIdentity => 255,
            IsolatorBrickletFunction::CallbackStatistics => 9,
        }
    }
}
pub const ISOLATOR_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const ISOLATOR_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const ISOLATOR_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const ISOLATOR_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const ISOLATOR_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const ISOLATOR_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const ISOLATOR_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const ISOLATOR_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const ISOLATOR_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const ISOLATOR_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const ISOLATOR_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const ISOLATOR_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const ISOLATOR_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const ISOLATOR_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const ISOLATOR_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Statistics {
    pub messages_from_brick: u32,
    pub messages_from_bricklet: u32,
    pub connected_bricklet_device_identifier: u16,
    pub connected_bricklet_uid: String,
}
impl FromByteSlice for Statistics {
    fn bytes_expected() -> usize { 18 }
    fn from_le_byte_slice(bytes: &[u8]) -> Statistics {
        Statistics {
            messages_from_brick: <u32>::from_le_byte_slice(&bytes[0..4]),
            messages_from_bricklet: <u32>::from_le_byte_slice(&bytes[4..8]),
            connected_bricklet_device_identifier: <u16>::from_le_byte_slice(&bytes[8..10]),
            connected_bricklet_uid: <String>::from_le_byte_slice(&bytes[10..18]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpBaudrateConfig {
    pub enable_dynamic_baudrate: bool,
    pub minimum_dynamic_baudrate: u32,
}
impl FromByteSlice for SpitfpBaudrateConfig {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpBaudrateConfig {
        SpitfpBaudrateConfig {
            enable_dynamic_baudrate: <bool>::from_le_byte_slice(&bytes[0..1]),
            minimum_dynamic_baudrate: <u32>::from_le_byte_slice(&bytes[1..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct IsolatorSpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for IsolatorSpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> IsolatorSpitfpErrorCount {
        IsolatorSpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct StatisticsCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for StatisticsCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> StatisticsCallbackConfiguration {
        StatisticsCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct StatisticsEvent {
    pub messages_from_brick: u32,
    pub messages_from_bricklet: u32,
    pub connected_bricklet_device_identifier: u16,
    pub connected_bricklet_uid: String,
}
impl FromByteSlice for StatisticsEvent {
    fn bytes_expected() -> usize { 18 }
    fn from_le_byte_slice(bytes: &[u8]) -> StatisticsEvent {
        StatisticsEvent {
            messages_from_brick: <u32>::from_le_byte_slice(&bytes[0..4]),
            messages_from_bricklet: <u32>::from_le_byte_slice(&bytes[4..8]),
            connected_bricklet_device_identifier: <u16>::from_le_byte_slice(&bytes[8..10]),
            connected_bricklet_uid: <String>::from_le_byte_slice(&bytes[10..18]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Galvanically isolates any Bricklet from any Brick
#[derive(Clone)]
pub struct IsolatorBricklet {
    device: Device,
}
impl IsolatorBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2122;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Isolator Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> IsolatorBricklet {
        let mut result = IsolatorBricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(IsolatorBrickletFunction::GetStatistics) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IsolatorBrickletFunction::SetSpitfpBaudrateConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IsolatorBrickletFunction::GetSpitfpBaudrateConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IsolatorBrickletFunction::SetSpitfpBaudrate) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IsolatorBrickletFunction::GetSpitfpBaudrate) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IsolatorBrickletFunction::GetIsolatorSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IsolatorBrickletFunction::SetStatisticsCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(IsolatorBrickletFunction::GetStatisticsCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IsolatorBrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IsolatorBrickletFunction::SetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IsolatorBrickletFunction::GetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IsolatorBrickletFunction::SetWriteFirmwarePointer) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IsolatorBrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IsolatorBrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IsolatorBrickletFunction::GetStatusLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IsolatorBrickletFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IsolatorBrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IsolatorBrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IsolatorBrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IsolatorBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::isolator_bricklet::IsolatorBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::isolator_bricklet::IsolatorBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: IsolatorBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: IsolatorBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_statistics_callback_configuration`].
    ///
    /// The parameters are the same as [`get_statistics`].
    ///
    /// [`get_statistics`]: #method.get_statistics
    /// [`set_statistics_callback_configuration`]: #method.set_statistics_callback_configuration
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_statistics_callback_receiver(&self) -> ConvertingCallbackReceiver<StatisticsEvent> {
        self.device.get_callback_receiver(u8::from(IsolatorBrickletFunction::CallbackStatistics))
    }

    /// Returns statistics for the Isolator Bricklet.
    pub fn get_statistics(&self) -> ConvertingReceiver<Statistics> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IsolatorBrickletFunction::GetStatistics), payload)
    }

    /// The SPITF protocol can be used with a dynamic baudrate. If the dynamic baudrate is
    /// enabled, the Isolator Bricklet will try to adapt the baudrate for the communication
    /// between Bricks and Bricklets according to the amount of data that is transferred.
    ///
    /// The baudrate for communication config between
    /// Brick and Isolator Bricklet can be set through the API of the Brick.
    ///
    /// The baudrate will be increased exponentially if lots of data is sent/received and
    /// decreased linearly if little data is sent/received.
    ///
    /// This lowers the baudrate in applications where little data is transferred (e.g.
    /// a weather station) and increases the robustness. If there is lots of data to transfer
    /// (e.g. Thermal Imaging Bricklet) it automatically increases the baudrate as needed.
    ///
    /// In cases where some data has to transferred as fast as possible every few seconds
    /// (e.g. RS485 Bricklet with a high baudrate but small payload) you may want to turn
    /// the dynamic baudrate off to get the highest possible performance.
    ///
    /// The maximum value of the baudrate can be set per port with the function
    /// [`set_spitfp_baudrate`]. If the dynamic baudrate is disabled, the baudrate
    /// as set by [`set_spitfp_baudrate`] will be used statically.
    pub fn set_spitfp_baudrate_config(&self, enable_dynamic_baudrate: bool, minimum_dynamic_baudrate: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enable_dynamic_baudrate));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(minimum_dynamic_baudrate));

        self.device.set(u8::from(IsolatorBrickletFunction::SetSpitfpBaudrateConfig), payload)
    }

    /// Returns the baudrate config, see [`set_spitfp_baudrate_config`].
    pub fn get_spitfp_baudrate_config(&self) -> ConvertingReceiver<SpitfpBaudrateConfig> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IsolatorBrickletFunction::GetSpitfpBaudrateConfig), payload)
    }

    /// Sets the baudrate for a the communication between Isolator Bricklet
    /// and the connected Bricklet. The baudrate for communication between
    /// Brick and Isolator Bricklet can be set through the API of the Brick.
    ///
    /// If you want to increase the throughput of Bricklets you can increase
    /// the baudrate. If you get a high error count because of high
    /// interference (see [`get_spitfp_error_count`]) you can decrease the
    /// baudrate.
    ///
    /// If the dynamic baudrate feature is enabled, the baudrate set by this
    /// function corresponds to the maximum baudrate (see [`set_spitfp_baudrate_config`]).
    ///
    /// Regulatory testing is done with the default baudrate. If CE compatibility
    /// or similar is necessary in your applications we recommend to not change
    /// the baudrate.
    pub fn set_spitfp_baudrate(&self, baudrate: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(baudrate));

        self.device.set(u8::from(IsolatorBrickletFunction::SetSpitfpBaudrate), payload)
    }

    /// Returns the baudrate, see [`set_spitfp_baudrate`].
    pub fn get_spitfp_baudrate(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IsolatorBrickletFunction::GetSpitfpBaudrate), payload)
    }

    /// Returns the error count for the communication between Isolator Bricklet and
    /// the connected Bricklet. Call [`get_spitfp_error_count`] to get the
    /// error count between Isolator Bricklet and Brick.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    pub fn get_isolator_spitfp_error_count(&self) -> ConvertingReceiver<IsolatorSpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IsolatorBrickletFunction::GetIsolatorSpitfpErrorCount), payload)
    }

    /// The period is the period with which the [`get_statistics_callback_receiver`]
    /// receiver is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn set_statistics_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(IsolatorBrickletFunction::SetStatisticsCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_statistics_callback_configuration`].
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_statistics_callback_configuration(&self) -> ConvertingReceiver<StatisticsCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IsolatorBrickletFunction::GetStatisticsCallbackConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IsolatorBrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * ISOLATOR_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* ISOLATOR_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* ISOLATOR_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* ISOLATOR_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* ISOLATOR_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* ISOLATOR_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* ISOLATOR_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* ISOLATOR_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* ISOLATOR_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* ISOLATOR_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* ISOLATOR_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(IsolatorBrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * ISOLATOR_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* ISOLATOR_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* ISOLATOR_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* ISOLATOR_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* ISOLATOR_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IsolatorBrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(IsolatorBrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(IsolatorBrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * ISOLATOR_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* ISOLATOR_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* ISOLATOR_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* ISOLATOR_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(IsolatorBrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * ISOLATOR_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* ISOLATOR_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* ISOLATOR_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* ISOLATOR_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IsolatorBrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IsolatorBrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(IsolatorBrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(IsolatorBrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IsolatorBrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IsolatorBrickletFunction::GetIdentity), payload)
    }
}
