/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! 4-channel digital input/output.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/IO4_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum Io4BrickletFunction {
    SetValue,
    GetValue,
    SetConfiguration,
    GetConfiguration,
    SetDebouncePeriod,
    GetDebouncePeriod,
    SetInterrupt,
    GetInterrupt,
    SetMonoflop,
    GetMonoflop,
    SetSelectedValues,
    GetEdgeCount,
    SetEdgeCountConfig,
    GetEdgeCountConfig,
    GetIdentity,
    CallbackInterrupt,
    CallbackMonoflopDone,
}
impl From<Io4BrickletFunction> for u8 {
    fn from(fun: Io4BrickletFunction) -> Self {
        match fun {
            Io4BrickletFunction::SetValue => 1,
            Io4BrickletFunction::GetValue => 2,
            Io4BrickletFunction::SetConfiguration => 3,
            Io4BrickletFunction::GetConfiguration => 4,
            Io4BrickletFunction::SetDebouncePeriod => 5,
            Io4BrickletFunction::GetDebouncePeriod => 6,
            Io4BrickletFunction::SetInterrupt => 7,
            Io4BrickletFunction::GetInterrupt => 8,
            Io4BrickletFunction::SetMonoflop => 10,
            Io4BrickletFunction::GetMonoflop => 11,
            Io4BrickletFunction::SetSelectedValues => 13,
            Io4BrickletFunction::GetEdgeCount => 14,
            Io4BrickletFunction::SetEdgeCountConfig => 15,
            Io4BrickletFunction::GetEdgeCountConfig => 16,
            Io4BrickletFunction::GetIdentity => 255,
            Io4BrickletFunction::CallbackInterrupt => 9,
            Io4BrickletFunction::CallbackMonoflopDone => 12,
        }
    }
}
pub const IO4_BRICKLET_DIRECTION_IN: char = 'i';
pub const IO4_BRICKLET_DIRECTION_OUT: char = 'o';
pub const IO4_BRICKLET_EDGE_TYPE_RISING: u8 = 0;
pub const IO4_BRICKLET_EDGE_TYPE_FALLING: u8 = 1;
pub const IO4_BRICKLET_EDGE_TYPE_BOTH: u8 = 2;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub direction_mask: u8,
    pub value_mask: u8,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration { direction_mask: <u8>::from_le_byte_slice(&bytes[0..1]), value_mask: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct InterruptEvent {
    pub interrupt_mask: u8,
    pub value_mask: u8,
}
impl FromByteSlice for InterruptEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> InterruptEvent {
        InterruptEvent { interrupt_mask: <u8>::from_le_byte_slice(&bytes[0..1]), value_mask: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Monoflop {
    pub value: u8,
    pub time: u32,
    pub time_remaining: u32,
}
impl FromByteSlice for Monoflop {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> Monoflop {
        Monoflop {
            value: <u8>::from_le_byte_slice(&bytes[0..1]),
            time: <u32>::from_le_byte_slice(&bytes[1..5]),
            time_remaining: <u32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MonoflopDoneEvent {
    pub selection_mask: u8,
    pub value_mask: u8,
}
impl FromByteSlice for MonoflopDoneEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> MonoflopDoneEvent {
        MonoflopDoneEvent { selection_mask: <u8>::from_le_byte_slice(&bytes[0..1]), value_mask: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct EdgeCountConfig {
    pub edge_type: u8,
    pub debounce: u8,
}
impl FromByteSlice for EdgeCountConfig {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> EdgeCountConfig {
        EdgeCountConfig { edge_type: <u8>::from_le_byte_slice(&bytes[0..1]), debounce: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// 4-channel digital input/output
#[derive(Clone)]
pub struct Io4Bricklet {
    device: Device,
}
impl Io4Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 29;
    pub const DEVICE_DISPLAY_NAME: &'static str = "IO-4 Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> Io4Bricklet {
        let mut result = Io4Bricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(Io4BrickletFunction::SetValue) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Io4BrickletFunction::GetValue) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io4BrickletFunction::SetConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Io4BrickletFunction::GetConfiguration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io4BrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Io4BrickletFunction::GetDebouncePeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io4BrickletFunction::SetInterrupt) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Io4BrickletFunction::GetInterrupt) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io4BrickletFunction::SetMonoflop) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Io4BrickletFunction::GetMonoflop) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io4BrickletFunction::SetSelectedValues) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Io4BrickletFunction::GetEdgeCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io4BrickletFunction::SetEdgeCountConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Io4BrickletFunction::GetEdgeCountConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io4BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::io4_bricklet::Io4Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::io4_bricklet::Io4Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: Io4BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: Io4BrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered whenever a change of the voltage level is detected
    /// on pins where the interrupt was activated with [`set_interrupt`].
    ///
    /// The values are a bitmask that specifies which interrupts occurred
    /// and the current value bitmask.
    ///
    /// For example:
    ///
    /// * (1, 1) or (0b0001, 0b0001) means that an interrupt on pin 0 occurred and
    ///   currently pin 0 is high and pins 1-3 are low.
    /// * (9, 14) or (0b1001, 0b1110) means that interrupts on pins 0 and 3
    ///   occurred and currently pin 0 is low and pins 1-3 are high.
    ///
    /// [`set_interrupt`]: #method.set_interrupt
    pub fn get_interrupt_callback_receiver(&self) -> ConvertingCallbackReceiver<InterruptEvent> {
        self.device.get_callback_receiver(u8::from(Io4BrickletFunction::CallbackInterrupt))
    }

    /// This receiver is triggered whenever a monoflop timer reaches 0. The
    /// parameters contain the involved pins and the current value of the pins
    /// (the value after the monoflop).
    pub fn get_monoflop_done_callback_receiver(&self) -> ConvertingCallbackReceiver<MonoflopDoneEvent> {
        self.device.get_callback_receiver(u8::from(Io4BrickletFunction::CallbackMonoflopDone))
    }

    /// Sets the output value (high or low) with a bitmask (4bit). A 1 in the bitmask
    /// means high and a 0 in the bitmask means low.
    ///
    /// For example: The value 3 or 0b0011 will turn the pins 0-1 high and the
    /// pins 2-3 low.
    ///
    /// All running monoflop timers will be aborted if this function is called.
    ///
    /// # Note
    ///  This function does nothing for pins that are configured as input.
    ///  Pull-up resistors can be switched on with [`set_configuration`].
    pub fn set_value(&self, value_mask: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(value_mask));

        self.device.set(u8::from(Io4BrickletFunction::SetValue), payload)
    }

    /// Returns a bitmask of the values that are currently measured.
    /// This function works if the pin is configured to input
    /// as well as if it is configured to output.
    pub fn get_value(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Io4BrickletFunction::GetValue), payload)
    }

    /// Configures the value and direction of the specified pins. Possible directions
    /// are 'i' and 'o' for input and output.
    ///
    /// If the direction is configured as output, the value is either high or low
    /// (set as *true* or *false*).
    ///
    /// If the direction is configured as input, the value is either pull-up or
    /// default (set as *true* or *false*).
    ///
    /// For example:
    ///
    /// * (15, 'i', true) or (0b1111, 'i', true) will set all pins of as input pull-up.
    /// * (8, 'i', false) or (0b1000, 'i', false) will set pin 3 of as input default (floating if nothing is connected).
    /// * (3, 'o', false) or (0b0011, 'o', false) will set pins 0 and 1 as output low.
    /// * (4, 'o', true) or (0b0100, 'o', true) will set pin 2 of as output high.
    ///
    /// Running monoflop timers for the specified pins will be aborted if this
    /// function is called.
    ///
    /// Associated constants:
    /// * IO4_BRICKLET_DIRECTION_IN
    ///	* IO4_BRICKLET_DIRECTION_OUT
    pub fn set_configuration(&self, selection_mask: u8, direction: char, value: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(selection_mask));
        payload[1..2].copy_from_slice(&<char>::to_le_byte_vec(direction));
        payload[2..3].copy_from_slice(&<bool>::to_le_byte_vec(value));

        self.device.set(u8::from(Io4BrickletFunction::SetConfiguration), payload)
    }

    /// Returns a value bitmask and a direction bitmask. A 1 in the direction bitmask
    /// means input and a 0 in the bitmask means output.
    ///
    /// For example: A return value of (3, 5) or (0b0011, 0b0101) for direction and
    /// value means that:
    ///
    /// * pin 0 is configured as input pull-up,
    /// * pin 1 is configured as input default,
    /// * pin 2 is configured as output high and
    /// * pin 3 is are configured as output low.
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Io4BrickletFunction::GetConfiguration), payload)
    }

    /// Sets the debounce period of the [`get_interrupt_callback_receiver`] receiver.
    ///
    /// For example: If you set this value to 100, you will get the interrupt
    /// maximal every 100ms. This is necessary if something that bounces is
    /// connected to the IO-4 Bricklet, such as a button.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(Io4BrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Io4BrickletFunction::GetDebouncePeriod), payload)
    }

    /// Sets the pins on which an interrupt is activated with a bitmask.
    /// Interrupts are triggered on changes of the voltage level of the pin,
    /// i.e. changes from high to low and low to high.
    ///
    /// For example: An interrupt bitmask of 10 or 0b1010 will enable the interrupt for
    /// pins 1 and 3.
    ///
    /// The interrupt is delivered with the [`get_interrupt_callback_receiver`] receiver.
    pub fn set_interrupt(&self, interrupt_mask: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(interrupt_mask));

        self.device.set(u8::from(Io4BrickletFunction::SetInterrupt), payload)
    }

    /// Returns the interrupt bitmask as set by [`set_interrupt`].
    pub fn get_interrupt(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Io4BrickletFunction::GetInterrupt), payload)
    }

    /// Configures a monoflop of the pins specified by the first parameter as 4 bit
    /// long bitmask. The specified pins must be configured for output. Non-output
    /// pins will be ignored.
    ///
    /// The second parameter is a bitmask with the desired value of the specified
    /// output pins. A 1 in the bitmask means high and a 0 in the bitmask means low.
    ///
    /// The third parameter indicates the time that the pins should hold
    /// the value.
    ///
    /// If this function is called with the parameters (9, 1, 1500) or
    /// (0b1001, 0b0001, 1500): Pin 0 will get high and pin 3 will get low. In 1.5s pin
    /// 0 will get low and pin 3 will get high again.
    ///
    /// A monoflop can be used as a fail-safe mechanism. For example: Lets assume you
    /// have a RS485 bus and an IO-4 Bricklet connected to one of the slave
    /// stacks. You can now call this function every second, with a time parameter
    /// of two seconds and pin 0 set to high. Pin 0 will be high all the time. If now
    /// the RS485 connection is lost, then pin 0 will get low in at most two seconds.
    pub fn set_monoflop(&self, selection_mask: u8, value_mask: u8, time: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(selection_mask));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(value_mask));
        payload[2..6].copy_from_slice(&<u32>::to_le_byte_vec(time));

        self.device.set(u8::from(Io4BrickletFunction::SetMonoflop), payload)
    }

    /// Returns (for the given pin) the current value and the time as set by
    /// [`set_monoflop`] as well as the remaining time until the value flips.
    ///
    /// If the timer is not running currently, the remaining time will be returned
    /// as 0.
    pub fn get_monoflop(&self, pin: u8) -> ConvertingReceiver<Monoflop> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(pin));

        self.device.get(u8::from(Io4BrickletFunction::GetMonoflop), payload)
    }

    /// Sets the output value (high or low) with a bitmask, according to
    /// the selection mask. The bitmask is 4 bit long, *true* refers to high
    /// and *false* refers to low.
    ///
    /// For example: The parameters (9, 4) or (0b0110, 0b0100) will turn
    /// pin 1 low and pin 2 high, pin 0 and 3 will remain untouched.
    ///
    /// Running monoflop timers for the selected pins will be aborted if this
    /// function is called.
    ///
    /// # Note
    ///  This function does nothing for pins that are configured as input.
    ///  Pull-up resistors can be switched on with [`set_configuration`].
    pub fn set_selected_values(&self, selection_mask: u8, value_mask: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(selection_mask));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(value_mask));

        self.device.set(u8::from(Io4BrickletFunction::SetSelectedValues), payload)
    }

    /// Returns the current value of the edge counter for the selected pin. You can
    /// configure the edges that are counted with [`set_edge_count_config`].
    ///
    /// If you set the reset counter to *true*, the count is set back to 0
    /// directly after it is read.
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    pub fn get_edge_count(&self, pin: u8, reset_counter: bool) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(pin));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(reset_counter));

        self.device.get(u8::from(Io4BrickletFunction::GetEdgeCount), payload)
    }

    /// Configures the edge counter for the selected pins.
    ///
    /// The edge type parameter configures if rising edges, falling edges or
    /// both are counted if the pin is configured for input. Possible edge types are:
    ///
    /// * 0 = rising (default)
    /// * 1 = falling
    /// * 2 = both
    ///
    /// Configuring an edge counter resets its value to 0.
    ///
    /// If you don't know what any of this means, just leave it at default. The
    /// default configuration is very likely OK for you.
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * IO4_BRICKLET_EDGE_TYPE_RISING
    ///	* IO4_BRICKLET_EDGE_TYPE_FALLING
    ///	* IO4_BRICKLET_EDGE_TYPE_BOTH
    pub fn set_edge_count_config(&self, selection_mask: u8, edge_type: u8, debounce: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(selection_mask));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(edge_type));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(debounce));

        self.device.set(u8::from(Io4BrickletFunction::SetEdgeCountConfig), payload)
    }

    /// Returns the edge type and debounce time for the selected pin as set by
    /// [`set_edge_count_config`].
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * IO4_BRICKLET_EDGE_TYPE_RISING
    ///	* IO4_BRICKLET_EDGE_TYPE_FALLING
    ///	* IO4_BRICKLET_EDGE_TYPE_BOTH
    pub fn get_edge_count_config(&self, pin: u8) -> ConvertingReceiver<EdgeCountConfig> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(pin));

        self.device.get(u8::from(Io4BrickletFunction::GetEdgeCountConfig), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Io4BrickletFunction::GetIdentity), payload)
    }
}
