/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! 16-channel digital input/output.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/IO16V2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum Io16V2BrickletFunction {
    SetValue,
    GetValue,
    SetSelectedValue,
    SetConfiguration,
    GetConfiguration,
    SetInputValueCallbackConfiguration,
    GetInputValueCallbackConfiguration,
    SetAllInputValueCallbackConfiguration,
    GetAllInputValueCallbackConfiguration,
    SetMonoflop,
    GetMonoflop,
    GetEdgeCount,
    SetEdgeCountConfiguration,
    GetEdgeCountConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackInputValue,
    CallbackAllInputValue,
    CallbackMonoflopDone,
}
impl From<Io16V2BrickletFunction> for u8 {
    fn from(fun: Io16V2BrickletFunction) -> Self {
        match fun {
            Io16V2BrickletFunction::SetValue => 1,
            Io16V2BrickletFunction::GetValue => 2,
            Io16V2BrickletFunction::SetSelectedValue => 3,
            Io16V2BrickletFunction::SetConfiguration => 4,
            Io16V2BrickletFunction::GetConfiguration => 5,
            Io16V2BrickletFunction::SetInputValueCallbackConfiguration => 6,
            Io16V2BrickletFunction::GetInputValueCallbackConfiguration => 7,
            Io16V2BrickletFunction::SetAllInputValueCallbackConfiguration => 8,
            Io16V2BrickletFunction::GetAllInputValueCallbackConfiguration => 9,
            Io16V2BrickletFunction::SetMonoflop => 10,
            Io16V2BrickletFunction::GetMonoflop => 11,
            Io16V2BrickletFunction::GetEdgeCount => 12,
            Io16V2BrickletFunction::SetEdgeCountConfiguration => 13,
            Io16V2BrickletFunction::GetEdgeCountConfiguration => 14,
            Io16V2BrickletFunction::GetSpitfpErrorCount => 234,
            Io16V2BrickletFunction::SetBootloaderMode => 235,
            Io16V2BrickletFunction::GetBootloaderMode => 236,
            Io16V2BrickletFunction::SetWriteFirmwarePointer => 237,
            Io16V2BrickletFunction::WriteFirmware => 238,
            Io16V2BrickletFunction::SetStatusLedConfig => 239,
            Io16V2BrickletFunction::GetStatusLedConfig => 240,
            Io16V2BrickletFunction::GetChipTemperature => 242,
            Io16V2BrickletFunction::Reset => 243,
            Io16V2BrickletFunction::WriteUid => 248,
            Io16V2BrickletFunction::ReadUid => 249,
            Io16V2BrickletFunction::GetIdentity => 255,
            Io16V2BrickletFunction::CallbackInputValue => 15,
            Io16V2BrickletFunction::CallbackAllInputValue => 16,
            Io16V2BrickletFunction::CallbackMonoflopDone => 17,
        }
    }
}
pub const IO16_V2_BRICKLET_DIRECTION_IN: char = 'i';
pub const IO16_V2_BRICKLET_DIRECTION_OUT: char = 'o';
pub const IO16_V2_BRICKLET_EDGE_TYPE_RISING: u8 = 0;
pub const IO16_V2_BRICKLET_EDGE_TYPE_FALLING: u8 = 1;
pub const IO16_V2_BRICKLET_EDGE_TYPE_BOTH: u8 = 2;
pub const IO16_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const IO16_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const IO16_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const IO16_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const IO16_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const IO16_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const IO16_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const IO16_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const IO16_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const IO16_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const IO16_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const IO16_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const IO16_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const IO16_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const IO16_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub direction: char,
    pub value: bool,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration { direction: <char>::from_le_byte_slice(&bytes[0..1]), value: <bool>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct InputValueCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for InputValueCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> InputValueCallbackConfiguration {
        InputValueCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllInputValueCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for AllInputValueCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllInputValueCallbackConfiguration {
        AllInputValueCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Monoflop {
    pub value: bool,
    pub time: u32,
    pub time_remaining: u32,
}
impl FromByteSlice for Monoflop {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> Monoflop {
        Monoflop {
            value: <bool>::from_le_byte_slice(&bytes[0..1]),
            time: <u32>::from_le_byte_slice(&bytes[1..5]),
            time_remaining: <u32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct EdgeCountConfiguration {
    pub edge_type: u8,
    pub debounce: u8,
}
impl FromByteSlice for EdgeCountConfiguration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> EdgeCountConfiguration {
        EdgeCountConfiguration { edge_type: <u8>::from_le_byte_slice(&bytes[0..1]), debounce: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct InputValueEvent {
    pub channel: u8,
    pub changed: bool,
    pub value: bool,
}
impl FromByteSlice for InputValueEvent {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> InputValueEvent {
        InputValueEvent {
            channel: <u8>::from_le_byte_slice(&bytes[0..1]),
            changed: <bool>::from_le_byte_slice(&bytes[1..2]),
            value: <bool>::from_le_byte_slice(&bytes[2..3]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllInputValueEvent {
    pub changed: [bool; 16],
    pub value: [bool; 16],
}
impl FromByteSlice for AllInputValueEvent {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllInputValueEvent {
        AllInputValueEvent {
            changed: <[bool; 16]>::from_le_byte_slice(&bytes[0..2]),
            value: <[bool; 16]>::from_le_byte_slice(&bytes[2..4]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MonoflopDoneEvent {
    pub channel: u8,
    pub value: bool,
}
impl FromByteSlice for MonoflopDoneEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> MonoflopDoneEvent {
        MonoflopDoneEvent { channel: <u8>::from_le_byte_slice(&bytes[0..1]), value: <bool>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// 16-channel digital input/output
#[derive(Clone)]
pub struct Io16V2Bricklet {
    device: Device,
}
impl Io16V2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2114;
    pub const DEVICE_DISPLAY_NAME: &'static str = "IO-16 Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> Io16V2Bricklet {
        let mut result = Io16V2Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(Io16V2BrickletFunction::SetValue) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::GetValue) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::SetSelectedValue) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::SetConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::GetConfiguration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::SetInputValueCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::GetInputValueCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::SetAllInputValueCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::GetAllInputValueCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::SetMonoflop) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::GetMonoflop) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::GetEdgeCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::SetEdgeCountConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::GetEdgeCountConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::SetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::GetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::SetWriteFirmwarePointer) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::GetStatusLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16V2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::io16_v2_bricklet::Io16V2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::io16_v2_bricklet::Io16V2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: Io16V2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: Io16V2BrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_input_value_callback_configuration`].
    ///
    /// The parameters are the channel, a value-changed indicator and the actual value
    /// for the channel. The `changed` parameter is true if the value has changed since
    /// the last receiver.
    ///
    /// [`set_input_value_callback_configuration`]: #method.set_input_value_callback_configuration
    pub fn get_input_value_callback_receiver(&self) -> ConvertingCallbackReceiver<InputValueEvent> {
        self.device.get_callback_receiver(u8::from(Io16V2BrickletFunction::CallbackInputValue))
    }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_all_input_value_callback_configuration`].
    ///
    /// The parameters are the same as [`get_value`]. Additional the
    /// `changed` parameter is true if the value has changed since
    /// the last receiver.
    pub fn get_all_input_value_callback_receiver(&self) -> ConvertingCallbackReceiver<AllInputValueEvent> {
        self.device.get_callback_receiver(u8::from(Io16V2BrickletFunction::CallbackAllInputValue))
    }

    /// This receiver is triggered whenever a monoflop timer reaches 0. The
    /// parameters contain the channel and the current value of the channel
    /// (the value after the monoflop).
    pub fn get_monoflop_done_callback_receiver(&self) -> ConvertingCallbackReceiver<MonoflopDoneEvent> {
        self.device.get_callback_receiver(u8::from(Io16V2BrickletFunction::CallbackMonoflopDone))
    }

    /// Sets the output value of all sixteen channels. A value of *true* or *false* outputs
    /// logic 1 or logic 0 respectively on the corresponding channel.
    ///
    /// Use [`set_selected_value`] to change only one output channel state.
    ///
    /// For example: (True, True, False, False, ..., False) will turn the channels 0-1
    /// high and the channels 2-15 low.
    ///
    /// All running monoflop timers will be aborted if this function is called.
    ///
    /// # Note
    ///  This function does nothing for channels that are configured as input. Pull-up
    ///  resistors can be switched on with [`set_configuration`].
    pub fn set_value(&self, value: [bool; 16]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<[bool; 16]>::to_le_byte_vec(value));

        self.device.set(u8::from(Io16V2BrickletFunction::SetValue), payload)
    }

    /// Returns the logic levels that are currently measured on the channels.
    /// This function works if the channel is configured as input as well as if it is
    /// configured as output.
    pub fn get_value(&self) -> ConvertingReceiver<[bool; 16]> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Io16V2BrickletFunction::GetValue), payload)
    }

    /// Sets the output value of a specific channel without affecting the other channels.
    ///
    /// A running monoflop timer for the specific channel will be aborted if this
    /// function is called.
    ///
    /// # Note
    ///  This function does nothing for channels that are configured as input. Pull-up
    ///  resistors can be switched on with [`set_configuration`].
    pub fn set_selected_value(&self, channel: u8, value: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(value));

        self.device.set(u8::from(Io16V2BrickletFunction::SetSelectedValue), payload)
    }

    /// Configures the value and direction of a specific channel. Possible directions
    /// are 'i' and 'o' for input and output.
    ///
    /// If the direction is configured as output, the value is either high or low
    /// (set as *true* or *false*).
    ///
    /// If the direction is configured as input, the value is either pull-up or
    /// default (set as *true* or *false*).
    ///
    /// For example:
    ///
    /// * (0, 'i', true) will set channel-0 as input pull-up.
    /// * (1, 'i', false) will set channel-1 as input default (floating if nothing is connected).
    /// * (2, 'o', true) will set channel-2 as output high.
    /// * (3, 'o', false) will set channel-3 as output low.
    ///
    /// A running monoflop timer for the specific channel will be aborted if this
    /// function is called.
    ///
    /// Associated constants:
    /// * IO16_V2_BRICKLET_DIRECTION_IN
    ///	* IO16_V2_BRICKLET_DIRECTION_OUT
    pub fn set_configuration(&self, channel: u8, direction: char, value: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..2].copy_from_slice(&<char>::to_le_byte_vec(direction));
        payload[2..3].copy_from_slice(&<bool>::to_le_byte_vec(value));

        self.device.set(u8::from(Io16V2BrickletFunction::SetConfiguration), payload)
    }

    /// Returns the channel configuration as set by [`set_configuration`].
    ///
    /// Associated constants:
    /// * IO16_V2_BRICKLET_DIRECTION_IN
    ///	* IO16_V2_BRICKLET_DIRECTION_OUT
    pub fn get_configuration(&self, channel: u8) -> ConvertingReceiver<Configuration> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(Io16V2BrickletFunction::GetConfiguration), payload)
    }

    /// This receiver can be configured per channel.
    ///
    /// The period is the period with which the [`get_input_value_callback_receiver`]
    /// receiver is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_input_value_callback_configuration(&self, channel: u8, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[5..6].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(Io16V2BrickletFunction::SetInputValueCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_input_value_callback_configuration`].
    pub fn get_input_value_callback_configuration(&self, channel: u8) -> ConvertingReceiver<InputValueCallbackConfiguration> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(Io16V2BrickletFunction::GetInputValueCallbackConfiguration), payload)
    }

    /// The period is the period with which the [`get_all_input_value_callback_receiver`]
    /// receiver is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_all_input_value_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(Io16V2BrickletFunction::SetAllInputValueCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_all_input_value_callback_configuration`].
    pub fn get_all_input_value_callback_configuration(&self) -> ConvertingReceiver<AllInputValueCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Io16V2BrickletFunction::GetAllInputValueCallbackConfiguration), payload)
    }

    /// Configures a monoflop of the specified channel.
    ///
    /// The second parameter is the desired value of the specified
    /// channel. A *true* means relay closed and a *false* means relay open.
    ///
    /// The third parameter indicates the time that the channels should hold
    /// the value.
    ///
    /// If this function is called with the parameters (0, 1, 1500) channel 0 will
    /// close and in 1.5s channel 0 will open again
    ///
    /// A monoflop can be used as a fail-safe mechanism. For example: Lets assume you
    /// have a RS485 bus and a IO-16 Bricklet 2.0 connected to one of
    /// the slave stacks. You can now call this function every second, with a time
    /// parameter of two seconds and channel 0 closed. Channel 0 will be closed all the
    /// time. If now the RS485 connection is lost, then channel 0 will be opened in at
    /// most two seconds.
    pub fn set_monoflop(&self, channel: u8, value: bool, time: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(value));
        payload[2..6].copy_from_slice(&<u32>::to_le_byte_vec(time));

        self.device.set(u8::from(Io16V2BrickletFunction::SetMonoflop), payload)
    }

    /// Returns (for the given channel) the current value and the time as set by
    /// [`set_monoflop`] as well as the remaining time until the value flips.
    ///
    /// If the timer is not running currently, the remaining time will be returned
    /// as 0.
    pub fn get_monoflop(&self, channel: u8) -> ConvertingReceiver<Monoflop> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(Io16V2BrickletFunction::GetMonoflop), payload)
    }

    /// Returns the current value of the edge counter for the selected channel. You can
    /// configure the edges that are counted with [`set_edge_count_configuration`].
    ///
    /// If you set the reset counter to *true*, the count is set back to 0
    /// directly after it is read.
    pub fn get_edge_count(&self, channel: u8, reset_counter: bool) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(reset_counter));

        self.device.get(u8::from(Io16V2BrickletFunction::GetEdgeCount), payload)
    }

    /// Configures the edge counter for a specific channel.
    ///
    /// The edge type parameter configures if rising edges, falling edges or
    /// both are counted if the channel is configured for input. Possible edge types are:
    ///
    /// * 0 = rising
    /// * 1 = falling
    /// * 2 = both
    ///
    /// Configuring an edge counter resets its value to 0.
    ///
    /// If you don't know what any of this means, just leave it at default. The
    /// default configuration is very likely OK for you.
    ///
    /// Associated constants:
    /// * IO16_V2_BRICKLET_EDGE_TYPE_RISING
    ///	* IO16_V2_BRICKLET_EDGE_TYPE_FALLING
    ///	* IO16_V2_BRICKLET_EDGE_TYPE_BOTH
    pub fn set_edge_count_configuration(&self, channel: u8, edge_type: u8, debounce: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(edge_type));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(debounce));

        self.device.set(u8::from(Io16V2BrickletFunction::SetEdgeCountConfiguration), payload)
    }

    /// Returns the edge type and debounce time for the selected channel as set by
    /// [`set_edge_count_configuration`].
    ///
    /// Associated constants:
    /// * IO16_V2_BRICKLET_EDGE_TYPE_RISING
    ///	* IO16_V2_BRICKLET_EDGE_TYPE_FALLING
    ///	* IO16_V2_BRICKLET_EDGE_TYPE_BOTH
    pub fn get_edge_count_configuration(&self, channel: u8) -> ConvertingReceiver<EdgeCountConfiguration> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(Io16V2BrickletFunction::GetEdgeCountConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Io16V2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * IO16_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* IO16_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* IO16_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* IO16_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* IO16_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* IO16_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* IO16_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* IO16_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* IO16_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* IO16_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* IO16_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(Io16V2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * IO16_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* IO16_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* IO16_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* IO16_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* IO16_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Io16V2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(Io16V2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(Io16V2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * IO16_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* IO16_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* IO16_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* IO16_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(Io16V2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * IO16_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* IO16_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* IO16_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* IO16_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Io16V2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Io16V2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Io16V2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(Io16V2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Io16V2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Io16V2BrickletFunction::GetIdentity), payload)
    }
}
