/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Reads temperatures from Pt100 und Pt1000 sensors.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/IndustrialPTC_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum IndustrialPtcBrickletFunction {
    GetTemperature,
    SetTemperatureCallbackConfiguration,
    GetTemperatureCallbackConfiguration,
    GetResistance,
    SetResistanceCallbackConfiguration,
    GetResistanceCallbackConfiguration,
    SetNoiseRejectionFilter,
    GetNoiseRejectionFilter,
    IsSensorConnected,
    SetWireMode,
    GetWireMode,
    SetMovingAverageConfiguration,
    GetMovingAverageConfiguration,
    SetSensorConnectedCallbackConfiguration,
    GetSensorConnectedCallbackConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackTemperature,
    CallbackResistance,
    CallbackSensorConnected,
}
impl From<IndustrialPtcBrickletFunction> for u8 {
    fn from(fun: IndustrialPtcBrickletFunction) -> Self {
        match fun {
            IndustrialPtcBrickletFunction::GetTemperature => 1,
            IndustrialPtcBrickletFunction::SetTemperatureCallbackConfiguration => 2,
            IndustrialPtcBrickletFunction::GetTemperatureCallbackConfiguration => 3,
            IndustrialPtcBrickletFunction::GetResistance => 5,
            IndustrialPtcBrickletFunction::SetResistanceCallbackConfiguration => 6,
            IndustrialPtcBrickletFunction::GetResistanceCallbackConfiguration => 7,
            IndustrialPtcBrickletFunction::SetNoiseRejectionFilter => 9,
            IndustrialPtcBrickletFunction::GetNoiseRejectionFilter => 10,
            IndustrialPtcBrickletFunction::IsSensorConnected => 11,
            IndustrialPtcBrickletFunction::SetWireMode => 12,
            IndustrialPtcBrickletFunction::GetWireMode => 13,
            IndustrialPtcBrickletFunction::SetMovingAverageConfiguration => 14,
            IndustrialPtcBrickletFunction::GetMovingAverageConfiguration => 15,
            IndustrialPtcBrickletFunction::SetSensorConnectedCallbackConfiguration => 16,
            IndustrialPtcBrickletFunction::GetSensorConnectedCallbackConfiguration => 17,
            IndustrialPtcBrickletFunction::GetSpitfpErrorCount => 234,
            IndustrialPtcBrickletFunction::SetBootloaderMode => 235,
            IndustrialPtcBrickletFunction::GetBootloaderMode => 236,
            IndustrialPtcBrickletFunction::SetWriteFirmwarePointer => 237,
            IndustrialPtcBrickletFunction::WriteFirmware => 238,
            IndustrialPtcBrickletFunction::SetStatusLedConfig => 239,
            IndustrialPtcBrickletFunction::GetStatusLedConfig => 240,
            IndustrialPtcBrickletFunction::GetChipTemperature => 242,
            IndustrialPtcBrickletFunction::Reset => 243,
            IndustrialPtcBrickletFunction::WriteUid => 248,
            IndustrialPtcBrickletFunction::ReadUid => 249,
            IndustrialPtcBrickletFunction::GetIdentity => 255,
            IndustrialPtcBrickletFunction::CallbackTemperature => 4,
            IndustrialPtcBrickletFunction::CallbackResistance => 8,
            IndustrialPtcBrickletFunction::CallbackSensorConnected => 18,
        }
    }
}
pub const INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const INDUSTRIAL_PTC_BRICKLET_FILTER_OPTION_50HZ: u8 = 0;
pub const INDUSTRIAL_PTC_BRICKLET_FILTER_OPTION_60HZ: u8 = 1;
pub const INDUSTRIAL_PTC_BRICKLET_WIRE_MODE_2: u8 = 2;
pub const INDUSTRIAL_PTC_BRICKLET_WIRE_MODE_3: u8 = 3;
pub const INDUSTRIAL_PTC_BRICKLET_WIRE_MODE_4: u8 = 4;
pub const INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const INDUSTRIAL_PTC_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const INDUSTRIAL_PTC_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const INDUSTRIAL_PTC_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const INDUSTRIAL_PTC_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct TemperatureCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for TemperatureCallbackConfiguration {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> TemperatureCallbackConfiguration {
        TemperatureCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <i32>::from_le_byte_slice(&bytes[6..10]),
            max: <i32>::from_le_byte_slice(&bytes[10..14]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ResistanceCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for ResistanceCallbackConfiguration {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> ResistanceCallbackConfiguration {
        ResistanceCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <i32>::from_le_byte_slice(&bytes[6..10]),
            max: <i32>::from_le_byte_slice(&bytes[10..14]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MovingAverageConfiguration {
    pub moving_average_length_resistance: u16,
    pub moving_average_length_temperature: u16,
}
impl FromByteSlice for MovingAverageConfiguration {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> MovingAverageConfiguration {
        MovingAverageConfiguration {
            moving_average_length_resistance: <u16>::from_le_byte_slice(&bytes[0..2]),
            moving_average_length_temperature: <u16>::from_le_byte_slice(&bytes[2..4]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Reads temperatures from Pt100 und Pt1000 sensors
#[derive(Clone)]
pub struct IndustrialPtcBricklet {
    device: Device,
}
impl IndustrialPtcBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2164;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Industrial PTC Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> IndustrialPtcBricklet {
        let mut result = IndustrialPtcBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::GetTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::SetTemperatureCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::GetTemperatureCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::GetResistance) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::SetResistanceCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::GetResistanceCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::SetNoiseRejectionFilter) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::GetNoiseRejectionFilter) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::IsSensorConnected) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::SetWireMode) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::GetWireMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::SetMovingAverageConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::GetMovingAverageConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::SetSensorConnectedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::GetSensorConnectedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialPtcBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::industrial_ptc_bricklet::IndustrialPtcBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::industrial_ptc_bricklet::IndustrialPtcBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: IndustrialPtcBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: IndustrialPtcBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_temperature_callback_configuration`].
    ///
    /// The parameter is the same as [`get_temperature`].
    ///
    /// [`get_temperature`]: #method.get_temperature
    /// [`set_temperature_callback_configuration`]: #method.set_temperature_callback_configuration
    pub fn get_temperature_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(IndustrialPtcBrickletFunction::CallbackTemperature))
    }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_resistance_callback_configuration`].
    ///
    /// The parameter is the same as [`get_resistance`].
    pub fn get_resistance_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(IndustrialPtcBrickletFunction::CallbackResistance))
    }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_sensor_connected_callback_configuration`].
    ///
    /// The parameter is the same as [`is_sensor_connected`].
    pub fn get_sensor_connected_callback_receiver(&self) -> ConvertingCallbackReceiver<bool> {
        self.device.get_callback_receiver(u8::from(IndustrialPtcBrickletFunction::CallbackSensorConnected))
    }

    /// Returns the temperature of the connected sensor.
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_temperature_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_temperature_callback_configuration`].
    pub fn get_temperature(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialPtcBrickletFunction::GetTemperature), payload)
    }

    /// The period is the period with which the [`get_temperature_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_temperature_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_temperature_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: i32,
        max: i32,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 14];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..10].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[10..14].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(IndustrialPtcBrickletFunction::SetTemperatureCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_temperature_callback_configuration`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_temperature_callback_configuration(&self) -> ConvertingReceiver<TemperatureCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialPtcBrickletFunction::GetTemperatureCallbackConfiguration), payload)
    }

    /// Returns the value as measured by the MAX31865 precision delta-sigma ADC.
    ///
    /// The value can be converted with the following formulas:
    ///
    /// * Pt100:  resistance = (value * 390) / 32768
    /// * Pt1000: resistance = (value * 3900) / 32768
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_resistance_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_resistance_callback_configuration`].
    pub fn get_resistance(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialPtcBrickletFunction::GetResistance), payload)
    }

    /// The period is the period with which the [`get_resistance_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_resistance_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_resistance_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: i32,
        max: i32,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 14];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..10].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[10..14].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(IndustrialPtcBrickletFunction::SetResistanceCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_resistance_callback_configuration`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* INDUSTRIAL_PTC_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_resistance_callback_configuration(&self) -> ConvertingReceiver<ResistanceCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialPtcBrickletFunction::GetResistanceCallbackConfiguration), payload)
    }

    /// Sets the noise rejection filter to either 50Hz (0) or 60Hz (1).
    /// Noise from 50Hz or 60Hz power sources (including
    /// harmonics of the AC power's fundamental frequency) is
    /// attenuated by 82dB.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_PTC_BRICKLET_FILTER_OPTION_50HZ
    ///	* INDUSTRIAL_PTC_BRICKLET_FILTER_OPTION_60HZ
    pub fn set_noise_rejection_filter(&self, filter: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(filter));

        self.device.set(u8::from(IndustrialPtcBrickletFunction::SetNoiseRejectionFilter), payload)
    }

    /// Returns the noise rejection filter option as set by
    /// [`set_noise_rejection_filter`]
    ///
    /// Associated constants:
    /// * INDUSTRIAL_PTC_BRICKLET_FILTER_OPTION_50HZ
    ///	* INDUSTRIAL_PTC_BRICKLET_FILTER_OPTION_60HZ
    pub fn get_noise_rejection_filter(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialPtcBrickletFunction::GetNoiseRejectionFilter), payload)
    }

    /// Returns *true* if the sensor is connected correctly.
    ///
    /// If this function
    /// returns *false*, there is either no Pt100 or Pt1000 sensor connected,
    /// the sensor is connected incorrectly or the sensor itself is faulty.
    ///
    /// If you want to get the status automatically, it is recommended to use the
    /// [`get_sensor_connected_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_sensor_connected_callback_configuration`].
    pub fn is_sensor_connected(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialPtcBrickletFunction::IsSensorConnected), payload)
    }

    /// Sets the wire mode of the sensor. Possible values are 2, 3 and 4 which
    /// correspond to 2-, 3- and 4-wire sensors. The value has to match the jumper
    /// configuration on the Bricklet.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_PTC_BRICKLET_WIRE_MODE_2
    ///	* INDUSTRIAL_PTC_BRICKLET_WIRE_MODE_3
    ///	* INDUSTRIAL_PTC_BRICKLET_WIRE_MODE_4
    pub fn set_wire_mode(&self, mode: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.set(u8::from(IndustrialPtcBrickletFunction::SetWireMode), payload)
    }

    /// Returns the wire mode as set by [`set_wire_mode`]
    ///
    /// Associated constants:
    /// * INDUSTRIAL_PTC_BRICKLET_WIRE_MODE_2
    ///	* INDUSTRIAL_PTC_BRICKLET_WIRE_MODE_3
    ///	* INDUSTRIAL_PTC_BRICKLET_WIRE_MODE_4
    pub fn get_wire_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialPtcBrickletFunction::GetWireMode), payload)
    }

    /// Sets the length of a [moving averaging](https://en.wikipedia.org/wiki/Moving_average)__
    /// for the resistance and temperature.
    ///
    /// Setting the length to 1 will turn the averaging off. With less
    /// averaging, there is more noise on the data.
    ///
    /// New data is gathered every 20ms. With a moving average of length 1000 the resulting
    /// averaging window has a length of 20s. If you want to do long term measurements the longest
    /// moving average will give the cleanest results.
    ///
    /// The default values match the non-changeable averaging settings of the old PTC Bricklet 1.0
    pub fn set_moving_average_configuration(
        &self,
        moving_average_length_resistance: u16,
        moving_average_length_temperature: u16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(moving_average_length_resistance));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(moving_average_length_temperature));

        self.device.set(u8::from(IndustrialPtcBrickletFunction::SetMovingAverageConfiguration), payload)
    }

    /// Returns the moving average configuration as set by [`set_moving_average_configuration`].
    pub fn get_moving_average_configuration(&self) -> ConvertingReceiver<MovingAverageConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialPtcBrickletFunction::GetMovingAverageConfiguration), payload)
    }

    /// If you enable this receiver, the [`get_sensor_connected_callback_receiver`] receiver is triggered
    /// every time a Pt sensor is connected/disconnected.
    pub fn set_sensor_connected_callback_configuration(&self, enabled: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enabled));

        self.device.set(u8::from(IndustrialPtcBrickletFunction::SetSensorConnectedCallbackConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_sensor_connected_callback_configuration`].
    pub fn get_sensor_connected_callback_configuration(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialPtcBrickletFunction::GetSensorConnectedCallbackConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialPtcBrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(IndustrialPtcBrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_PTC_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialPtcBrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(IndustrialPtcBrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(IndustrialPtcBrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_PTC_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* INDUSTRIAL_PTC_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* INDUSTRIAL_PTC_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_PTC_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(IndustrialPtcBrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * INDUSTRIAL_PTC_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* INDUSTRIAL_PTC_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* INDUSTRIAL_PTC_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_PTC_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialPtcBrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialPtcBrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(IndustrialPtcBrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(IndustrialPtcBrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialPtcBrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialPtcBrickletFunction::GetIdentity), payload)
    }
}
