/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Two relays to switch AC/DC devices.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/IndustrialDualRelay_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum IndustrialDualRelayBrickletFunction {
    SetValue,
    GetValue,
    SetMonoflop,
    GetMonoflop,
    SetSelectedValue,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackMonoflopDone,
}
impl From<IndustrialDualRelayBrickletFunction> for u8 {
    fn from(fun: IndustrialDualRelayBrickletFunction) -> Self {
        match fun {
            IndustrialDualRelayBrickletFunction::SetValue => 1,
            IndustrialDualRelayBrickletFunction::GetValue => 2,
            IndustrialDualRelayBrickletFunction::SetMonoflop => 3,
            IndustrialDualRelayBrickletFunction::GetMonoflop => 4,
            IndustrialDualRelayBrickletFunction::SetSelectedValue => 6,
            IndustrialDualRelayBrickletFunction::GetSpitfpErrorCount => 234,
            IndustrialDualRelayBrickletFunction::SetBootloaderMode => 235,
            IndustrialDualRelayBrickletFunction::GetBootloaderMode => 236,
            IndustrialDualRelayBrickletFunction::SetWriteFirmwarePointer => 237,
            IndustrialDualRelayBrickletFunction::WriteFirmware => 238,
            IndustrialDualRelayBrickletFunction::SetStatusLedConfig => 239,
            IndustrialDualRelayBrickletFunction::GetStatusLedConfig => 240,
            IndustrialDualRelayBrickletFunction::GetChipTemperature => 242,
            IndustrialDualRelayBrickletFunction::Reset => 243,
            IndustrialDualRelayBrickletFunction::WriteUid => 248,
            IndustrialDualRelayBrickletFunction::ReadUid => 249,
            IndustrialDualRelayBrickletFunction::GetIdentity => 255,
            IndustrialDualRelayBrickletFunction::CallbackMonoflopDone => 5,
        }
    }
}
pub const INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const INDUSTRIAL_DUAL_RELAY_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const INDUSTRIAL_DUAL_RELAY_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const INDUSTRIAL_DUAL_RELAY_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const INDUSTRIAL_DUAL_RELAY_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Value {
    pub channel0: bool,
    pub channel1: bool,
}
impl FromByteSlice for Value {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> Value {
        Value { channel0: <bool>::from_le_byte_slice(&bytes[0..1]), channel1: <bool>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Monoflop {
    pub value: bool,
    pub time: u32,
    pub time_remaining: u32,
}
impl FromByteSlice for Monoflop {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> Monoflop {
        Monoflop {
            value: <bool>::from_le_byte_slice(&bytes[0..1]),
            time: <u32>::from_le_byte_slice(&bytes[1..5]),
            time_remaining: <u32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MonoflopDoneEvent {
    pub channel: u8,
    pub value: bool,
}
impl FromByteSlice for MonoflopDoneEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> MonoflopDoneEvent {
        MonoflopDoneEvent { channel: <u8>::from_le_byte_slice(&bytes[0..1]), value: <bool>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Two relays to switch AC/DC devices
#[derive(Clone)]
pub struct IndustrialDualRelayBricklet {
    device: Device,
}
impl IndustrialDualRelayBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 284;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Industrial Dual Relay Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> IndustrialDualRelayBricklet {
        let mut result = IndustrialDualRelayBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(IndustrialDualRelayBrickletFunction::SetValue) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDualRelayBrickletFunction::GetValue) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualRelayBrickletFunction::SetMonoflop) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDualRelayBrickletFunction::GetMonoflop) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualRelayBrickletFunction::SetSelectedValue) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDualRelayBrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualRelayBrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualRelayBrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualRelayBrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDualRelayBrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualRelayBrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDualRelayBrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualRelayBrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualRelayBrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDualRelayBrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDualRelayBrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualRelayBrickletFunction::GetIdentity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::industrial_dual_relay_bricklet::IndustrialDualRelayBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::industrial_dual_relay_bricklet::IndustrialDualRelayBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: IndustrialDualRelayBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: IndustrialDualRelayBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered whenever a monoflop timer reaches 0. The
    /// parameters contain the relay and the current state of the relay
    /// (the state after the monoflop).
    pub fn get_monoflop_done_callback_receiver(&self) -> ConvertingCallbackReceiver<MonoflopDoneEvent> {
        self.device.get_callback_receiver(u8::from(IndustrialDualRelayBrickletFunction::CallbackMonoflopDone))
    }

    /// Sets the state of the relays, *true* means on and *false* means off.
    /// For example: (true, false) turns relay 0 on and relay 1 off.
    ///
    /// If you just want to set one of the relays and don't know the current state
    /// of the other relay, you can get the state with [`get_value`] or you
    /// can use [`set_selected_value`].
    ///
    /// All running monoflop timers will be aborted if this function is called.
    pub fn set_value(&self, channel0: bool, channel1: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(channel0));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(channel1));

        self.device.set(u8::from(IndustrialDualRelayBrickletFunction::SetValue), payload)
    }

    /// Returns the state of the relays, *true* means on and *false* means off.
    pub fn get_value(&self) -> ConvertingReceiver<Value> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualRelayBrickletFunction::GetValue), payload)
    }

    /// The first parameter can be 0 or 1 (relay 0 or relay 1). The second parameter
    /// is the desired state of the relay (*true* means on and *false* means off).
    /// The third parameter indicates the time that the relay should hold
    /// the state.
    ///
    /// If this function is called with the parameters (1, true, 1500):
    /// Relay 1 will turn on and in 1.5s it will turn off again.
    ///
    /// A monoflop can be used as a failsafe mechanism. For example: Lets assume you
    /// have a RS485 bus and a Industrial Dual Relay Bricklet connected to one of the
    /// slave stacks. You can now call this function every second, with a time parameter
    /// of two seconds. The relay will be on all the time. If now the RS485
    /// connection is lost, the relay will turn off in at most two seconds.
    pub fn set_monoflop(&self, channel: u8, value: bool, time: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(value));
        payload[2..6].copy_from_slice(&<u32>::to_le_byte_vec(time));

        self.device.set(u8::from(IndustrialDualRelayBrickletFunction::SetMonoflop), payload)
    }

    /// Returns (for the given relay) the current state and the time as set by
    /// [`set_monoflop`] as well as the remaining time until the state flips.
    ///
    /// If the timer is not running currently, the remaining time will be returned
    /// as 0.
    pub fn get_monoflop(&self, channel: u8) -> ConvertingReceiver<Monoflop> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(IndustrialDualRelayBrickletFunction::GetMonoflop), payload)
    }

    /// Sets the state of the selected relay, *true* means on and *false*
    /// means off.
    ///
    /// A running monoflop timer for the selected relay will be aborted if this function
    /// is called.
    ///
    /// The other relay remains untouched.
    pub fn set_selected_value(&self, channel: u8, value: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(value));

        self.device.set(u8::from(IndustrialDualRelayBrickletFunction::SetSelectedValue), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualRelayBrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(IndustrialDualRelayBrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualRelayBrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(IndustrialDualRelayBrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(IndustrialDualRelayBrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_RELAY_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(IndustrialDualRelayBrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_RELAY_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_DUAL_RELAY_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualRelayBrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualRelayBrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(IndustrialDualRelayBrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(IndustrialDualRelayBrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualRelayBrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualRelayBrickletFunction::GetIdentity), payload)
    }
}
