/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures two DC voltages between -35V and +35V with 24bit resolution each.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/IndustrialDualAnalogIn_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum IndustrialDualAnalogInBrickletFunction {
    GetVoltage,
    SetVoltageCallbackPeriod,
    GetVoltageCallbackPeriod,
    SetVoltageCallbackThreshold,
    GetVoltageCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    SetSampleRate,
    GetSampleRate,
    SetCalibration,
    GetCalibration,
    GetAdcValues,
    GetIdentity,
    CallbackVoltage,
    CallbackVoltageReached,
}
impl From<IndustrialDualAnalogInBrickletFunction> for u8 {
    fn from(fun: IndustrialDualAnalogInBrickletFunction) -> Self {
        match fun {
            IndustrialDualAnalogInBrickletFunction::GetVoltage => 1,
            IndustrialDualAnalogInBrickletFunction::SetVoltageCallbackPeriod => 2,
            IndustrialDualAnalogInBrickletFunction::GetVoltageCallbackPeriod => 3,
            IndustrialDualAnalogInBrickletFunction::SetVoltageCallbackThreshold => 4,
            IndustrialDualAnalogInBrickletFunction::GetVoltageCallbackThreshold => 5,
            IndustrialDualAnalogInBrickletFunction::SetDebouncePeriod => 6,
            IndustrialDualAnalogInBrickletFunction::GetDebouncePeriod => 7,
            IndustrialDualAnalogInBrickletFunction::SetSampleRate => 8,
            IndustrialDualAnalogInBrickletFunction::GetSampleRate => 9,
            IndustrialDualAnalogInBrickletFunction::SetCalibration => 10,
            IndustrialDualAnalogInBrickletFunction::GetCalibration => 11,
            IndustrialDualAnalogInBrickletFunction::GetAdcValues => 12,
            IndustrialDualAnalogInBrickletFunction::GetIdentity => 255,
            IndustrialDualAnalogInBrickletFunction::CallbackVoltage => 13,
            IndustrialDualAnalogInBrickletFunction::CallbackVoltageReached => 14,
        }
    }
}
pub const INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_976_SPS: u8 = 0;
pub const INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_488_SPS: u8 = 1;
pub const INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_244_SPS: u8 = 2;
pub const INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_122_SPS: u8 = 3;
pub const INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_61_SPS: u8 = 4;
pub const INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_4_SPS: u8 = 5;
pub const INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_2_SPS: u8 = 6;
pub const INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_1_SPS: u8 = 7;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct VoltageCallbackThreshold {
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for VoltageCallbackThreshold {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> VoltageCallbackThreshold {
        VoltageCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <i32>::from_le_byte_slice(&bytes[1..5]),
            max: <i32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Calibration {
    pub offset: [i32; 2],
    pub gain: [i32; 2],
}
impl FromByteSlice for Calibration {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> Calibration {
        Calibration { offset: <[i32; 2]>::from_le_byte_slice(&bytes[0..8]), gain: <[i32; 2]>::from_le_byte_slice(&bytes[8..16]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct VoltageEvent {
    pub channel: u8,
    pub voltage: i32,
}
impl FromByteSlice for VoltageEvent {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> VoltageEvent {
        VoltageEvent { channel: <u8>::from_le_byte_slice(&bytes[0..1]), voltage: <i32>::from_le_byte_slice(&bytes[1..5]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct VoltageReachedEvent {
    pub channel: u8,
    pub voltage: i32,
}
impl FromByteSlice for VoltageReachedEvent {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> VoltageReachedEvent {
        VoltageReachedEvent { channel: <u8>::from_le_byte_slice(&bytes[0..1]), voltage: <i32>::from_le_byte_slice(&bytes[1..5]) }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures two DC voltages between -35V and +35V with 24bit resolution each
#[derive(Clone)]
pub struct IndustrialDualAnalogInBricklet {
    device: Device,
}
impl IndustrialDualAnalogInBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 249;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Industrial Dual Analog In Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> IndustrialDualAnalogInBricklet {
        let mut result = IndustrialDualAnalogInBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(IndustrialDualAnalogInBrickletFunction::GetVoltage) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInBrickletFunction::SetVoltageCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(IndustrialDualAnalogInBrickletFunction::GetVoltageCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInBrickletFunction::SetVoltageCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(IndustrialDualAnalogInBrickletFunction::GetVoltageCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInBrickletFunction::SetDebouncePeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(IndustrialDualAnalogInBrickletFunction::GetDebouncePeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInBrickletFunction::SetSampleRate) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDualAnalogInBrickletFunction::GetSampleRate) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInBrickletFunction::SetCalibration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDualAnalogInBrickletFunction::GetCalibration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInBrickletFunction::GetAdcValues) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInBrickletFunction::GetIdentity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::industrial_dual_analog_in_bricklet::IndustrialDualAnalogInBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::industrial_dual_analog_in_bricklet::IndustrialDualAnalogInBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: IndustrialDualAnalogInBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: IndustrialDualAnalogInBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_voltage_callback_period`]. The parameter is the voltage of the
    /// channel.
    ///
    /// The [`get_voltage_callback_receiver`] receiver is only triggered if the voltage has changed since the
    /// last triggering.
    ///
    /// [`set_voltage_callback_period`]: #method.set_voltage_callback_period
    /// [`get_voltage_callback_receiver`]: #method.get_voltage_callback_receiver
    pub fn get_voltage_callback_receiver(&self) -> ConvertingCallbackReceiver<VoltageEvent> {
        self.device.get_callback_receiver(u8::from(IndustrialDualAnalogInBrickletFunction::CallbackVoltage))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_voltage_callback_threshold`] is reached.
    /// The parameter is the voltage of the channel.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_voltage_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<VoltageReachedEvent> {
        self.device.get_callback_receiver(u8::from(IndustrialDualAnalogInBrickletFunction::CallbackVoltageReached))
    }

    /// Returns the voltage for the given channel.
    ///
    /// If you want to get the voltage periodically, it is recommended to use the
    /// [`get_voltage_callback_receiver`] receiver and set the period with
    /// [`set_voltage_callback_period`].
    pub fn get_voltage(&self, channel: u8) -> ConvertingReceiver<i32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(IndustrialDualAnalogInBrickletFunction::GetVoltage), payload)
    }

    /// Sets the period with which the [`get_voltage_callback_receiver`] receiver is triggered
    /// periodically for the given channel. A value of 0 turns the receiver off.
    ///
    /// The [`get_voltage_callback_receiver`] receiver is only triggered if the voltage has changed since the
    /// last triggering.
    pub fn set_voltage_callback_period(&self, channel: u8, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(IndustrialDualAnalogInBrickletFunction::SetVoltageCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_voltage_callback_period`].
    pub fn get_voltage_callback_period(&self, channel: u8) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(IndustrialDualAnalogInBrickletFunction::GetVoltageCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_voltage_reached_callback_receiver`] receiver for the given
    /// channel.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the voltage is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the voltage is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the voltage is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the voltage is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_voltage_callback_threshold(&self, channel: u8, option: char, min: i32, max: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 10];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..2].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[2..6].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[6..10].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(IndustrialDualAnalogInBrickletFunction::SetVoltageCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_voltage_callback_threshold`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_voltage_callback_threshold(&self, channel: u8) -> ConvertingReceiver<VoltageCallbackThreshold> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(IndustrialDualAnalogInBrickletFunction::GetVoltageCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receiver
    ///
    /// * [`get_voltage_reached_callback_receiver`]
    ///
    /// is triggered, if the threshold
    ///
    /// * [`set_voltage_callback_threshold`]
    ///
    /// keeps being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(IndustrialDualAnalogInBrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualAnalogInBrickletFunction::GetDebouncePeriod), payload)
    }

    /// Sets the sample rate. The sample rate can be between 1 sample per second
    /// and 976 samples per second. Decreasing the sample rate will also decrease the
    /// noise on the data.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_976_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_488_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_244_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_122_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_61_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_4_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_2_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_1_SPS
    pub fn set_sample_rate(&self, rate: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(rate));

        self.device.set(u8::from(IndustrialDualAnalogInBrickletFunction::SetSampleRate), payload)
    }

    /// Returns the sample rate as set by [`set_sample_rate`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_976_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_488_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_244_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_122_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_61_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_4_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_2_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_BRICKLET_SAMPLE_RATE_1_SPS
    pub fn get_sample_rate(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualAnalogInBrickletFunction::GetSampleRate), payload)
    }

    /// Sets offset and gain of MCP3911 internal calibration registers.
    ///
    /// See MCP3911 datasheet 7.7 and 7.8. The Industrial Dual Analog In Bricklet
    /// is already factory calibrated by Tinkerforge. It should not be necessary
    /// for you to use this function
    pub fn set_calibration(&self, offset: [i32; 2], gain: [i32; 2]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 16];
        payload[0..8].copy_from_slice(&<[i32; 2]>::to_le_byte_vec(offset));
        payload[8..16].copy_from_slice(&<[i32; 2]>::to_le_byte_vec(gain));

        self.device.set(u8::from(IndustrialDualAnalogInBrickletFunction::SetCalibration), payload)
    }

    /// Returns the calibration as set by [`set_calibration`].
    pub fn get_calibration(&self) -> ConvertingReceiver<Calibration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualAnalogInBrickletFunction::GetCalibration), payload)
    }

    /// Returns the ADC values as given by the MCP3911 IC. This function
    /// is needed for proper calibration, see [`set_calibration`].
    pub fn get_adc_values(&self) -> ConvertingReceiver<[i32; 2]> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualAnalogInBrickletFunction::GetAdcValues), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualAnalogInBrickletFunction::GetIdentity), payload)
    }
}
