/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures two DC currents between 0mA and 20mA (IEC 60381-1).
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/IndustrialDual020mA_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum IndustrialDual020maBrickletFunction {
    GetCurrent,
    SetCurrentCallbackPeriod,
    GetCurrentCallbackPeriod,
    SetCurrentCallbackThreshold,
    GetCurrentCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    SetSampleRate,
    GetSampleRate,
    GetIdentity,
    CallbackCurrent,
    CallbackCurrentReached,
}
impl From<IndustrialDual020maBrickletFunction> for u8 {
    fn from(fun: IndustrialDual020maBrickletFunction) -> Self {
        match fun {
            IndustrialDual020maBrickletFunction::GetCurrent => 1,
            IndustrialDual020maBrickletFunction::SetCurrentCallbackPeriod => 2,
            IndustrialDual020maBrickletFunction::GetCurrentCallbackPeriod => 3,
            IndustrialDual020maBrickletFunction::SetCurrentCallbackThreshold => 4,
            IndustrialDual020maBrickletFunction::GetCurrentCallbackThreshold => 5,
            IndustrialDual020maBrickletFunction::SetDebouncePeriod => 6,
            IndustrialDual020maBrickletFunction::GetDebouncePeriod => 7,
            IndustrialDual020maBrickletFunction::SetSampleRate => 8,
            IndustrialDual020maBrickletFunction::GetSampleRate => 9,
            IndustrialDual020maBrickletFunction::GetIdentity => 255,
            IndustrialDual020maBrickletFunction::CallbackCurrent => 10,
            IndustrialDual020maBrickletFunction::CallbackCurrentReached => 11,
        }
    }
}
pub const INDUSTRIAL_DUAL_0_20MA_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const INDUSTRIAL_DUAL_0_20MA_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const INDUSTRIAL_DUAL_0_20MA_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const INDUSTRIAL_DUAL_0_20MA_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const INDUSTRIAL_DUAL_0_20MA_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const INDUSTRIAL_DUAL_0_20MA_BRICKLET_SAMPLE_RATE_240_SPS: u8 = 0;
pub const INDUSTRIAL_DUAL_0_20MA_BRICKLET_SAMPLE_RATE_60_SPS: u8 = 1;
pub const INDUSTRIAL_DUAL_0_20MA_BRICKLET_SAMPLE_RATE_15_SPS: u8 = 2;
pub const INDUSTRIAL_DUAL_0_20MA_BRICKLET_SAMPLE_RATE_4_SPS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CurrentCallbackThreshold {
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for CurrentCallbackThreshold {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> CurrentCallbackThreshold {
        CurrentCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <i32>::from_le_byte_slice(&bytes[1..5]),
            max: <i32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CurrentEvent {
    pub sensor: u8,
    pub current: i32,
}
impl FromByteSlice for CurrentEvent {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> CurrentEvent {
        CurrentEvent { sensor: <u8>::from_le_byte_slice(&bytes[0..1]), current: <i32>::from_le_byte_slice(&bytes[1..5]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CurrentReachedEvent {
    pub sensor: u8,
    pub current: i32,
}
impl FromByteSlice for CurrentReachedEvent {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> CurrentReachedEvent {
        CurrentReachedEvent { sensor: <u8>::from_le_byte_slice(&bytes[0..1]), current: <i32>::from_le_byte_slice(&bytes[1..5]) }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures two DC currents between 0mA and 20mA (IEC 60381-1)
#[derive(Clone)]
pub struct IndustrialDual020maBricklet {
    device: Device,
}
impl IndustrialDual020maBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 228;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Industrial Dual 0-20mA Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> IndustrialDual020maBricklet {
        let mut result = IndustrialDual020maBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(IndustrialDual020maBrickletFunction::GetCurrent) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDual020maBrickletFunction::SetCurrentCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(IndustrialDual020maBrickletFunction::GetCurrentCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDual020maBrickletFunction::SetCurrentCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(IndustrialDual020maBrickletFunction::GetCurrentCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDual020maBrickletFunction::SetDebouncePeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(IndustrialDual020maBrickletFunction::GetDebouncePeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDual020maBrickletFunction::SetSampleRate) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDual020maBrickletFunction::GetSampleRate) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDual020maBrickletFunction::GetIdentity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::industrial_dual_0_20ma_bricklet::IndustrialDual020maBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::industrial_dual_0_20ma_bricklet::IndustrialDual020maBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: IndustrialDual020maBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: IndustrialDual020maBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_current_callback_period`]. The parameter is the current of the
    /// sensor.
    ///
    /// The [`get_current_callback_receiver`] receiver is only triggered if the current has changed since the
    /// last triggering.
    ///
    /// [`set_current_callback_period`]: #method.set_current_callback_period
    /// [`get_current_callback_receiver`]: #method.get_current_callback_receiver
    pub fn get_current_callback_receiver(&self) -> ConvertingCallbackReceiver<CurrentEvent> {
        self.device.get_callback_receiver(u8::from(IndustrialDual020maBrickletFunction::CallbackCurrent))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_current_callback_threshold`] is reached.
    /// The parameter is the current of the sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_current_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<CurrentReachedEvent> {
        self.device.get_callback_receiver(u8::from(IndustrialDual020maBrickletFunction::CallbackCurrentReached))
    }

    /// Returns the current of the specified sensor.
    ///
    /// It is possible to detect if an IEC 60381-1 compatible sensor is connected
    /// and if it works properly.
    ///
    /// If the returned current is below 4mA, there is likely no sensor connected
    /// or the sensor may be defect. If the returned current is over 20mA, there might
    /// be a short circuit or the sensor may be defect.
    ///
    /// If you want to get the current periodically, it is recommended to use the
    /// [`get_current_callback_receiver`] receiver and set the period with
    /// [`set_current_callback_period`].
    pub fn get_current(&self, sensor: u8) -> ConvertingReceiver<i32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(sensor));

        self.device.get(u8::from(IndustrialDual020maBrickletFunction::GetCurrent), payload)
    }

    /// Sets the period with which the [`get_current_callback_receiver`] receiver is triggered
    /// periodically for the given sensor. A value of 0 turns the receiver off.
    ///
    /// The [`get_current_callback_receiver`] receiver is only triggered if the current has changed since the
    /// last triggering.
    pub fn set_current_callback_period(&self, sensor: u8, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(sensor));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(IndustrialDual020maBrickletFunction::SetCurrentCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_current_callback_period`].
    pub fn get_current_callback_period(&self, sensor: u8) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(sensor));

        self.device.get(u8::from(IndustrialDual020maBrickletFunction::GetCurrentCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_current_reached_callback_receiver`] receiver for the given
    /// sensor.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the current is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the current is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the current is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the current is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_0_20MA_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* INDUSTRIAL_DUAL_0_20MA_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* INDUSTRIAL_DUAL_0_20MA_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* INDUSTRIAL_DUAL_0_20MA_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* INDUSTRIAL_DUAL_0_20MA_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_current_callback_threshold(&self, sensor: u8, option: char, min: i32, max: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 10];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(sensor));
        payload[1..2].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[2..6].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[6..10].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(IndustrialDual020maBrickletFunction::SetCurrentCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_current_callback_threshold`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_0_20MA_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* INDUSTRIAL_DUAL_0_20MA_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* INDUSTRIAL_DUAL_0_20MA_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* INDUSTRIAL_DUAL_0_20MA_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* INDUSTRIAL_DUAL_0_20MA_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_current_callback_threshold(&self, sensor: u8) -> ConvertingReceiver<CurrentCallbackThreshold> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(sensor));

        self.device.get(u8::from(IndustrialDual020maBrickletFunction::GetCurrentCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receiver
    ///
    /// * [`get_current_reached_callback_receiver`]
    ///
    /// is triggered, if the threshold
    ///
    /// * [`set_current_callback_threshold`]
    ///
    /// keeps being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(IndustrialDual020maBrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDual020maBrickletFunction::GetDebouncePeriod), payload)
    }

    /// Sets the sample rate to either 240, 60, 15 or 4 samples per second.
    /// The resolution for the rates is 12, 14, 16 and 18 bit respectively.
    ///
    ///  Value| Description
    ///  --- | ---
    ///  0|    240 samples per second| 12 bit resolution
    ///  1|    60 samples per second| 14 bit resolution
    ///  2|    15 samples per second| 16 bit resolution
    ///  3|    4 samples per second| 18 bit resolution
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_0_20MA_BRICKLET_SAMPLE_RATE_240_SPS
    ///	* INDUSTRIAL_DUAL_0_20MA_BRICKLET_SAMPLE_RATE_60_SPS
    ///	* INDUSTRIAL_DUAL_0_20MA_BRICKLET_SAMPLE_RATE_15_SPS
    ///	* INDUSTRIAL_DUAL_0_20MA_BRICKLET_SAMPLE_RATE_4_SPS
    pub fn set_sample_rate(&self, rate: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(rate));

        self.device.set(u8::from(IndustrialDual020maBrickletFunction::SetSampleRate), payload)
    }

    /// Returns the sample rate as set by [`set_sample_rate`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_0_20MA_BRICKLET_SAMPLE_RATE_240_SPS
    ///	* INDUSTRIAL_DUAL_0_20MA_BRICKLET_SAMPLE_RATE_60_SPS
    ///	* INDUSTRIAL_DUAL_0_20MA_BRICKLET_SAMPLE_RATE_15_SPS
    ///	* INDUSTRIAL_DUAL_0_20MA_BRICKLET_SAMPLE_RATE_4_SPS
    pub fn get_sample_rate(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDual020maBrickletFunction::GetSampleRate), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDual020maBrickletFunction::GetIdentity), payload)
    }
}
