/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! 4 galvanically isolated digital inputs.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/IndustrialDigitalIn4_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum IndustrialDigitalIn4BrickletFunction {
    GetValue,
    SetGroup,
    GetGroup,
    GetAvailableForGroup,
    SetDebouncePeriod,
    GetDebouncePeriod,
    SetInterrupt,
    GetInterrupt,
    GetEdgeCount,
    SetEdgeCountConfig,
    GetEdgeCountConfig,
    GetIdentity,
    CallbackInterrupt,
}
impl From<IndustrialDigitalIn4BrickletFunction> for u8 {
    fn from(fun: IndustrialDigitalIn4BrickletFunction) -> Self {
        match fun {
            IndustrialDigitalIn4BrickletFunction::GetValue => 1,
            IndustrialDigitalIn4BrickletFunction::SetGroup => 2,
            IndustrialDigitalIn4BrickletFunction::GetGroup => 3,
            IndustrialDigitalIn4BrickletFunction::GetAvailableForGroup => 4,
            IndustrialDigitalIn4BrickletFunction::SetDebouncePeriod => 5,
            IndustrialDigitalIn4BrickletFunction::GetDebouncePeriod => 6,
            IndustrialDigitalIn4BrickletFunction::SetInterrupt => 7,
            IndustrialDigitalIn4BrickletFunction::GetInterrupt => 8,
            IndustrialDigitalIn4BrickletFunction::GetEdgeCount => 10,
            IndustrialDigitalIn4BrickletFunction::SetEdgeCountConfig => 11,
            IndustrialDigitalIn4BrickletFunction::GetEdgeCountConfig => 12,
            IndustrialDigitalIn4BrickletFunction::GetIdentity => 255,
            IndustrialDigitalIn4BrickletFunction::CallbackInterrupt => 9,
        }
    }
}
pub const INDUSTRIAL_DIGITAL_IN_4_BRICKLET_EDGE_TYPE_RISING: u8 = 0;
pub const INDUSTRIAL_DIGITAL_IN_4_BRICKLET_EDGE_TYPE_FALLING: u8 = 1;
pub const INDUSTRIAL_DIGITAL_IN_4_BRICKLET_EDGE_TYPE_BOTH: u8 = 2;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct InterruptEvent {
    pub interrupt_mask: u16,
    pub value_mask: u16,
}
impl FromByteSlice for InterruptEvent {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> InterruptEvent {
        InterruptEvent { interrupt_mask: <u16>::from_le_byte_slice(&bytes[0..2]), value_mask: <u16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct EdgeCountConfig {
    pub edge_type: u8,
    pub debounce: u8,
}
impl FromByteSlice for EdgeCountConfig {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> EdgeCountConfig {
        EdgeCountConfig { edge_type: <u8>::from_le_byte_slice(&bytes[0..1]), debounce: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// 4 galvanically isolated digital inputs
#[derive(Clone)]
pub struct IndustrialDigitalIn4Bricklet {
    device: Device,
}
impl IndustrialDigitalIn4Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 223;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Industrial Digital In 4 Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> IndustrialDigitalIn4Bricklet {
        let mut result = IndustrialDigitalIn4Bricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(IndustrialDigitalIn4BrickletFunction::GetValue) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDigitalIn4BrickletFunction::SetGroup) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDigitalIn4BrickletFunction::GetGroup) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDigitalIn4BrickletFunction::GetAvailableForGroup) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDigitalIn4BrickletFunction::SetDebouncePeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(IndustrialDigitalIn4BrickletFunction::GetDebouncePeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDigitalIn4BrickletFunction::SetInterrupt) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(IndustrialDigitalIn4BrickletFunction::GetInterrupt) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDigitalIn4BrickletFunction::GetEdgeCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDigitalIn4BrickletFunction::SetEdgeCountConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDigitalIn4BrickletFunction::GetEdgeCountConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDigitalIn4BrickletFunction::GetIdentity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::industrial_digital_in_4_bricklet::IndustrialDigitalIn4Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::industrial_digital_in_4_bricklet::IndustrialDigitalIn4Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: IndustrialDigitalIn4BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: IndustrialDigitalIn4BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered whenever a change of the voltage level is detected
    /// on pins where the interrupt was activated with [`set_interrupt`].
    ///
    /// The values are a bitmask that specifies which interrupts occurred
    /// and the current value bitmask.
    ///
    /// For example:
    ///
    /// * (1, 1) or (0b0001, 0b0001) means that an interrupt on pin 0 occurred and
    ///   currently pin 0 is high and pins 1-3 are low.
    /// * (9, 14) or (0b1001, 0b1110) means that interrupts on pins 0 and 3
    ///   occurred and currently pin 0 is low and pins 1-3 are high.
    ///
    /// The interrupts use the grouping as set by [`set_group`].
    ///
    /// [`set_group`]: #method.set_group
    /// [`set_interrupt`]: #method.set_interrupt
    pub fn get_interrupt_callback_receiver(&self) -> ConvertingCallbackReceiver<InterruptEvent> {
        self.device.get_callback_receiver(u8::from(IndustrialDigitalIn4BrickletFunction::CallbackInterrupt))
    }

    /// Returns the input value with a bitmask. The bitmask is 16bit long, *true*
    /// refers to high and *false* refers to low.
    ///
    /// For example: The value 3 or 0b0011 means that pins 0-1 are high and the other
    /// pins are low.
    ///
    /// If no groups are used (see [`set_group`]), the pins correspond to the
    /// markings on the IndustrialDigital In 4 Bricklet.
    ///
    /// If groups are used, the pins correspond to the element in the group.
    /// Element 1 in the group will get pins 0-3, element 2 pins 4-7, element 3
    /// pins 8-11 and element 4 pins 12-15.
    pub fn get_value(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDigitalIn4BrickletFunction::GetValue), payload)
    }

    /// Sets a group of Digital In 4 Bricklets that should work together. You can
    /// find Bricklets that can be grouped together with [`get_available_for_group`].
    ///
    /// The group consists of 4 elements. Element 1 in the group will get pins 0-3,
    /// element 2 pins 4-7, element 3 pins 8-11 and element 4 pins 12-15.
    ///
    /// Each element can either be one of the ports ('a' to 'd') or 'n' if it should
    /// not be used.
    ///
    /// For example: If you have two Digital In 4 Bricklets connected to port A and
    /// port B respectively, you could call with ``['a', 'b', 'n', 'n']``.
    ///
    /// Now the pins on the Digital In 4 on port A are assigned to 0-3 and the
    /// pins on the Digital In 4 on port B are assigned to 4-7. It is now possible
    /// to call [`get_value`] and read out two Bricklets at the same time.
    ///
    /// Changing the group configuration resets all edge counter configurations
    /// and values.
    pub fn set_group(&self, group: [char; 4]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<[char; 4]>::to_le_byte_vec(group));

        self.device.set(u8::from(IndustrialDigitalIn4BrickletFunction::SetGroup), payload)
    }

    /// Returns the group as set by [`set_group`]
    pub fn get_group(&self) -> ConvertingReceiver<[char; 4]> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDigitalIn4BrickletFunction::GetGroup), payload)
    }

    /// Returns a bitmask of ports that are available for grouping. For example the
    /// value 5 or 0b0101 means: Port A and port C are connected to Bricklets that
    /// can be grouped together.
    pub fn get_available_for_group(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDigitalIn4BrickletFunction::GetAvailableForGroup), payload)
    }

    /// Sets the debounce period of the [`get_interrupt_callback_receiver`] receiver.
    ///
    /// For example: If you set this value to 100, you will get the interrupt
    /// maximal every 100ms. This is necessary if something that bounces is
    /// connected to the Digital In 4 Bricklet, such as a button.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(IndustrialDigitalIn4BrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDigitalIn4BrickletFunction::GetDebouncePeriod), payload)
    }

    /// Sets the pins on which an interrupt is activated with a bitmask.
    /// Interrupts are triggered on changes of the voltage level of the pin,
    /// i.e. changes from high to low and low to high.
    ///
    /// For example: An interrupt bitmask of 9 or 0b1001 will enable the interrupt for
    /// pins 0 and 3.
    ///
    /// The interrupts use the grouping as set by [`set_group`].
    ///
    /// The interrupt is delivered with the [`get_interrupt_callback_receiver`] receiver.
    pub fn set_interrupt(&self, interrupt_mask: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(interrupt_mask));

        self.device.set(u8::from(IndustrialDigitalIn4BrickletFunction::SetInterrupt), payload)
    }

    /// Returns the interrupt bitmask as set by [`set_interrupt`].
    pub fn get_interrupt(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDigitalIn4BrickletFunction::GetInterrupt), payload)
    }

    /// Returns the current value of the edge counter for the selected pin. You can
    /// configure the edges that are counted with [`set_edge_count_config`].
    ///
    /// If you set the reset counter to *true*, the count is set back to 0
    /// directly after it is read.
    ///
    /// The edge counters use the grouping as set by [`set_group`].
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    pub fn get_edge_count(&self, pin: u8, reset_counter: bool) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(pin));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(reset_counter));

        self.device.get(u8::from(IndustrialDigitalIn4BrickletFunction::GetEdgeCount), payload)
    }

    /// Configures the edge counter for the selected pins. A bitmask of 9 or 0b1001 will
    /// enable the edge counter for pins 0 and 3.
    ///
    /// The edge type parameter configures if rising edges, falling edges or
    /// both are counted if the pin is configured for input. Possible edge types are:
    ///
    /// * 0 = rising
    /// * 1 = falling
    /// * 2 = both
    ///
    /// Configuring an edge counter resets its value to 0.
    ///
    /// If you don't know what any of this means, just leave it at default. The
    /// default configuration is very likely OK for you.
    ///
    /// The edge counters use the grouping as set by [`set_group`].
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DIGITAL_IN_4_BRICKLET_EDGE_TYPE_RISING
    ///	* INDUSTRIAL_DIGITAL_IN_4_BRICKLET_EDGE_TYPE_FALLING
    ///	* INDUSTRIAL_DIGITAL_IN_4_BRICKLET_EDGE_TYPE_BOTH
    pub fn set_edge_count_config(&self, selection_mask: u16, edge_type: u8, debounce: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(selection_mask));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(edge_type));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(debounce));

        self.device.set(u8::from(IndustrialDigitalIn4BrickletFunction::SetEdgeCountConfig), payload)
    }

    /// Returns the edge type and debounce time for the selected pin as set by
    /// [`set_edge_count_config`].
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DIGITAL_IN_4_BRICKLET_EDGE_TYPE_RISING
    ///	* INDUSTRIAL_DIGITAL_IN_4_BRICKLET_EDGE_TYPE_FALLING
    ///	* INDUSTRIAL_DIGITAL_IN_4_BRICKLET_EDGE_TYPE_BOTH
    pub fn get_edge_count_config(&self, pin: u8) -> ConvertingReceiver<EdgeCountConfig> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(pin));

        self.device.get(u8::from(IndustrialDigitalIn4BrickletFunction::GetEdgeCountConfig), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDigitalIn4BrickletFunction::GetIdentity), payload)
    }
}
