/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Generates configurable DC voltage and current, 0V to 10V and 4mA to 20mA.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/IndustrialAnalogOutV2_Bricklet_Rust.html).
use crate::{byte_converter::*, converting_receiver::ConvertingReceiver, device::*, ip_connection::GetRequestSender};
pub enum IndustrialAnalogOutV2BrickletFunction {
    SetEnabled,
    GetEnabled,
    SetVoltage,
    GetVoltage,
    SetCurrent,
    GetCurrent,
    SetConfiguration,
    GetConfiguration,
    SetOutLedConfig,
    GetOutLedConfig,
    SetOutLedStatusConfig,
    GetOutLedStatusConfig,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
}
impl From<IndustrialAnalogOutV2BrickletFunction> for u8 {
    fn from(fun: IndustrialAnalogOutV2BrickletFunction) -> Self {
        match fun {
            IndustrialAnalogOutV2BrickletFunction::SetEnabled => 1,
            IndustrialAnalogOutV2BrickletFunction::GetEnabled => 2,
            IndustrialAnalogOutV2BrickletFunction::SetVoltage => 3,
            IndustrialAnalogOutV2BrickletFunction::GetVoltage => 4,
            IndustrialAnalogOutV2BrickletFunction::SetCurrent => 5,
            IndustrialAnalogOutV2BrickletFunction::GetCurrent => 6,
            IndustrialAnalogOutV2BrickletFunction::SetConfiguration => 7,
            IndustrialAnalogOutV2BrickletFunction::GetConfiguration => 8,
            IndustrialAnalogOutV2BrickletFunction::SetOutLedConfig => 9,
            IndustrialAnalogOutV2BrickletFunction::GetOutLedConfig => 10,
            IndustrialAnalogOutV2BrickletFunction::SetOutLedStatusConfig => 11,
            IndustrialAnalogOutV2BrickletFunction::GetOutLedStatusConfig => 12,
            IndustrialAnalogOutV2BrickletFunction::GetSpitfpErrorCount => 234,
            IndustrialAnalogOutV2BrickletFunction::SetBootloaderMode => 235,
            IndustrialAnalogOutV2BrickletFunction::GetBootloaderMode => 236,
            IndustrialAnalogOutV2BrickletFunction::SetWriteFirmwarePointer => 237,
            IndustrialAnalogOutV2BrickletFunction::WriteFirmware => 238,
            IndustrialAnalogOutV2BrickletFunction::SetStatusLedConfig => 239,
            IndustrialAnalogOutV2BrickletFunction::GetStatusLedConfig => 240,
            IndustrialAnalogOutV2BrickletFunction::GetChipTemperature => 242,
            IndustrialAnalogOutV2BrickletFunction::Reset => 243,
            IndustrialAnalogOutV2BrickletFunction::WriteUid => 248,
            IndustrialAnalogOutV2BrickletFunction::ReadUid => 249,
            IndustrialAnalogOutV2BrickletFunction::GetIdentity => 255,
        }
    }
}
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_VOLTAGE_RANGE_0_TO_5V: u8 = 0;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_VOLTAGE_RANGE_0_TO_10V: u8 = 1;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_CURRENT_RANGE_4_TO_20MA: u8 = 0;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_CURRENT_RANGE_0_TO_20MA: u8 = 1;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_CURRENT_RANGE_0_TO_24MA: u8 = 2;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_OUT_LED_CONFIG_OFF: u8 = 0;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_OUT_LED_CONFIG_ON: u8 = 1;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_OUT_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_OUT_LED_CONFIG_SHOW_OUT_STATUS: u8 = 3;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_OUT_LED_STATUS_CONFIG_THRESHOLD: u8 = 0;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_OUT_LED_STATUS_CONFIG_INTENSITY: u8 = 1;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub voltage_range: u8,
    pub current_range: u8,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration { voltage_range: <u8>::from_le_byte_slice(&bytes[0..1]), current_range: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct OutLedStatusConfig {
    pub min: u16,
    pub max: u16,
    pub config: u8,
}
impl FromByteSlice for OutLedStatusConfig {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> OutLedStatusConfig {
        OutLedStatusConfig {
            min: <u16>::from_le_byte_slice(&bytes[0..2]),
            max: <u16>::from_le_byte_slice(&bytes[2..4]),
            config: <u8>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Generates configurable DC voltage and current, 0V to 10V and 4mA to 20mA
#[derive(Clone)]
pub struct IndustrialAnalogOutV2Bricklet {
    device: Device,
}
impl IndustrialAnalogOutV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2116;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Industrial Analog Out Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> IndustrialAnalogOutV2Bricklet {
        let mut result = IndustrialAnalogOutV2Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::SetEnabled) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::GetEnabled) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::SetVoltage) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::GetVoltage) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::SetCurrent) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::GetCurrent) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::SetConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::GetConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::SetOutLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::GetOutLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::SetOutLedStatusConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::GetOutLedStatusConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::ReadUid) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialAnalogOutV2BrickletFunction::GetIdentity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::industrial_analog_out_v2_bricklet::IndustrialAnalogOutV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::industrial_analog_out_v2_bricklet::IndustrialAnalogOutV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: IndustrialAnalogOutV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: IndustrialAnalogOutV2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// Enables/disables the output of voltage and current.
    pub fn set_enabled(&self, enabled: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enabled));

        self.device.set(u8::from(IndustrialAnalogOutV2BrickletFunction::SetEnabled), payload)
    }

    /// Returns *true* if output of voltage and current is enabled, *false* otherwise.
    pub fn get_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialAnalogOutV2BrickletFunction::GetEnabled), payload)
    }

    /// Sets the output voltage.
    ///
    /// The output voltage and output current are linked. Changing the output voltage
    /// also changes the output current.
    pub fn set_voltage(&self, voltage: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(voltage));

        self.device.set(u8::from(IndustrialAnalogOutV2BrickletFunction::SetVoltage), payload)
    }

    /// Returns the voltage as set by [`set_voltage`].
    pub fn get_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialAnalogOutV2BrickletFunction::GetVoltage), payload)
    }

    /// Sets the output current.
    ///
    /// The output current and output voltage are linked. Changing the output current
    /// also changes the output voltage.
    pub fn set_current(&self, current: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(current));

        self.device.set(u8::from(IndustrialAnalogOutV2BrickletFunction::SetCurrent), payload)
    }

    /// Returns the current as set by [`set_current`].
    pub fn get_current(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialAnalogOutV2BrickletFunction::GetCurrent), payload)
    }

    /// Configures the voltage and current range.
    ///
    /// Possible voltage ranges are:
    ///
    /// * 0V to 5V
    /// * 0V to 10V
    ///
    /// Possible current ranges are:
    ///
    /// * 4mA to 20mA
    /// * 0mA to 20mA
    /// * 0mA to 24mA
    ///
    /// The resolution will always be 12 bit. This means, that the
    /// precision is higher with a smaller range.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_VOLTAGE_RANGE_0_TO_5V
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_VOLTAGE_RANGE_0_TO_10V
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_CURRENT_RANGE_4_TO_20MA
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_CURRENT_RANGE_0_TO_20MA
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_CURRENT_RANGE_0_TO_24MA
    pub fn set_configuration(&self, voltage_range: u8, current_range: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(voltage_range));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(current_range));

        self.device.set(u8::from(IndustrialAnalogOutV2BrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_VOLTAGE_RANGE_0_TO_5V
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_VOLTAGE_RANGE_0_TO_10V
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_CURRENT_RANGE_4_TO_20MA
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_CURRENT_RANGE_0_TO_20MA
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_CURRENT_RANGE_0_TO_24MA
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialAnalogOutV2BrickletFunction::GetConfiguration), payload)
    }

    /// You can turn the Out LED off, on or show a
    /// heartbeat. You can also set the LED to Out Status. In this mode the
    /// LED can either be turned on with a pre-defined threshold or the intensity
    /// of the LED can change with the output value (voltage or current).
    ///
    /// You can configure the channel status behavior with [`set_out_led_status_config`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_OUT_LED_CONFIG_OFF
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_OUT_LED_CONFIG_ON
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_OUT_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_OUT_LED_CONFIG_SHOW_OUT_STATUS
    pub fn set_out_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(IndustrialAnalogOutV2BrickletFunction::SetOutLedConfig), payload)
    }

    /// Returns the Out LED configuration as set by [`set_out_led_config`]
    ///
    /// Associated constants:
    /// * INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_OUT_LED_CONFIG_OFF
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_OUT_LED_CONFIG_ON
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_OUT_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_OUT_LED_CONFIG_SHOW_OUT_STATUS
    pub fn get_out_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialAnalogOutV2BrickletFunction::GetOutLedConfig), payload)
    }

    /// Sets the Out LED status config. This config is used if the Out LED is
    /// configured as Out Status, see [`set_out_led_config`].
    ///
    /// For each channel you can choose between threshold and intensity mode.
    ///
    /// In threshold mode you can define a positive or a negative threshold.
    /// For a positive threshold set the min parameter to the threshold value in mV or
    /// µA above which the LED should turn on and set the max parameter to 0. Example:
    /// If you set a positive threshold of 5V, the LED will turn on as soon as the
    /// output value exceeds 5V and turn off again if it goes below 5V.
    /// For a negative threshold set the max parameter to the threshold value in mV or
    /// µA below which the LED should turn on and set the min parameter to 0. Example:
    /// If you set a negative threshold of 5V, the LED will turn on as soon as the
    /// output value goes below 5V and the LED will turn off when the output value
    /// exceeds 5V.
    ///
    /// In intensity mode you can define a range mV or µA that is used to scale the brightness
    /// of the LED. Example with min=2V, max=8V: The LED is off at 2V and below, on at
    /// 8V and above and the brightness is linearly scaled between the values 2V and 8V.
    /// If the min value is greater than the max value, the LED brightness is scaled the
    /// other way around.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_OUT_LED_STATUS_CONFIG_THRESHOLD
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_OUT_LED_STATUS_CONFIG_INTENSITY
    pub fn set_out_led_status_config(&self, min: u16, max: u16, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(max));
        payload[4..5].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(IndustrialAnalogOutV2BrickletFunction::SetOutLedStatusConfig), payload)
    }

    /// Returns the Out LED status configuration as set by [`set_out_led_status_config`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_OUT_LED_STATUS_CONFIG_THRESHOLD
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_OUT_LED_STATUS_CONFIG_INTENSITY
    pub fn get_out_led_status_config(&self) -> ConvertingReceiver<OutLedStatusConfig> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialAnalogOutV2BrickletFunction::GetOutLedStatusConfig), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialAnalogOutV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(IndustrialAnalogOutV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialAnalogOutV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(IndustrialAnalogOutV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(IndustrialAnalogOutV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(IndustrialAnalogOutV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_ANALOG_OUT_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialAnalogOutV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialAnalogOutV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(IndustrialAnalogOutV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(IndustrialAnalogOutV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialAnalogOutV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialAnalogOutV2BrickletFunction::GetIdentity), payload)
    }
}
